/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdStudy;
import com.facebook.ads.sdk.AdVideo;
import com.facebook.ads.sdk.AgeRange;
import com.facebook.ads.sdk.Album;
import com.facebook.ads.sdk.AppRequest;
import com.facebook.ads.sdk.AppRequestFormerRecipient;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.BusinessAssetGroup;
import com.facebook.ads.sdk.BusinessUser;
import com.facebook.ads.sdk.Canvas;
import com.facebook.ads.sdk.Currency;
import com.facebook.ads.sdk.Event;
import com.facebook.ads.sdk.Experience;
import com.facebook.ads.sdk.FundraiserPersonToCharity;
import com.facebook.ads.sdk.GameItem;
import com.facebook.ads.sdk.Group;
import com.facebook.ads.sdk.LiveVideo;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.PageUserMessageThreadLabel;
import com.facebook.ads.sdk.PaymentEnginePayment;
import com.facebook.ads.sdk.PaymentPricepoints;
import com.facebook.ads.sdk.Permission;
import com.facebook.ads.sdk.Photo;
import com.facebook.ads.sdk.Post;
import com.facebook.ads.sdk.ProductCatalog;
import com.facebook.ads.sdk.ProfilePictureSource;
import com.facebook.ads.sdk.UnifiedThread;
import com.facebook.ads.sdk.UserCoverPhoto;
import com.facebook.ads.sdk.UserIDForApp;
import com.facebook.ads.sdk.UserIDForPage;
import com.facebook.ads.sdk.VideoUploadLimits;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class User
extends APINode {
    @SerializedName(value="about")
    private String mAbout = null;
    @SerializedName(value="age_range")
    private AgeRange mAgeRange = null;
    @SerializedName(value="birthday")
    private String mBirthday = null;
    @SerializedName(value="community")
    private Group mCommunity = null;
    @SerializedName(value="cover")
    private UserCoverPhoto mCover = null;
    @SerializedName(value="currency")
    private Currency mCurrency = null;
    @SerializedName(value="education")
    private List<Object> mEducation = null;
    @SerializedName(value="email")
    private String mEmail = null;
    @SerializedName(value="favorite_athletes")
    private List<Experience> mFavoriteAthletes = null;
    @SerializedName(value="favorite_teams")
    private List<Experience> mFavoriteTeams = null;
    @SerializedName(value="first_name")
    private String mFirstName = null;
    @SerializedName(value="gender")
    private String mGender = null;
    @SerializedName(value="hometown")
    private Page mHometown = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="id_for_avatars")
    private String mIdForAvatars = null;
    @SerializedName(value="inspirational_people")
    private List<Experience> mInspirationalPeople = null;
    @SerializedName(value="install_type")
    private String mInstallType = null;
    @SerializedName(value="installed")
    private Boolean mInstalled = null;
    @SerializedName(value="is_guest_user")
    private Boolean mIsGuestUser = null;
    @SerializedName(value="languages")
    private List<Experience> mLanguages = null;
    @SerializedName(value="last_name")
    private String mLastName = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="local_news_megaphone_dismiss_status")
    private Boolean mLocalNewsMegaphoneDismissStatus = null;
    @SerializedName(value="local_news_subscription_status")
    private Boolean mLocalNewsSubscriptionStatus = null;
    @SerializedName(value="locale")
    private String mLocale = null;
    @SerializedName(value="location")
    private Page mLocation = null;
    @SerializedName(value="meeting_for")
    private List<String> mMeetingFor = null;
    @SerializedName(value="middle_name")
    private String mMiddleName = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="name_format")
    private String mNameFormat = null;
    @SerializedName(value="payment_pricepoints")
    private PaymentPricepoints mPaymentPricepoints = null;
    @SerializedName(value="political")
    private String mPolitical = null;
    @SerializedName(value="profile_pic")
    private String mProfilePic = null;
    @SerializedName(value="quotes")
    private String mQuotes = null;
    @SerializedName(value="relationship_status")
    private String mRelationshipStatus = null;
    @SerializedName(value="shared_login_upgrade_required_by")
    private Object mSharedLoginUpgradeRequiredBy = null;
    @SerializedName(value="short_name")
    private String mShortName = null;
    @SerializedName(value="significant_other")
    private User mSignificantOther = null;
    @SerializedName(value="sports")
    private List<Experience> mSports = null;
    @SerializedName(value="supports_donate_button_in_live_video")
    private Boolean mSupportsDonateButtonInLiveVideo = null;
    @SerializedName(value="third_party_id")
    private String mThirdPartyId = null;
    @SerializedName(value="timezone")
    private Double mTimezone = null;
    @SerializedName(value="token_for_business")
    private String mTokenForBusiness = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="verified")
    private Boolean mVerified = null;
    @SerializedName(value="video_upload_limits")
    private VideoUploadLimits mVideoUploadLimits = null;
    @SerializedName(value="website")
    private String mWebsite = null;
    protected static Gson gson = null;

    User() {
    }

    public User(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public User(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public User fetch() throws APIException {
        User newInstance = User.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static User fetchById(Long id, APIContext context) throws APIException {
        return User.fetchById(id.toString(), context);
    }

    public static ListenableFuture<User> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return User.fetchByIdAsync(id.toString(), context);
    }

    public static User fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<User> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<User> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<User>(context, "", "/", "GET", User.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<User>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<User>(context, "", "/", "GET", User.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static User loadJSON(String json, APIContext context, String header) {
        User user = (User)User.getGson().fromJson(json, User.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(user.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        user.context = context;
        user.rawValue = json;
        user.header = header;
        return user;
    }

    public static APINodeList<User> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<User> users = new APINodeList<User>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        users.add(User.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return users;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            users.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        users.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            users.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            users.add(User.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                users.add(User.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            users.add(User.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return users;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        users.add(User.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return users;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        users.add(User.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return users;
                }
                users.clear();
                users.add(User.loadJSON(json, context, header));
                return users;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return User.getGson().toJson((Object)this);
    }

    public APIRequestDeleteAccessTokens deleteAccessTokens() {
        return new APIRequestDeleteAccessTokens(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAccessToken createAccessToken() {
        return new APIRequestCreateAccessToken(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAccounts getAccounts() {
        return new APIRequestGetAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAccount createAccount() {
        return new APIRequestCreateAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdStudies getAdStudies() {
        return new APIRequestGetAdStudies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdStudy createAdStudy() {
        return new APIRequestCreateAdStudy(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdAccounts getAdAccounts() {
        return new APIRequestGetAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAlbums getAlbums() {
        return new APIRequestGetAlbums(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateApplication createApplication() {
        return new APIRequestCreateApplication(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAppRequestFormerRecipients getAppRequestFormerRecipients() {
        return new APIRequestGetAppRequestFormerRecipients(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAppRequests getAppRequests() {
        return new APIRequestGetAppRequests(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedAdAccounts getAssignedAdAccounts() {
        return new APIRequestGetAssignedAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedBusinessAssetGroups getAssignedBusinessAssetGroups() {
        return new APIRequestGetAssignedBusinessAssetGroups(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedPages getAssignedPages() {
        return new APIRequestGetAssignedPages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedProductCatalogs getAssignedProductCatalogs() {
        return new APIRequestGetAssignedProductCatalogs(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAvatars getAvatars() {
        return new APIRequestGetAvatars(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBusinessUsers getBusinessUsers() {
        return new APIRequestGetBusinessUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteBusinesses deleteBusinesses() {
        return new APIRequestDeleteBusinesses(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBusinesses getBusinesses() {
        return new APIRequestGetBusinesses(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateBusiness createBusiness() {
        return new APIRequestCreateBusiness(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetConversations getConversations() {
        return new APIRequestGetConversations(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCustomLabels getCustomLabels() {
        return new APIRequestGetCustomLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetEvents getEvents() {
        return new APIRequestGetEvents(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetFeed getFeed() {
        return new APIRequestGetFeed(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateFeed createFeed() {
        return new APIRequestCreateFeed(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetFriends getFriends() {
        return new APIRequestGetFriends(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetFundraisers getFundraisers() {
        return new APIRequestGetFundraisers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateFundraiser createFundraiser() {
        return new APIRequestCreateFundraiser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateGameItem createGameItem() {
        return new APIRequestCreateGameItem(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateGameTime createGameTime() {
        return new APIRequestCreateGameTime(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetGroups getGroups() {
        return new APIRequestGetGroups(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetIdsForApps getIdsForApps() {
        return new APIRequestGetIdsForApps(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetIdsForBusiness getIdsForBusiness() {
        return new APIRequestGetIdsForBusiness(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetIdsForPages getIdsForPages() {
        return new APIRequestGetIdsForPages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLikes getLikes() {
        return new APIRequestGetLikes(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLiveVideos getLiveVideos() {
        return new APIRequestGetLiveVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLiveVideo createLiveVideo() {
        return new APIRequestCreateLiveVideo(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMessengerDesktopPerformanceTrace createMessengerDesktopPerformanceTrace() {
        return new APIRequestCreateMessengerDesktopPerformanceTrace(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMusic getMusic() {
        return new APIRequestGetMusic(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateNotification createNotification() {
        return new APIRequestCreateNotification(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPaymentTransactions getPaymentTransactions() {
        return new APIRequestGetPaymentTransactions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeletePermissions deletePermissions() {
        return new APIRequestDeletePermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPermissions getPermissions() {
        return new APIRequestGetPermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPersonalAdAccounts getPersonalAdAccounts() {
        return new APIRequestGetPersonalAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPhotos getPhotos() {
        return new APIRequestGetPhotos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePhoto createPhoto() {
        return new APIRequestCreatePhoto(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPicture getPicture() {
        return new APIRequestGetPicture(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPosts getPosts() {
        return new APIRequestGetPosts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetRichMediaDocuments getRichMediaDocuments() {
        return new APIRequestGetRichMediaDocuments(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateStagingResource createStagingResource() {
        return new APIRequestCreateStagingResource(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideos getVideos() {
        return new APIRequestGetVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateVideo createVideo() {
        return new APIRequestCreateVideo(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAbout() {
        return this.mAbout;
    }

    public AgeRange getFieldAgeRange() {
        return this.mAgeRange;
    }

    public String getFieldBirthday() {
        return this.mBirthday;
    }

    public Group getFieldCommunity() {
        if (this.mCommunity != null) {
            this.mCommunity.context = this.getContext();
        }
        return this.mCommunity;
    }

    public UserCoverPhoto getFieldCover() {
        return this.mCover;
    }

    public Currency getFieldCurrency() {
        return this.mCurrency;
    }

    public List<Object> getFieldEducation() {
        return this.mEducation;
    }

    public String getFieldEmail() {
        return this.mEmail;
    }

    public List<Experience> getFieldFavoriteAthletes() {
        return this.mFavoriteAthletes;
    }

    public List<Experience> getFieldFavoriteTeams() {
        return this.mFavoriteTeams;
    }

    public String getFieldFirstName() {
        return this.mFirstName;
    }

    public String getFieldGender() {
        return this.mGender;
    }

    public Page getFieldHometown() {
        if (this.mHometown != null) {
            this.mHometown.context = this.getContext();
        }
        return this.mHometown;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIdForAvatars() {
        return this.mIdForAvatars;
    }

    public List<Experience> getFieldInspirationalPeople() {
        return this.mInspirationalPeople;
    }

    public String getFieldInstallType() {
        return this.mInstallType;
    }

    public Boolean getFieldInstalled() {
        return this.mInstalled;
    }

    public Boolean getFieldIsGuestUser() {
        return this.mIsGuestUser;
    }

    public List<Experience> getFieldLanguages() {
        return this.mLanguages;
    }

    public String getFieldLastName() {
        return this.mLastName;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public Boolean getFieldLocalNewsMegaphoneDismissStatus() {
        return this.mLocalNewsMegaphoneDismissStatus;
    }

    public Boolean getFieldLocalNewsSubscriptionStatus() {
        return this.mLocalNewsSubscriptionStatus;
    }

    public String getFieldLocale() {
        return this.mLocale;
    }

    public Page getFieldLocation() {
        if (this.mLocation != null) {
            this.mLocation.context = this.getContext();
        }
        return this.mLocation;
    }

    public List<String> getFieldMeetingFor() {
        return this.mMeetingFor;
    }

    public String getFieldMiddleName() {
        return this.mMiddleName;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldNameFormat() {
        return this.mNameFormat;
    }

    public PaymentPricepoints getFieldPaymentPricepoints() {
        return this.mPaymentPricepoints;
    }

    public String getFieldPolitical() {
        return this.mPolitical;
    }

    public String getFieldProfilePic() {
        return this.mProfilePic;
    }

    public String getFieldQuotes() {
        return this.mQuotes;
    }

    public String getFieldRelationshipStatus() {
        return this.mRelationshipStatus;
    }

    public Object getFieldSharedLoginUpgradeRequiredBy() {
        return this.mSharedLoginUpgradeRequiredBy;
    }

    public String getFieldShortName() {
        return this.mShortName;
    }

    public User getFieldSignificantOther() {
        if (this.mSignificantOther != null) {
            this.mSignificantOther.context = this.getContext();
        }
        return this.mSignificantOther;
    }

    public List<Experience> getFieldSports() {
        return this.mSports;
    }

    public Boolean getFieldSupportsDonateButtonInLiveVideo() {
        return this.mSupportsDonateButtonInLiveVideo;
    }

    public String getFieldThirdPartyId() {
        return this.mThirdPartyId;
    }

    public Double getFieldTimezone() {
        return this.mTimezone;
    }

    public String getFieldTokenForBusiness() {
        return this.mTokenForBusiness;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public Boolean getFieldVerified() {
        return this.mVerified;
    }

    public VideoUploadLimits getFieldVideoUploadLimits() {
        return this.mVideoUploadLimits;
    }

    public String getFieldWebsite() {
        return this.mWebsite;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public User copyFrom(User instance) {
        this.mAbout = instance.mAbout;
        this.mAgeRange = instance.mAgeRange;
        this.mBirthday = instance.mBirthday;
        this.mCommunity = instance.mCommunity;
        this.mCover = instance.mCover;
        this.mCurrency = instance.mCurrency;
        this.mEducation = instance.mEducation;
        this.mEmail = instance.mEmail;
        this.mFavoriteAthletes = instance.mFavoriteAthletes;
        this.mFavoriteTeams = instance.mFavoriteTeams;
        this.mFirstName = instance.mFirstName;
        this.mGender = instance.mGender;
        this.mHometown = instance.mHometown;
        this.mId = instance.mId;
        this.mIdForAvatars = instance.mIdForAvatars;
        this.mInspirationalPeople = instance.mInspirationalPeople;
        this.mInstallType = instance.mInstallType;
        this.mInstalled = instance.mInstalled;
        this.mIsGuestUser = instance.mIsGuestUser;
        this.mLanguages = instance.mLanguages;
        this.mLastName = instance.mLastName;
        this.mLink = instance.mLink;
        this.mLocalNewsMegaphoneDismissStatus = instance.mLocalNewsMegaphoneDismissStatus;
        this.mLocalNewsSubscriptionStatus = instance.mLocalNewsSubscriptionStatus;
        this.mLocale = instance.mLocale;
        this.mLocation = instance.mLocation;
        this.mMeetingFor = instance.mMeetingFor;
        this.mMiddleName = instance.mMiddleName;
        this.mName = instance.mName;
        this.mNameFormat = instance.mNameFormat;
        this.mPaymentPricepoints = instance.mPaymentPricepoints;
        this.mPolitical = instance.mPolitical;
        this.mProfilePic = instance.mProfilePic;
        this.mQuotes = instance.mQuotes;
        this.mRelationshipStatus = instance.mRelationshipStatus;
        this.mSharedLoginUpgradeRequiredBy = instance.mSharedLoginUpgradeRequiredBy;
        this.mShortName = instance.mShortName;
        this.mSignificantOther = instance.mSignificantOther;
        this.mSports = instance.mSports;
        this.mSupportsDonateButtonInLiveVideo = instance.mSupportsDonateButtonInLiveVideo;
        this.mThirdPartyId = instance.mThirdPartyId;
        this.mTimezone = instance.mTimezone;
        this.mTokenForBusiness = instance.mTokenForBusiness;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mVerified = instance.mVerified;
        this.mVideoUploadLimits = instance.mVideoUploadLimits;
        this.mWebsite = instance.mWebsite;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<User> getParser() {
        return new APIRequest.ResponseParser<User>(){

            @Override
            public APINodeList<User> parseResponse(String response, APIContext context, APIRequest<User> request, String header) throws APIException.MalformedResponseException {
                return User.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumAction {
        VALUE_END("END"),
        VALUE_HEARTBEAT("HEARTBEAT"),
        VALUE_START("START");

        private String value;

        private EnumAction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumType {
        VALUE_CONTENT_UPDATE("content_update"),
        VALUE_GENERIC("generic");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumFiltering {
        VALUE_EMA("ema"),
        VALUE_GROUPS("groups"),
        VALUE_GROUPS_SOCIAL("groups_social");

        private String value;

        private EnumFiltering(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumLocalNewsSubscriptionStatus {
        VALUE_STATUS_OFF("STATUS_OFF"),
        VALUE_STATUS_ON("STATUS_ON");

        private String value;

        private EnumLocalNewsSubscriptionStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumLocalNewsMegaphoneDismissStatus {
        VALUE_NO("NO"),
        VALUE_YES("YES");

        private String value;

        private EnumLocalNewsMegaphoneDismissStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"emoji_color_pref", "firstname", "lastname", "local_news_megaphone_dismiss_status", "local_news_subscription_status", "name", "password"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, User>(){

                public User apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setEmojiColorPref(Long emojiColorPref) {
            this.setParam("emoji_color_pref", emojiColorPref);
            return this;
        }

        public APIRequestUpdate setEmojiColorPref(String emojiColorPref) {
            this.setParam("emoji_color_pref", emojiColorPref);
            return this;
        }

        public APIRequestUpdate setFirstname(String firstname) {
            this.setParam("firstname", firstname);
            return this;
        }

        public APIRequestUpdate setLastname(String lastname) {
            this.setParam("lastname", lastname);
            return this;
        }

        public APIRequestUpdate setLocalNewsMegaphoneDismissStatus(EnumLocalNewsMegaphoneDismissStatus localNewsMegaphoneDismissStatus) {
            this.setParam("local_news_megaphone_dismiss_status", (Object)localNewsMegaphoneDismissStatus);
            return this;
        }

        public APIRequestUpdate setLocalNewsMegaphoneDismissStatus(String localNewsMegaphoneDismissStatus) {
            this.setParam("local_news_megaphone_dismiss_status", localNewsMegaphoneDismissStatus);
            return this;
        }

        public APIRequestUpdate setLocalNewsSubscriptionStatus(EnumLocalNewsSubscriptionStatus localNewsSubscriptionStatus) {
            this.setParam("local_news_subscription_status", (Object)localNewsSubscriptionStatus);
            return this;
        }

        public APIRequestUpdate setLocalNewsSubscriptionStatus(String localNewsSubscriptionStatus) {
            this.setParam("local_news_subscription_status", localNewsSubscriptionStatus);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setPassword(String password) {
            this.setParam("password", password);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "age_range", "birthday", "community", "cover", "currency", "education", "email", "favorite_athletes", "favorite_teams", "first_name", "gender", "hometown", "id", "id_for_avatars", "inspirational_people", "install_type", "installed", "is_guest_user", "languages", "last_name", "link", "local_news_megaphone_dismiss_status", "local_news_subscription_status", "locale", "location", "meeting_for", "middle_name", "name", "name_format", "payment_pricepoints", "political", "profile_pic", "quotes", "relationship_status", "shared_login_upgrade_required_by", "short_name", "significant_other", "sports", "supports_donate_button_in_live_video", "third_party_id", "timezone", "token_for_business", "updated_time", "verified", "video_upload_limits", "website"};

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, User>(){

                public User apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGet requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGet requestAgeRangeField() {
            return this.requestAgeRangeField(true);
        }

        public APIRequestGet requestAgeRangeField(boolean value) {
            this.requestField("age_range", value);
            return this;
        }

        public APIRequestGet requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGet requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGet requestCommunityField() {
            return this.requestCommunityField(true);
        }

        public APIRequestGet requestCommunityField(boolean value) {
            this.requestField("community", value);
            return this;
        }

        public APIRequestGet requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGet requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestEducationField() {
            return this.requestEducationField(true);
        }

        public APIRequestGet requestEducationField(boolean value) {
            this.requestField("education", value);
            return this;
        }

        public APIRequestGet requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGet requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGet requestFavoriteAthletesField() {
            return this.requestFavoriteAthletesField(true);
        }

        public APIRequestGet requestFavoriteAthletesField(boolean value) {
            this.requestField("favorite_athletes", value);
            return this;
        }

        public APIRequestGet requestFavoriteTeamsField() {
            return this.requestFavoriteTeamsField(true);
        }

        public APIRequestGet requestFavoriteTeamsField(boolean value) {
            this.requestField("favorite_teams", value);
            return this;
        }

        public APIRequestGet requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGet requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGet requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGet requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGet requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGet requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIdForAvatarsField() {
            return this.requestIdForAvatarsField(true);
        }

        public APIRequestGet requestIdForAvatarsField(boolean value) {
            this.requestField("id_for_avatars", value);
            return this;
        }

        public APIRequestGet requestInspirationalPeopleField() {
            return this.requestInspirationalPeopleField(true);
        }

        public APIRequestGet requestInspirationalPeopleField(boolean value) {
            this.requestField("inspirational_people", value);
            return this;
        }

        public APIRequestGet requestInstallTypeField() {
            return this.requestInstallTypeField(true);
        }

        public APIRequestGet requestInstallTypeField(boolean value) {
            this.requestField("install_type", value);
            return this;
        }

        public APIRequestGet requestInstalledField() {
            return this.requestInstalledField(true);
        }

        public APIRequestGet requestInstalledField(boolean value) {
            this.requestField("installed", value);
            return this;
        }

        public APIRequestGet requestIsGuestUserField() {
            return this.requestIsGuestUserField(true);
        }

        public APIRequestGet requestIsGuestUserField(boolean value) {
            this.requestField("is_guest_user", value);
            return this;
        }

        public APIRequestGet requestLanguagesField() {
            return this.requestLanguagesField(true);
        }

        public APIRequestGet requestLanguagesField(boolean value) {
            this.requestField("languages", value);
            return this;
        }

        public APIRequestGet requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGet requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestLocalNewsMegaphoneDismissStatusField() {
            return this.requestLocalNewsMegaphoneDismissStatusField(true);
        }

        public APIRequestGet requestLocalNewsMegaphoneDismissStatusField(boolean value) {
            this.requestField("local_news_megaphone_dismiss_status", value);
            return this;
        }

        public APIRequestGet requestLocalNewsSubscriptionStatusField() {
            return this.requestLocalNewsSubscriptionStatusField(true);
        }

        public APIRequestGet requestLocalNewsSubscriptionStatusField(boolean value) {
            this.requestField("local_news_subscription_status", value);
            return this;
        }

        public APIRequestGet requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGet requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGet requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGet requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGet requestMeetingForField() {
            return this.requestMeetingForField(true);
        }

        public APIRequestGet requestMeetingForField(boolean value) {
            this.requestField("meeting_for", value);
            return this;
        }

        public APIRequestGet requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGet requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNameFormatField() {
            return this.requestNameFormatField(true);
        }

        public APIRequestGet requestNameFormatField(boolean value) {
            this.requestField("name_format", value);
            return this;
        }

        public APIRequestGet requestPaymentPricepointsField() {
            return this.requestPaymentPricepointsField(true);
        }

        public APIRequestGet requestPaymentPricepointsField(boolean value) {
            this.requestField("payment_pricepoints", value);
            return this;
        }

        public APIRequestGet requestPoliticalField() {
            return this.requestPoliticalField(true);
        }

        public APIRequestGet requestPoliticalField(boolean value) {
            this.requestField("political", value);
            return this;
        }

        public APIRequestGet requestProfilePicField() {
            return this.requestProfilePicField(true);
        }

        public APIRequestGet requestProfilePicField(boolean value) {
            this.requestField("profile_pic", value);
            return this;
        }

        public APIRequestGet requestQuotesField() {
            return this.requestQuotesField(true);
        }

        public APIRequestGet requestQuotesField(boolean value) {
            this.requestField("quotes", value);
            return this;
        }

        public APIRequestGet requestRelationshipStatusField() {
            return this.requestRelationshipStatusField(true);
        }

        public APIRequestGet requestRelationshipStatusField(boolean value) {
            this.requestField("relationship_status", value);
            return this;
        }

        public APIRequestGet requestSharedLoginUpgradeRequiredByField() {
            return this.requestSharedLoginUpgradeRequiredByField(true);
        }

        public APIRequestGet requestSharedLoginUpgradeRequiredByField(boolean value) {
            this.requestField("shared_login_upgrade_required_by", value);
            return this;
        }

        public APIRequestGet requestShortNameField() {
            return this.requestShortNameField(true);
        }

        public APIRequestGet requestShortNameField(boolean value) {
            this.requestField("short_name", value);
            return this;
        }

        public APIRequestGet requestSignificantOtherField() {
            return this.requestSignificantOtherField(true);
        }

        public APIRequestGet requestSignificantOtherField(boolean value) {
            this.requestField("significant_other", value);
            return this;
        }

        public APIRequestGet requestSportsField() {
            return this.requestSportsField(true);
        }

        public APIRequestGet requestSportsField(boolean value) {
            this.requestField("sports", value);
            return this;
        }

        public APIRequestGet requestSupportsDonateButtonInLiveVideoField() {
            return this.requestSupportsDonateButtonInLiveVideoField(true);
        }

        public APIRequestGet requestSupportsDonateButtonInLiveVideoField(boolean value) {
            this.requestField("supports_donate_button_in_live_video", value);
            return this;
        }

        public APIRequestGet requestThirdPartyIdField() {
            return this.requestThirdPartyIdField(true);
        }

        public APIRequestGet requestThirdPartyIdField(boolean value) {
            this.requestField("third_party_id", value);
            return this;
        }

        public APIRequestGet requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGet requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGet requestTokenForBusinessField() {
            return this.requestTokenForBusinessField(true);
        }

        public APIRequestGet requestTokenForBusinessField(boolean value) {
            this.requestField("token_for_business", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestVerifiedField() {
            return this.requestVerifiedField(true);
        }

        public APIRequestGet requestVerifiedField(boolean value) {
            this.requestField("verified", value);
            return this;
        }

        public APIRequestGet requestVideoUploadLimitsField() {
            return this.requestVideoUploadLimitsField(true);
        }

        public APIRequestGet requestVideoUploadLimitsField(boolean value) {
            this.requestField("video_upload_limits", value);
            return this;
        }

        public APIRequestGet requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGet requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateVideo
    extends APIRequest<AdVideo> {
        AdVideo lastResponse = null;
        public static final String[] PARAMS = new String[]{"adaptive_type", "animated_effect_id", "application_id", "asked_fun_fact_prompt_id", "audio_story_wave_animation_handle", "composer_entry_picker", "composer_entry_point", "composer_entry_time", "composer_session_events_log", "composer_session_id", "composer_source_surface", "composer_type", "container_type", "content_category", "creative_tools", "description", "direct_share_status", "embeddable", "end_offset", "fbuploader_video_file_chunk", "file_size", "file_url", "fisheye_video_cropped", "formatting", "fov", "front_z_rotation", "fun_fact_prompt_id", "fun_fact_toastee_id", "guide", "guide_enabled", "has_nickname", "holiday_card", "initial_heading", "initial_pitch", "instant_game_entry_point_data", "is_boost_intended", "is_explicit_share", "is_group_linking_post", "is_voice_clip", "location_source_id", "manual_privacy", "no_story", "offer_like_post_id", "og_action_type_id", "og_icon_id", "og_object_id", "og_phrase", "og_suggestion_mechanism", "original_fov", "original_projection_type", "privacy", "publish_event_id", "react_mode_metadata", "referenced_sticker_id", "replace_video_id", "slideshow_spec", "source", "source_instagram_media_id", "spherical", "sponsor_id", "start_offset", "swap_mode", "text_format_metadata", "throwback_camera_roll_media", "thumb", "time_since_original_post", "title", "transcode_setting_properties", "unpublished_content_type", "upload_phase", "upload_session_id", "upload_setting_properties", "video_file_chunk", "video_id_original", "video_start_time_ms", "waterfall_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdVideo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdVideo parseResponse(String response, String header) throws APIException {
            return AdVideo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdVideo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdVideo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdVideo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdVideo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdVideo>(){

                public AdVideo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateVideo(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateVideo setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateVideo setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateVideo setAdaptiveType(String adaptiveType) {
            this.setParam("adaptive_type", adaptiveType);
            return this;
        }

        public APIRequestCreateVideo setAnimatedEffectId(Long animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateVideo setAnimatedEffectId(String animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateVideo setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreateVideo setAskedFunFactPromptId(Long askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateVideo setAskedFunFactPromptId(String askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateVideo setAudioStoryWaveAnimationHandle(String audioStoryWaveAnimationHandle) {
            this.setParam("audio_story_wave_animation_handle", audioStoryWaveAnimationHandle);
            return this;
        }

        public APIRequestCreateVideo setComposerEntryPicker(String composerEntryPicker) {
            this.setParam("composer_entry_picker", composerEntryPicker);
            return this;
        }

        public APIRequestCreateVideo setComposerEntryPoint(String composerEntryPoint) {
            this.setParam("composer_entry_point", composerEntryPoint);
            return this;
        }

        public APIRequestCreateVideo setComposerEntryTime(Long composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateVideo setComposerEntryTime(String composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateVideo setComposerSessionEventsLog(String composerSessionEventsLog) {
            this.setParam("composer_session_events_log", composerSessionEventsLog);
            return this;
        }

        public APIRequestCreateVideo setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreateVideo setComposerSourceSurface(String composerSourceSurface) {
            this.setParam("composer_source_surface", composerSourceSurface);
            return this;
        }

        public APIRequestCreateVideo setComposerType(String composerType) {
            this.setParam("composer_type", composerType);
            return this;
        }

        public APIRequestCreateVideo setContainerType(AdVideo.EnumContainerType containerType) {
            this.setParam("container_type", (Object)containerType);
            return this;
        }

        public APIRequestCreateVideo setContainerType(String containerType) {
            this.setParam("container_type", containerType);
            return this;
        }

        public APIRequestCreateVideo setContentCategory(AdVideo.EnumContentCategory contentCategory) {
            this.setParam("content_category", (Object)contentCategory);
            return this;
        }

        public APIRequestCreateVideo setContentCategory(String contentCategory) {
            this.setParam("content_category", contentCategory);
            return this;
        }

        public APIRequestCreateVideo setCreativeTools(String creativeTools) {
            this.setParam("creative_tools", creativeTools);
            return this;
        }

        public APIRequestCreateVideo setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateVideo setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreateVideo setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreateVideo setEmbeddable(Boolean embeddable) {
            this.setParam("embeddable", embeddable);
            return this;
        }

        public APIRequestCreateVideo setEmbeddable(String embeddable) {
            this.setParam("embeddable", embeddable);
            return this;
        }

        public APIRequestCreateVideo setEndOffset(Long endOffset) {
            this.setParam("end_offset", endOffset);
            return this;
        }

        public APIRequestCreateVideo setEndOffset(String endOffset) {
            this.setParam("end_offset", endOffset);
            return this;
        }

        public APIRequestCreateVideo setFbuploaderVideoFileChunk(String fbuploaderVideoFileChunk) {
            this.setParam("fbuploader_video_file_chunk", fbuploaderVideoFileChunk);
            return this;
        }

        public APIRequestCreateVideo setFileSize(Long fileSize) {
            this.setParam("file_size", fileSize);
            return this;
        }

        public APIRequestCreateVideo setFileSize(String fileSize) {
            this.setParam("file_size", fileSize);
            return this;
        }

        public APIRequestCreateVideo setFileUrl(String fileUrl) {
            this.setParam("file_url", fileUrl);
            return this;
        }

        public APIRequestCreateVideo setFisheyeVideoCropped(Boolean fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateVideo setFisheyeVideoCropped(String fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateVideo setFormatting(AdVideo.EnumFormatting formatting) {
            this.setParam("formatting", (Object)formatting);
            return this;
        }

        public APIRequestCreateVideo setFormatting(String formatting) {
            this.setParam("formatting", formatting);
            return this;
        }

        public APIRequestCreateVideo setFov(Long fov) {
            this.setParam("fov", fov);
            return this;
        }

        public APIRequestCreateVideo setFov(String fov) {
            this.setParam("fov", fov);
            return this;
        }

        public APIRequestCreateVideo setFrontZRotation(Double frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateVideo setFrontZRotation(String frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateVideo setFunFactPromptId(Long funFactPromptId) {
            this.setParam("fun_fact_prompt_id", funFactPromptId);
            return this;
        }

        public APIRequestCreateVideo setFunFactPromptId(String funFactPromptId) {
            this.setParam("fun_fact_prompt_id", funFactPromptId);
            return this;
        }

        public APIRequestCreateVideo setFunFactToasteeId(Long funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateVideo setFunFactToasteeId(String funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateVideo setGuide(List<List<Long>> guide) {
            this.setParam("guide", guide);
            return this;
        }

        public APIRequestCreateVideo setGuide(String guide) {
            this.setParam("guide", guide);
            return this;
        }

        public APIRequestCreateVideo setGuideEnabled(Boolean guideEnabled) {
            this.setParam("guide_enabled", guideEnabled);
            return this;
        }

        public APIRequestCreateVideo setGuideEnabled(String guideEnabled) {
            this.setParam("guide_enabled", guideEnabled);
            return this;
        }

        public APIRequestCreateVideo setHasNickname(Boolean hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateVideo setHasNickname(String hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateVideo setHolidayCard(String holidayCard) {
            this.setParam("holiday_card", holidayCard);
            return this;
        }

        public APIRequestCreateVideo setInitialHeading(Long initialHeading) {
            this.setParam("initial_heading", initialHeading);
            return this;
        }

        public APIRequestCreateVideo setInitialHeading(String initialHeading) {
            this.setParam("initial_heading", initialHeading);
            return this;
        }

        public APIRequestCreateVideo setInitialPitch(Long initialPitch) {
            this.setParam("initial_pitch", initialPitch);
            return this;
        }

        public APIRequestCreateVideo setInitialPitch(String initialPitch) {
            this.setParam("initial_pitch", initialPitch);
            return this;
        }

        public APIRequestCreateVideo setInstantGameEntryPointData(String instantGameEntryPointData) {
            this.setParam("instant_game_entry_point_data", instantGameEntryPointData);
            return this;
        }

        public APIRequestCreateVideo setIsBoostIntended(Boolean isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateVideo setIsBoostIntended(String isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateVideo setIsExplicitShare(Boolean isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateVideo setIsExplicitShare(String isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateVideo setIsGroupLinkingPost(Boolean isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateVideo setIsGroupLinkingPost(String isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateVideo setIsVoiceClip(Boolean isVoiceClip) {
            this.setParam("is_voice_clip", isVoiceClip);
            return this;
        }

        public APIRequestCreateVideo setIsVoiceClip(String isVoiceClip) {
            this.setParam("is_voice_clip", isVoiceClip);
            return this;
        }

        public APIRequestCreateVideo setLocationSourceId(String locationSourceId) {
            this.setParam("location_source_id", locationSourceId);
            return this;
        }

        public APIRequestCreateVideo setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateVideo setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateVideo setNoStory(Boolean noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreateVideo setNoStory(String noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreateVideo setOfferLikePostId(Long offerLikePostId) {
            this.setParam("offer_like_post_id", offerLikePostId);
            return this;
        }

        public APIRequestCreateVideo setOfferLikePostId(String offerLikePostId) {
            this.setParam("offer_like_post_id", offerLikePostId);
            return this;
        }

        public APIRequestCreateVideo setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestCreateVideo setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestCreateVideo setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestCreateVideo setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestCreateVideo setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestCreateVideo setOriginalFov(Long originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateVideo setOriginalFov(String originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateVideo setOriginalProjectionType(AdVideo.EnumOriginalProjectionType originalProjectionType) {
            this.setParam("original_projection_type", (Object)originalProjectionType);
            return this;
        }

        public APIRequestCreateVideo setOriginalProjectionType(String originalProjectionType) {
            this.setParam("original_projection_type", originalProjectionType);
            return this;
        }

        public APIRequestCreateVideo setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateVideo setPublishEventId(Long publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateVideo setPublishEventId(String publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateVideo setReactModeMetadata(String reactModeMetadata) {
            this.setParam("react_mode_metadata", reactModeMetadata);
            return this;
        }

        public APIRequestCreateVideo setReferencedStickerId(String referencedStickerId) {
            this.setParam("referenced_sticker_id", referencedStickerId);
            return this;
        }

        public APIRequestCreateVideo setReplaceVideoId(String replaceVideoId) {
            this.setParam("replace_video_id", replaceVideoId);
            return this;
        }

        public APIRequestCreateVideo setSlideshowSpec(Map<String, String> slideshowSpec) {
            this.setParam("slideshow_spec", slideshowSpec);
            return this;
        }

        public APIRequestCreateVideo setSlideshowSpec(String slideshowSpec) {
            this.setParam("slideshow_spec", slideshowSpec);
            return this;
        }

        public APIRequestCreateVideo setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestCreateVideo setSourceInstagramMediaId(String sourceInstagramMediaId) {
            this.setParam("source_instagram_media_id", sourceInstagramMediaId);
            return this;
        }

        public APIRequestCreateVideo setSpherical(Boolean spherical) {
            this.setParam("spherical", spherical);
            return this;
        }

        public APIRequestCreateVideo setSpherical(String spherical) {
            this.setParam("spherical", spherical);
            return this;
        }

        public APIRequestCreateVideo setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestCreateVideo setStartOffset(Long startOffset) {
            this.setParam("start_offset", startOffset);
            return this;
        }

        public APIRequestCreateVideo setStartOffset(String startOffset) {
            this.setParam("start_offset", startOffset);
            return this;
        }

        public APIRequestCreateVideo setSwapMode(AdVideo.EnumSwapMode swapMode) {
            this.setParam("swap_mode", (Object)swapMode);
            return this;
        }

        public APIRequestCreateVideo setSwapMode(String swapMode) {
            this.setParam("swap_mode", swapMode);
            return this;
        }

        public APIRequestCreateVideo setTextFormatMetadata(String textFormatMetadata) {
            this.setParam("text_format_metadata", textFormatMetadata);
            return this;
        }

        public APIRequestCreateVideo setThrowbackCameraRollMedia(String throwbackCameraRollMedia) {
            this.setParam("throwback_camera_roll_media", throwbackCameraRollMedia);
            return this;
        }

        public APIRequestCreateVideo setThumb(File thumb) {
            this.setParam("thumb", thumb);
            return this;
        }

        public APIRequestCreateVideo setThumb(String thumb) {
            this.setParam("thumb", thumb);
            return this;
        }

        public APIRequestCreateVideo setTimeSinceOriginalPost(Long timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateVideo setTimeSinceOriginalPost(String timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateVideo setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestCreateVideo setTranscodeSettingProperties(String transcodeSettingProperties) {
            this.setParam("transcode_setting_properties", transcodeSettingProperties);
            return this;
        }

        public APIRequestCreateVideo setUnpublishedContentType(AdVideo.EnumUnpublishedContentType unpublishedContentType) {
            this.setParam("unpublished_content_type", (Object)unpublishedContentType);
            return this;
        }

        public APIRequestCreateVideo setUnpublishedContentType(String unpublishedContentType) {
            this.setParam("unpublished_content_type", unpublishedContentType);
            return this;
        }

        public APIRequestCreateVideo setUploadPhase(AdVideo.EnumUploadPhase uploadPhase) {
            this.setParam("upload_phase", (Object)uploadPhase);
            return this;
        }

        public APIRequestCreateVideo setUploadPhase(String uploadPhase) {
            this.setParam("upload_phase", uploadPhase);
            return this;
        }

        public APIRequestCreateVideo setUploadSessionId(String uploadSessionId) {
            this.setParam("upload_session_id", uploadSessionId);
            return this;
        }

        public APIRequestCreateVideo setUploadSettingProperties(String uploadSettingProperties) {
            this.setParam("upload_setting_properties", uploadSettingProperties);
            return this;
        }

        public APIRequestCreateVideo setVideoFileChunk(String videoFileChunk) {
            this.setParam("video_file_chunk", videoFileChunk);
            return this;
        }

        public APIRequestCreateVideo setVideoIdOriginal(String videoIdOriginal) {
            this.setParam("video_id_original", videoIdOriginal);
            return this;
        }

        public APIRequestCreateVideo setVideoStartTimeMs(Long videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateVideo setVideoStartTimeMs(String videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateVideo setWaterfallId(String waterfallId) {
            this.setParam("waterfall_id", waterfallId);
            return this;
        }

        public APIRequestCreateVideo requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateVideo requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVideo requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateVideo requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVideo requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateVideo requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetVideos
    extends APIRequest<AdVideo> {
        APINodeList<AdVideo> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[]{"ad_breaks", "admin_creator", "audio_isrc", "backdated_time", "backdated_time_granularity", "content_category", "content_tags", "copyright", "copyright_monitoring_status", "created_time", "custom_labels", "description", "embed_html", "embeddable", "event", "expiration", "format", "from", "icon", "id", "is_crosspost_video", "is_crossposting_eligible", "is_episode", "is_instagram_eligible", "is_reference_only", "length", "live_audience_count", "live_status", "music_video_copyright", "permalink_url", "picture", "place", "post_views", "premiere_living_room_status", "privacy", "published", "scheduled_publish_time", "source", "spherical", "status", "title", "universal_video_id", "updated_time", "views"};

        @Override
        public APINodeList<AdVideo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdVideo> parseResponse(String response, String header) throws APIException {
            return AdVideo.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdVideo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdVideo> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdVideo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdVideo>>(){

                public APINodeList<AdVideo> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideos setType(AdVideo.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetVideos setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetVideos requestAdBreaksField() {
            return this.requestAdBreaksField(true);
        }

        public APIRequestGetVideos requestAdBreaksField(boolean value) {
            this.requestField("ad_breaks", value);
            return this;
        }

        public APIRequestGetVideos requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGetVideos requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGetVideos requestAudioIsrcField() {
            return this.requestAudioIsrcField(true);
        }

        public APIRequestGetVideos requestAudioIsrcField(boolean value) {
            this.requestField("audio_isrc", value);
            return this;
        }

        public APIRequestGetVideos requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetVideos requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetVideos requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGetVideos requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGetVideos requestContentCategoryField() {
            return this.requestContentCategoryField(true);
        }

        public APIRequestGetVideos requestContentCategoryField(boolean value) {
            this.requestField("content_category", value);
            return this;
        }

        public APIRequestGetVideos requestContentTagsField() {
            return this.requestContentTagsField(true);
        }

        public APIRequestGetVideos requestContentTagsField(boolean value) {
            this.requestField("content_tags", value);
            return this;
        }

        public APIRequestGetVideos requestCopyrightField() {
            return this.requestCopyrightField(true);
        }

        public APIRequestGetVideos requestCopyrightField(boolean value) {
            this.requestField("copyright", value);
            return this;
        }

        public APIRequestGetVideos requestCopyrightMonitoringStatusField() {
            return this.requestCopyrightMonitoringStatusField(true);
        }

        public APIRequestGetVideos requestCopyrightMonitoringStatusField(boolean value) {
            this.requestField("copyright_monitoring_status", value);
            return this;
        }

        public APIRequestGetVideos requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetVideos requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetVideos requestCustomLabelsField() {
            return this.requestCustomLabelsField(true);
        }

        public APIRequestGetVideos requestCustomLabelsField(boolean value) {
            this.requestField("custom_labels", value);
            return this;
        }

        public APIRequestGetVideos requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetVideos requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetVideos requestEmbedHtmlField() {
            return this.requestEmbedHtmlField(true);
        }

        public APIRequestGetVideos requestEmbedHtmlField(boolean value) {
            this.requestField("embed_html", value);
            return this;
        }

        public APIRequestGetVideos requestEmbeddableField() {
            return this.requestEmbeddableField(true);
        }

        public APIRequestGetVideos requestEmbeddableField(boolean value) {
            this.requestField("embeddable", value);
            return this;
        }

        public APIRequestGetVideos requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetVideos requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetVideos requestExpirationField() {
            return this.requestExpirationField(true);
        }

        public APIRequestGetVideos requestExpirationField(boolean value) {
            this.requestField("expiration", value);
            return this;
        }

        public APIRequestGetVideos requestFormatField() {
            return this.requestFormatField(true);
        }

        public APIRequestGetVideos requestFormatField(boolean value) {
            this.requestField("format", value);
            return this;
        }

        public APIRequestGetVideos requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetVideos requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetVideos requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetVideos requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetVideos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetVideos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetVideos requestIsCrosspostVideoField() {
            return this.requestIsCrosspostVideoField(true);
        }

        public APIRequestGetVideos requestIsCrosspostVideoField(boolean value) {
            this.requestField("is_crosspost_video", value);
            return this;
        }

        public APIRequestGetVideos requestIsCrosspostingEligibleField() {
            return this.requestIsCrosspostingEligibleField(true);
        }

        public APIRequestGetVideos requestIsCrosspostingEligibleField(boolean value) {
            this.requestField("is_crossposting_eligible", value);
            return this;
        }

        public APIRequestGetVideos requestIsEpisodeField() {
            return this.requestIsEpisodeField(true);
        }

        public APIRequestGetVideos requestIsEpisodeField(boolean value) {
            this.requestField("is_episode", value);
            return this;
        }

        public APIRequestGetVideos requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGetVideos requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGetVideos requestIsReferenceOnlyField() {
            return this.requestIsReferenceOnlyField(true);
        }

        public APIRequestGetVideos requestIsReferenceOnlyField(boolean value) {
            this.requestField("is_reference_only", value);
            return this;
        }

        public APIRequestGetVideos requestLengthField() {
            return this.requestLengthField(true);
        }

        public APIRequestGetVideos requestLengthField(boolean value) {
            this.requestField("length", value);
            return this;
        }

        public APIRequestGetVideos requestLiveAudienceCountField() {
            return this.requestLiveAudienceCountField(true);
        }

        public APIRequestGetVideos requestLiveAudienceCountField(boolean value) {
            this.requestField("live_audience_count", value);
            return this;
        }

        public APIRequestGetVideos requestLiveStatusField() {
            return this.requestLiveStatusField(true);
        }

        public APIRequestGetVideos requestLiveStatusField(boolean value) {
            this.requestField("live_status", value);
            return this;
        }

        public APIRequestGetVideos requestMusicVideoCopyrightField() {
            return this.requestMusicVideoCopyrightField(true);
        }

        public APIRequestGetVideos requestMusicVideoCopyrightField(boolean value) {
            this.requestField("music_video_copyright", value);
            return this;
        }

        public APIRequestGetVideos requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetVideos requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetVideos requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetVideos requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetVideos requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetVideos requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetVideos requestPostViewsField() {
            return this.requestPostViewsField(true);
        }

        public APIRequestGetVideos requestPostViewsField(boolean value) {
            this.requestField("post_views", value);
            return this;
        }

        public APIRequestGetVideos requestPremiereLivingRoomStatusField() {
            return this.requestPremiereLivingRoomStatusField(true);
        }

        public APIRequestGetVideos requestPremiereLivingRoomStatusField(boolean value) {
            this.requestField("premiere_living_room_status", value);
            return this;
        }

        public APIRequestGetVideos requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetVideos requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetVideos requestPublishedField() {
            return this.requestPublishedField(true);
        }

        public APIRequestGetVideos requestPublishedField(boolean value) {
            this.requestField("published", value);
            return this;
        }

        public APIRequestGetVideos requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetVideos requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetVideos requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetVideos requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetVideos requestSphericalField() {
            return this.requestSphericalField(true);
        }

        public APIRequestGetVideos requestSphericalField(boolean value) {
            this.requestField("spherical", value);
            return this;
        }

        public APIRequestGetVideos requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetVideos requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetVideos requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetVideos requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetVideos requestUniversalVideoIdField() {
            return this.requestUniversalVideoIdField(true);
        }

        public APIRequestGetVideos requestUniversalVideoIdField(boolean value) {
            this.requestField("universal_video_id", value);
            return this;
        }

        public APIRequestGetVideos requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetVideos requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetVideos requestViewsField() {
            return this.requestViewsField(true);
        }

        public APIRequestGetVideos requestViewsField(boolean value) {
            this.requestField("views", value);
            return this;
        }
    }

    public static class APIRequestCreateStagingResource
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"file"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, User>(){

                public User apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateStagingResource(String nodeId, APIContext context) {
            super(context, nodeId, "/staging_resources", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateStagingResource setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateStagingResource setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateStagingResource addUploadFile(String uploadName, File file) {
            this.setParam(uploadName, file);
            return this;
        }

        @Override
        public APIRequestCreateStagingResource setUseVideoEndpoint(boolean useVideoEndpoint) {
            this.useVideoEndpoint = useVideoEndpoint;
            return this;
        }

        public APIRequestCreateStagingResource requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateStagingResource requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateStagingResource requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateStagingResource requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateStagingResource requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateStagingResource requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetRichMediaDocuments
    extends APIRequest<Canvas> {
        APINodeList<Canvas> lastResponse = null;
        public static final String[] PARAMS = new String[]{"query"};
        public static final String[] FIELDS = new String[]{"background_color", "body_elements", "business_id", "canvas_link", "collection_hero_image", "collection_hero_video", "collection_thumbnails", "dynamic_setting", "element_payload", "elements", "fb_body_elements", "id", "is_hidden", "is_published", "last_editor", "linked_documents", "name", "owner", "property_list", "source_template", "store_url", "style_list", "tags", "ui_property_list", "unused_body_elements", "update_time", "use_retailer_item_ids"};

        @Override
        public APINodeList<Canvas> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Canvas> parseResponse(String response, String header) throws APIException {
            return Canvas.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Canvas> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Canvas> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Canvas>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Canvas>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Canvas>>(){

                public APINodeList<Canvas> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetRichMediaDocuments(String nodeId, APIContext context) {
            super(context, nodeId, "/rich_media_documents", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetRichMediaDocuments setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetRichMediaDocuments setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetRichMediaDocuments setQuery(String query) {
            this.setParam("query", query);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetRichMediaDocuments requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRichMediaDocuments requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetRichMediaDocuments requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRichMediaDocuments requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetRichMediaDocuments requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestBackgroundColorField() {
            return this.requestBackgroundColorField(true);
        }

        public APIRequestGetRichMediaDocuments requestBackgroundColorField(boolean value) {
            this.requestField("background_color", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestBodyElementsField() {
            return this.requestBodyElementsField(true);
        }

        public APIRequestGetRichMediaDocuments requestBodyElementsField(boolean value) {
            this.requestField("body_elements", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestBusinessIdField() {
            return this.requestBusinessIdField(true);
        }

        public APIRequestGetRichMediaDocuments requestBusinessIdField(boolean value) {
            this.requestField("business_id", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestCanvasLinkField() {
            return this.requestCanvasLinkField(true);
        }

        public APIRequestGetRichMediaDocuments requestCanvasLinkField(boolean value) {
            this.requestField("canvas_link", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestCollectionHeroImageField() {
            return this.requestCollectionHeroImageField(true);
        }

        public APIRequestGetRichMediaDocuments requestCollectionHeroImageField(boolean value) {
            this.requestField("collection_hero_image", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestCollectionHeroVideoField() {
            return this.requestCollectionHeroVideoField(true);
        }

        public APIRequestGetRichMediaDocuments requestCollectionHeroVideoField(boolean value) {
            this.requestField("collection_hero_video", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestCollectionThumbnailsField() {
            return this.requestCollectionThumbnailsField(true);
        }

        public APIRequestGetRichMediaDocuments requestCollectionThumbnailsField(boolean value) {
            this.requestField("collection_thumbnails", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestDynamicSettingField() {
            return this.requestDynamicSettingField(true);
        }

        public APIRequestGetRichMediaDocuments requestDynamicSettingField(boolean value) {
            this.requestField("dynamic_setting", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestElementPayloadField() {
            return this.requestElementPayloadField(true);
        }

        public APIRequestGetRichMediaDocuments requestElementPayloadField(boolean value) {
            this.requestField("element_payload", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestElementsField() {
            return this.requestElementsField(true);
        }

        public APIRequestGetRichMediaDocuments requestElementsField(boolean value) {
            this.requestField("elements", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestFbBodyElementsField() {
            return this.requestFbBodyElementsField(true);
        }

        public APIRequestGetRichMediaDocuments requestFbBodyElementsField(boolean value) {
            this.requestField("fb_body_elements", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetRichMediaDocuments requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetRichMediaDocuments requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetRichMediaDocuments requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestLastEditorField() {
            return this.requestLastEditorField(true);
        }

        public APIRequestGetRichMediaDocuments requestLastEditorField(boolean value) {
            this.requestField("last_editor", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestLinkedDocumentsField() {
            return this.requestLinkedDocumentsField(true);
        }

        public APIRequestGetRichMediaDocuments requestLinkedDocumentsField(boolean value) {
            this.requestField("linked_documents", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetRichMediaDocuments requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetRichMediaDocuments requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestPropertyListField() {
            return this.requestPropertyListField(true);
        }

        public APIRequestGetRichMediaDocuments requestPropertyListField(boolean value) {
            this.requestField("property_list", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestSourceTemplateField() {
            return this.requestSourceTemplateField(true);
        }

        public APIRequestGetRichMediaDocuments requestSourceTemplateField(boolean value) {
            this.requestField("source_template", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestStoreUrlField() {
            return this.requestStoreUrlField(true);
        }

        public APIRequestGetRichMediaDocuments requestStoreUrlField(boolean value) {
            this.requestField("store_url", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestStyleListField() {
            return this.requestStyleListField(true);
        }

        public APIRequestGetRichMediaDocuments requestStyleListField(boolean value) {
            this.requestField("style_list", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGetRichMediaDocuments requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestUiPropertyListField() {
            return this.requestUiPropertyListField(true);
        }

        public APIRequestGetRichMediaDocuments requestUiPropertyListField(boolean value) {
            this.requestField("ui_property_list", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestUnusedBodyElementsField() {
            return this.requestUnusedBodyElementsField(true);
        }

        public APIRequestGetRichMediaDocuments requestUnusedBodyElementsField(boolean value) {
            this.requestField("unused_body_elements", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGetRichMediaDocuments requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestUseRetailerItemIdsField() {
            return this.requestUseRetailerItemIdsField(true);
        }

        public APIRequestGetRichMediaDocuments requestUseRetailerItemIdsField(boolean value) {
            this.requestField("use_retailer_item_ids", value);
            return this;
        }
    }

    public static class APIRequestGetPosts
    extends APIRequest<Post> {
        APINodeList<Post> lastResponse = null;
        public static final String[] PARAMS = new String[]{"include_hidden", "q", "show_expired", "since", "until", "with"};
        public static final String[] FIELDS = new String[]{"actions", "admin_creator", "allowed_advertising_objectives", "application", "backdated_time", "call_to_action", "can_reply_privately", "caption", "child_attachments", "comments_mirroring_domain", "coordinates", "created_time", "description", "event", "expanded_height", "expanded_width", "feed_targeting", "from", "full_picture", "height", "icon", "id", "instagram_eligibility", "is_app_share", "is_eligible_for_promotion", "is_expired", "is_hidden", "is_inline_created", "is_instagram_eligible", "is_popular", "is_published", "is_spherical", "link", "message", "message_tags", "multi_share_end_card", "multi_share_optimized", "name", "object_id", "parent_id", "permalink_url", "picture", "place", "privacy", "promotable_id", "promotion_status", "properties", "scheduled_publish_time", "shares", "source", "status_type", "story", "story_tags", "subscribed", "target", "targeting", "timeline_visibility", "type", "updated_time", "via", "video_buying_eligibility", "width"};

        @Override
        public APINodeList<Post> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Post> parseResponse(String response, String header) throws APIException {
            return Post.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Post> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Post> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Post>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Post>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Post>>(){

                public APINodeList<Post> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPosts(String nodeId, APIContext context) {
            super(context, nodeId, "/posts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPosts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPosts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPosts setIncludeHidden(Boolean includeHidden) {
            this.setParam("include_hidden", includeHidden);
            return this;
        }

        public APIRequestGetPosts setIncludeHidden(String includeHidden) {
            this.setParam("include_hidden", includeHidden);
            return this;
        }

        public APIRequestGetPosts setQ(String q) {
            this.setParam("q", q);
            return this;
        }

        public APIRequestGetPosts setShowExpired(Boolean showExpired) {
            this.setParam("show_expired", showExpired);
            return this;
        }

        public APIRequestGetPosts setShowExpired(String showExpired) {
            this.setParam("show_expired", showExpired);
            return this;
        }

        public APIRequestGetPosts setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetPosts setUntil(String until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestGetPosts setWith(String with) {
            this.setParam("with", with);
            return this;
        }

        public APIRequestGetPosts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPosts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPosts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPosts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPosts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPosts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPosts requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGetPosts requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGetPosts requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGetPosts requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGetPosts requestAllowedAdvertisingObjectivesField() {
            return this.requestAllowedAdvertisingObjectivesField(true);
        }

        public APIRequestGetPosts requestAllowedAdvertisingObjectivesField(boolean value) {
            this.requestField("allowed_advertising_objectives", value);
            return this;
        }

        public APIRequestGetPosts requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetPosts requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetPosts requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetPosts requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetPosts requestCallToActionField() {
            return this.requestCallToActionField(true);
        }

        public APIRequestGetPosts requestCallToActionField(boolean value) {
            this.requestField("call_to_action", value);
            return this;
        }

        public APIRequestGetPosts requestCanReplyPrivatelyField() {
            return this.requestCanReplyPrivatelyField(true);
        }

        public APIRequestGetPosts requestCanReplyPrivatelyField(boolean value) {
            this.requestField("can_reply_privately", value);
            return this;
        }

        public APIRequestGetPosts requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGetPosts requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGetPosts requestChildAttachmentsField() {
            return this.requestChildAttachmentsField(true);
        }

        public APIRequestGetPosts requestChildAttachmentsField(boolean value) {
            this.requestField("child_attachments", value);
            return this;
        }

        public APIRequestGetPosts requestCommentsMirroringDomainField() {
            return this.requestCommentsMirroringDomainField(true);
        }

        public APIRequestGetPosts requestCommentsMirroringDomainField(boolean value) {
            this.requestField("comments_mirroring_domain", value);
            return this;
        }

        public APIRequestGetPosts requestCoordinatesField() {
            return this.requestCoordinatesField(true);
        }

        public APIRequestGetPosts requestCoordinatesField(boolean value) {
            this.requestField("coordinates", value);
            return this;
        }

        public APIRequestGetPosts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetPosts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetPosts requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetPosts requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetPosts requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetPosts requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetPosts requestExpandedHeightField() {
            return this.requestExpandedHeightField(true);
        }

        public APIRequestGetPosts requestExpandedHeightField(boolean value) {
            this.requestField("expanded_height", value);
            return this;
        }

        public APIRequestGetPosts requestExpandedWidthField() {
            return this.requestExpandedWidthField(true);
        }

        public APIRequestGetPosts requestExpandedWidthField(boolean value) {
            this.requestField("expanded_width", value);
            return this;
        }

        public APIRequestGetPosts requestFeedTargetingField() {
            return this.requestFeedTargetingField(true);
        }

        public APIRequestGetPosts requestFeedTargetingField(boolean value) {
            this.requestField("feed_targeting", value);
            return this;
        }

        public APIRequestGetPosts requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetPosts requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetPosts requestFullPictureField() {
            return this.requestFullPictureField(true);
        }

        public APIRequestGetPosts requestFullPictureField(boolean value) {
            this.requestField("full_picture", value);
            return this;
        }

        public APIRequestGetPosts requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPosts requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPosts requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetPosts requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetPosts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPosts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPosts requestInstagramEligibilityField() {
            return this.requestInstagramEligibilityField(true);
        }

        public APIRequestGetPosts requestInstagramEligibilityField(boolean value) {
            this.requestField("instagram_eligibility", value);
            return this;
        }

        public APIRequestGetPosts requestIsAppShareField() {
            return this.requestIsAppShareField(true);
        }

        public APIRequestGetPosts requestIsAppShareField(boolean value) {
            this.requestField("is_app_share", value);
            return this;
        }

        public APIRequestGetPosts requestIsEligibleForPromotionField() {
            return this.requestIsEligibleForPromotionField(true);
        }

        public APIRequestGetPosts requestIsEligibleForPromotionField(boolean value) {
            this.requestField("is_eligible_for_promotion", value);
            return this;
        }

        public APIRequestGetPosts requestIsExpiredField() {
            return this.requestIsExpiredField(true);
        }

        public APIRequestGetPosts requestIsExpiredField(boolean value) {
            this.requestField("is_expired", value);
            return this;
        }

        public APIRequestGetPosts requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetPosts requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetPosts requestIsInlineCreatedField() {
            return this.requestIsInlineCreatedField(true);
        }

        public APIRequestGetPosts requestIsInlineCreatedField(boolean value) {
            this.requestField("is_inline_created", value);
            return this;
        }

        public APIRequestGetPosts requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGetPosts requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGetPosts requestIsPopularField() {
            return this.requestIsPopularField(true);
        }

        public APIRequestGetPosts requestIsPopularField(boolean value) {
            this.requestField("is_popular", value);
            return this;
        }

        public APIRequestGetPosts requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetPosts requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetPosts requestIsSphericalField() {
            return this.requestIsSphericalField(true);
        }

        public APIRequestGetPosts requestIsSphericalField(boolean value) {
            this.requestField("is_spherical", value);
            return this;
        }

        public APIRequestGetPosts requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetPosts requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetPosts requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetPosts requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetPosts requestMessageTagsField() {
            return this.requestMessageTagsField(true);
        }

        public APIRequestGetPosts requestMessageTagsField(boolean value) {
            this.requestField("message_tags", value);
            return this;
        }

        public APIRequestGetPosts requestMultiShareEndCardField() {
            return this.requestMultiShareEndCardField(true);
        }

        public APIRequestGetPosts requestMultiShareEndCardField(boolean value) {
            this.requestField("multi_share_end_card", value);
            return this;
        }

        public APIRequestGetPosts requestMultiShareOptimizedField() {
            return this.requestMultiShareOptimizedField(true);
        }

        public APIRequestGetPosts requestMultiShareOptimizedField(boolean value) {
            this.requestField("multi_share_optimized", value);
            return this;
        }

        public APIRequestGetPosts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPosts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPosts requestObjectIdField() {
            return this.requestObjectIdField(true);
        }

        public APIRequestGetPosts requestObjectIdField(boolean value) {
            this.requestField("object_id", value);
            return this;
        }

        public APIRequestGetPosts requestParentIdField() {
            return this.requestParentIdField(true);
        }

        public APIRequestGetPosts requestParentIdField(boolean value) {
            this.requestField("parent_id", value);
            return this;
        }

        public APIRequestGetPosts requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetPosts requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetPosts requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetPosts requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetPosts requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetPosts requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetPosts requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetPosts requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetPosts requestPromotableIdField() {
            return this.requestPromotableIdField(true);
        }

        public APIRequestGetPosts requestPromotableIdField(boolean value) {
            this.requestField("promotable_id", value);
            return this;
        }

        public APIRequestGetPosts requestPromotionStatusField() {
            return this.requestPromotionStatusField(true);
        }

        public APIRequestGetPosts requestPromotionStatusField(boolean value) {
            this.requestField("promotion_status", value);
            return this;
        }

        public APIRequestGetPosts requestPropertiesField() {
            return this.requestPropertiesField(true);
        }

        public APIRequestGetPosts requestPropertiesField(boolean value) {
            this.requestField("properties", value);
            return this;
        }

        public APIRequestGetPosts requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetPosts requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetPosts requestSharesField() {
            return this.requestSharesField(true);
        }

        public APIRequestGetPosts requestSharesField(boolean value) {
            this.requestField("shares", value);
            return this;
        }

        public APIRequestGetPosts requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetPosts requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetPosts requestStatusTypeField() {
            return this.requestStatusTypeField(true);
        }

        public APIRequestGetPosts requestStatusTypeField(boolean value) {
            this.requestField("status_type", value);
            return this;
        }

        public APIRequestGetPosts requestStoryField() {
            return this.requestStoryField(true);
        }

        public APIRequestGetPosts requestStoryField(boolean value) {
            this.requestField("story", value);
            return this;
        }

        public APIRequestGetPosts requestStoryTagsField() {
            return this.requestStoryTagsField(true);
        }

        public APIRequestGetPosts requestStoryTagsField(boolean value) {
            this.requestField("story_tags", value);
            return this;
        }

        public APIRequestGetPosts requestSubscribedField() {
            return this.requestSubscribedField(true);
        }

        public APIRequestGetPosts requestSubscribedField(boolean value) {
            this.requestField("subscribed", value);
            return this;
        }

        public APIRequestGetPosts requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGetPosts requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGetPosts requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetPosts requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetPosts requestTimelineVisibilityField() {
            return this.requestTimelineVisibilityField(true);
        }

        public APIRequestGetPosts requestTimelineVisibilityField(boolean value) {
            this.requestField("timeline_visibility", value);
            return this;
        }

        public APIRequestGetPosts requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetPosts requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetPosts requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetPosts requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetPosts requestViaField() {
            return this.requestViaField(true);
        }

        public APIRequestGetPosts requestViaField(boolean value) {
            this.requestField("via", value);
            return this;
        }

        public APIRequestGetPosts requestVideoBuyingEligibilityField() {
            return this.requestVideoBuyingEligibilityField(true);
        }

        public APIRequestGetPosts requestVideoBuyingEligibilityField(boolean value) {
            this.requestField("video_buying_eligibility", value);
            return this;
        }

        public APIRequestGetPosts requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPosts requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    public static class APIRequestGetPicture
    extends APIRequest<ProfilePictureSource> {
        APINodeList<ProfilePictureSource> lastResponse = null;
        public static final String[] PARAMS = new String[]{"breaking_change", "height", "redirect", "type", "width"};
        public static final String[] FIELDS = new String[]{"bottom", "cache_key", "height", "is_silhouette", "left", "right", "top", "url", "width"};

        @Override
        public APINodeList<ProfilePictureSource> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProfilePictureSource> parseResponse(String response, String header) throws APIException {
            return ProfilePictureSource.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ProfilePictureSource> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ProfilePictureSource>>(){

                public APINodeList<ProfilePictureSource> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPicture(String nodeId, APIContext context) {
            super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPicture setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPicture setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPicture setBreakingChange(ProfilePictureSource.EnumBreakingChange breakingChange) {
            this.setParam("breaking_change", (Object)breakingChange);
            return this;
        }

        public APIRequestGetPicture setBreakingChange(String breakingChange) {
            this.setParam("breaking_change", breakingChange);
            return this;
        }

        public APIRequestGetPicture setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setRedirect(Boolean redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setRedirect(String redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setType(ProfilePictureSource.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPicture setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPicture setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPicture requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPicture requestBottomField() {
            return this.requestBottomField(true);
        }

        public APIRequestGetPicture requestBottomField(boolean value) {
            this.requestField("bottom", value);
            return this;
        }

        public APIRequestGetPicture requestCacheKeyField() {
            return this.requestCacheKeyField(true);
        }

        public APIRequestGetPicture requestCacheKeyField(boolean value) {
            this.requestField("cache_key", value);
            return this;
        }

        public APIRequestGetPicture requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPicture requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPicture requestIsSilhouetteField() {
            return this.requestIsSilhouetteField(true);
        }

        public APIRequestGetPicture requestIsSilhouetteField(boolean value) {
            this.requestField("is_silhouette", value);
            return this;
        }

        public APIRequestGetPicture requestLeftField() {
            return this.requestLeftField(true);
        }

        public APIRequestGetPicture requestLeftField(boolean value) {
            this.requestField("left", value);
            return this;
        }

        public APIRequestGetPicture requestRightField() {
            return this.requestRightField(true);
        }

        public APIRequestGetPicture requestRightField(boolean value) {
            this.requestField("right", value);
            return this;
        }

        public APIRequestGetPicture requestTopField() {
            return this.requestTopField(true);
        }

        public APIRequestGetPicture requestTopField(boolean value) {
            this.requestField("top", value);
            return this;
        }

        public APIRequestGetPicture requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetPicture requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetPicture requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPicture requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    public static class APIRequestCreatePhoto
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[]{"aid", "allow_spherical_photo", "alt_text_custom", "android_key_hash", "application_id", "attempt", "audience_exp", "backdated_time", "backdated_time_granularity", "caption", "composer_session_id", "direct_share_status", "feed_targeting", "filter_type", "full_res_is_coming_later", "initial_view_heading_override_degrees", "initial_view_pitch_override_degrees", "initial_view_vertical_fov_override_degrees", "ios_bundle_id", "is_explicit_location", "is_explicit_place", "manual_privacy", "message", "name", "no_story", "offline_id", "og_action_type_id", "og_icon_id", "og_object_id", "og_phrase", "og_set_profile_badge", "og_suggestion_mechanism", "place", "privacy", "profile_id", "proxied_app_id", "published", "qn", "scheduled_publish_time", "spherical_metadata", "sponsor_id", "sponsor_relationship", "tags", "target_id", "targeting", "time_since_original_post", "uid", "unpublished_content_type", "url", "user_selected_tags", "vault_image_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response, String header) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Photo>(){

                public Photo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePhoto(String nodeId, APIContext context) {
            super(context, nodeId, "/photos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePhoto setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePhoto setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePhoto setAid(String aid) {
            this.setParam("aid", aid);
            return this;
        }

        public APIRequestCreatePhoto setAllowSphericalPhoto(Boolean allowSphericalPhoto) {
            this.setParam("allow_spherical_photo", allowSphericalPhoto);
            return this;
        }

        public APIRequestCreatePhoto setAllowSphericalPhoto(String allowSphericalPhoto) {
            this.setParam("allow_spherical_photo", allowSphericalPhoto);
            return this;
        }

        public APIRequestCreatePhoto setAltTextCustom(String altTextCustom) {
            this.setParam("alt_text_custom", altTextCustom);
            return this;
        }

        public APIRequestCreatePhoto setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestCreatePhoto setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreatePhoto setAttempt(Long attempt) {
            this.setParam("attempt", attempt);
            return this;
        }

        public APIRequestCreatePhoto setAttempt(String attempt) {
            this.setParam("attempt", attempt);
            return this;
        }

        public APIRequestCreatePhoto setAudienceExp(Boolean audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreatePhoto setAudienceExp(String audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTime(String backdatedTime) {
            this.setParam("backdated_time", backdatedTime);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTimeGranularity(Photo.EnumBackdatedTimeGranularity backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", (Object)backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTimeGranularity(String backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreatePhoto setCaption(String caption) {
            this.setParam("caption", caption);
            return this;
        }

        public APIRequestCreatePhoto setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreatePhoto setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreatePhoto setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreatePhoto setFeedTargeting(Object feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreatePhoto setFeedTargeting(String feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreatePhoto setFilterType(Long filterType) {
            this.setParam("filter_type", filterType);
            return this;
        }

        public APIRequestCreatePhoto setFilterType(String filterType) {
            this.setParam("filter_type", filterType);
            return this;
        }

        public APIRequestCreatePhoto setFullResIsComingLater(Boolean fullResIsComingLater) {
            this.setParam("full_res_is_coming_later", fullResIsComingLater);
            return this;
        }

        public APIRequestCreatePhoto setFullResIsComingLater(String fullResIsComingLater) {
            this.setParam("full_res_is_coming_later", fullResIsComingLater);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees(Long initialViewHeadingOverrideDegrees) {
            this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees(String initialViewHeadingOverrideDegrees) {
            this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees(Long initialViewPitchOverrideDegrees) {
            this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees(String initialViewPitchOverrideDegrees) {
            this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees(Long initialViewVerticalFovOverrideDegrees) {
            this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees(String initialViewVerticalFovOverrideDegrees) {
            this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitLocation(Boolean isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitLocation(String isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitPlace(Boolean isExplicitPlace) {
            this.setParam("is_explicit_place", isExplicitPlace);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitPlace(String isExplicitPlace) {
            this.setParam("is_explicit_place", isExplicitPlace);
            return this;
        }

        public APIRequestCreatePhoto setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreatePhoto setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreatePhoto setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreatePhoto setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreatePhoto setNoStory(Boolean noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreatePhoto setNoStory(String noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreatePhoto setOfflineId(Long offlineId) {
            this.setParam("offline_id", offlineId);
            return this;
        }

        public APIRequestCreatePhoto setOfflineId(String offlineId) {
            this.setParam("offline_id", offlineId);
            return this;
        }

        public APIRequestCreatePhoto setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestCreatePhoto setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestCreatePhoto setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestCreatePhoto setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestCreatePhoto setOgSetProfileBadge(Boolean ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreatePhoto setOgSetProfileBadge(String ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreatePhoto setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestCreatePhoto setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreatePhoto setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreatePhoto setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreatePhoto setProfileId(Long profileId) {
            this.setParam("profile_id", profileId);
            return this;
        }

        public APIRequestCreatePhoto setProfileId(String profileId) {
            this.setParam("profile_id", profileId);
            return this;
        }

        public APIRequestCreatePhoto setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestCreatePhoto setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreatePhoto setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreatePhoto setQn(String qn) {
            this.setParam("qn", qn);
            return this;
        }

        public APIRequestCreatePhoto setScheduledPublishTime(Long scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreatePhoto setScheduledPublishTime(String scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreatePhoto setSphericalMetadata(Map<String, String> sphericalMetadata) {
            this.setParam("spherical_metadata", sphericalMetadata);
            return this;
        }

        public APIRequestCreatePhoto setSphericalMetadata(String sphericalMetadata) {
            this.setParam("spherical_metadata", sphericalMetadata);
            return this;
        }

        public APIRequestCreatePhoto setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestCreatePhoto setSponsorRelationship(Long sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreatePhoto setSponsorRelationship(String sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreatePhoto setTags(List<Object> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreatePhoto setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreatePhoto setTargetId(Long targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestCreatePhoto setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestCreatePhoto setTargeting(Object targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreatePhoto setTargeting(String targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreatePhoto setTimeSinceOriginalPost(Long timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreatePhoto setTimeSinceOriginalPost(String timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreatePhoto setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreatePhoto setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreatePhoto setUnpublishedContentType(Photo.EnumUnpublishedContentType unpublishedContentType) {
            this.setParam("unpublished_content_type", (Object)unpublishedContentType);
            return this;
        }

        public APIRequestCreatePhoto setUnpublishedContentType(String unpublishedContentType) {
            this.setParam("unpublished_content_type", unpublishedContentType);
            return this;
        }

        public APIRequestCreatePhoto setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestCreatePhoto setUserSelectedTags(Boolean userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreatePhoto setUserSelectedTags(String userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreatePhoto setVaultImageId(String vaultImageId) {
            this.setParam("vault_image_id", vaultImageId);
            return this;
        }

        public APIRequestCreatePhoto requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePhoto requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePhoto requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetPhotos
    extends APIRequest<Photo> {
        APINodeList<Photo> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[]{"album", "alt_text", "alt_text_custom", "backdated_time", "backdated_time_granularity", "can_backdate", "can_delete", "can_tag", "created_time", "event", "from", "height", "icon", "id", "images", "link", "name", "name_tags", "page_story_id", "picture", "place", "position", "source", "target", "updated_time", "webp_images", "width"};

        @Override
        public APINodeList<Photo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Photo> parseResponse(String response, String header) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Photo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Photo> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Photo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Photo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Photo>>(){

                public APINodeList<Photo> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPhotos(String nodeId, APIContext context) {
            super(context, nodeId, "/photos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPhotos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPhotos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPhotos setType(Photo.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPhotos setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPhotos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPhotos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPhotos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPhotos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPhotos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPhotos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPhotos requestAlbumField() {
            return this.requestAlbumField(true);
        }

        public APIRequestGetPhotos requestAlbumField(boolean value) {
            this.requestField("album", value);
            return this;
        }

        public APIRequestGetPhotos requestAltTextField() {
            return this.requestAltTextField(true);
        }

        public APIRequestGetPhotos requestAltTextField(boolean value) {
            this.requestField("alt_text", value);
            return this;
        }

        public APIRequestGetPhotos requestAltTextCustomField() {
            return this.requestAltTextCustomField(true);
        }

        public APIRequestGetPhotos requestAltTextCustomField(boolean value) {
            this.requestField("alt_text_custom", value);
            return this;
        }

        public APIRequestGetPhotos requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetPhotos requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetPhotos requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGetPhotos requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGetPhotos requestCanBackdateField() {
            return this.requestCanBackdateField(true);
        }

        public APIRequestGetPhotos requestCanBackdateField(boolean value) {
            this.requestField("can_backdate", value);
            return this;
        }

        public APIRequestGetPhotos requestCanDeleteField() {
            return this.requestCanDeleteField(true);
        }

        public APIRequestGetPhotos requestCanDeleteField(boolean value) {
            this.requestField("can_delete", value);
            return this;
        }

        public APIRequestGetPhotos requestCanTagField() {
            return this.requestCanTagField(true);
        }

        public APIRequestGetPhotos requestCanTagField(boolean value) {
            this.requestField("can_tag", value);
            return this;
        }

        public APIRequestGetPhotos requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetPhotos requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetPhotos requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetPhotos requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetPhotos requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetPhotos requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetPhotos requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPhotos requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPhotos requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetPhotos requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetPhotos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPhotos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPhotos requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGetPhotos requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGetPhotos requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetPhotos requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetPhotos requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPhotos requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPhotos requestNameTagsField() {
            return this.requestNameTagsField(true);
        }

        public APIRequestGetPhotos requestNameTagsField(boolean value) {
            this.requestField("name_tags", value);
            return this;
        }

        public APIRequestGetPhotos requestPageStoryIdField() {
            return this.requestPageStoryIdField(true);
        }

        public APIRequestGetPhotos requestPageStoryIdField(boolean value) {
            this.requestField("page_story_id", value);
            return this;
        }

        public APIRequestGetPhotos requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetPhotos requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetPhotos requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetPhotos requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetPhotos requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGetPhotos requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }

        public APIRequestGetPhotos requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetPhotos requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetPhotos requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGetPhotos requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGetPhotos requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetPhotos requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetPhotos requestWebpImagesField() {
            return this.requestWebpImagesField(true);
        }

        public APIRequestGetPhotos requestWebpImagesField(boolean value) {
            this.requestField("webp_images", value);
            return this;
        }

        public APIRequestGetPhotos requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPhotos requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    public static class APIRequestGetPersonalAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "custom_audience_info", "default_dsa_beneficiary", "default_dsa_payor", "disable_reason", "end_advertiser", "end_advertiser_name", "existing_customers", "extended_credit_invoice_group", "failed_delivery_checks", "fb_entity", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "liable_address", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "owner_business", "partner", "rf_spec", "send_bill_to_address", "show_checkout_experience", "sold_to_address", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_tasks", "user_tos_accepted", "viewable_business"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPersonalAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/personal_ad_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPersonalAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPersonalAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPersonalAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPersonalAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPersonalAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPersonalAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPersonalAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetPersonalAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetPersonalAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestCustomAudienceInfoField() {
            return this.requestCustomAudienceInfoField(true);
        }

        public APIRequestGetPersonalAdAccounts requestCustomAudienceInfoField(boolean value) {
            this.requestField("custom_audience_info", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestDefaultDsaBeneficiaryField() {
            return this.requestDefaultDsaBeneficiaryField(true);
        }

        public APIRequestGetPersonalAdAccounts requestDefaultDsaBeneficiaryField(boolean value) {
            this.requestField("default_dsa_beneficiary", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestDefaultDsaPayorField() {
            return this.requestDefaultDsaPayorField(true);
        }

        public APIRequestGetPersonalAdAccounts requestDefaultDsaPayorField(boolean value) {
            this.requestField("default_dsa_payor", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetPersonalAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetPersonalAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetPersonalAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestExistingCustomersField() {
            return this.requestExistingCustomersField(true);
        }

        public APIRequestGetPersonalAdAccounts requestExistingCustomersField(boolean value) {
            this.requestField("existing_customers", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetPersonalAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetPersonalAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestFbEntityField() {
            return this.requestFbEntityField(true);
        }

        public APIRequestGetPersonalAdAccounts requestFbEntityField(boolean value) {
            this.requestField("fb_entity", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetPersonalAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetPersonalAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetPersonalAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetPersonalAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestLiableAddressField() {
            return this.requestLiableAddressField(true);
        }

        public APIRequestGetPersonalAdAccounts requestLiableAddressField(boolean value) {
            this.requestField("liable_address", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetPersonalAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetPersonalAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetPersonalAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetPersonalAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPersonalAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetPersonalAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetPersonalAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetPersonalAdAccounts requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetPersonalAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetPersonalAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestSendBillToAddressField() {
            return this.requestSendBillToAddressField(true);
        }

        public APIRequestGetPersonalAdAccounts requestSendBillToAddressField(boolean value) {
            this.requestField("send_bill_to_address", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetPersonalAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestSoldToAddressField() {
            return this.requestSoldToAddressField(true);
        }

        public APIRequestGetPersonalAdAccounts requestSoldToAddressField(boolean value) {
            this.requestField("sold_to_address", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetPersonalAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestUserTasksField() {
            return this.requestUserTasksField(true);
        }

        public APIRequestGetPersonalAdAccounts requestUserTasksField(boolean value) {
            this.requestField("user_tasks", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetPersonalAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestViewableBusinessField() {
            return this.requestViewableBusinessField(true);
        }

        public APIRequestGetPersonalAdAccounts requestViewableBusinessField(boolean value) {
            this.requestField("viewable_business", value);
            return this;
        }
    }

    public static class APIRequestGetPermissions
    extends APIRequest<Permission> {
        APINodeList<Permission> lastResponse = null;
        public static final String[] PARAMS = new String[]{"permission", "status"};
        public static final String[] FIELDS = new String[]{"permission", "status"};

        @Override
        public APINodeList<Permission> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Permission> parseResponse(String response, String header) throws APIException {
            return Permission.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Permission> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Permission> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Permission>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Permission>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Permission>>(){

                public APINodeList<Permission> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/permissions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPermissions setPermission(String permission) {
            this.setParam("permission", permission);
            return this;
        }

        public APIRequestGetPermissions setStatus(Permission.EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestGetPermissions setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetPermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPermissions requestPermissionField() {
            return this.requestPermissionField(true);
        }

        public APIRequestGetPermissions requestPermissionField(boolean value) {
            this.requestField("permission", value);
            return this;
        }

        public APIRequestGetPermissions requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetPermissions requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }

    public static class APIRequestDeletePermissions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"permission"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeletePermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/permissions", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeletePermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeletePermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeletePermissions setPermission(String permission) {
            this.setParam("permission", permission);
            return this;
        }

        public APIRequestDeletePermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeletePermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeletePermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeletePermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeletePermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeletePermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetPaymentTransactions
    extends APIRequest<PaymentEnginePayment> {
        APINodeList<PaymentEnginePayment> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"actions", "application", "country", "created_time", "disputes", "fraud_status", "fulfillment_status", "id", "is_from_ad", "is_from_page_post", "items", "payout_foreign_exchange_rate", "phone_support_eligible", "platform", "refundable_amount", "request_id", "tax", "tax_country", "test", "user"};

        @Override
        public APINodeList<PaymentEnginePayment> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<PaymentEnginePayment> parseResponse(String response, String header) throws APIException {
            return PaymentEnginePayment.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<PaymentEnginePayment> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<PaymentEnginePayment> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<PaymentEnginePayment>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<PaymentEnginePayment>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<PaymentEnginePayment>>(){

                public APINodeList<PaymentEnginePayment> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPaymentTransactions(String nodeId, APIContext context) {
            super(context, nodeId, "/payment_transactions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPaymentTransactions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPaymentTransactions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPaymentTransactions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPaymentTransactions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPaymentTransactions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPaymentTransactions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPaymentTransactions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPaymentTransactions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGetPaymentTransactions requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetPaymentTransactions requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGetPaymentTransactions requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetPaymentTransactions requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestDisputesField() {
            return this.requestDisputesField(true);
        }

        public APIRequestGetPaymentTransactions requestDisputesField(boolean value) {
            this.requestField("disputes", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestFraudStatusField() {
            return this.requestFraudStatusField(true);
        }

        public APIRequestGetPaymentTransactions requestFraudStatusField(boolean value) {
            this.requestField("fraud_status", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestFulfillmentStatusField() {
            return this.requestFulfillmentStatusField(true);
        }

        public APIRequestGetPaymentTransactions requestFulfillmentStatusField(boolean value) {
            this.requestField("fulfillment_status", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPaymentTransactions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestIsFromAdField() {
            return this.requestIsFromAdField(true);
        }

        public APIRequestGetPaymentTransactions requestIsFromAdField(boolean value) {
            this.requestField("is_from_ad", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestIsFromPagePostField() {
            return this.requestIsFromPagePostField(true);
        }

        public APIRequestGetPaymentTransactions requestIsFromPagePostField(boolean value) {
            this.requestField("is_from_page_post", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestItemsField() {
            return this.requestItemsField(true);
        }

        public APIRequestGetPaymentTransactions requestItemsField(boolean value) {
            this.requestField("items", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestPayoutForeignExchangeRateField() {
            return this.requestPayoutForeignExchangeRateField(true);
        }

        public APIRequestGetPaymentTransactions requestPayoutForeignExchangeRateField(boolean value) {
            this.requestField("payout_foreign_exchange_rate", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestPhoneSupportEligibleField() {
            return this.requestPhoneSupportEligibleField(true);
        }

        public APIRequestGetPaymentTransactions requestPhoneSupportEligibleField(boolean value) {
            this.requestField("phone_support_eligible", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestPlatformField() {
            return this.requestPlatformField(true);
        }

        public APIRequestGetPaymentTransactions requestPlatformField(boolean value) {
            this.requestField("platform", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestRefundableAmountField() {
            return this.requestRefundableAmountField(true);
        }

        public APIRequestGetPaymentTransactions requestRefundableAmountField(boolean value) {
            this.requestField("refundable_amount", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestRequestIdField() {
            return this.requestRequestIdField(true);
        }

        public APIRequestGetPaymentTransactions requestRequestIdField(boolean value) {
            this.requestField("request_id", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestTaxField() {
            return this.requestTaxField(true);
        }

        public APIRequestGetPaymentTransactions requestTaxField(boolean value) {
            this.requestField("tax", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestTaxCountryField() {
            return this.requestTaxCountryField(true);
        }

        public APIRequestGetPaymentTransactions requestTaxCountryField(boolean value) {
            this.requestField("tax_country", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestTestField() {
            return this.requestTestField(true);
        }

        public APIRequestGetPaymentTransactions requestTestField(boolean value) {
            this.requestField("test", value);
            return this;
        }

        public APIRequestGetPaymentTransactions requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGetPaymentTransactions requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }
    }

    public static class APIRequestCreateNotification
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"bot_message_payload_elements", "filtering", "href", "label", "message", "notif_ids", "payload", "read", "ref", "schedule_interval", "seen", "template", "type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, User>(){

                public User apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateNotification(String nodeId, APIContext context) {
            super(context, nodeId, "/notifications", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateNotification setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateNotification setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateNotification setBotMessagePayloadElements(String botMessagePayloadElements) {
            this.setParam("bot_message_payload_elements", botMessagePayloadElements);
            return this;
        }

        public APIRequestCreateNotification setFiltering(List<EnumFiltering> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestCreateNotification setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestCreateNotification setHref(Object href) {
            this.setParam("href", href);
            return this;
        }

        public APIRequestCreateNotification setHref(String href) {
            this.setParam("href", href);
            return this;
        }

        public APIRequestCreateNotification setLabel(String label) {
            this.setParam("label", label);
            return this;
        }

        public APIRequestCreateNotification setMessage(Map<String, String> message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateNotification setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateNotification setNotifIds(List<String> notifIds) {
            this.setParam("notif_ids", notifIds);
            return this;
        }

        public APIRequestCreateNotification setNotifIds(String notifIds) {
            this.setParam("notif_ids", notifIds);
            return this;
        }

        public APIRequestCreateNotification setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateNotification setRead(Boolean read) {
            this.setParam("read", read);
            return this;
        }

        public APIRequestCreateNotification setRead(String read) {
            this.setParam("read", read);
            return this;
        }

        public APIRequestCreateNotification setRef(String ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateNotification setScheduleInterval(Long scheduleInterval) {
            this.setParam("schedule_interval", scheduleInterval);
            return this;
        }

        public APIRequestCreateNotification setScheduleInterval(String scheduleInterval) {
            this.setParam("schedule_interval", scheduleInterval);
            return this;
        }

        public APIRequestCreateNotification setSeen(Boolean seen) {
            this.setParam("seen", seen);
            return this;
        }

        public APIRequestCreateNotification setSeen(String seen) {
            this.setParam("seen", seen);
            return this;
        }

        public APIRequestCreateNotification setTemplate(Object template) {
            this.setParam("template", template);
            return this;
        }

        public APIRequestCreateNotification setTemplate(String template) {
            this.setParam("template", template);
            return this;
        }

        public APIRequestCreateNotification setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreateNotification setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateNotification requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateNotification requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateNotification requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateNotification requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateNotification requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateNotification requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetMusic
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"target_id"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "connected_page_backed_instagram_account", "contact_address", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "delivery_and_pickup_option_info", "description", "description_html", "differently_open_offerings", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "followers_count", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_root_id", "has_added_app", "has_transitioned_to_new_page_experience", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messaging_feature_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mini_shop_storefront", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "owner_business", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "pickup_options", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "privacy_info_url", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_donate_button_in_live_video", "talking_about_count", "temporary_status", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response, String header) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Page>>(){

                public APINodeList<Page> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetMusic(String nodeId, APIContext context) {
            super(context, nodeId, "/music", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMusic setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMusic setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMusic setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestGetMusic requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMusic requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMusic requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMusic requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMusic requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMusic requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetMusic requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetMusic requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetMusic requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetMusic requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetMusic requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetMusic requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetMusic requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetMusic requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetMusic requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetMusic requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetMusic requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetMusic requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetMusic requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetMusic requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetMusic requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetMusic requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetMusic requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetMusic requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetMusic requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetMusic requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetMusic requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetMusic requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetMusic requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetMusic requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetMusic requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetMusic requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetMusic requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetMusic requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetMusic requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetMusic requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetMusic requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetMusic requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetMusic requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetMusic requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetMusic requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetMusic requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetMusic requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetMusic requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetMusic requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetMusic requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetMusic requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetMusic requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetMusic requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetMusic requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetMusic requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetMusic requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetMusic requestConnectedPageBackedInstagramAccountField() {
            return this.requestConnectedPageBackedInstagramAccountField(true);
        }

        public APIRequestGetMusic requestConnectedPageBackedInstagramAccountField(boolean value) {
            this.requestField("connected_page_backed_instagram_account", value);
            return this;
        }

        public APIRequestGetMusic requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetMusic requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetMusic requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetMusic requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetMusic requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetMusic requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetMusic requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetMusic requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetMusic requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetMusic requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetMusic requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetMusic requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetMusic requestDeliveryAndPickupOptionInfoField() {
            return this.requestDeliveryAndPickupOptionInfoField(true);
        }

        public APIRequestGetMusic requestDeliveryAndPickupOptionInfoField(boolean value) {
            this.requestField("delivery_and_pickup_option_info", value);
            return this;
        }

        public APIRequestGetMusic requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetMusic requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetMusic requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetMusic requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetMusic requestDifferentlyOpenOfferingsField() {
            return this.requestDifferentlyOpenOfferingsField(true);
        }

        public APIRequestGetMusic requestDifferentlyOpenOfferingsField(boolean value) {
            this.requestField("differently_open_offerings", value);
            return this;
        }

        public APIRequestGetMusic requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetMusic requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetMusic requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetMusic requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetMusic requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetMusic requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetMusic requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetMusic requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetMusic requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetMusic requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetMusic requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetMusic requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetMusic requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetMusic requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetMusic requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetMusic requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetMusic requestFollowersCountField() {
            return this.requestFollowersCountField(true);
        }

        public APIRequestGetMusic requestFollowersCountField(boolean value) {
            this.requestField("followers_count", value);
            return this;
        }

        public APIRequestGetMusic requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetMusic requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetMusic requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetMusic requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetMusic requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetMusic requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetMusic requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetMusic requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetMusic requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetMusic requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetMusic requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetMusic requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetMusic requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetMusic requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetMusic requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetMusic requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetMusic requestHasTransitionedToNewPageExperienceField() {
            return this.requestHasTransitionedToNewPageExperienceField(true);
        }

        public APIRequestGetMusic requestHasTransitionedToNewPageExperienceField(boolean value) {
            this.requestField("has_transitioned_to_new_page_experience", value);
            return this;
        }

        public APIRequestGetMusic requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetMusic requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetMusic requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetMusic requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetMusic requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetMusic requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetMusic requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetMusic requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetMusic requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetMusic requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetMusic requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetMusic requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetMusic requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetMusic requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetMusic requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetMusic requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetMusic requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetMusic requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetMusic requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetMusic requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetMusic requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetMusic requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetMusic requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetMusic requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetMusic requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetMusic requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetMusic requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetMusic requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetMusic requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetMusic requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetMusic requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetMusic requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetMusic requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetMusic requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetMusic requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetMusic requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetMusic requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetMusic requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetMusic requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetMusic requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetMusic requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetMusic requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetMusic requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetMusic requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetMusic requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetMusic requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetMusic requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetMusic requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetMusic requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetMusic requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetMusic requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetMusic requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetMusic requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetMusic requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetMusic requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetMusic requestMessagingFeatureStatusField() {
            return this.requestMessagingFeatureStatusField(true);
        }

        public APIRequestGetMusic requestMessagingFeatureStatusField(boolean value) {
            this.requestField("messaging_feature_status", value);
            return this;
        }

        public APIRequestGetMusic requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetMusic requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetMusic requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetMusic requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetMusic requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetMusic requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetMusic requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetMusic requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetMusic requestMiniShopStorefrontField() {
            return this.requestMiniShopStorefrontField(true);
        }

        public APIRequestGetMusic requestMiniShopStorefrontField(boolean value) {
            this.requestField("mini_shop_storefront", value);
            return this;
        }

        public APIRequestGetMusic requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetMusic requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetMusic requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetMusic requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetMusic requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetMusic requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetMusic requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetMusic requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetMusic requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetMusic requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetMusic requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetMusic requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetMusic requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetMusic requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetMusic requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetMusic requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetMusic requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetMusic requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetMusic requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetMusic requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetMusic requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetMusic requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetMusic requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetMusic requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetMusic requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetMusic requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetMusic requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetMusic requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetMusic requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetMusic requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetMusic requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetMusic requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetMusic requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetMusic requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetMusic requestPickupOptionsField() {
            return this.requestPickupOptionsField(true);
        }

        public APIRequestGetMusic requestPickupOptionsField(boolean value) {
            this.requestField("pickup_options", value);
            return this;
        }

        public APIRequestGetMusic requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetMusic requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetMusic requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetMusic requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetMusic requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetMusic requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetMusic requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetMusic requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetMusic requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetMusic requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetMusic requestPrivacyInfoUrlField() {
            return this.requestPrivacyInfoUrlField(true);
        }

        public APIRequestGetMusic requestPrivacyInfoUrlField(boolean value) {
            this.requestField("privacy_info_url", value);
            return this;
        }

        public APIRequestGetMusic requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetMusic requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetMusic requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetMusic requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetMusic requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetMusic requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetMusic requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetMusic requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetMusic requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetMusic requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetMusic requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetMusic requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetMusic requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetMusic requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetMusic requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetMusic requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetMusic requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetMusic requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetMusic requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetMusic requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetMusic requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetMusic requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetMusic requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetMusic requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetMusic requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetMusic requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetMusic requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetMusic requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetMusic requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetMusic requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetMusic requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetMusic requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetMusic requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetMusic requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetMusic requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetMusic requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetMusic requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetMusic requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetMusic requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetMusic requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetMusic requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetMusic requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetMusic requestSupportsDonateButtonInLiveVideoField() {
            return this.requestSupportsDonateButtonInLiveVideoField(true);
        }

        public APIRequestGetMusic requestSupportsDonateButtonInLiveVideoField(boolean value) {
            this.requestField("supports_donate_button_in_live_video", value);
            return this;
        }

        public APIRequestGetMusic requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetMusic requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetMusic requestTemporaryStatusField() {
            return this.requestTemporaryStatusField(true);
        }

        public APIRequestGetMusic requestTemporaryStatusField(boolean value) {
            this.requestField("temporary_status", value);
            return this;
        }

        public APIRequestGetMusic requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetMusic requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetMusic requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetMusic requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetMusic requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetMusic requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetMusic requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetMusic requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetMusic requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetMusic requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetMusic requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetMusic requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetMusic requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetMusic requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetMusic requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetMusic requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetMusic requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetMusic requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetMusic requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetMusic requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    public static class APIRequestCreateMessengerDesktopPerformanceTrace
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, User>(){

                public User apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMessengerDesktopPerformanceTrace(String nodeId, APIContext context) {
            super(context, nodeId, "/messenger_desktop_performance_traces", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMessengerDesktopPerformanceTrace setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMessengerDesktopPerformanceTrace setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMessengerDesktopPerformanceTrace requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMessengerDesktopPerformanceTrace requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMessengerDesktopPerformanceTrace requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMessengerDesktopPerformanceTrace requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMessengerDesktopPerformanceTrace requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMessengerDesktopPerformanceTrace requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateLiveVideo
    extends APIRequest<LiveVideo> {
        LiveVideo lastResponse = null;
        public static final String[] PARAMS = new String[]{"content_tags", "description", "enable_backup_ingest", "encoding_settings", "event_params", "fisheye_video_cropped", "front_z_rotation", "is_audio_only", "is_spherical", "original_fov", "privacy", "projection", "published", "schedule_custom_profile_image", "spatial_audio_format", "status", "stereoscopic_mode", "stop_on_delete_stream", "stream_type", "title"};
        public static final String[] FIELDS = new String[0];

        @Override
        public LiveVideo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveVideo parseResponse(String response, String header) throws APIException {
            return LiveVideo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveVideo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveVideo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveVideo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveVideo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LiveVideo>(){

                public LiveVideo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLiveVideo(String nodeId, APIContext context) {
            super(context, nodeId, "/live_videos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLiveVideo setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLiveVideo setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLiveVideo setContentTags(List<String> contentTags) {
            this.setParam("content_tags", contentTags);
            return this;
        }

        public APIRequestCreateLiveVideo setContentTags(String contentTags) {
            this.setParam("content_tags", contentTags);
            return this;
        }

        public APIRequestCreateLiveVideo setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateLiveVideo setEnableBackupIngest(Boolean enableBackupIngest) {
            this.setParam("enable_backup_ingest", enableBackupIngest);
            return this;
        }

        public APIRequestCreateLiveVideo setEnableBackupIngest(String enableBackupIngest) {
            this.setParam("enable_backup_ingest", enableBackupIngest);
            return this;
        }

        public APIRequestCreateLiveVideo setEncodingSettings(String encodingSettings) {
            this.setParam("encoding_settings", encodingSettings);
            return this;
        }

        public APIRequestCreateLiveVideo setEventParams(Object eventParams) {
            this.setParam("event_params", eventParams);
            return this;
        }

        public APIRequestCreateLiveVideo setEventParams(String eventParams) {
            this.setParam("event_params", eventParams);
            return this;
        }

        public APIRequestCreateLiveVideo setFisheyeVideoCropped(Boolean fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateLiveVideo setFisheyeVideoCropped(String fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateLiveVideo setFrontZRotation(Double frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateLiveVideo setFrontZRotation(String frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateLiveVideo setIsAudioOnly(Boolean isAudioOnly) {
            this.setParam("is_audio_only", isAudioOnly);
            return this;
        }

        public APIRequestCreateLiveVideo setIsAudioOnly(String isAudioOnly) {
            this.setParam("is_audio_only", isAudioOnly);
            return this;
        }

        public APIRequestCreateLiveVideo setIsSpherical(Boolean isSpherical) {
            this.setParam("is_spherical", isSpherical);
            return this;
        }

        public APIRequestCreateLiveVideo setIsSpherical(String isSpherical) {
            this.setParam("is_spherical", isSpherical);
            return this;
        }

        public APIRequestCreateLiveVideo setOriginalFov(Long originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateLiveVideo setOriginalFov(String originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateLiveVideo setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateLiveVideo setProjection(LiveVideo.EnumProjection projection) {
            this.setParam("projection", (Object)projection);
            return this;
        }

        public APIRequestCreateLiveVideo setProjection(String projection) {
            this.setParam("projection", projection);
            return this;
        }

        public APIRequestCreateLiveVideo setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateLiveVideo setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateLiveVideo setScheduleCustomProfileImage(File scheduleCustomProfileImage) {
            this.setParam("schedule_custom_profile_image", scheduleCustomProfileImage);
            return this;
        }

        public APIRequestCreateLiveVideo setScheduleCustomProfileImage(String scheduleCustomProfileImage) {
            this.setParam("schedule_custom_profile_image", scheduleCustomProfileImage);
            return this;
        }

        public APIRequestCreateLiveVideo setSpatialAudioFormat(LiveVideo.EnumSpatialAudioFormat spatialAudioFormat) {
            this.setParam("spatial_audio_format", (Object)spatialAudioFormat);
            return this;
        }

        public APIRequestCreateLiveVideo setSpatialAudioFormat(String spatialAudioFormat) {
            this.setParam("spatial_audio_format", spatialAudioFormat);
            return this;
        }

        public APIRequestCreateLiveVideo setStatus(LiveVideo.EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestCreateLiveVideo setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestCreateLiveVideo setStereoscopicMode(LiveVideo.EnumStereoscopicMode stereoscopicMode) {
            this.setParam("stereoscopic_mode", (Object)stereoscopicMode);
            return this;
        }

        public APIRequestCreateLiveVideo setStereoscopicMode(String stereoscopicMode) {
            this.setParam("stereoscopic_mode", stereoscopicMode);
            return this;
        }

        public APIRequestCreateLiveVideo setStopOnDeleteStream(Boolean stopOnDeleteStream) {
            this.setParam("stop_on_delete_stream", stopOnDeleteStream);
            return this;
        }

        public APIRequestCreateLiveVideo setStopOnDeleteStream(String stopOnDeleteStream) {
            this.setParam("stop_on_delete_stream", stopOnDeleteStream);
            return this;
        }

        public APIRequestCreateLiveVideo setStreamType(LiveVideo.EnumStreamType streamType) {
            this.setParam("stream_type", (Object)streamType);
            return this;
        }

        public APIRequestCreateLiveVideo setStreamType(String streamType) {
            this.setParam("stream_type", streamType);
            return this;
        }

        public APIRequestCreateLiveVideo setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestCreateLiveVideo requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLiveVideo requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLiveVideo requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLiveVideo requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLiveVideo requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLiveVideo requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetLiveVideos
    extends APIRequest<LiveVideo> {
        APINodeList<LiveVideo> lastResponse = null;
        public static final String[] PARAMS = new String[]{"broadcast_status", "source"};
        public static final String[] FIELDS = new String[]{"ad_break_config", "ad_break_failure_reason", "broadcast_start_time", "copyright", "creation_time", "dash_ingest_url", "dash_preview_url", "description", "embed_html", "from", "id", "ingest_streams", "is_manual_mode", "is_reference_only", "live_views", "overlay_url", "permalink_url", "planned_start_time", "recommended_encoder_settings", "seconds_left", "secure_stream_url", "status", "stream_url", "targeting", "title", "total_views", "video"};

        @Override
        public APINodeList<LiveVideo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<LiveVideo> parseResponse(String response, String header) throws APIException {
            return LiveVideo.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<LiveVideo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<LiveVideo> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<LiveVideo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<LiveVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<LiveVideo>>(){

                public APINodeList<LiveVideo> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetLiveVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/live_videos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLiveVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLiveVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLiveVideos setBroadcastStatus(List<LiveVideo.EnumBroadcastStatus> broadcastStatus) {
            this.setParam("broadcast_status", broadcastStatus);
            return this;
        }

        public APIRequestGetLiveVideos setBroadcastStatus(String broadcastStatus) {
            this.setParam("broadcast_status", broadcastStatus);
            return this;
        }

        public APIRequestGetLiveVideos setSource(LiveVideo.EnumSource source) {
            this.setParam("source", (Object)source);
            return this;
        }

        public APIRequestGetLiveVideos setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestGetLiveVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLiveVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLiveVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLiveVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLiveVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLiveVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetLiveVideos requestAdBreakConfigField() {
            return this.requestAdBreakConfigField(true);
        }

        public APIRequestGetLiveVideos requestAdBreakConfigField(boolean value) {
            this.requestField("ad_break_config", value);
            return this;
        }

        public APIRequestGetLiveVideos requestAdBreakFailureReasonField() {
            return this.requestAdBreakFailureReasonField(true);
        }

        public APIRequestGetLiveVideos requestAdBreakFailureReasonField(boolean value) {
            this.requestField("ad_break_failure_reason", value);
            return this;
        }

        public APIRequestGetLiveVideos requestBroadcastStartTimeField() {
            return this.requestBroadcastStartTimeField(true);
        }

        public APIRequestGetLiveVideos requestBroadcastStartTimeField(boolean value) {
            this.requestField("broadcast_start_time", value);
            return this;
        }

        public APIRequestGetLiveVideos requestCopyrightField() {
            return this.requestCopyrightField(true);
        }

        public APIRequestGetLiveVideos requestCopyrightField(boolean value) {
            this.requestField("copyright", value);
            return this;
        }

        public APIRequestGetLiveVideos requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetLiveVideos requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetLiveVideos requestDashIngestUrlField() {
            return this.requestDashIngestUrlField(true);
        }

        public APIRequestGetLiveVideos requestDashIngestUrlField(boolean value) {
            this.requestField("dash_ingest_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestDashPreviewUrlField() {
            return this.requestDashPreviewUrlField(true);
        }

        public APIRequestGetLiveVideos requestDashPreviewUrlField(boolean value) {
            this.requestField("dash_preview_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetLiveVideos requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetLiveVideos requestEmbedHtmlField() {
            return this.requestEmbedHtmlField(true);
        }

        public APIRequestGetLiveVideos requestEmbedHtmlField(boolean value) {
            this.requestField("embed_html", value);
            return this;
        }

        public APIRequestGetLiveVideos requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetLiveVideos requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetLiveVideos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetLiveVideos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetLiveVideos requestIngestStreamsField() {
            return this.requestIngestStreamsField(true);
        }

        public APIRequestGetLiveVideos requestIngestStreamsField(boolean value) {
            this.requestField("ingest_streams", value);
            return this;
        }

        public APIRequestGetLiveVideos requestIsManualModeField() {
            return this.requestIsManualModeField(true);
        }

        public APIRequestGetLiveVideos requestIsManualModeField(boolean value) {
            this.requestField("is_manual_mode", value);
            return this;
        }

        public APIRequestGetLiveVideos requestIsReferenceOnlyField() {
            return this.requestIsReferenceOnlyField(true);
        }

        public APIRequestGetLiveVideos requestIsReferenceOnlyField(boolean value) {
            this.requestField("is_reference_only", value);
            return this;
        }

        public APIRequestGetLiveVideos requestLiveViewsField() {
            return this.requestLiveViewsField(true);
        }

        public APIRequestGetLiveVideos requestLiveViewsField(boolean value) {
            this.requestField("live_views", value);
            return this;
        }

        public APIRequestGetLiveVideos requestOverlayUrlField() {
            return this.requestOverlayUrlField(true);
        }

        public APIRequestGetLiveVideos requestOverlayUrlField(boolean value) {
            this.requestField("overlay_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetLiveVideos requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestPlannedStartTimeField() {
            return this.requestPlannedStartTimeField(true);
        }

        public APIRequestGetLiveVideos requestPlannedStartTimeField(boolean value) {
            this.requestField("planned_start_time", value);
            return this;
        }

        public APIRequestGetLiveVideos requestRecommendedEncoderSettingsField() {
            return this.requestRecommendedEncoderSettingsField(true);
        }

        public APIRequestGetLiveVideos requestRecommendedEncoderSettingsField(boolean value) {
            this.requestField("recommended_encoder_settings", value);
            return this;
        }

        public APIRequestGetLiveVideos requestSecondsLeftField() {
            return this.requestSecondsLeftField(true);
        }

        public APIRequestGetLiveVideos requestSecondsLeftField(boolean value) {
            this.requestField("seconds_left", value);
            return this;
        }

        public APIRequestGetLiveVideos requestSecureStreamUrlField() {
            return this.requestSecureStreamUrlField(true);
        }

        public APIRequestGetLiveVideos requestSecureStreamUrlField(boolean value) {
            this.requestField("secure_stream_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetLiveVideos requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetLiveVideos requestStreamUrlField() {
            return this.requestStreamUrlField(true);
        }

        public APIRequestGetLiveVideos requestStreamUrlField(boolean value) {
            this.requestField("stream_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetLiveVideos requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetLiveVideos requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetLiveVideos requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetLiveVideos requestTotalViewsField() {
            return this.requestTotalViewsField(true);
        }

        public APIRequestGetLiveVideos requestTotalViewsField(boolean value) {
            this.requestField("total_views", value);
            return this;
        }

        public APIRequestGetLiveVideos requestVideoField() {
            return this.requestVideoField(true);
        }

        public APIRequestGetLiveVideos requestVideoField(boolean value) {
            this.requestField("video", value);
            return this;
        }
    }

    public static class APIRequestGetLikes
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"target_id"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "connected_page_backed_instagram_account", "contact_address", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "delivery_and_pickup_option_info", "description", "description_html", "differently_open_offerings", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "followers_count", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_root_id", "has_added_app", "has_transitioned_to_new_page_experience", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messaging_feature_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mini_shop_storefront", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "owner_business", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "pickup_options", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "privacy_info_url", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_donate_button_in_live_video", "talking_about_count", "temporary_status", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response, String header) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Page>>(){

                public APINodeList<Page> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetLikes(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLikes setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLikes setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLikes setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestGetLikes requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLikes requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetLikes requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetLikes requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetLikes requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetLikes requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetLikes requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetLikes requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetLikes requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetLikes requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetLikes requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetLikes requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetLikes requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetLikes requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetLikes requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetLikes requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetLikes requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetLikes requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetLikes requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetLikes requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetLikes requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetLikes requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetLikes requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetLikes requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetLikes requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetLikes requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetLikes requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetLikes requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetLikes requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetLikes requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetLikes requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetLikes requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetLikes requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetLikes requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetLikes requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetLikes requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetLikes requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetLikes requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetLikes requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetLikes requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetLikes requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetLikes requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetLikes requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetLikes requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetLikes requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetLikes requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetLikes requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetLikes requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetLikes requestConnectedPageBackedInstagramAccountField() {
            return this.requestConnectedPageBackedInstagramAccountField(true);
        }

        public APIRequestGetLikes requestConnectedPageBackedInstagramAccountField(boolean value) {
            this.requestField("connected_page_backed_instagram_account", value);
            return this;
        }

        public APIRequestGetLikes requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetLikes requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetLikes requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetLikes requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetLikes requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetLikes requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetLikes requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetLikes requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetLikes requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetLikes requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetLikes requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetLikes requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetLikes requestDeliveryAndPickupOptionInfoField() {
            return this.requestDeliveryAndPickupOptionInfoField(true);
        }

        public APIRequestGetLikes requestDeliveryAndPickupOptionInfoField(boolean value) {
            this.requestField("delivery_and_pickup_option_info", value);
            return this;
        }

        public APIRequestGetLikes requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetLikes requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetLikes requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetLikes requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetLikes requestDifferentlyOpenOfferingsField() {
            return this.requestDifferentlyOpenOfferingsField(true);
        }

        public APIRequestGetLikes requestDifferentlyOpenOfferingsField(boolean value) {
            this.requestField("differently_open_offerings", value);
            return this;
        }

        public APIRequestGetLikes requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetLikes requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetLikes requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetLikes requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetLikes requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetLikes requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetLikes requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetLikes requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetLikes requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetLikes requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetLikes requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetLikes requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetLikes requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetLikes requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetLikes requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetLikes requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetLikes requestFollowersCountField() {
            return this.requestFollowersCountField(true);
        }

        public APIRequestGetLikes requestFollowersCountField(boolean value) {
            this.requestField("followers_count", value);
            return this;
        }

        public APIRequestGetLikes requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetLikes requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetLikes requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetLikes requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetLikes requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetLikes requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetLikes requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetLikes requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetLikes requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetLikes requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetLikes requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetLikes requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetLikes requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetLikes requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetLikes requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetLikes requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetLikes requestHasTransitionedToNewPageExperienceField() {
            return this.requestHasTransitionedToNewPageExperienceField(true);
        }

        public APIRequestGetLikes requestHasTransitionedToNewPageExperienceField(boolean value) {
            this.requestField("has_transitioned_to_new_page_experience", value);
            return this;
        }

        public APIRequestGetLikes requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetLikes requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetLikes requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetLikes requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetLikes requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetLikes requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetLikes requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetLikes requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetLikes requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetLikes requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetLikes requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetLikes requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetLikes requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetLikes requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetLikes requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetLikes requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetLikes requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetLikes requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetLikes requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetLikes requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetLikes requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetLikes requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetLikes requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetLikes requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetLikes requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetLikes requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetLikes requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetLikes requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetLikes requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetLikes requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetLikes requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetLikes requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetLikes requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetLikes requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetLikes requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetLikes requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetLikes requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetLikes requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetLikes requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetLikes requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetLikes requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetLikes requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetLikes requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetLikes requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetLikes requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetLikes requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetLikes requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetLikes requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetLikes requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetLikes requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetLikes requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetLikes requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetLikes requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetLikes requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetLikes requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetLikes requestMessagingFeatureStatusField() {
            return this.requestMessagingFeatureStatusField(true);
        }

        public APIRequestGetLikes requestMessagingFeatureStatusField(boolean value) {
            this.requestField("messaging_feature_status", value);
            return this;
        }

        public APIRequestGetLikes requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetLikes requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetLikes requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetLikes requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetLikes requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetLikes requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetLikes requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetLikes requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetLikes requestMiniShopStorefrontField() {
            return this.requestMiniShopStorefrontField(true);
        }

        public APIRequestGetLikes requestMiniShopStorefrontField(boolean value) {
            this.requestField("mini_shop_storefront", value);
            return this;
        }

        public APIRequestGetLikes requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetLikes requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetLikes requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetLikes requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetLikes requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetLikes requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetLikes requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetLikes requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetLikes requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetLikes requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetLikes requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetLikes requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetLikes requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetLikes requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetLikes requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetLikes requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetLikes requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetLikes requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetLikes requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetLikes requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetLikes requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetLikes requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetLikes requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetLikes requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetLikes requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetLikes requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetLikes requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetLikes requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetLikes requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetLikes requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetLikes requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetLikes requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetLikes requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetLikes requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetLikes requestPickupOptionsField() {
            return this.requestPickupOptionsField(true);
        }

        public APIRequestGetLikes requestPickupOptionsField(boolean value) {
            this.requestField("pickup_options", value);
            return this;
        }

        public APIRequestGetLikes requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetLikes requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetLikes requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetLikes requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetLikes requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetLikes requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetLikes requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetLikes requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetLikes requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetLikes requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetLikes requestPrivacyInfoUrlField() {
            return this.requestPrivacyInfoUrlField(true);
        }

        public APIRequestGetLikes requestPrivacyInfoUrlField(boolean value) {
            this.requestField("privacy_info_url", value);
            return this;
        }

        public APIRequestGetLikes requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetLikes requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetLikes requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetLikes requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetLikes requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetLikes requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetLikes requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetLikes requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetLikes requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetLikes requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetLikes requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetLikes requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetLikes requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetLikes requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetLikes requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetLikes requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetLikes requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetLikes requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetLikes requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetLikes requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetLikes requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetLikes requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetLikes requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetLikes requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetLikes requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetLikes requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetLikes requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetLikes requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetLikes requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetLikes requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetLikes requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetLikes requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetLikes requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetLikes requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetLikes requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetLikes requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetLikes requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetLikes requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetLikes requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetLikes requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetLikes requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetLikes requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetLikes requestSupportsDonateButtonInLiveVideoField() {
            return this.requestSupportsDonateButtonInLiveVideoField(true);
        }

        public APIRequestGetLikes requestSupportsDonateButtonInLiveVideoField(boolean value) {
            this.requestField("supports_donate_button_in_live_video", value);
            return this;
        }

        public APIRequestGetLikes requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetLikes requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetLikes requestTemporaryStatusField() {
            return this.requestTemporaryStatusField(true);
        }

        public APIRequestGetLikes requestTemporaryStatusField(boolean value) {
            this.requestField("temporary_status", value);
            return this;
        }

        public APIRequestGetLikes requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetLikes requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetLikes requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetLikes requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetLikes requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetLikes requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetLikes requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetLikes requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetLikes requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetLikes requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetLikes requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetLikes requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetLikes requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetLikes requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetLikes requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetLikes requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetLikes requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetLikes requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetLikes requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetLikes requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    public static class APIRequestGetIdsForPages
    extends APIRequest<UserIDForPage> {
        APINodeList<UserIDForPage> lastResponse = null;
        public static final String[] PARAMS = new String[]{"page"};
        public static final String[] FIELDS = new String[]{"id", "page"};

        @Override
        public APINodeList<UserIDForPage> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UserIDForPage> parseResponse(String response, String header) throws APIException {
            return UserIDForPage.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<UserIDForPage> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UserIDForPage> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UserIDForPage>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UserIDForPage>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<UserIDForPage>>(){

                public APINodeList<UserIDForPage> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetIdsForPages(String nodeId, APIContext context) {
            super(context, nodeId, "/ids_for_pages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetIdsForPages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetIdsForPages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetIdsForPages setPage(Long page) {
            this.setParam("page", page);
            return this;
        }

        public APIRequestGetIdsForPages setPage(String page) {
            this.setParam("page", page);
            return this;
        }

        public APIRequestGetIdsForPages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetIdsForPages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForPages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetIdsForPages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForPages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetIdsForPages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetIdsForPages requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetIdsForPages requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetIdsForPages requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGetIdsForPages requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }
    }

    public static class APIRequestGetIdsForBusiness
    extends APIRequest<UserIDForApp> {
        APINodeList<UserIDForApp> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app"};
        public static final String[] FIELDS = new String[]{"app", "id"};

        @Override
        public APINodeList<UserIDForApp> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UserIDForApp> parseResponse(String response, String header) throws APIException {
            return UserIDForApp.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<UserIDForApp> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UserIDForApp> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UserIDForApp>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UserIDForApp>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<UserIDForApp>>(){

                public APINodeList<UserIDForApp> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetIdsForBusiness(String nodeId, APIContext context) {
            super(context, nodeId, "/ids_for_business", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetIdsForBusiness setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetIdsForBusiness setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetIdsForBusiness setApp(Long app) {
            this.setParam("app", app);
            return this;
        }

        public APIRequestGetIdsForBusiness setApp(String app) {
            this.setParam("app", app);
            return this;
        }

        public APIRequestGetIdsForBusiness requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetIdsForBusiness requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForBusiness requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetIdsForBusiness requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForBusiness requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetIdsForBusiness requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetIdsForBusiness requestAppField() {
            return this.requestAppField(true);
        }

        public APIRequestGetIdsForBusiness requestAppField(boolean value) {
            this.requestField("app", value);
            return this;
        }

        public APIRequestGetIdsForBusiness requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetIdsForBusiness requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    public static class APIRequestGetIdsForApps
    extends APIRequest<UserIDForApp> {
        APINodeList<UserIDForApp> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app"};
        public static final String[] FIELDS = new String[]{"app", "id"};

        @Override
        public APINodeList<UserIDForApp> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UserIDForApp> parseResponse(String response, String header) throws APIException {
            return UserIDForApp.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<UserIDForApp> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UserIDForApp> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UserIDForApp>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UserIDForApp>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<UserIDForApp>>(){

                public APINodeList<UserIDForApp> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetIdsForApps(String nodeId, APIContext context) {
            super(context, nodeId, "/ids_for_apps", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetIdsForApps setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetIdsForApps setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetIdsForApps setApp(Long app) {
            this.setParam("app", app);
            return this;
        }

        public APIRequestGetIdsForApps setApp(String app) {
            this.setParam("app", app);
            return this;
        }

        public APIRequestGetIdsForApps requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetIdsForApps requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForApps requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetIdsForApps requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForApps requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetIdsForApps requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetIdsForApps requestAppField() {
            return this.requestAppField(true);
        }

        public APIRequestGetIdsForApps requestAppField(boolean value) {
            this.requestField("app", value);
            return this;
        }

        public APIRequestGetIdsForApps requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetIdsForApps requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    public static class APIRequestGetGroups
    extends APIRequest<Group> {
        APINodeList<Group> lastResponse = null;
        public static final String[] PARAMS = new String[]{"admin_only", "parent"};
        public static final String[] FIELDS = new String[]{"archived", "cover", "created_time", "description", "email", "icon", "id", "install", "link", "member_count", "member_request_count", "name", "parent", "permissions", "privacy", "purpose", "subdomain", "updated_time", "venue"};

        @Override
        public APINodeList<Group> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Group> parseResponse(String response, String header) throws APIException {
            return Group.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Group> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Group> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Group>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Group>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Group>>(){

                public APINodeList<Group> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetGroups(String nodeId, APIContext context) {
            super(context, nodeId, "/groups", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetGroups setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetGroups setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetGroups setAdminOnly(Boolean adminOnly) {
            this.setParam("admin_only", adminOnly);
            return this;
        }

        public APIRequestGetGroups setAdminOnly(String adminOnly) {
            this.setParam("admin_only", adminOnly);
            return this;
        }

        public APIRequestGetGroups setParent(String parent) {
            this.setParam("parent", parent);
            return this;
        }

        public APIRequestGetGroups requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetGroups requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGroups requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetGroups requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGroups requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetGroups requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetGroups requestArchivedField() {
            return this.requestArchivedField(true);
        }

        public APIRequestGetGroups requestArchivedField(boolean value) {
            this.requestField("archived", value);
            return this;
        }

        public APIRequestGetGroups requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetGroups requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetGroups requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetGroups requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetGroups requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetGroups requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetGroups requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetGroups requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetGroups requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetGroups requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetGroups requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetGroups requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetGroups requestInstallField() {
            return this.requestInstallField(true);
        }

        public APIRequestGetGroups requestInstallField(boolean value) {
            this.requestField("install", value);
            return this;
        }

        public APIRequestGetGroups requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetGroups requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetGroups requestMemberCountField() {
            return this.requestMemberCountField(true);
        }

        public APIRequestGetGroups requestMemberCountField(boolean value) {
            this.requestField("member_count", value);
            return this;
        }

        public APIRequestGetGroups requestMemberRequestCountField() {
            return this.requestMemberRequestCountField(true);
        }

        public APIRequestGetGroups requestMemberRequestCountField(boolean value) {
            this.requestField("member_request_count", value);
            return this;
        }

        public APIRequestGetGroups requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetGroups requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetGroups requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetGroups requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetGroups requestPermissionsField() {
            return this.requestPermissionsField(true);
        }

        public APIRequestGetGroups requestPermissionsField(boolean value) {
            this.requestField("permissions", value);
            return this;
        }

        public APIRequestGetGroups requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetGroups requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetGroups requestPurposeField() {
            return this.requestPurposeField(true);
        }

        public APIRequestGetGroups requestPurposeField(boolean value) {
            this.requestField("purpose", value);
            return this;
        }

        public APIRequestGetGroups requestSubdomainField() {
            return this.requestSubdomainField(true);
        }

        public APIRequestGetGroups requestSubdomainField(boolean value) {
            this.requestField("subdomain", value);
            return this;
        }

        public APIRequestGetGroups requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetGroups requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetGroups requestVenueField() {
            return this.requestVenueField(true);
        }

        public APIRequestGetGroups requestVenueField(boolean value) {
            this.requestField("venue", value);
            return this;
        }
    }

    public static class APIRequestCreateGameTime
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"action"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateGameTime(String nodeId, APIContext context) {
            super(context, nodeId, "/game_times", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateGameTime setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateGameTime setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateGameTime setAction(EnumAction action) {
            this.setParam("action", (Object)action);
            return this;
        }

        public APIRequestCreateGameTime setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestCreateGameTime requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateGameTime requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGameTime requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateGameTime requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGameTime requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateGameTime requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateGameItem
    extends APIRequest<GameItem> {
        GameItem lastResponse = null;
        public static final String[] PARAMS = new String[]{"action", "app_id", "drop_table_id", "ext_id", "item_id", "quantity"};
        public static final String[] FIELDS = new String[0];

        @Override
        public GameItem getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public GameItem parseResponse(String response, String header) throws APIException {
            return GameItem.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public GameItem execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public GameItem execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<GameItem> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<GameItem> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, GameItem>(){

                public GameItem apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateGameItem(String nodeId, APIContext context) {
            super(context, nodeId, "/game_items", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateGameItem setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateGameItem setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateGameItem setAction(GameItem.EnumAction action) {
            this.setParam("action", (Object)action);
            return this;
        }

        public APIRequestCreateGameItem setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestCreateGameItem setAppId(String appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestCreateGameItem setDropTableId(String dropTableId) {
            this.setParam("drop_table_id", dropTableId);
            return this;
        }

        public APIRequestCreateGameItem setExtId(String extId) {
            this.setParam("ext_id", extId);
            return this;
        }

        public APIRequestCreateGameItem setItemId(String itemId) {
            this.setParam("item_id", itemId);
            return this;
        }

        public APIRequestCreateGameItem setQuantity(Long quantity) {
            this.setParam("quantity", quantity);
            return this;
        }

        public APIRequestCreateGameItem setQuantity(String quantity) {
            this.setParam("quantity", quantity);
            return this;
        }

        public APIRequestCreateGameItem requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateGameItem requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGameItem requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateGameItem requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGameItem requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateGameItem requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateFundraiser
    extends APIRequest<FundraiserPersonToCharity> {
        FundraiserPersonToCharity lastResponse = null;
        public static final String[] PARAMS = new String[]{"charity_id", "cover_photo", "currency", "description", "end_time", "external_event_name", "external_event_start_time", "external_event_uri", "external_fundraiser_uri", "external_id", "fundraiser_type", "goal_amount", "name", "page_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public FundraiserPersonToCharity getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FundraiserPersonToCharity parseResponse(String response, String header) throws APIException {
            return FundraiserPersonToCharity.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public FundraiserPersonToCharity execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FundraiserPersonToCharity execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<FundraiserPersonToCharity> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FundraiserPersonToCharity> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, FundraiserPersonToCharity>(){

                public FundraiserPersonToCharity apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateFundraiser(String nodeId, APIContext context) {
            super(context, nodeId, "/fundraisers", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateFundraiser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateFundraiser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateFundraiser setCharityId(String charityId) {
            this.setParam("charity_id", charityId);
            return this;
        }

        public APIRequestCreateFundraiser setCoverPhoto(File coverPhoto) {
            this.setParam("cover_photo", coverPhoto);
            return this;
        }

        public APIRequestCreateFundraiser setCoverPhoto(String coverPhoto) {
            this.setParam("cover_photo", coverPhoto);
            return this;
        }

        public APIRequestCreateFundraiser setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestCreateFundraiser setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateFundraiser setEndTime(Long endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateFundraiser setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateFundraiser setExternalEventName(String externalEventName) {
            this.setParam("external_event_name", externalEventName);
            return this;
        }

        public APIRequestCreateFundraiser setExternalEventStartTime(Long externalEventStartTime) {
            this.setParam("external_event_start_time", externalEventStartTime);
            return this;
        }

        public APIRequestCreateFundraiser setExternalEventStartTime(String externalEventStartTime) {
            this.setParam("external_event_start_time", externalEventStartTime);
            return this;
        }

        public APIRequestCreateFundraiser setExternalEventUri(String externalEventUri) {
            this.setParam("external_event_uri", externalEventUri);
            return this;
        }

        public APIRequestCreateFundraiser setExternalFundraiserUri(String externalFundraiserUri) {
            this.setParam("external_fundraiser_uri", externalFundraiserUri);
            return this;
        }

        public APIRequestCreateFundraiser setExternalId(String externalId) {
            this.setParam("external_id", externalId);
            return this;
        }

        public APIRequestCreateFundraiser setFundraiserType(FundraiserPersonToCharity.EnumFundraiserType fundraiserType) {
            this.setParam("fundraiser_type", (Object)fundraiserType);
            return this;
        }

        public APIRequestCreateFundraiser setFundraiserType(String fundraiserType) {
            this.setParam("fundraiser_type", fundraiserType);
            return this;
        }

        public APIRequestCreateFundraiser setGoalAmount(Long goalAmount) {
            this.setParam("goal_amount", goalAmount);
            return this;
        }

        public APIRequestCreateFundraiser setGoalAmount(String goalAmount) {
            this.setParam("goal_amount", goalAmount);
            return this;
        }

        public APIRequestCreateFundraiser setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateFundraiser setPageId(String pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestCreateFundraiser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateFundraiser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFundraiser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateFundraiser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFundraiser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateFundraiser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetFundraisers
    extends APIRequest<FundraiserPersonToCharity> {
        APINodeList<FundraiserPersonToCharity> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"amount_raised", "charity_id", "currency", "description", "donations_count", "donors_count", "end_time", "external_amount_raised", "external_donations_count", "external_donors_count", "external_event_name", "external_event_start_time", "external_event_uri", "external_fundraiser_uri", "external_id", "goal_amount", "id", "internal_amount_raised", "internal_donations_count", "internal_donors_count", "name", "uri"};

        @Override
        public APINodeList<FundraiserPersonToCharity> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<FundraiserPersonToCharity> parseResponse(String response, String header) throws APIException {
            return FundraiserPersonToCharity.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<FundraiserPersonToCharity> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<FundraiserPersonToCharity> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<FundraiserPersonToCharity>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<FundraiserPersonToCharity>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<FundraiserPersonToCharity>>(){

                public APINodeList<FundraiserPersonToCharity> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetFundraisers(String nodeId, APIContext context) {
            super(context, nodeId, "/fundraisers", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetFundraisers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetFundraisers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetFundraisers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetFundraisers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFundraisers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetFundraisers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFundraisers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetFundraisers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetFundraisers requestAmountRaisedField() {
            return this.requestAmountRaisedField(true);
        }

        public APIRequestGetFundraisers requestAmountRaisedField(boolean value) {
            this.requestField("amount_raised", value);
            return this;
        }

        public APIRequestGetFundraisers requestCharityIdField() {
            return this.requestCharityIdField(true);
        }

        public APIRequestGetFundraisers requestCharityIdField(boolean value) {
            this.requestField("charity_id", value);
            return this;
        }

        public APIRequestGetFundraisers requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetFundraisers requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetFundraisers requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetFundraisers requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetFundraisers requestDonationsCountField() {
            return this.requestDonationsCountField(true);
        }

        public APIRequestGetFundraisers requestDonationsCountField(boolean value) {
            this.requestField("donations_count", value);
            return this;
        }

        public APIRequestGetFundraisers requestDonorsCountField() {
            return this.requestDonorsCountField(true);
        }

        public APIRequestGetFundraisers requestDonorsCountField(boolean value) {
            this.requestField("donors_count", value);
            return this;
        }

        public APIRequestGetFundraisers requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetFundraisers requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetFundraisers requestExternalAmountRaisedField() {
            return this.requestExternalAmountRaisedField(true);
        }

        public APIRequestGetFundraisers requestExternalAmountRaisedField(boolean value) {
            this.requestField("external_amount_raised", value);
            return this;
        }

        public APIRequestGetFundraisers requestExternalDonationsCountField() {
            return this.requestExternalDonationsCountField(true);
        }

        public APIRequestGetFundraisers requestExternalDonationsCountField(boolean value) {
            this.requestField("external_donations_count", value);
            return this;
        }

        public APIRequestGetFundraisers requestExternalDonorsCountField() {
            return this.requestExternalDonorsCountField(true);
        }

        public APIRequestGetFundraisers requestExternalDonorsCountField(boolean value) {
            this.requestField("external_donors_count", value);
            return this;
        }

        public APIRequestGetFundraisers requestExternalEventNameField() {
            return this.requestExternalEventNameField(true);
        }

        public APIRequestGetFundraisers requestExternalEventNameField(boolean value) {
            this.requestField("external_event_name", value);
            return this;
        }

        public APIRequestGetFundraisers requestExternalEventStartTimeField() {
            return this.requestExternalEventStartTimeField(true);
        }

        public APIRequestGetFundraisers requestExternalEventStartTimeField(boolean value) {
            this.requestField("external_event_start_time", value);
            return this;
        }

        public APIRequestGetFundraisers requestExternalEventUriField() {
            return this.requestExternalEventUriField(true);
        }

        public APIRequestGetFundraisers requestExternalEventUriField(boolean value) {
            this.requestField("external_event_uri", value);
            return this;
        }

        public APIRequestGetFundraisers requestExternalFundraiserUriField() {
            return this.requestExternalFundraiserUriField(true);
        }

        public APIRequestGetFundraisers requestExternalFundraiserUriField(boolean value) {
            this.requestField("external_fundraiser_uri", value);
            return this;
        }

        public APIRequestGetFundraisers requestExternalIdField() {
            return this.requestExternalIdField(true);
        }

        public APIRequestGetFundraisers requestExternalIdField(boolean value) {
            this.requestField("external_id", value);
            return this;
        }

        public APIRequestGetFundraisers requestGoalAmountField() {
            return this.requestGoalAmountField(true);
        }

        public APIRequestGetFundraisers requestGoalAmountField(boolean value) {
            this.requestField("goal_amount", value);
            return this;
        }

        public APIRequestGetFundraisers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetFundraisers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetFundraisers requestInternalAmountRaisedField() {
            return this.requestInternalAmountRaisedField(true);
        }

        public APIRequestGetFundraisers requestInternalAmountRaisedField(boolean value) {
            this.requestField("internal_amount_raised", value);
            return this;
        }

        public APIRequestGetFundraisers requestInternalDonationsCountField() {
            return this.requestInternalDonationsCountField(true);
        }

        public APIRequestGetFundraisers requestInternalDonationsCountField(boolean value) {
            this.requestField("internal_donations_count", value);
            return this;
        }

        public APIRequestGetFundraisers requestInternalDonorsCountField() {
            return this.requestInternalDonorsCountField(true);
        }

        public APIRequestGetFundraisers requestInternalDonorsCountField(boolean value) {
            this.requestField("internal_donors_count", value);
            return this;
        }

        public APIRequestGetFundraisers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetFundraisers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetFundraisers requestUriField() {
            return this.requestUriField(true);
        }

        public APIRequestGetFundraisers requestUriField(boolean value) {
            this.requestField("uri", value);
            return this;
        }
    }

    public static class APIRequestGetFriends
    extends APIRequest<User> {
        APINodeList<User> lastResponse = null;
        public static final String[] PARAMS = new String[]{"uid"};
        public static final String[] FIELDS = new String[]{"about", "age_range", "birthday", "community", "cover", "currency", "education", "email", "favorite_athletes", "favorite_teams", "first_name", "gender", "hometown", "id", "id_for_avatars", "inspirational_people", "install_type", "installed", "is_guest_user", "languages", "last_name", "link", "local_news_megaphone_dismiss_status", "local_news_subscription_status", "locale", "location", "meeting_for", "middle_name", "name", "name_format", "payment_pricepoints", "political", "profile_pic", "quotes", "relationship_status", "shared_login_upgrade_required_by", "short_name", "significant_other", "sports", "supports_donate_button_in_live_video", "third_party_id", "timezone", "token_for_business", "updated_time", "verified", "video_upload_limits", "website"};

        @Override
        public APINodeList<User> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<User> parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<User> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<User> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<User>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<User>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<User>>(){

                public APINodeList<User> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetFriends(String nodeId, APIContext context) {
            super(context, nodeId, "/friends", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetFriends setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetFriends setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetFriends setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestGetFriends setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestGetFriends requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetFriends requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFriends requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetFriends requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFriends requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetFriends requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetFriends requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetFriends requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetFriends requestAgeRangeField() {
            return this.requestAgeRangeField(true);
        }

        public APIRequestGetFriends requestAgeRangeField(boolean value) {
            this.requestField("age_range", value);
            return this;
        }

        public APIRequestGetFriends requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetFriends requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetFriends requestCommunityField() {
            return this.requestCommunityField(true);
        }

        public APIRequestGetFriends requestCommunityField(boolean value) {
            this.requestField("community", value);
            return this;
        }

        public APIRequestGetFriends requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetFriends requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetFriends requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetFriends requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetFriends requestEducationField() {
            return this.requestEducationField(true);
        }

        public APIRequestGetFriends requestEducationField(boolean value) {
            this.requestField("education", value);
            return this;
        }

        public APIRequestGetFriends requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetFriends requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetFriends requestFavoriteAthletesField() {
            return this.requestFavoriteAthletesField(true);
        }

        public APIRequestGetFriends requestFavoriteAthletesField(boolean value) {
            this.requestField("favorite_athletes", value);
            return this;
        }

        public APIRequestGetFriends requestFavoriteTeamsField() {
            return this.requestFavoriteTeamsField(true);
        }

        public APIRequestGetFriends requestFavoriteTeamsField(boolean value) {
            this.requestField("favorite_teams", value);
            return this;
        }

        public APIRequestGetFriends requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetFriends requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetFriends requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGetFriends requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGetFriends requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetFriends requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetFriends requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetFriends requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetFriends requestIdForAvatarsField() {
            return this.requestIdForAvatarsField(true);
        }

        public APIRequestGetFriends requestIdForAvatarsField(boolean value) {
            this.requestField("id_for_avatars", value);
            return this;
        }

        public APIRequestGetFriends requestInspirationalPeopleField() {
            return this.requestInspirationalPeopleField(true);
        }

        public APIRequestGetFriends requestInspirationalPeopleField(boolean value) {
            this.requestField("inspirational_people", value);
            return this;
        }

        public APIRequestGetFriends requestInstallTypeField() {
            return this.requestInstallTypeField(true);
        }

        public APIRequestGetFriends requestInstallTypeField(boolean value) {
            this.requestField("install_type", value);
            return this;
        }

        public APIRequestGetFriends requestInstalledField() {
            return this.requestInstalledField(true);
        }

        public APIRequestGetFriends requestInstalledField(boolean value) {
            this.requestField("installed", value);
            return this;
        }

        public APIRequestGetFriends requestIsGuestUserField() {
            return this.requestIsGuestUserField(true);
        }

        public APIRequestGetFriends requestIsGuestUserField(boolean value) {
            this.requestField("is_guest_user", value);
            return this;
        }

        public APIRequestGetFriends requestLanguagesField() {
            return this.requestLanguagesField(true);
        }

        public APIRequestGetFriends requestLanguagesField(boolean value) {
            this.requestField("languages", value);
            return this;
        }

        public APIRequestGetFriends requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetFriends requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetFriends requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetFriends requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetFriends requestLocalNewsMegaphoneDismissStatusField() {
            return this.requestLocalNewsMegaphoneDismissStatusField(true);
        }

        public APIRequestGetFriends requestLocalNewsMegaphoneDismissStatusField(boolean value) {
            this.requestField("local_news_megaphone_dismiss_status", value);
            return this;
        }

        public APIRequestGetFriends requestLocalNewsSubscriptionStatusField() {
            return this.requestLocalNewsSubscriptionStatusField(true);
        }

        public APIRequestGetFriends requestLocalNewsSubscriptionStatusField(boolean value) {
            this.requestField("local_news_subscription_status", value);
            return this;
        }

        public APIRequestGetFriends requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGetFriends requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGetFriends requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetFriends requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetFriends requestMeetingForField() {
            return this.requestMeetingForField(true);
        }

        public APIRequestGetFriends requestMeetingForField(boolean value) {
            this.requestField("meeting_for", value);
            return this;
        }

        public APIRequestGetFriends requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGetFriends requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGetFriends requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetFriends requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetFriends requestNameFormatField() {
            return this.requestNameFormatField(true);
        }

        public APIRequestGetFriends requestNameFormatField(boolean value) {
            this.requestField("name_format", value);
            return this;
        }

        public APIRequestGetFriends requestPaymentPricepointsField() {
            return this.requestPaymentPricepointsField(true);
        }

        public APIRequestGetFriends requestPaymentPricepointsField(boolean value) {
            this.requestField("payment_pricepoints", value);
            return this;
        }

        public APIRequestGetFriends requestPoliticalField() {
            return this.requestPoliticalField(true);
        }

        public APIRequestGetFriends requestPoliticalField(boolean value) {
            this.requestField("political", value);
            return this;
        }

        public APIRequestGetFriends requestProfilePicField() {
            return this.requestProfilePicField(true);
        }

        public APIRequestGetFriends requestProfilePicField(boolean value) {
            this.requestField("profile_pic", value);
            return this;
        }

        public APIRequestGetFriends requestQuotesField() {
            return this.requestQuotesField(true);
        }

        public APIRequestGetFriends requestQuotesField(boolean value) {
            this.requestField("quotes", value);
            return this;
        }

        public APIRequestGetFriends requestRelationshipStatusField() {
            return this.requestRelationshipStatusField(true);
        }

        public APIRequestGetFriends requestRelationshipStatusField(boolean value) {
            this.requestField("relationship_status", value);
            return this;
        }

        public APIRequestGetFriends requestSharedLoginUpgradeRequiredByField() {
            return this.requestSharedLoginUpgradeRequiredByField(true);
        }

        public APIRequestGetFriends requestSharedLoginUpgradeRequiredByField(boolean value) {
            this.requestField("shared_login_upgrade_required_by", value);
            return this;
        }

        public APIRequestGetFriends requestShortNameField() {
            return this.requestShortNameField(true);
        }

        public APIRequestGetFriends requestShortNameField(boolean value) {
            this.requestField("short_name", value);
            return this;
        }

        public APIRequestGetFriends requestSignificantOtherField() {
            return this.requestSignificantOtherField(true);
        }

        public APIRequestGetFriends requestSignificantOtherField(boolean value) {
            this.requestField("significant_other", value);
            return this;
        }

        public APIRequestGetFriends requestSportsField() {
            return this.requestSportsField(true);
        }

        public APIRequestGetFriends requestSportsField(boolean value) {
            this.requestField("sports", value);
            return this;
        }

        public APIRequestGetFriends requestSupportsDonateButtonInLiveVideoField() {
            return this.requestSupportsDonateButtonInLiveVideoField(true);
        }

        public APIRequestGetFriends requestSupportsDonateButtonInLiveVideoField(boolean value) {
            this.requestField("supports_donate_button_in_live_video", value);
            return this;
        }

        public APIRequestGetFriends requestThirdPartyIdField() {
            return this.requestThirdPartyIdField(true);
        }

        public APIRequestGetFriends requestThirdPartyIdField(boolean value) {
            this.requestField("third_party_id", value);
            return this;
        }

        public APIRequestGetFriends requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGetFriends requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGetFriends requestTokenForBusinessField() {
            return this.requestTokenForBusinessField(true);
        }

        public APIRequestGetFriends requestTokenForBusinessField(boolean value) {
            this.requestField("token_for_business", value);
            return this;
        }

        public APIRequestGetFriends requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetFriends requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetFriends requestVerifiedField() {
            return this.requestVerifiedField(true);
        }

        public APIRequestGetFriends requestVerifiedField(boolean value) {
            this.requestField("verified", value);
            return this;
        }

        public APIRequestGetFriends requestVideoUploadLimitsField() {
            return this.requestVideoUploadLimitsField(true);
        }

        public APIRequestGetFriends requestVideoUploadLimitsField(boolean value) {
            this.requestField("video_upload_limits", value);
            return this;
        }

        public APIRequestGetFriends requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetFriends requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }
    }

    public static class APIRequestCreateFeed
    extends APIRequest<Post> {
        Post lastResponse = null;
        public static final String[] PARAMS = new String[]{"actions", "adaptive_type", "album_id", "android_key_hash", "animated_effect_id", "application_id", "asked_fun_fact_prompt_id", "asset3d_id", "associated_id", "attach_place_suggestion", "attached_media", "audience_exp", "backdated_time", "backdated_time_granularity", "call_to_action", "caption", "checkin_entry_point", "child_attachments", "client_mutation_id", "composer_entry_picker", "composer_entry_point", "composer_entry_time", "composer_session_events_log", "composer_session_id", "composer_source_surface", "composer_type", "connection_class", "content_attachment", "coordinates", "cta_link", "cta_type", "description", "direct_share_status", "expanded_height", "expanded_width", "feed_targeting", "formatting", "fun_fact_prompt_id", "fun_fact_toastee_id", "has_nickname", "height", "holiday_card", "home_checkin_city_id", "image_crops", "implicit_with_tags", "instant_game_entry_point_data", "ios_bundle_id", "is_backout_draft", "is_boost_intended", "is_explicit_location", "is_explicit_share", "is_group_linking_post", "is_photo_container", "link", "location_source_id", "manual_privacy", "message", "multi_share_end_card", "multi_share_optimized", "name", "nectar_module", "object_attachment", "offer_like_post_id", "og_action_type_id", "og_hide_object_attachment", "og_icon_id", "og_object_id", "og_phrase", "og_set_profile_badge", "og_suggestion_mechanism", "page_recommendation", "picture", "place", "place_attachment_setting", "place_list", "place_list_data", "post_surfaces_blacklist", "posting_to_redspace", "privacy", "prompt_id", "prompt_tracking_string", "properties", "proxied_app_id", "publish_event_id", "published", "quote", "react_mode_metadata", "ref", "referenceable_image_ids", "referral_id", "scheduled_publish_time", "source", "sponsor_id", "sponsor_relationship", "suggested_place_id", "tags", "target_surface", "targeting", "text_format_metadata", "text_format_preset_id", "text_only_place", "throwback_camera_roll_media", "thumbnail", "time_since_original_post", "title", "tracking_info", "unpublished_content_type", "user_selected_tags", "video_start_time_ms", "viewer_coordinates", "width"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Post getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Post parseResponse(String response, String header) throws APIException {
            return Post.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Post execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Post execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Post> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Post> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Post>(){

                public Post apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateFeed(String nodeId, APIContext context) {
            super(context, nodeId, "/feed", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateFeed setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateFeed setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateFeed setActions(Object actions) {
            this.setParam("actions", actions);
            return this;
        }

        public APIRequestCreateFeed setActions(String actions) {
            this.setParam("actions", actions);
            return this;
        }

        public APIRequestCreateFeed setAdaptiveType(String adaptiveType) {
            this.setParam("adaptive_type", adaptiveType);
            return this;
        }

        public APIRequestCreateFeed setAlbumId(String albumId) {
            this.setParam("album_id", albumId);
            return this;
        }

        public APIRequestCreateFeed setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestCreateFeed setAnimatedEffectId(Long animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateFeed setAnimatedEffectId(String animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateFeed setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreateFeed setAskedFunFactPromptId(Long askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateFeed setAskedFunFactPromptId(String askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateFeed setAsset3dId(Long asset3dId) {
            this.setParam("asset3d_id", asset3dId);
            return this;
        }

        public APIRequestCreateFeed setAsset3dId(String asset3dId) {
            this.setParam("asset3d_id", asset3dId);
            return this;
        }

        public APIRequestCreateFeed setAssociatedId(String associatedId) {
            this.setParam("associated_id", associatedId);
            return this;
        }

        public APIRequestCreateFeed setAttachPlaceSuggestion(Boolean attachPlaceSuggestion) {
            this.setParam("attach_place_suggestion", attachPlaceSuggestion);
            return this;
        }

        public APIRequestCreateFeed setAttachPlaceSuggestion(String attachPlaceSuggestion) {
            this.setParam("attach_place_suggestion", attachPlaceSuggestion);
            return this;
        }

        public APIRequestCreateFeed setAttachedMedia(List<Object> attachedMedia) {
            this.setParam("attached_media", attachedMedia);
            return this;
        }

        public APIRequestCreateFeed setAttachedMedia(String attachedMedia) {
            this.setParam("attached_media", attachedMedia);
            return this;
        }

        public APIRequestCreateFeed setAudienceExp(Boolean audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreateFeed setAudienceExp(String audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreateFeed setBackdatedTime(String backdatedTime) {
            this.setParam("backdated_time", backdatedTime);
            return this;
        }

        public APIRequestCreateFeed setBackdatedTimeGranularity(Post.EnumBackdatedTimeGranularity backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", (Object)backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreateFeed setBackdatedTimeGranularity(String backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreateFeed setCallToAction(Object callToAction) {
            this.setParam("call_to_action", callToAction);
            return this;
        }

        public APIRequestCreateFeed setCallToAction(String callToAction) {
            this.setParam("call_to_action", callToAction);
            return this;
        }

        public APIRequestCreateFeed setCaption(String caption) {
            this.setParam("caption", caption);
            return this;
        }

        public APIRequestCreateFeed setCheckinEntryPoint(Post.EnumCheckinEntryPoint checkinEntryPoint) {
            this.setParam("checkin_entry_point", (Object)checkinEntryPoint);
            return this;
        }

        public APIRequestCreateFeed setCheckinEntryPoint(String checkinEntryPoint) {
            this.setParam("checkin_entry_point", checkinEntryPoint);
            return this;
        }

        public APIRequestCreateFeed setChildAttachments(List<Object> childAttachments) {
            this.setParam("child_attachments", childAttachments);
            return this;
        }

        public APIRequestCreateFeed setChildAttachments(String childAttachments) {
            this.setParam("child_attachments", childAttachments);
            return this;
        }

        public APIRequestCreateFeed setClientMutationId(String clientMutationId) {
            this.setParam("client_mutation_id", clientMutationId);
            return this;
        }

        public APIRequestCreateFeed setComposerEntryPicker(String composerEntryPicker) {
            this.setParam("composer_entry_picker", composerEntryPicker);
            return this;
        }

        public APIRequestCreateFeed setComposerEntryPoint(String composerEntryPoint) {
            this.setParam("composer_entry_point", composerEntryPoint);
            return this;
        }

        public APIRequestCreateFeed setComposerEntryTime(Long composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateFeed setComposerEntryTime(String composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateFeed setComposerSessionEventsLog(String composerSessionEventsLog) {
            this.setParam("composer_session_events_log", composerSessionEventsLog);
            return this;
        }

        public APIRequestCreateFeed setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreateFeed setComposerSourceSurface(String composerSourceSurface) {
            this.setParam("composer_source_surface", composerSourceSurface);
            return this;
        }

        public APIRequestCreateFeed setComposerType(String composerType) {
            this.setParam("composer_type", composerType);
            return this;
        }

        public APIRequestCreateFeed setConnectionClass(String connectionClass) {
            this.setParam("connection_class", connectionClass);
            return this;
        }

        public APIRequestCreateFeed setContentAttachment(String contentAttachment) {
            this.setParam("content_attachment", contentAttachment);
            return this;
        }

        public APIRequestCreateFeed setCoordinates(Object coordinates) {
            this.setParam("coordinates", coordinates);
            return this;
        }

        public APIRequestCreateFeed setCoordinates(String coordinates) {
            this.setParam("coordinates", coordinates);
            return this;
        }

        public APIRequestCreateFeed setCtaLink(String ctaLink) {
            this.setParam("cta_link", ctaLink);
            return this;
        }

        public APIRequestCreateFeed setCtaType(String ctaType) {
            this.setParam("cta_type", ctaType);
            return this;
        }

        public APIRequestCreateFeed setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateFeed setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreateFeed setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreateFeed setExpandedHeight(Long expandedHeight) {
            this.setParam("expanded_height", expandedHeight);
            return this;
        }

        public APIRequestCreateFeed setExpandedHeight(String expandedHeight) {
            this.setParam("expanded_height", expandedHeight);
            return this;
        }

        public APIRequestCreateFeed setExpandedWidth(Long expandedWidth) {
            this.setParam("expanded_width", expandedWidth);
            return this;
        }

        public APIRequestCreateFeed setExpandedWidth(String expandedWidth) {
            this.setParam("expanded_width", expandedWidth);
            return this;
        }

        public APIRequestCreateFeed setFeedTargeting(Object feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreateFeed setFeedTargeting(String feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreateFeed setFormatting(Post.EnumFormatting formatting) {
            this.setParam("formatting", (Object)formatting);
            return this;
        }

        public APIRequestCreateFeed setFormatting(String formatting) {
            this.setParam("formatting", formatting);
            return this;
        }

        public APIRequestCreateFeed setFunFactPromptId(Long funFactPromptId) {
            this.setParam("fun_fact_prompt_id", funFactPromptId);
            return this;
        }

        public APIRequestCreateFeed setFunFactPromptId(String funFactPromptId) {
            this.setParam("fun_fact_prompt_id", funFactPromptId);
            return this;
        }

        public APIRequestCreateFeed setFunFactToasteeId(Long funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateFeed setFunFactToasteeId(String funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateFeed setHasNickname(Boolean hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateFeed setHasNickname(String hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateFeed setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestCreateFeed setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestCreateFeed setHolidayCard(String holidayCard) {
            this.setParam("holiday_card", holidayCard);
            return this;
        }

        public APIRequestCreateFeed setHomeCheckinCityId(Object homeCheckinCityId) {
            this.setParam("home_checkin_city_id", homeCheckinCityId);
            return this;
        }

        public APIRequestCreateFeed setHomeCheckinCityId(String homeCheckinCityId) {
            this.setParam("home_checkin_city_id", homeCheckinCityId);
            return this;
        }

        public APIRequestCreateFeed setImageCrops(Map<String, String> imageCrops) {
            this.setParam("image_crops", imageCrops);
            return this;
        }

        public APIRequestCreateFeed setImageCrops(String imageCrops) {
            this.setParam("image_crops", imageCrops);
            return this;
        }

        public APIRequestCreateFeed setImplicitWithTags(List<Long> implicitWithTags) {
            this.setParam("implicit_with_tags", implicitWithTags);
            return this;
        }

        public APIRequestCreateFeed setImplicitWithTags(String implicitWithTags) {
            this.setParam("implicit_with_tags", implicitWithTags);
            return this;
        }

        public APIRequestCreateFeed setInstantGameEntryPointData(String instantGameEntryPointData) {
            this.setParam("instant_game_entry_point_data", instantGameEntryPointData);
            return this;
        }

        public APIRequestCreateFeed setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestCreateFeed setIsBackoutDraft(Boolean isBackoutDraft) {
            this.setParam("is_backout_draft", isBackoutDraft);
            return this;
        }

        public APIRequestCreateFeed setIsBackoutDraft(String isBackoutDraft) {
            this.setParam("is_backout_draft", isBackoutDraft);
            return this;
        }

        public APIRequestCreateFeed setIsBoostIntended(Boolean isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateFeed setIsBoostIntended(String isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateFeed setIsExplicitLocation(Boolean isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreateFeed setIsExplicitLocation(String isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreateFeed setIsExplicitShare(Boolean isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateFeed setIsExplicitShare(String isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateFeed setIsGroupLinkingPost(Boolean isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateFeed setIsGroupLinkingPost(String isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateFeed setIsPhotoContainer(Boolean isPhotoContainer) {
            this.setParam("is_photo_container", isPhotoContainer);
            return this;
        }

        public APIRequestCreateFeed setIsPhotoContainer(String isPhotoContainer) {
            this.setParam("is_photo_container", isPhotoContainer);
            return this;
        }

        public APIRequestCreateFeed setLink(String link) {
            this.setParam("link", link);
            return this;
        }

        public APIRequestCreateFeed setLocationSourceId(String locationSourceId) {
            this.setParam("location_source_id", locationSourceId);
            return this;
        }

        public APIRequestCreateFeed setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateFeed setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateFeed setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateFeed setMultiShareEndCard(Boolean multiShareEndCard) {
            this.setParam("multi_share_end_card", multiShareEndCard);
            return this;
        }

        public APIRequestCreateFeed setMultiShareEndCard(String multiShareEndCard) {
            this.setParam("multi_share_end_card", multiShareEndCard);
            return this;
        }

        public APIRequestCreateFeed setMultiShareOptimized(Boolean multiShareOptimized) {
            this.setParam("multi_share_optimized", multiShareOptimized);
            return this;
        }

        public APIRequestCreateFeed setMultiShareOptimized(String multiShareOptimized) {
            this.setParam("multi_share_optimized", multiShareOptimized);
            return this;
        }

        public APIRequestCreateFeed setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateFeed setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateFeed setObjectAttachment(String objectAttachment) {
            this.setParam("object_attachment", objectAttachment);
            return this;
        }

        public APIRequestCreateFeed setOfferLikePostId(Long offerLikePostId) {
            this.setParam("offer_like_post_id", offerLikePostId);
            return this;
        }

        public APIRequestCreateFeed setOfferLikePostId(String offerLikePostId) {
            this.setParam("offer_like_post_id", offerLikePostId);
            return this;
        }

        public APIRequestCreateFeed setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestCreateFeed setOgHideObjectAttachment(Boolean ogHideObjectAttachment) {
            this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
            return this;
        }

        public APIRequestCreateFeed setOgHideObjectAttachment(String ogHideObjectAttachment) {
            this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
            return this;
        }

        public APIRequestCreateFeed setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestCreateFeed setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestCreateFeed setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestCreateFeed setOgSetProfileBadge(Boolean ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreateFeed setOgSetProfileBadge(String ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreateFeed setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestCreateFeed setPageRecommendation(String pageRecommendation) {
            this.setParam("page_recommendation", pageRecommendation);
            return this;
        }

        public APIRequestCreateFeed setPicture(String picture) {
            this.setParam("picture", picture);
            return this;
        }

        public APIRequestCreateFeed setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateFeed setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateFeed setPlaceAttachmentSetting(Post.EnumPlaceAttachmentSetting placeAttachmentSetting) {
            this.setParam("place_attachment_setting", (Object)placeAttachmentSetting);
            return this;
        }

        public APIRequestCreateFeed setPlaceAttachmentSetting(String placeAttachmentSetting) {
            this.setParam("place_attachment_setting", placeAttachmentSetting);
            return this;
        }

        public APIRequestCreateFeed setPlaceList(String placeList) {
            this.setParam("place_list", placeList);
            return this;
        }

        public APIRequestCreateFeed setPlaceListData(JsonArray placeListData) {
            this.setParam("place_list_data", placeListData);
            return this;
        }

        public APIRequestCreateFeed setPlaceListData(String placeListData) {
            this.setParam("place_list_data", placeListData);
            return this;
        }

        public APIRequestCreateFeed setPostSurfacesBlacklist(List<Post.EnumPostSurfacesBlacklist> postSurfacesBlacklist) {
            this.setParam("post_surfaces_blacklist", postSurfacesBlacklist);
            return this;
        }

        public APIRequestCreateFeed setPostSurfacesBlacklist(String postSurfacesBlacklist) {
            this.setParam("post_surfaces_blacklist", postSurfacesBlacklist);
            return this;
        }

        public APIRequestCreateFeed setPostingToRedspace(Post.EnumPostingToRedspace postingToRedspace) {
            this.setParam("posting_to_redspace", (Object)postingToRedspace);
            return this;
        }

        public APIRequestCreateFeed setPostingToRedspace(String postingToRedspace) {
            this.setParam("posting_to_redspace", postingToRedspace);
            return this;
        }

        public APIRequestCreateFeed setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateFeed setPromptId(String promptId) {
            this.setParam("prompt_id", promptId);
            return this;
        }

        public APIRequestCreateFeed setPromptTrackingString(String promptTrackingString) {
            this.setParam("prompt_tracking_string", promptTrackingString);
            return this;
        }

        public APIRequestCreateFeed setProperties(Object properties) {
            this.setParam("properties", properties);
            return this;
        }

        public APIRequestCreateFeed setProperties(String properties) {
            this.setParam("properties", properties);
            return this;
        }

        public APIRequestCreateFeed setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestCreateFeed setPublishEventId(Long publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateFeed setPublishEventId(String publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateFeed setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateFeed setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateFeed setQuote(String quote) {
            this.setParam("quote", quote);
            return this;
        }

        public APIRequestCreateFeed setReactModeMetadata(String reactModeMetadata) {
            this.setParam("react_mode_metadata", reactModeMetadata);
            return this;
        }

        public APIRequestCreateFeed setRef(List<String> ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateFeed setRef(String ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateFeed setReferenceableImageIds(List<String> referenceableImageIds) {
            this.setParam("referenceable_image_ids", referenceableImageIds);
            return this;
        }

        public APIRequestCreateFeed setReferenceableImageIds(String referenceableImageIds) {
            this.setParam("referenceable_image_ids", referenceableImageIds);
            return this;
        }

        public APIRequestCreateFeed setReferralId(String referralId) {
            this.setParam("referral_id", referralId);
            return this;
        }

        public APIRequestCreateFeed setScheduledPublishTime(String scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreateFeed setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestCreateFeed setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestCreateFeed setSponsorRelationship(Long sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreateFeed setSponsorRelationship(String sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreateFeed setSuggestedPlaceId(Object suggestedPlaceId) {
            this.setParam("suggested_place_id", suggestedPlaceId);
            return this;
        }

        public APIRequestCreateFeed setSuggestedPlaceId(String suggestedPlaceId) {
            this.setParam("suggested_place_id", suggestedPlaceId);
            return this;
        }

        public APIRequestCreateFeed setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateFeed setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateFeed setTargetSurface(Post.EnumTargetSurface targetSurface) {
            this.setParam("target_surface", (Object)targetSurface);
            return this;
        }

        public APIRequestCreateFeed setTargetSurface(String targetSurface) {
            this.setParam("target_surface", targetSurface);
            return this;
        }

        public APIRequestCreateFeed setTargeting(Object targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateFeed setTargeting(String targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateFeed setTextFormatMetadata(String textFormatMetadata) {
            this.setParam("text_format_metadata", textFormatMetadata);
            return this;
        }

        public APIRequestCreateFeed setTextFormatPresetId(String textFormatPresetId) {
            this.setParam("text_format_preset_id", textFormatPresetId);
            return this;
        }

        public APIRequestCreateFeed setTextOnlyPlace(String textOnlyPlace) {
            this.setParam("text_only_place", textOnlyPlace);
            return this;
        }

        public APIRequestCreateFeed setThrowbackCameraRollMedia(String throwbackCameraRollMedia) {
            this.setParam("throwback_camera_roll_media", throwbackCameraRollMedia);
            return this;
        }

        public APIRequestCreateFeed setThumbnail(File thumbnail) {
            this.setParam("thumbnail", thumbnail);
            return this;
        }

        public APIRequestCreateFeed setThumbnail(String thumbnail) {
            this.setParam("thumbnail", thumbnail);
            return this;
        }

        public APIRequestCreateFeed setTimeSinceOriginalPost(Long timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateFeed setTimeSinceOriginalPost(String timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateFeed setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestCreateFeed setTrackingInfo(String trackingInfo) {
            this.setParam("tracking_info", trackingInfo);
            return this;
        }

        public APIRequestCreateFeed setUnpublishedContentType(Post.EnumUnpublishedContentType unpublishedContentType) {
            this.setParam("unpublished_content_type", (Object)unpublishedContentType);
            return this;
        }

        public APIRequestCreateFeed setUnpublishedContentType(String unpublishedContentType) {
            this.setParam("unpublished_content_type", unpublishedContentType);
            return this;
        }

        public APIRequestCreateFeed setUserSelectedTags(Boolean userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateFeed setUserSelectedTags(String userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateFeed setVideoStartTimeMs(Long videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateFeed setVideoStartTimeMs(String videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateFeed setViewerCoordinates(Object viewerCoordinates) {
            this.setParam("viewer_coordinates", viewerCoordinates);
            return this;
        }

        public APIRequestCreateFeed setViewerCoordinates(String viewerCoordinates) {
            this.setParam("viewer_coordinates", viewerCoordinates);
            return this;
        }

        public APIRequestCreateFeed setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestCreateFeed setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestCreateFeed requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateFeed requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFeed requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateFeed requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFeed requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateFeed requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetFeed
    extends APIRequest<Post> {
        APINodeList<Post> lastResponse = null;
        public static final String[] PARAMS = new String[]{"include_hidden", "q", "show_expired", "since", "until", "with"};
        public static final String[] FIELDS = new String[]{"actions", "admin_creator", "allowed_advertising_objectives", "application", "backdated_time", "call_to_action", "can_reply_privately", "caption", "child_attachments", "comments_mirroring_domain", "coordinates", "created_time", "description", "event", "expanded_height", "expanded_width", "feed_targeting", "from", "full_picture", "height", "icon", "id", "instagram_eligibility", "is_app_share", "is_eligible_for_promotion", "is_expired", "is_hidden", "is_inline_created", "is_instagram_eligible", "is_popular", "is_published", "is_spherical", "link", "message", "message_tags", "multi_share_end_card", "multi_share_optimized", "name", "object_id", "parent_id", "permalink_url", "picture", "place", "privacy", "promotable_id", "promotion_status", "properties", "scheduled_publish_time", "shares", "source", "status_type", "story", "story_tags", "subscribed", "target", "targeting", "timeline_visibility", "type", "updated_time", "via", "video_buying_eligibility", "width"};

        @Override
        public APINodeList<Post> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Post> parseResponse(String response, String header) throws APIException {
            return Post.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Post> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Post> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Post>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Post>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Post>>(){

                public APINodeList<Post> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetFeed(String nodeId, APIContext context) {
            super(context, nodeId, "/feed", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetFeed setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetFeed setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetFeed setIncludeHidden(Boolean includeHidden) {
            this.setParam("include_hidden", includeHidden);
            return this;
        }

        public APIRequestGetFeed setIncludeHidden(String includeHidden) {
            this.setParam("include_hidden", includeHidden);
            return this;
        }

        public APIRequestGetFeed setQ(String q) {
            this.setParam("q", q);
            return this;
        }

        public APIRequestGetFeed setShowExpired(Boolean showExpired) {
            this.setParam("show_expired", showExpired);
            return this;
        }

        public APIRequestGetFeed setShowExpired(String showExpired) {
            this.setParam("show_expired", showExpired);
            return this;
        }

        public APIRequestGetFeed setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetFeed setUntil(String until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestGetFeed setWith(String with) {
            this.setParam("with", with);
            return this;
        }

        public APIRequestGetFeed requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetFeed requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFeed requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetFeed requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFeed requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetFeed requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetFeed requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGetFeed requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGetFeed requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGetFeed requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGetFeed requestAllowedAdvertisingObjectivesField() {
            return this.requestAllowedAdvertisingObjectivesField(true);
        }

        public APIRequestGetFeed requestAllowedAdvertisingObjectivesField(boolean value) {
            this.requestField("allowed_advertising_objectives", value);
            return this;
        }

        public APIRequestGetFeed requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetFeed requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetFeed requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetFeed requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetFeed requestCallToActionField() {
            return this.requestCallToActionField(true);
        }

        public APIRequestGetFeed requestCallToActionField(boolean value) {
            this.requestField("call_to_action", value);
            return this;
        }

        public APIRequestGetFeed requestCanReplyPrivatelyField() {
            return this.requestCanReplyPrivatelyField(true);
        }

        public APIRequestGetFeed requestCanReplyPrivatelyField(boolean value) {
            this.requestField("can_reply_privately", value);
            return this;
        }

        public APIRequestGetFeed requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGetFeed requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGetFeed requestChildAttachmentsField() {
            return this.requestChildAttachmentsField(true);
        }

        public APIRequestGetFeed requestChildAttachmentsField(boolean value) {
            this.requestField("child_attachments", value);
            return this;
        }

        public APIRequestGetFeed requestCommentsMirroringDomainField() {
            return this.requestCommentsMirroringDomainField(true);
        }

        public APIRequestGetFeed requestCommentsMirroringDomainField(boolean value) {
            this.requestField("comments_mirroring_domain", value);
            return this;
        }

        public APIRequestGetFeed requestCoordinatesField() {
            return this.requestCoordinatesField(true);
        }

        public APIRequestGetFeed requestCoordinatesField(boolean value) {
            this.requestField("coordinates", value);
            return this;
        }

        public APIRequestGetFeed requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetFeed requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetFeed requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetFeed requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetFeed requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetFeed requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetFeed requestExpandedHeightField() {
            return this.requestExpandedHeightField(true);
        }

        public APIRequestGetFeed requestExpandedHeightField(boolean value) {
            this.requestField("expanded_height", value);
            return this;
        }

        public APIRequestGetFeed requestExpandedWidthField() {
            return this.requestExpandedWidthField(true);
        }

        public APIRequestGetFeed requestExpandedWidthField(boolean value) {
            this.requestField("expanded_width", value);
            return this;
        }

        public APIRequestGetFeed requestFeedTargetingField() {
            return this.requestFeedTargetingField(true);
        }

        public APIRequestGetFeed requestFeedTargetingField(boolean value) {
            this.requestField("feed_targeting", value);
            return this;
        }

        public APIRequestGetFeed requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetFeed requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetFeed requestFullPictureField() {
            return this.requestFullPictureField(true);
        }

        public APIRequestGetFeed requestFullPictureField(boolean value) {
            this.requestField("full_picture", value);
            return this;
        }

        public APIRequestGetFeed requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetFeed requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetFeed requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetFeed requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetFeed requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetFeed requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetFeed requestInstagramEligibilityField() {
            return this.requestInstagramEligibilityField(true);
        }

        public APIRequestGetFeed requestInstagramEligibilityField(boolean value) {
            this.requestField("instagram_eligibility", value);
            return this;
        }

        public APIRequestGetFeed requestIsAppShareField() {
            return this.requestIsAppShareField(true);
        }

        public APIRequestGetFeed requestIsAppShareField(boolean value) {
            this.requestField("is_app_share", value);
            return this;
        }

        public APIRequestGetFeed requestIsEligibleForPromotionField() {
            return this.requestIsEligibleForPromotionField(true);
        }

        public APIRequestGetFeed requestIsEligibleForPromotionField(boolean value) {
            this.requestField("is_eligible_for_promotion", value);
            return this;
        }

        public APIRequestGetFeed requestIsExpiredField() {
            return this.requestIsExpiredField(true);
        }

        public APIRequestGetFeed requestIsExpiredField(boolean value) {
            this.requestField("is_expired", value);
            return this;
        }

        public APIRequestGetFeed requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetFeed requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetFeed requestIsInlineCreatedField() {
            return this.requestIsInlineCreatedField(true);
        }

        public APIRequestGetFeed requestIsInlineCreatedField(boolean value) {
            this.requestField("is_inline_created", value);
            return this;
        }

        public APIRequestGetFeed requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGetFeed requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGetFeed requestIsPopularField() {
            return this.requestIsPopularField(true);
        }

        public APIRequestGetFeed requestIsPopularField(boolean value) {
            this.requestField("is_popular", value);
            return this;
        }

        public APIRequestGetFeed requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetFeed requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetFeed requestIsSphericalField() {
            return this.requestIsSphericalField(true);
        }

        public APIRequestGetFeed requestIsSphericalField(boolean value) {
            this.requestField("is_spherical", value);
            return this;
        }

        public APIRequestGetFeed requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetFeed requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetFeed requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetFeed requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetFeed requestMessageTagsField() {
            return this.requestMessageTagsField(true);
        }

        public APIRequestGetFeed requestMessageTagsField(boolean value) {
            this.requestField("message_tags", value);
            return this;
        }

        public APIRequestGetFeed requestMultiShareEndCardField() {
            return this.requestMultiShareEndCardField(true);
        }

        public APIRequestGetFeed requestMultiShareEndCardField(boolean value) {
            this.requestField("multi_share_end_card", value);
            return this;
        }

        public APIRequestGetFeed requestMultiShareOptimizedField() {
            return this.requestMultiShareOptimizedField(true);
        }

        public APIRequestGetFeed requestMultiShareOptimizedField(boolean value) {
            this.requestField("multi_share_optimized", value);
            return this;
        }

        public APIRequestGetFeed requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetFeed requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetFeed requestObjectIdField() {
            return this.requestObjectIdField(true);
        }

        public APIRequestGetFeed requestObjectIdField(boolean value) {
            this.requestField("object_id", value);
            return this;
        }

        public APIRequestGetFeed requestParentIdField() {
            return this.requestParentIdField(true);
        }

        public APIRequestGetFeed requestParentIdField(boolean value) {
            this.requestField("parent_id", value);
            return this;
        }

        public APIRequestGetFeed requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetFeed requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetFeed requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetFeed requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetFeed requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetFeed requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetFeed requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetFeed requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetFeed requestPromotableIdField() {
            return this.requestPromotableIdField(true);
        }

        public APIRequestGetFeed requestPromotableIdField(boolean value) {
            this.requestField("promotable_id", value);
            return this;
        }

        public APIRequestGetFeed requestPromotionStatusField() {
            return this.requestPromotionStatusField(true);
        }

        public APIRequestGetFeed requestPromotionStatusField(boolean value) {
            this.requestField("promotion_status", value);
            return this;
        }

        public APIRequestGetFeed requestPropertiesField() {
            return this.requestPropertiesField(true);
        }

        public APIRequestGetFeed requestPropertiesField(boolean value) {
            this.requestField("properties", value);
            return this;
        }

        public APIRequestGetFeed requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetFeed requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetFeed requestSharesField() {
            return this.requestSharesField(true);
        }

        public APIRequestGetFeed requestSharesField(boolean value) {
            this.requestField("shares", value);
            return this;
        }

        public APIRequestGetFeed requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetFeed requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetFeed requestStatusTypeField() {
            return this.requestStatusTypeField(true);
        }

        public APIRequestGetFeed requestStatusTypeField(boolean value) {
            this.requestField("status_type", value);
            return this;
        }

        public APIRequestGetFeed requestStoryField() {
            return this.requestStoryField(true);
        }

        public APIRequestGetFeed requestStoryField(boolean value) {
            this.requestField("story", value);
            return this;
        }

        public APIRequestGetFeed requestStoryTagsField() {
            return this.requestStoryTagsField(true);
        }

        public APIRequestGetFeed requestStoryTagsField(boolean value) {
            this.requestField("story_tags", value);
            return this;
        }

        public APIRequestGetFeed requestSubscribedField() {
            return this.requestSubscribedField(true);
        }

        public APIRequestGetFeed requestSubscribedField(boolean value) {
            this.requestField("subscribed", value);
            return this;
        }

        public APIRequestGetFeed requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGetFeed requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGetFeed requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetFeed requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetFeed requestTimelineVisibilityField() {
            return this.requestTimelineVisibilityField(true);
        }

        public APIRequestGetFeed requestTimelineVisibilityField(boolean value) {
            this.requestField("timeline_visibility", value);
            return this;
        }

        public APIRequestGetFeed requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetFeed requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetFeed requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetFeed requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetFeed requestViaField() {
            return this.requestViaField(true);
        }

        public APIRequestGetFeed requestViaField(boolean value) {
            this.requestField("via", value);
            return this;
        }

        public APIRequestGetFeed requestVideoBuyingEligibilityField() {
            return this.requestVideoBuyingEligibilityField(true);
        }

        public APIRequestGetFeed requestVideoBuyingEligibilityField(boolean value) {
            this.requestField("video_buying_eligibility", value);
            return this;
        }

        public APIRequestGetFeed requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetFeed requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    public static class APIRequestGetEvents
    extends APIRequest<Event> {
        APINodeList<Event> lastResponse = null;
        public static final String[] PARAMS = new String[]{"include_canceled", "type"};
        public static final String[] FIELDS = new String[]{"attending_count", "can_guests_invite", "category", "cover", "created_time", "declined_count", "description", "discount_code_enabled", "end_time", "event_times", "guest_list_enabled", "id", "interested_count", "is_canceled", "is_draft", "is_online", "is_page_owned", "maybe_count", "name", "noreply_count", "online_event_format", "online_event_third_party_url", "owner", "parent_group", "place", "registration_setting", "scheduled_publish_time", "start_time", "ticket_setting", "ticket_uri", "ticket_uri_start_sales_time", "ticketing_privacy_uri", "ticketing_terms_uri", "timezone", "type", "updated_time"};

        @Override
        public APINodeList<Event> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Event> parseResponse(String response, String header) throws APIException {
            return Event.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Event> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Event> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Event>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Event>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Event>>(){

                public APINodeList<Event> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetEvents(String nodeId, APIContext context) {
            super(context, nodeId, "/events", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetEvents setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetEvents setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetEvents setIncludeCanceled(Boolean includeCanceled) {
            this.setParam("include_canceled", includeCanceled);
            return this;
        }

        public APIRequestGetEvents setIncludeCanceled(String includeCanceled) {
            this.setParam("include_canceled", includeCanceled);
            return this;
        }

        public APIRequestGetEvents setType(Event.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetEvents setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetEvents requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetEvents requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetEvents requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetEvents requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetEvents requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetEvents requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetEvents requestAttendingCountField() {
            return this.requestAttendingCountField(true);
        }

        public APIRequestGetEvents requestAttendingCountField(boolean value) {
            this.requestField("attending_count", value);
            return this;
        }

        public APIRequestGetEvents requestCanGuestsInviteField() {
            return this.requestCanGuestsInviteField(true);
        }

        public APIRequestGetEvents requestCanGuestsInviteField(boolean value) {
            this.requestField("can_guests_invite", value);
            return this;
        }

        public APIRequestGetEvents requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetEvents requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetEvents requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetEvents requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetEvents requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetEvents requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetEvents requestDeclinedCountField() {
            return this.requestDeclinedCountField(true);
        }

        public APIRequestGetEvents requestDeclinedCountField(boolean value) {
            this.requestField("declined_count", value);
            return this;
        }

        public APIRequestGetEvents requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetEvents requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetEvents requestDiscountCodeEnabledField() {
            return this.requestDiscountCodeEnabledField(true);
        }

        public APIRequestGetEvents requestDiscountCodeEnabledField(boolean value) {
            this.requestField("discount_code_enabled", value);
            return this;
        }

        public APIRequestGetEvents requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetEvents requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetEvents requestEventTimesField() {
            return this.requestEventTimesField(true);
        }

        public APIRequestGetEvents requestEventTimesField(boolean value) {
            this.requestField("event_times", value);
            return this;
        }

        public APIRequestGetEvents requestGuestListEnabledField() {
            return this.requestGuestListEnabledField(true);
        }

        public APIRequestGetEvents requestGuestListEnabledField(boolean value) {
            this.requestField("guest_list_enabled", value);
            return this;
        }

        public APIRequestGetEvents requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetEvents requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetEvents requestInterestedCountField() {
            return this.requestInterestedCountField(true);
        }

        public APIRequestGetEvents requestInterestedCountField(boolean value) {
            this.requestField("interested_count", value);
            return this;
        }

        public APIRequestGetEvents requestIsCanceledField() {
            return this.requestIsCanceledField(true);
        }

        public APIRequestGetEvents requestIsCanceledField(boolean value) {
            this.requestField("is_canceled", value);
            return this;
        }

        public APIRequestGetEvents requestIsDraftField() {
            return this.requestIsDraftField(true);
        }

        public APIRequestGetEvents requestIsDraftField(boolean value) {
            this.requestField("is_draft", value);
            return this;
        }

        public APIRequestGetEvents requestIsOnlineField() {
            return this.requestIsOnlineField(true);
        }

        public APIRequestGetEvents requestIsOnlineField(boolean value) {
            this.requestField("is_online", value);
            return this;
        }

        public APIRequestGetEvents requestIsPageOwnedField() {
            return this.requestIsPageOwnedField(true);
        }

        public APIRequestGetEvents requestIsPageOwnedField(boolean value) {
            this.requestField("is_page_owned", value);
            return this;
        }

        public APIRequestGetEvents requestMaybeCountField() {
            return this.requestMaybeCountField(true);
        }

        public APIRequestGetEvents requestMaybeCountField(boolean value) {
            this.requestField("maybe_count", value);
            return this;
        }

        public APIRequestGetEvents requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetEvents requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetEvents requestNoreplyCountField() {
            return this.requestNoreplyCountField(true);
        }

        public APIRequestGetEvents requestNoreplyCountField(boolean value) {
            this.requestField("noreply_count", value);
            return this;
        }

        public APIRequestGetEvents requestOnlineEventFormatField() {
            return this.requestOnlineEventFormatField(true);
        }

        public APIRequestGetEvents requestOnlineEventFormatField(boolean value) {
            this.requestField("online_event_format", value);
            return this;
        }

        public APIRequestGetEvents requestOnlineEventThirdPartyUrlField() {
            return this.requestOnlineEventThirdPartyUrlField(true);
        }

        public APIRequestGetEvents requestOnlineEventThirdPartyUrlField(boolean value) {
            this.requestField("online_event_third_party_url", value);
            return this;
        }

        public APIRequestGetEvents requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetEvents requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetEvents requestParentGroupField() {
            return this.requestParentGroupField(true);
        }

        public APIRequestGetEvents requestParentGroupField(boolean value) {
            this.requestField("parent_group", value);
            return this;
        }

        public APIRequestGetEvents requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetEvents requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetEvents requestRegistrationSettingField() {
            return this.requestRegistrationSettingField(true);
        }

        public APIRequestGetEvents requestRegistrationSettingField(boolean value) {
            this.requestField("registration_setting", value);
            return this;
        }

        public APIRequestGetEvents requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetEvents requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetEvents requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetEvents requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetEvents requestTicketSettingField() {
            return this.requestTicketSettingField(true);
        }

        public APIRequestGetEvents requestTicketSettingField(boolean value) {
            this.requestField("ticket_setting", value);
            return this;
        }

        public APIRequestGetEvents requestTicketUriField() {
            return this.requestTicketUriField(true);
        }

        public APIRequestGetEvents requestTicketUriField(boolean value) {
            this.requestField("ticket_uri", value);
            return this;
        }

        public APIRequestGetEvents requestTicketUriStartSalesTimeField() {
            return this.requestTicketUriStartSalesTimeField(true);
        }

        public APIRequestGetEvents requestTicketUriStartSalesTimeField(boolean value) {
            this.requestField("ticket_uri_start_sales_time", value);
            return this;
        }

        public APIRequestGetEvents requestTicketingPrivacyUriField() {
            return this.requestTicketingPrivacyUriField(true);
        }

        public APIRequestGetEvents requestTicketingPrivacyUriField(boolean value) {
            this.requestField("ticketing_privacy_uri", value);
            return this;
        }

        public APIRequestGetEvents requestTicketingTermsUriField() {
            return this.requestTicketingTermsUriField(true);
        }

        public APIRequestGetEvents requestTicketingTermsUriField(boolean value) {
            this.requestField("ticketing_terms_uri", value);
            return this;
        }

        public APIRequestGetEvents requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGetEvents requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGetEvents requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetEvents requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetEvents requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetEvents requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    public static class APIRequestGetCustomLabels
    extends APIRequest<PageUserMessageThreadLabel> {
        APINodeList<PageUserMessageThreadLabel> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "page_label_name"};

        @Override
        public APINodeList<PageUserMessageThreadLabel> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<PageUserMessageThreadLabel> parseResponse(String response, String header) throws APIException {
            return PageUserMessageThreadLabel.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<PageUserMessageThreadLabel> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<PageUserMessageThreadLabel> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<PageUserMessageThreadLabel>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<PageUserMessageThreadLabel>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<PageUserMessageThreadLabel>>(){

                public APINodeList<PageUserMessageThreadLabel> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCustomLabels(String nodeId, APIContext context) {
            super(context, nodeId, "/custom_labels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCustomLabels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCustomLabels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCustomLabels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCustomLabels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomLabels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCustomLabels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomLabels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCustomLabels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCustomLabels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCustomLabels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCustomLabels requestPageLabelNameField() {
            return this.requestPageLabelNameField(true);
        }

        public APIRequestGetCustomLabels requestPageLabelNameField(boolean value) {
            this.requestField("page_label_name", value);
            return this;
        }
    }

    public static class APIRequestGetConversations
    extends APIRequest<UnifiedThread> {
        APINodeList<UnifiedThread> lastResponse = null;
        public static final String[] PARAMS = new String[]{"folder", "tags", "user_id"};
        public static final String[] FIELDS = new String[]{"can_reply", "folder", "former_participants", "id", "is_subscribed", "link", "linked_group", "message_count", "name", "participants", "scoped_thread_key", "senders", "snippet", "subject", "unread_count", "updated_time", "wallpaper"};

        @Override
        public APINodeList<UnifiedThread> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UnifiedThread> parseResponse(String response, String header) throws APIException {
            return UnifiedThread.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<UnifiedThread> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UnifiedThread> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UnifiedThread>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UnifiedThread>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<UnifiedThread>>(){

                public APINodeList<UnifiedThread> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetConversations(String nodeId, APIContext context) {
            super(context, nodeId, "/conversations", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetConversations setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetConversations setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetConversations setFolder(String folder) {
            this.setParam("folder", folder);
            return this;
        }

        public APIRequestGetConversations setTags(List<String> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestGetConversations setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestGetConversations setUserId(String userId) {
            this.setParam("user_id", userId);
            return this;
        }

        public APIRequestGetConversations requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetConversations requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetConversations requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetConversations requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetConversations requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetConversations requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetConversations requestCanReplyField() {
            return this.requestCanReplyField(true);
        }

        public APIRequestGetConversations requestCanReplyField(boolean value) {
            this.requestField("can_reply", value);
            return this;
        }

        public APIRequestGetConversations requestFolderField() {
            return this.requestFolderField(true);
        }

        public APIRequestGetConversations requestFolderField(boolean value) {
            this.requestField("folder", value);
            return this;
        }

        public APIRequestGetConversations requestFormerParticipantsField() {
            return this.requestFormerParticipantsField(true);
        }

        public APIRequestGetConversations requestFormerParticipantsField(boolean value) {
            this.requestField("former_participants", value);
            return this;
        }

        public APIRequestGetConversations requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetConversations requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetConversations requestIsSubscribedField() {
            return this.requestIsSubscribedField(true);
        }

        public APIRequestGetConversations requestIsSubscribedField(boolean value) {
            this.requestField("is_subscribed", value);
            return this;
        }

        public APIRequestGetConversations requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetConversations requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetConversations requestLinkedGroupField() {
            return this.requestLinkedGroupField(true);
        }

        public APIRequestGetConversations requestLinkedGroupField(boolean value) {
            this.requestField("linked_group", value);
            return this;
        }

        public APIRequestGetConversations requestMessageCountField() {
            return this.requestMessageCountField(true);
        }

        public APIRequestGetConversations requestMessageCountField(boolean value) {
            this.requestField("message_count", value);
            return this;
        }

        public APIRequestGetConversations requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetConversations requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetConversations requestParticipantsField() {
            return this.requestParticipantsField(true);
        }

        public APIRequestGetConversations requestParticipantsField(boolean value) {
            this.requestField("participants", value);
            return this;
        }

        public APIRequestGetConversations requestScopedThreadKeyField() {
            return this.requestScopedThreadKeyField(true);
        }

        public APIRequestGetConversations requestScopedThreadKeyField(boolean value) {
            this.requestField("scoped_thread_key", value);
            return this;
        }

        public APIRequestGetConversations requestSendersField() {
            return this.requestSendersField(true);
        }

        public APIRequestGetConversations requestSendersField(boolean value) {
            this.requestField("senders", value);
            return this;
        }

        public APIRequestGetConversations requestSnippetField() {
            return this.requestSnippetField(true);
        }

        public APIRequestGetConversations requestSnippetField(boolean value) {
            this.requestField("snippet", value);
            return this;
        }

        public APIRequestGetConversations requestSubjectField() {
            return this.requestSubjectField(true);
        }

        public APIRequestGetConversations requestSubjectField(boolean value) {
            this.requestField("subject", value);
            return this;
        }

        public APIRequestGetConversations requestUnreadCountField() {
            return this.requestUnreadCountField(true);
        }

        public APIRequestGetConversations requestUnreadCountField(boolean value) {
            this.requestField("unread_count", value);
            return this;
        }

        public APIRequestGetConversations requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetConversations requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetConversations requestWallpaperField() {
            return this.requestWallpaperField(true);
        }

        public APIRequestGetConversations requestWallpaperField(boolean value) {
            this.requestField("wallpaper", value);
            return this;
        }
    }

    public static class APIRequestCreateBusiness
    extends APIRequest<Business> {
        Business lastResponse = null;
        public static final String[] PARAMS = new String[]{"child_business_external_id", "email", "name", "primary_page", "sales_rep_email", "survey_business_type", "survey_num_assets", "survey_num_people", "timezone_id", "vertical"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Business getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Business parseResponse(String response, String header) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Business execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Business execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Business> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Business> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Business>(){

                public Business apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateBusiness(String nodeId, APIContext context) {
            super(context, nodeId, "/businesses", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateBusiness setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateBusiness setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateBusiness setChildBusinessExternalId(String childBusinessExternalId) {
            this.setParam("child_business_external_id", childBusinessExternalId);
            return this;
        }

        public APIRequestCreateBusiness setEmail(String email) {
            this.setParam("email", email);
            return this;
        }

        public APIRequestCreateBusiness setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateBusiness setPrimaryPage(String primaryPage) {
            this.setParam("primary_page", primaryPage);
            return this;
        }

        public APIRequestCreateBusiness setSalesRepEmail(String salesRepEmail) {
            this.setParam("sales_rep_email", salesRepEmail);
            return this;
        }

        public APIRequestCreateBusiness setSurveyBusinessType(Business.EnumSurveyBusinessType surveyBusinessType) {
            this.setParam("survey_business_type", (Object)surveyBusinessType);
            return this;
        }

        public APIRequestCreateBusiness setSurveyBusinessType(String surveyBusinessType) {
            this.setParam("survey_business_type", surveyBusinessType);
            return this;
        }

        public APIRequestCreateBusiness setSurveyNumAssets(Long surveyNumAssets) {
            this.setParam("survey_num_assets", surveyNumAssets);
            return this;
        }

        public APIRequestCreateBusiness setSurveyNumAssets(String surveyNumAssets) {
            this.setParam("survey_num_assets", surveyNumAssets);
            return this;
        }

        public APIRequestCreateBusiness setSurveyNumPeople(Long surveyNumPeople) {
            this.setParam("survey_num_people", surveyNumPeople);
            return this;
        }

        public APIRequestCreateBusiness setSurveyNumPeople(String surveyNumPeople) {
            this.setParam("survey_num_people", surveyNumPeople);
            return this;
        }

        public APIRequestCreateBusiness setTimezoneId(Long timezoneId) {
            this.setParam("timezone_id", timezoneId);
            return this;
        }

        public APIRequestCreateBusiness setTimezoneId(String timezoneId) {
            this.setParam("timezone_id", timezoneId);
            return this;
        }

        public APIRequestCreateBusiness setVertical(Business.EnumVertical vertical) {
            this.setParam("vertical", (Object)vertical);
            return this;
        }

        public APIRequestCreateBusiness setVertical(String vertical) {
            this.setParam("vertical", vertical);
            return this;
        }

        public APIRequestCreateBusiness requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateBusiness requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBusiness requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateBusiness requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBusiness requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateBusiness requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetBusinesses
    extends APIRequest<Business> {
        APINodeList<Business> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_offline_analytics", "collaborative_ads_managed_partner_business_info", "collaborative_ads_managed_partner_eligibility", "collaborative_ads_partner_premium_options", "created_by", "created_time", "extended_updated_time", "id", "is_hidden", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "verification_status", "vertical", "vertical_id"};

        @Override
        public APINodeList<Business> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Business> parseResponse(String response, String header) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Business> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Business>>(){

                public APINodeList<Business> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBusinesses(String nodeId, APIContext context) {
            super(context, nodeId, "/businesses", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBusinesses setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBusinesses setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBusinesses requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBusinesses requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinesses requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBusinesses requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinesses requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBusinesses requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBusinesses requestBlockOfflineAnalyticsField() {
            return this.requestBlockOfflineAnalyticsField(true);
        }

        public APIRequestGetBusinesses requestBlockOfflineAnalyticsField(boolean value) {
            this.requestField("block_offline_analytics", value);
            return this;
        }

        public APIRequestGetBusinesses requestCollaborativeAdsManagedPartnerBusinessInfoField() {
            return this.requestCollaborativeAdsManagedPartnerBusinessInfoField(true);
        }

        public APIRequestGetBusinesses requestCollaborativeAdsManagedPartnerBusinessInfoField(boolean value) {
            this.requestField("collaborative_ads_managed_partner_business_info", value);
            return this;
        }

        public APIRequestGetBusinesses requestCollaborativeAdsManagedPartnerEligibilityField() {
            return this.requestCollaborativeAdsManagedPartnerEligibilityField(true);
        }

        public APIRequestGetBusinesses requestCollaborativeAdsManagedPartnerEligibilityField(boolean value) {
            this.requestField("collaborative_ads_managed_partner_eligibility", value);
            return this;
        }

        public APIRequestGetBusinesses requestCollaborativeAdsPartnerPremiumOptionsField() {
            return this.requestCollaborativeAdsPartnerPremiumOptionsField(true);
        }

        public APIRequestGetBusinesses requestCollaborativeAdsPartnerPremiumOptionsField(boolean value) {
            this.requestField("collaborative_ads_partner_premium_options", value);
            return this;
        }

        public APIRequestGetBusinesses requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetBusinesses requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetBusinesses requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetBusinesses requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetBusinesses requestExtendedUpdatedTimeField() {
            return this.requestExtendedUpdatedTimeField(true);
        }

        public APIRequestGetBusinesses requestExtendedUpdatedTimeField(boolean value) {
            this.requestField("extended_updated_time", value);
            return this;
        }

        public APIRequestGetBusinesses requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBusinesses requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBusinesses requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetBusinesses requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetBusinesses requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetBusinesses requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetBusinesses requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetBusinesses requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetBusinesses requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGetBusinesses requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGetBusinesses requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGetBusinesses requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGetBusinesses requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetBusinesses requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetBusinesses requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGetBusinesses requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGetBusinesses requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetBusinesses requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetBusinesses requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetBusinesses requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetBusinesses requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetBusinesses requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetBusinesses requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetBusinesses requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGetBusinesses requestVerticalIdField() {
            return this.requestVerticalIdField(true);
        }

        public APIRequestGetBusinesses requestVerticalIdField(boolean value) {
            this.requestField("vertical_id", value);
            return this;
        }
    }

    public static class APIRequestDeleteBusinesses
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteBusinesses(String nodeId, APIContext context) {
            super(context, nodeId, "/businesses", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteBusinesses setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteBusinesses setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteBusinesses setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteBusinesses requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteBusinesses requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteBusinesses requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteBusinesses requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteBusinesses requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteBusinesses requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetBusinessUsers
    extends APIRequest<BusinessUser> {
        APINodeList<BusinessUser> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "business_role_request", "email", "finance_permission", "first_name", "id", "ip_permission", "last_name", "marked_for_removal", "name", "pending_email", "role", "title", "two_fac_status"};

        @Override
        public APINodeList<BusinessUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BusinessUser> parseResponse(String response, String header) throws APIException {
            return BusinessUser.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<BusinessUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BusinessUser> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BusinessUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BusinessUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<BusinessUser>>(){

                public APINodeList<BusinessUser> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBusinessUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/business_users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBusinessUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBusinessUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBusinessUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBusinessUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBusinessUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBusinessUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBusinessUsers requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetBusinessUsers requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestBusinessRoleRequestField() {
            return this.requestBusinessRoleRequestField(true);
        }

        public APIRequestGetBusinessUsers requestBusinessRoleRequestField(boolean value) {
            this.requestField("business_role_request", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetBusinessUsers requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestFinancePermissionField() {
            return this.requestFinancePermissionField(true);
        }

        public APIRequestGetBusinessUsers requestFinancePermissionField(boolean value) {
            this.requestField("finance_permission", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetBusinessUsers requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBusinessUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestIpPermissionField() {
            return this.requestIpPermissionField(true);
        }

        public APIRequestGetBusinessUsers requestIpPermissionField(boolean value) {
            this.requestField("ip_permission", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetBusinessUsers requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestMarkedForRemovalField() {
            return this.requestMarkedForRemovalField(true);
        }

        public APIRequestGetBusinessUsers requestMarkedForRemovalField(boolean value) {
            this.requestField("marked_for_removal", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetBusinessUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestPendingEmailField() {
            return this.requestPendingEmailField(true);
        }

        public APIRequestGetBusinessUsers requestPendingEmailField(boolean value) {
            this.requestField("pending_email", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestRoleField() {
            return this.requestRoleField(true);
        }

        public APIRequestGetBusinessUsers requestRoleField(boolean value) {
            this.requestField("role", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetBusinessUsers requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestTwoFacStatusField() {
            return this.requestTwoFacStatusField(true);
        }

        public APIRequestGetBusinessUsers requestTwoFacStatusField(boolean value) {
            this.requestField("two_fac_status", value);
            return this;
        }
    }

    public static class APIRequestGetAvatars
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAvatars(String nodeId, APIContext context) {
            super(context, nodeId, "/avatars", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAvatars setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAvatars setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAvatars requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAvatars requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAvatars requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAvatars requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAvatars requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAvatars requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetAssignedProductCatalogs
    extends APIRequest<ProductCatalog> {
        APINodeList<ProductCatalog> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_to_collaborative_ads_share_settings", "agency_collaborative_ads_share_settings", "business", "catalog_store", "commerce_merchant_settings", "creator_user", "da_display_settings", "default_image_url", "fallback_image_url", "feed_count", "id", "is_catalog_segment", "name", "owner_business", "product_count", "store_catalog_settings", "vertical"};

        @Override
        public APINodeList<ProductCatalog> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProductCatalog> parseResponse(String response, String header) throws APIException {
            return ProductCatalog.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ProductCatalog> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProductCatalog> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProductCatalog>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProductCatalog>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ProductCatalog>>(){

                public APINodeList<ProductCatalog> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedProductCatalogs(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_product_catalogs", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedProductCatalogs setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedProductCatalogs setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedProductCatalogs requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedProductCatalogs requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedProductCatalogs requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedProductCatalogs requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedProductCatalogs requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestAdAccountToCollaborativeAdsShareSettingsField() {
            return this.requestAdAccountToCollaborativeAdsShareSettingsField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestAdAccountToCollaborativeAdsShareSettingsField(boolean value) {
            this.requestField("ad_account_to_collaborative_ads_share_settings", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestAgencyCollaborativeAdsShareSettingsField() {
            return this.requestAgencyCollaborativeAdsShareSettingsField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestAgencyCollaborativeAdsShareSettingsField(boolean value) {
            this.requestField("agency_collaborative_ads_share_settings", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestCatalogStoreField() {
            return this.requestCatalogStoreField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestCatalogStoreField(boolean value) {
            this.requestField("catalog_store", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestCommerceMerchantSettingsField() {
            return this.requestCommerceMerchantSettingsField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestCommerceMerchantSettingsField(boolean value) {
            this.requestField("commerce_merchant_settings", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestCreatorUserField() {
            return this.requestCreatorUserField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestCreatorUserField(boolean value) {
            this.requestField("creator_user", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestDaDisplaySettingsField() {
            return this.requestDaDisplaySettingsField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestDaDisplaySettingsField(boolean value) {
            this.requestField("da_display_settings", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestDefaultImageUrlField() {
            return this.requestDefaultImageUrlField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestDefaultImageUrlField(boolean value) {
            this.requestField("default_image_url", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestFallbackImageUrlField() {
            return this.requestFallbackImageUrlField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestFallbackImageUrlField(boolean value) {
            this.requestField("fallback_image_url", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestFeedCountField() {
            return this.requestFeedCountField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestFeedCountField(boolean value) {
            this.requestField("feed_count", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestIsCatalogSegmentField() {
            return this.requestIsCatalogSegmentField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestIsCatalogSegmentField(boolean value) {
            this.requestField("is_catalog_segment", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestProductCountField() {
            return this.requestProductCountField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestProductCountField(boolean value) {
            this.requestField("product_count", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestStoreCatalogSettingsField() {
            return this.requestStoreCatalogSettingsField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestStoreCatalogSettingsField(boolean value) {
            this.requestField("store_catalog_settings", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }
    }

    public static class APIRequestGetAssignedPages
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"pages"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "connected_page_backed_instagram_account", "contact_address", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "delivery_and_pickup_option_info", "description", "description_html", "differently_open_offerings", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "followers_count", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_root_id", "has_added_app", "has_transitioned_to_new_page_experience", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messaging_feature_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mini_shop_storefront", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "owner_business", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "pickup_options", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "privacy_info_url", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_donate_button_in_live_video", "talking_about_count", "temporary_status", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response, String header) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Page>>(){

                public APINodeList<Page> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedPages(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_pages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedPages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedPages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedPages setPages(List<Long> pages) {
            this.setParam("pages", pages);
            return this;
        }

        public APIRequestGetAssignedPages setPages(String pages) {
            this.setParam("pages", pages);
            return this;
        }

        public APIRequestGetAssignedPages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedPages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedPages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedPages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedPages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedPages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedPages requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetAssignedPages requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetAssignedPages requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetAssignedPages requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetAssignedPages requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetAssignedPages requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetAssignedPages requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetAssignedPages requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetAssignedPages requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetAssignedPages requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetAssignedPages requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetAssignedPages requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetAssignedPages requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetAssignedPages requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetAssignedPages requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetAssignedPages requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetAssignedPages requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedPages requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetAssignedPages requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetAssignedPages requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetAssignedPages requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetAssignedPages requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetAssignedPages requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetAssignedPages requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetAssignedPages requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetAssignedPages requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetAssignedPages requestConnectedPageBackedInstagramAccountField() {
            return this.requestConnectedPageBackedInstagramAccountField(true);
        }

        public APIRequestGetAssignedPages requestConnectedPageBackedInstagramAccountField(boolean value) {
            this.requestField("connected_page_backed_instagram_account", value);
            return this;
        }

        public APIRequestGetAssignedPages requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetAssignedPages requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetAssignedPages requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetAssignedPages requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetAssignedPages requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetAssignedPages requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetAssignedPages requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDeliveryAndPickupOptionInfoField() {
            return this.requestDeliveryAndPickupOptionInfoField(true);
        }

        public APIRequestGetAssignedPages requestDeliveryAndPickupOptionInfoField(boolean value) {
            this.requestField("delivery_and_pickup_option_info", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAssignedPages requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetAssignedPages requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDifferentlyOpenOfferingsField() {
            return this.requestDifferentlyOpenOfferingsField(true);
        }

        public APIRequestGetAssignedPages requestDifferentlyOpenOfferingsField(boolean value) {
            this.requestField("differently_open_offerings", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetAssignedPages requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetAssignedPages requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetAssignedPages requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetAssignedPages requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetAssignedPages requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetAssignedPages requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetAssignedPages requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetAssignedPages requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetAssignedPages requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetAssignedPages requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFollowersCountField() {
            return this.requestFollowersCountField(true);
        }

        public APIRequestGetAssignedPages requestFollowersCountField(boolean value) {
            this.requestField("followers_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetAssignedPages requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetAssignedPages requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetAssignedPages requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetAssignedPages requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetAssignedPages requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetAssignedPages requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetAssignedPages requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetAssignedPages requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHasTransitionedToNewPageExperienceField() {
            return this.requestHasTransitionedToNewPageExperienceField(true);
        }

        public APIRequestGetAssignedPages requestHasTransitionedToNewPageExperienceField(boolean value) {
            this.requestField("has_transitioned_to_new_page_experience", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetAssignedPages requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetAssignedPages requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetAssignedPages requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetAssignedPages requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedPages requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedPages requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetAssignedPages requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetAssignedPages requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetAssignedPages requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetAssignedPages requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetAssignedPages requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetAssignedPages requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetAssignedPages requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetAssignedPages requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetAssignedPages requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetAssignedPages requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetAssignedPages requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetAssignedPages requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetAssignedPages requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetAssignedPages requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetAssignedPages requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetAssignedPages requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetAssignedPages requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetAssignedPages requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetAssignedPages requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetAssignedPages requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetAssignedPages requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetAssignedPages requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetAssignedPages requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetAssignedPages requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetAssignedPages requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetAssignedPages requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetAssignedPages requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetAssignedPages requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetAssignedPages requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetAssignedPages requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetAssignedPages requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetAssignedPages requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetAssignedPages requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMessagingFeatureStatusField() {
            return this.requestMessagingFeatureStatusField(true);
        }

        public APIRequestGetAssignedPages requestMessagingFeatureStatusField(boolean value) {
            this.requestField("messaging_feature_status", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetAssignedPages requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetAssignedPages requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetAssignedPages requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetAssignedPages requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMiniShopStorefrontField() {
            return this.requestMiniShopStorefrontField(true);
        }

        public APIRequestGetAssignedPages requestMiniShopStorefrontField(boolean value) {
            this.requestField("mini_shop_storefront", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetAssignedPages requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetAssignedPages requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetAssignedPages requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetAssignedPages requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedPages requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedPages requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetAssignedPages requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetAssignedPages requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetAssignedPages requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetAssignedPages requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetAssignedPages requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetAssignedPages requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetAssignedPages requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetAssignedPages requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetAssignedPages requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAssignedPages requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetAssignedPages requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetAssignedPages requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetAssignedPages requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetAssignedPages requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetAssignedPages requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetAssignedPages requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetAssignedPages requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetAssignedPages requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetAssignedPages requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetAssignedPages requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPickupOptionsField() {
            return this.requestPickupOptionsField(true);
        }

        public APIRequestGetAssignedPages requestPickupOptionsField(boolean value) {
            this.requestField("pickup_options", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetAssignedPages requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetAssignedPages requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetAssignedPages requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetAssignedPages requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetAssignedPages requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPrivacyInfoUrlField() {
            return this.requestPrivacyInfoUrlField(true);
        }

        public APIRequestGetAssignedPages requestPrivacyInfoUrlField(boolean value) {
            this.requestField("privacy_info_url", value);
            return this;
        }

        public APIRequestGetAssignedPages requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetAssignedPages requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetAssignedPages requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetAssignedPages requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetAssignedPages requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetAssignedPages requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetAssignedPages requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetAssignedPages requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetAssignedPages requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetAssignedPages requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetAssignedPages requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetAssignedPages requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetAssignedPages requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetAssignedPages requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetAssignedPages requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetAssignedPages requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetAssignedPages requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetAssignedPages requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetAssignedPages requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetAssignedPages requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetAssignedPages requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetAssignedPages requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetAssignedPages requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetAssignedPages requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetAssignedPages requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetAssignedPages requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetAssignedPages requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetAssignedPages requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetAssignedPages requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetAssignedPages requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetAssignedPages requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetAssignedPages requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetAssignedPages requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetAssignedPages requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetAssignedPages requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetAssignedPages requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetAssignedPages requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetAssignedPages requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetAssignedPages requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetAssignedPages requestSupportsDonateButtonInLiveVideoField() {
            return this.requestSupportsDonateButtonInLiveVideoField(true);
        }

        public APIRequestGetAssignedPages requestSupportsDonateButtonInLiveVideoField(boolean value) {
            this.requestField("supports_donate_button_in_live_video", value);
            return this;
        }

        public APIRequestGetAssignedPages requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetAssignedPages requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestTemporaryStatusField() {
            return this.requestTemporaryStatusField(true);
        }

        public APIRequestGetAssignedPages requestTemporaryStatusField(boolean value) {
            this.requestField("temporary_status", value);
            return this;
        }

        public APIRequestGetAssignedPages requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetAssignedPages requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetAssignedPages requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetAssignedPages requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetAssignedPages requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetAssignedPages requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetAssignedPages requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetAssignedPages requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetAssignedPages requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetAssignedPages requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetAssignedPages requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetAssignedPages requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetAssignedPages requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetAssignedPages requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetAssignedPages requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetAssignedPages requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    public static class APIRequestGetAssignedBusinessAssetGroups
    extends APIRequest<BusinessAssetGroup> {
        APINodeList<BusinessAssetGroup> lastResponse = null;
        public static final String[] PARAMS = new String[]{"contained_asset_id"};
        public static final String[] FIELDS = new String[]{"id", "name", "owner_business"};

        @Override
        public APINodeList<BusinessAssetGroup> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BusinessAssetGroup> parseResponse(String response, String header) throws APIException {
            return BusinessAssetGroup.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<BusinessAssetGroup> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BusinessAssetGroup> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BusinessAssetGroup>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BusinessAssetGroup>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<BusinessAssetGroup>>(){

                public APINodeList<BusinessAssetGroup> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedBusinessAssetGroups(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_business_asset_groups", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedBusinessAssetGroups setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedBusinessAssetGroups setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedBusinessAssetGroups setContainedAssetId(String containedAssetId) {
            this.setParam("contained_asset_id", containedAssetId);
            return this;
        }

        public APIRequestGetAssignedBusinessAssetGroups requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedBusinessAssetGroups requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedBusinessAssetGroups requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedBusinessAssetGroups requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedBusinessAssetGroups requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedBusinessAssetGroups requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedBusinessAssetGroups requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedBusinessAssetGroups requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedBusinessAssetGroups requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedBusinessAssetGroups requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedBusinessAssetGroups requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAssignedBusinessAssetGroups requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }
    }

    public static class APIRequestGetAssignedAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "custom_audience_info", "default_dsa_beneficiary", "default_dsa_payor", "disable_reason", "end_advertiser", "end_advertiser_name", "existing_customers", "extended_credit_invoice_group", "failed_delivery_checks", "fb_entity", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "liable_address", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "owner_business", "partner", "rf_spec", "send_bill_to_address", "show_checkout_experience", "sold_to_address", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_tasks", "user_tos_accepted", "viewable_business"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_ad_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAssignedAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetAssignedAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetAssignedAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetAssignedAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetAssignedAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetAssignedAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAssignedAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetAssignedAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetAssignedAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetAssignedAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetAssignedAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetAssignedAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetAssignedAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetAssignedAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetAssignedAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetAssignedAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAssignedAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetAssignedAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestCustomAudienceInfoField() {
            return this.requestCustomAudienceInfoField(true);
        }

        public APIRequestGetAssignedAdAccounts requestCustomAudienceInfoField(boolean value) {
            this.requestField("custom_audience_info", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestDefaultDsaBeneficiaryField() {
            return this.requestDefaultDsaBeneficiaryField(true);
        }

        public APIRequestGetAssignedAdAccounts requestDefaultDsaBeneficiaryField(boolean value) {
            this.requestField("default_dsa_beneficiary", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestDefaultDsaPayorField() {
            return this.requestDefaultDsaPayorField(true);
        }

        public APIRequestGetAssignedAdAccounts requestDefaultDsaPayorField(boolean value) {
            this.requestField("default_dsa_payor", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetAssignedAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetAssignedAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetAssignedAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestExistingCustomersField() {
            return this.requestExistingCustomersField(true);
        }

        public APIRequestGetAssignedAdAccounts requestExistingCustomersField(boolean value) {
            this.requestField("existing_customers", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetAssignedAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAssignedAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestFbEntityField() {
            return this.requestFbEntityField(true);
        }

        public APIRequestGetAssignedAdAccounts requestFbEntityField(boolean value) {
            this.requestField("fb_entity", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetAssignedAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetAssignedAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetAssignedAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetAssignedAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetAssignedAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestLiableAddressField() {
            return this.requestLiableAddressField(true);
        }

        public APIRequestGetAssignedAdAccounts requestLiableAddressField(boolean value) {
            this.requestField("liable_address", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetAssignedAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetAssignedAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetAssignedAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetAssignedAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetAssignedAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetAssignedAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAssignedAdAccounts requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetAssignedAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetAssignedAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestSendBillToAddressField() {
            return this.requestSendBillToAddressField(true);
        }

        public APIRequestGetAssignedAdAccounts requestSendBillToAddressField(boolean value) {
            this.requestField("send_bill_to_address", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetAssignedAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestSoldToAddressField() {
            return this.requestSoldToAddressField(true);
        }

        public APIRequestGetAssignedAdAccounts requestSoldToAddressField(boolean value) {
            this.requestField("sold_to_address", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetAssignedAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetAssignedAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetAssignedAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetAssignedAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAssignedAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetAssignedAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetAssignedAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetAssignedAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestUserTasksField() {
            return this.requestUserTasksField(true);
        }

        public APIRequestGetAssignedAdAccounts requestUserTasksField(boolean value) {
            this.requestField("user_tasks", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetAssignedAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }

        public APIRequestGetAssignedAdAccounts requestViewableBusinessField() {
            return this.requestViewableBusinessField(true);
        }

        public APIRequestGetAssignedAdAccounts requestViewableBusinessField(boolean value) {
            this.requestField("viewable_business", value);
            return this;
        }
    }

    public static class APIRequestGetAppRequests
    extends APIRequest<AppRequest> {
        APINodeList<AppRequest> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"action_type", "application", "created_time", "data", "from", "id", "message", "object", "to"};

        @Override
        public APINodeList<AppRequest> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AppRequest> parseResponse(String response, String header) throws APIException {
            return AppRequest.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AppRequest> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AppRequest> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AppRequest>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AppRequest>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AppRequest>>(){

                public APINodeList<AppRequest> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAppRequests(String nodeId, APIContext context) {
            super(context, nodeId, "/apprequests", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAppRequests setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAppRequests setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAppRequests requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAppRequests requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAppRequests requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAppRequests requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAppRequests requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAppRequests requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAppRequests requestActionTypeField() {
            return this.requestActionTypeField(true);
        }

        public APIRequestGetAppRequests requestActionTypeField(boolean value) {
            this.requestField("action_type", value);
            return this;
        }

        public APIRequestGetAppRequests requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetAppRequests requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetAppRequests requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAppRequests requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAppRequests requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGetAppRequests requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGetAppRequests requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetAppRequests requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetAppRequests requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAppRequests requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAppRequests requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetAppRequests requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetAppRequests requestObjectField() {
            return this.requestObjectField(true);
        }

        public APIRequestGetAppRequests requestObjectField(boolean value) {
            this.requestField("object", value);
            return this;
        }

        public APIRequestGetAppRequests requestToField() {
            return this.requestToField(true);
        }

        public APIRequestGetAppRequests requestToField(boolean value) {
            this.requestField("to", value);
            return this;
        }
    }

    public static class APIRequestGetAppRequestFormerRecipients
    extends APIRequest<AppRequestFormerRecipient> {
        APINodeList<AppRequestFormerRecipient> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "recipient_id"};

        @Override
        public APINodeList<AppRequestFormerRecipient> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AppRequestFormerRecipient> parseResponse(String response, String header) throws APIException {
            return AppRequestFormerRecipient.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AppRequestFormerRecipient> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AppRequestFormerRecipient> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AppRequestFormerRecipient>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AppRequestFormerRecipient>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AppRequestFormerRecipient>>(){

                public APINodeList<AppRequestFormerRecipient> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAppRequestFormerRecipients(String nodeId, APIContext context) {
            super(context, nodeId, "/apprequestformerrecipients", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAppRequestFormerRecipients setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAppRequestFormerRecipients setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAppRequestFormerRecipients requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAppRequestFormerRecipients requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAppRequestFormerRecipients requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAppRequestFormerRecipients requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAppRequestFormerRecipients requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAppRequestFormerRecipients requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAppRequestFormerRecipients requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAppRequestFormerRecipients requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAppRequestFormerRecipients requestRecipientIdField() {
            return this.requestRecipientIdField(true);
        }

        public APIRequestGetAppRequestFormerRecipients requestRecipientIdField(boolean value) {
            this.requestField("recipient_id", value);
            return this;
        }
    }

    public static class APIRequestCreateApplication
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"business_app"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, User>(){

                public User apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateApplication(String nodeId, APIContext context) {
            super(context, nodeId, "/applications", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateApplication setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateApplication setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateApplication setBusinessApp(Long businessApp) {
            this.setParam("business_app", businessApp);
            return this;
        }

        public APIRequestCreateApplication setBusinessApp(String businessApp) {
            this.setParam("business_app", businessApp);
            return this;
        }

        public APIRequestCreateApplication requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateApplication requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateApplication requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateApplication requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateApplication requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateApplication requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetAlbums
    extends APIRequest<Album> {
        APINodeList<Album> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"backdated_time", "backdated_time_granularity", "can_backdate", "can_upload", "count", "cover_photo", "created_time", "description", "edit_link", "event", "from", "id", "is_user_facing", "link", "location", "modified_major", "name", "photo_count", "place", "privacy", "type", "updated_time", "video_count"};

        @Override
        public APINodeList<Album> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Album> parseResponse(String response, String header) throws APIException {
            return Album.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Album> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Album> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Album>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Album>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Album>>(){

                public APINodeList<Album> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAlbums(String nodeId, APIContext context) {
            super(context, nodeId, "/albums", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAlbums setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAlbums setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAlbums requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAlbums requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAlbums requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAlbums requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAlbums requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAlbums requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAlbums requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetAlbums requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetAlbums requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGetAlbums requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGetAlbums requestCanBackdateField() {
            return this.requestCanBackdateField(true);
        }

        public APIRequestGetAlbums requestCanBackdateField(boolean value) {
            this.requestField("can_backdate", value);
            return this;
        }

        public APIRequestGetAlbums requestCanUploadField() {
            return this.requestCanUploadField(true);
        }

        public APIRequestGetAlbums requestCanUploadField(boolean value) {
            this.requestField("can_upload", value);
            return this;
        }

        public APIRequestGetAlbums requestCountField() {
            return this.requestCountField(true);
        }

        public APIRequestGetAlbums requestCountField(boolean value) {
            this.requestField("count", value);
            return this;
        }

        public APIRequestGetAlbums requestCoverPhotoField() {
            return this.requestCoverPhotoField(true);
        }

        public APIRequestGetAlbums requestCoverPhotoField(boolean value) {
            this.requestField("cover_photo", value);
            return this;
        }

        public APIRequestGetAlbums requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAlbums requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAlbums requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAlbums requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAlbums requestEditLinkField() {
            return this.requestEditLinkField(true);
        }

        public APIRequestGetAlbums requestEditLinkField(boolean value) {
            this.requestField("edit_link", value);
            return this;
        }

        public APIRequestGetAlbums requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetAlbums requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetAlbums requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetAlbums requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetAlbums requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAlbums requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAlbums requestIsUserFacingField() {
            return this.requestIsUserFacingField(true);
        }

        public APIRequestGetAlbums requestIsUserFacingField(boolean value) {
            this.requestField("is_user_facing", value);
            return this;
        }

        public APIRequestGetAlbums requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetAlbums requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetAlbums requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetAlbums requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetAlbums requestModifiedMajorField() {
            return this.requestModifiedMajorField(true);
        }

        public APIRequestGetAlbums requestModifiedMajorField(boolean value) {
            this.requestField("modified_major", value);
            return this;
        }

        public APIRequestGetAlbums requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAlbums requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAlbums requestPhotoCountField() {
            return this.requestPhotoCountField(true);
        }

        public APIRequestGetAlbums requestPhotoCountField(boolean value) {
            this.requestField("photo_count", value);
            return this;
        }

        public APIRequestGetAlbums requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetAlbums requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetAlbums requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetAlbums requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetAlbums requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetAlbums requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetAlbums requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAlbums requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAlbums requestVideoCountField() {
            return this.requestVideoCountField(true);
        }

        public APIRequestGetAlbums requestVideoCountField(boolean value) {
            this.requestField("video_count", value);
            return this;
        }
    }

    public static class APIRequestGetAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "custom_audience_info", "default_dsa_beneficiary", "default_dsa_payor", "disable_reason", "end_advertiser", "end_advertiser_name", "existing_customers", "extended_credit_invoice_group", "failed_delivery_checks", "fb_entity", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "liable_address", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "owner_business", "partner", "rf_spec", "send_bill_to_address", "show_checkout_experience", "sold_to_address", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_tasks", "user_tos_accepted", "viewable_business"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCustomAudienceInfoField() {
            return this.requestCustomAudienceInfoField(true);
        }

        public APIRequestGetAdAccounts requestCustomAudienceInfoField(boolean value) {
            this.requestField("custom_audience_info", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDefaultDsaBeneficiaryField() {
            return this.requestDefaultDsaBeneficiaryField(true);
        }

        public APIRequestGetAdAccounts requestDefaultDsaBeneficiaryField(boolean value) {
            this.requestField("default_dsa_beneficiary", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDefaultDsaPayorField() {
            return this.requestDefaultDsaPayorField(true);
        }

        public APIRequestGetAdAccounts requestDefaultDsaPayorField(boolean value) {
            this.requestField("default_dsa_payor", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExistingCustomersField() {
            return this.requestExistingCustomersField(true);
        }

        public APIRequestGetAdAccounts requestExistingCustomersField(boolean value) {
            this.requestField("existing_customers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFbEntityField() {
            return this.requestFbEntityField(true);
        }

        public APIRequestGetAdAccounts requestFbEntityField(boolean value) {
            this.requestField("fb_entity", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLiableAddressField() {
            return this.requestLiableAddressField(true);
        }

        public APIRequestGetAdAccounts requestLiableAddressField(boolean value) {
            this.requestField("liable_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAdAccounts requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSendBillToAddressField() {
            return this.requestSendBillToAddressField(true);
        }

        public APIRequestGetAdAccounts requestSendBillToAddressField(boolean value) {
            this.requestField("send_bill_to_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSoldToAddressField() {
            return this.requestSoldToAddressField(true);
        }

        public APIRequestGetAdAccounts requestSoldToAddressField(boolean value) {
            this.requestField("sold_to_address", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTasksField() {
            return this.requestUserTasksField(true);
        }

        public APIRequestGetAdAccounts requestUserTasksField(boolean value) {
            this.requestField("user_tasks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestViewableBusinessField() {
            return this.requestViewableBusinessField(true);
        }

        public APIRequestGetAdAccounts requestViewableBusinessField(boolean value) {
            this.requestField("viewable_business", value);
            return this;
        }
    }

    public static class APIRequestCreateAdStudy
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[]{"cells", "client_business", "confidence_level", "cooldown_start_time", "description", "end_time", "name", "objectives", "observation_end_time", "start_time", "type", "viewers"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdStudy>(){

                public AdStudy apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdStudy(String nodeId, APIContext context) {
            super(context, nodeId, "/ad_studies", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdStudy setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdStudy setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdStudy setCells(List<Object> cells) {
            this.setParam("cells", cells);
            return this;
        }

        public APIRequestCreateAdStudy setCells(String cells) {
            this.setParam("cells", cells);
            return this;
        }

        public APIRequestCreateAdStudy setClientBusiness(String clientBusiness) {
            this.setParam("client_business", clientBusiness);
            return this;
        }

        public APIRequestCreateAdStudy setConfidenceLevel(Double confidenceLevel) {
            this.setParam("confidence_level", confidenceLevel);
            return this;
        }

        public APIRequestCreateAdStudy setConfidenceLevel(String confidenceLevel) {
            this.setParam("confidence_level", confidenceLevel);
            return this;
        }

        public APIRequestCreateAdStudy setCooldownStartTime(Long cooldownStartTime) {
            this.setParam("cooldown_start_time", cooldownStartTime);
            return this;
        }

        public APIRequestCreateAdStudy setCooldownStartTime(String cooldownStartTime) {
            this.setParam("cooldown_start_time", cooldownStartTime);
            return this;
        }

        public APIRequestCreateAdStudy setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateAdStudy setEndTime(Long endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateAdStudy setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateAdStudy setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAdStudy setObjectives(List<Object> objectives) {
            this.setParam("objectives", objectives);
            return this;
        }

        public APIRequestCreateAdStudy setObjectives(String objectives) {
            this.setParam("objectives", objectives);
            return this;
        }

        public APIRequestCreateAdStudy setObservationEndTime(Long observationEndTime) {
            this.setParam("observation_end_time", observationEndTime);
            return this;
        }

        public APIRequestCreateAdStudy setObservationEndTime(String observationEndTime) {
            this.setParam("observation_end_time", observationEndTime);
            return this;
        }

        public APIRequestCreateAdStudy setStartTime(Long startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateAdStudy setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateAdStudy setType(AdStudy.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreateAdStudy setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateAdStudy setViewers(List<Long> viewers) {
            this.setParam("viewers", viewers);
            return this;
        }

        public APIRequestCreateAdStudy setViewers(String viewers) {
            this.setParam("viewers", viewers);
            return this;
        }

        public APIRequestCreateAdStudy requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdStudy requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdStudy requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdStudy requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdStudy requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdStudy requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetAdStudies
    extends APIRequest<AdStudy> {
        APINodeList<AdStudy> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "canceled_time", "client_business", "cooldown_start_time", "created_by", "created_time", "description", "end_time", "id", "measurement_contact", "name", "observation_end_time", "results_first_available_date", "sales_contact", "start_time", "type", "updated_by", "updated_time"};

        @Override
        public APINodeList<AdStudy> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdStudy> parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdStudy> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdStudy> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdStudy>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdStudy>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdStudy>>(){

                public APINodeList<AdStudy> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdStudies(String nodeId, APIContext context) {
            super(context, nodeId, "/ad_studies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdStudies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdStudies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdStudies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdStudies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdStudies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdStudies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdStudies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdStudies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdStudies requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdStudies requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdStudies requestCanceledTimeField() {
            return this.requestCanceledTimeField(true);
        }

        public APIRequestGetAdStudies requestCanceledTimeField(boolean value) {
            this.requestField("canceled_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestClientBusinessField() {
            return this.requestClientBusinessField(true);
        }

        public APIRequestGetAdStudies requestClientBusinessField(boolean value) {
            this.requestField("client_business", value);
            return this;
        }

        public APIRequestGetAdStudies requestCooldownStartTimeField() {
            return this.requestCooldownStartTimeField(true);
        }

        public APIRequestGetAdStudies requestCooldownStartTimeField(boolean value) {
            this.requestField("cooldown_start_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetAdStudies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetAdStudies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdStudies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAdStudies requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAdStudies requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetAdStudies requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdStudies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdStudies requestMeasurementContactField() {
            return this.requestMeasurementContactField(true);
        }

        public APIRequestGetAdStudies requestMeasurementContactField(boolean value) {
            this.requestField("measurement_contact", value);
            return this;
        }

        public APIRequestGetAdStudies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdStudies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdStudies requestObservationEndTimeField() {
            return this.requestObservationEndTimeField(true);
        }

        public APIRequestGetAdStudies requestObservationEndTimeField(boolean value) {
            this.requestField("observation_end_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestResultsFirstAvailableDateField() {
            return this.requestResultsFirstAvailableDateField(true);
        }

        public APIRequestGetAdStudies requestResultsFirstAvailableDateField(boolean value) {
            this.requestField("results_first_available_date", value);
            return this;
        }

        public APIRequestGetAdStudies requestSalesContactField() {
            return this.requestSalesContactField(true);
        }

        public APIRequestGetAdStudies requestSalesContactField(boolean value) {
            this.requestField("sales_contact", value);
            return this;
        }

        public APIRequestGetAdStudies requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetAdStudies requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetAdStudies requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetAdStudies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetAdStudies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetAdStudies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAdStudies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    public static class APIRequestCreateAccount
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"about", "address", "category", "category_enum", "category_list", "city_id", "coordinates", "cover_photo", "description", "ignore_coordinate_warnings", "location", "name", "phone", "picture", "website", "zip"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/accounts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAccount setAbout(String about) {
            this.setParam("about", about);
            return this;
        }

        public APIRequestCreateAccount setAddress(String address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestCreateAccount setCategory(Long category) {
            this.setParam("category", category);
            return this;
        }

        public APIRequestCreateAccount setCategory(String category) {
            this.setParam("category", category);
            return this;
        }

        public APIRequestCreateAccount setCategoryEnum(String categoryEnum) {
            this.setParam("category_enum", categoryEnum);
            return this;
        }

        public APIRequestCreateAccount setCategoryList(List<String> categoryList) {
            this.setParam("category_list", categoryList);
            return this;
        }

        public APIRequestCreateAccount setCategoryList(String categoryList) {
            this.setParam("category_list", categoryList);
            return this;
        }

        public APIRequestCreateAccount setCityId(String cityId) {
            this.setParam("city_id", cityId);
            return this;
        }

        public APIRequestCreateAccount setCoordinates(Object coordinates) {
            this.setParam("coordinates", coordinates);
            return this;
        }

        public APIRequestCreateAccount setCoordinates(String coordinates) {
            this.setParam("coordinates", coordinates);
            return this;
        }

        public APIRequestCreateAccount setCoverPhoto(Object coverPhoto) {
            this.setParam("cover_photo", coverPhoto);
            return this;
        }

        public APIRequestCreateAccount setCoverPhoto(String coverPhoto) {
            this.setParam("cover_photo", coverPhoto);
            return this;
        }

        public APIRequestCreateAccount setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateAccount setIgnoreCoordinateWarnings(Boolean ignoreCoordinateWarnings) {
            this.setParam("ignore_coordinate_warnings", ignoreCoordinateWarnings);
            return this;
        }

        public APIRequestCreateAccount setIgnoreCoordinateWarnings(String ignoreCoordinateWarnings) {
            this.setParam("ignore_coordinate_warnings", ignoreCoordinateWarnings);
            return this;
        }

        public APIRequestCreateAccount setLocation(Object location) {
            this.setParam("location", location);
            return this;
        }

        public APIRequestCreateAccount setLocation(String location) {
            this.setParam("location", location);
            return this;
        }

        public APIRequestCreateAccount setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateAccount setPhone(String phone) {
            this.setParam("phone", phone);
            return this;
        }

        public APIRequestCreateAccount setPicture(String picture) {
            this.setParam("picture", picture);
            return this;
        }

        public APIRequestCreateAccount setWebsite(String website) {
            this.setParam("website", website);
            return this;
        }

        public APIRequestCreateAccount setZip(String zip) {
            this.setParam("zip", zip);
            return this;
        }

        public APIRequestCreateAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetAccounts
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"is_place", "is_promotable"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "connected_page_backed_instagram_account", "contact_address", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "delivery_and_pickup_option_info", "description", "description_html", "differently_open_offerings", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "followers_count", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_root_id", "has_added_app", "has_transitioned_to_new_page_experience", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messaging_feature_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mini_shop_storefront", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "owner_business", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "pickup_options", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "privacy_info_url", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_donate_button_in_live_video", "talking_about_count", "temporary_status", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response, String header) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Page>>(){

                public APINodeList<Page> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAccounts setIsPlace(Boolean isPlace) {
            this.setParam("is_place", isPlace);
            return this;
        }

        public APIRequestGetAccounts setIsPlace(String isPlace) {
            this.setParam("is_place", isPlace);
            return this;
        }

        public APIRequestGetAccounts setIsPromotable(Boolean isPromotable) {
            this.setParam("is_promotable", isPromotable);
            return this;
        }

        public APIRequestGetAccounts setIsPromotable(String isPromotable) {
            this.setParam("is_promotable", isPromotable);
            return this;
        }

        public APIRequestGetAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAccounts requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetAccounts requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetAccounts requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetAccounts requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetAccounts requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetAccounts requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetAccounts requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetAccounts requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetAccounts requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetAccounts requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetAccounts requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetAccounts requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetAccounts requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetAccounts requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetAccounts requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetAccounts requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetAccounts requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetAccounts requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetAccounts requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetAccounts requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetAccounts requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetAccounts requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetAccounts requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetAccounts requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetAccounts requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetAccounts requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetAccounts requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetAccounts requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetAccounts requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetAccounts requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAccounts requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetAccounts requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetAccounts requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetAccounts requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetAccounts requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetAccounts requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetAccounts requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetAccounts requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetAccounts requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetAccounts requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetAccounts requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetAccounts requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetAccounts requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetAccounts requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetAccounts requestConnectedPageBackedInstagramAccountField() {
            return this.requestConnectedPageBackedInstagramAccountField(true);
        }

        public APIRequestGetAccounts requestConnectedPageBackedInstagramAccountField(boolean value) {
            this.requestField("connected_page_backed_instagram_account", value);
            return this;
        }

        public APIRequestGetAccounts requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetAccounts requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetAccounts requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetAccounts requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetAccounts requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetAccounts requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetAccounts requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetAccounts requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetAccounts requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetAccounts requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetAccounts requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetAccounts requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetAccounts requestDeliveryAndPickupOptionInfoField() {
            return this.requestDeliveryAndPickupOptionInfoField(true);
        }

        public APIRequestGetAccounts requestDeliveryAndPickupOptionInfoField(boolean value) {
            this.requestField("delivery_and_pickup_option_info", value);
            return this;
        }

        public APIRequestGetAccounts requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAccounts requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAccounts requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetAccounts requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetAccounts requestDifferentlyOpenOfferingsField() {
            return this.requestDifferentlyOpenOfferingsField(true);
        }

        public APIRequestGetAccounts requestDifferentlyOpenOfferingsField(boolean value) {
            this.requestField("differently_open_offerings", value);
            return this;
        }

        public APIRequestGetAccounts requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetAccounts requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetAccounts requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetAccounts requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetAccounts requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetAccounts requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetAccounts requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetAccounts requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetAccounts requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetAccounts requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetAccounts requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetAccounts requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetAccounts requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetAccounts requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetAccounts requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetAccounts requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetAccounts requestFollowersCountField() {
            return this.requestFollowersCountField(true);
        }

        public APIRequestGetAccounts requestFollowersCountField(boolean value) {
            this.requestField("followers_count", value);
            return this;
        }

        public APIRequestGetAccounts requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetAccounts requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetAccounts requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetAccounts requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetAccounts requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetAccounts requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetAccounts requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetAccounts requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetAccounts requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetAccounts requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetAccounts requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetAccounts requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetAccounts requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetAccounts requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetAccounts requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetAccounts requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetAccounts requestHasTransitionedToNewPageExperienceField() {
            return this.requestHasTransitionedToNewPageExperienceField(true);
        }

        public APIRequestGetAccounts requestHasTransitionedToNewPageExperienceField(boolean value) {
            this.requestField("has_transitioned_to_new_page_experience", value);
            return this;
        }

        public APIRequestGetAccounts requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetAccounts requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetAccounts requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetAccounts requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetAccounts requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetAccounts requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetAccounts requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetAccounts requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAccounts requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetAccounts requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetAccounts requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetAccounts requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetAccounts requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetAccounts requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetAccounts requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetAccounts requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetAccounts requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetAccounts requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetAccounts requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetAccounts requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetAccounts requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetAccounts requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetAccounts requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetAccounts requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetAccounts requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetAccounts requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetAccounts requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetAccounts requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetAccounts requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetAccounts requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetAccounts requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetAccounts requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetAccounts requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetAccounts requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetAccounts requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetAccounts requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetAccounts requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetAccounts requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetAccounts requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetAccounts requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetAccounts requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetAccounts requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetAccounts requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetAccounts requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetAccounts requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetAccounts requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetAccounts requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetAccounts requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetAccounts requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetAccounts requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetAccounts requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetAccounts requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetAccounts requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetAccounts requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetAccounts requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetAccounts requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetAccounts requestMessagingFeatureStatusField() {
            return this.requestMessagingFeatureStatusField(true);
        }

        public APIRequestGetAccounts requestMessagingFeatureStatusField(boolean value) {
            this.requestField("messaging_feature_status", value);
            return this;
        }

        public APIRequestGetAccounts requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetAccounts requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetAccounts requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetAccounts requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetAccounts requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetAccounts requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetAccounts requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetAccounts requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetAccounts requestMiniShopStorefrontField() {
            return this.requestMiniShopStorefrontField(true);
        }

        public APIRequestGetAccounts requestMiniShopStorefrontField(boolean value) {
            this.requestField("mini_shop_storefront", value);
            return this;
        }

        public APIRequestGetAccounts requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetAccounts requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetAccounts requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetAccounts requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAccounts requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetAccounts requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetAccounts requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetAccounts requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetAccounts requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetAccounts requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetAccounts requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetAccounts requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetAccounts requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetAccounts requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetAccounts requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAccounts requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetAccounts requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetAccounts requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetAccounts requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetAccounts requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetAccounts requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetAccounts requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetAccounts requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetAccounts requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetAccounts requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetAccounts requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetAccounts requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetAccounts requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetAccounts requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetAccounts requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetAccounts requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetAccounts requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetAccounts requestPickupOptionsField() {
            return this.requestPickupOptionsField(true);
        }

        public APIRequestGetAccounts requestPickupOptionsField(boolean value) {
            this.requestField("pickup_options", value);
            return this;
        }

        public APIRequestGetAccounts requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetAccounts requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetAccounts requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetAccounts requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetAccounts requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetAccounts requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetAccounts requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetAccounts requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetAccounts requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetAccounts requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetAccounts requestPrivacyInfoUrlField() {
            return this.requestPrivacyInfoUrlField(true);
        }

        public APIRequestGetAccounts requestPrivacyInfoUrlField(boolean value) {
            this.requestField("privacy_info_url", value);
            return this;
        }

        public APIRequestGetAccounts requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetAccounts requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetAccounts requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetAccounts requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetAccounts requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetAccounts requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetAccounts requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetAccounts requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetAccounts requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetAccounts requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetAccounts requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetAccounts requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetAccounts requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetAccounts requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetAccounts requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetAccounts requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetAccounts requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetAccounts requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetAccounts requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetAccounts requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetAccounts requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetAccounts requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetAccounts requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetAccounts requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetAccounts requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetAccounts requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetAccounts requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetAccounts requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetAccounts requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetAccounts requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetAccounts requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetAccounts requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetAccounts requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetAccounts requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetAccounts requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetAccounts requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetAccounts requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetAccounts requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetAccounts requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetAccounts requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetAccounts requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetAccounts requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetAccounts requestSupportsDonateButtonInLiveVideoField() {
            return this.requestSupportsDonateButtonInLiveVideoField(true);
        }

        public APIRequestGetAccounts requestSupportsDonateButtonInLiveVideoField(boolean value) {
            this.requestField("supports_donate_button_in_live_video", value);
            return this;
        }

        public APIRequestGetAccounts requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetAccounts requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetAccounts requestTemporaryStatusField() {
            return this.requestTemporaryStatusField(true);
        }

        public APIRequestGetAccounts requestTemporaryStatusField(boolean value) {
            this.requestField("temporary_status", value);
            return this;
        }

        public APIRequestGetAccounts requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetAccounts requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetAccounts requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetAccounts requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetAccounts requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetAccounts requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetAccounts requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetAccounts requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetAccounts requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetAccounts requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetAccounts requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetAccounts requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetAccounts requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetAccounts requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetAccounts requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetAccounts requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetAccounts requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetAccounts requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetAccounts requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetAccounts requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    public static class APIRequestCreateAccessToken
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"business_app", "page_id", "scope", "set_token_expires_in_60_days"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, User>(){

                public User apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAccessToken(String nodeId, APIContext context) {
            super(context, nodeId, "/access_tokens", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAccessToken setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAccessToken setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAccessToken setBusinessApp(Long businessApp) {
            this.setParam("business_app", businessApp);
            return this;
        }

        public APIRequestCreateAccessToken setBusinessApp(String businessApp) {
            this.setParam("business_app", businessApp);
            return this;
        }

        public APIRequestCreateAccessToken setPageId(String pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestCreateAccessToken setScope(List<Permission> scope) {
            this.setParam("scope", scope);
            return this;
        }

        public APIRequestCreateAccessToken setScope(String scope) {
            this.setParam("scope", scope);
            return this;
        }

        public APIRequestCreateAccessToken setSetTokenExpiresIn60Days(Boolean setTokenExpiresIn60Days) {
            this.setParam("set_token_expires_in_60_days", setTokenExpiresIn60Days);
            return this;
        }

        public APIRequestCreateAccessToken setSetTokenExpiresIn60Days(String setTokenExpiresIn60Days) {
            this.setParam("set_token_expires_in_60_days", setTokenExpiresIn60Days);
            return this;
        }

        public APIRequestCreateAccessToken requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAccessToken requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAccessToken requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAccessToken requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAccessToken requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAccessToken requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestDeleteAccessTokens
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAccessTokens(String nodeId, APIContext context) {
            super(context, nodeId, "/access_tokens", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAccessTokens setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAccessTokens setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAccessTokens requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAccessTokens requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAccessTokens requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAccessTokens requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAccessTokens requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAccessTokens requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

