/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class DACheck
extends APINode {
    @SerializedName(value="action_uri")
    private String mActionUri = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="result")
    private String mResult = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="user_message")
    private String mUserMessage = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static DACheck loadJSON(String json, APIContext context, String header) {
        DACheck daCheck = (DACheck)DACheck.getGson().fromJson(json, DACheck.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(daCheck.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        daCheck.context = context;
        daCheck.rawValue = json;
        daCheck.header = header;
        return daCheck;
    }

    public static APINodeList<DACheck> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<DACheck> daChecks = new APINodeList<DACheck>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        daChecks.add(DACheck.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return daChecks;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            daChecks.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        daChecks.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            daChecks.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            daChecks.add(DACheck.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                daChecks.add(DACheck.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            daChecks.add(DACheck.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return daChecks;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        daChecks.add(DACheck.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return daChecks;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        daChecks.add(DACheck.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return daChecks;
                }
                daChecks.clear();
                daChecks.add(DACheck.loadJSON(json, context, header));
                return daChecks;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DACheck.getGson().toJson((Object)this);
    }

    public String getFieldActionUri() {
        return this.mActionUri;
    }

    public DACheck setFieldActionUri(String value) {
        this.mActionUri = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public DACheck setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public DACheck setFieldKey(String value) {
        this.mKey = value;
        return this;
    }

    public String getFieldResult() {
        return this.mResult;
    }

    public DACheck setFieldResult(String value) {
        this.mResult = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public DACheck setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public String getFieldUserMessage() {
        return this.mUserMessage;
    }

    public DACheck setFieldUserMessage(String value) {
        this.mUserMessage = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DACheck copyFrom(DACheck instance) {
        this.mActionUri = instance.mActionUri;
        this.mDescription = instance.mDescription;
        this.mKey = instance.mKey;
        this.mResult = instance.mResult;
        this.mTitle = instance.mTitle;
        this.mUserMessage = instance.mUserMessage;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DACheck> getParser() {
        return new APIRequest.ResponseParser<DACheck>(){

            @Override
            public APINodeList<DACheck> parseResponse(String response, APIContext context, APIRequest<DACheck> request, String header) throws APIException.MalformedResponseException {
                return DACheck.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumConnectionMethod {
        VALUE_ALL("ALL"),
        VALUE_APP("APP"),
        VALUE_BROWSER("BROWSER"),
        VALUE_SERVER("SERVER");

        private String value;

        private EnumConnectionMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

