/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.Photo;
import com.facebook.ads.sdk.Post;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobOpening
extends APINode {
    @SerializedName(value="address")
    private String mAddress = null;
    @SerializedName(value="application_callback_url")
    private String mApplicationCallbackUrl = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="errors")
    private List<String> mErrors = null;
    @SerializedName(value="external_company_facebook_url")
    private String mExternalCompanyFacebookUrl = null;
    @SerializedName(value="external_company_full_address")
    private String mExternalCompanyFullAddress = null;
    @SerializedName(value="external_company_id")
    private String mExternalCompanyId = null;
    @SerializedName(value="external_company_name")
    private String mExternalCompanyName = null;
    @SerializedName(value="external_id")
    private String mExternalId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="job_status")
    private EnumJobStatus mJobStatus = null;
    @SerializedName(value="latitude")
    private Double mLatitude = null;
    @SerializedName(value="longitude")
    private Double mLongitude = null;
    @SerializedName(value="offsite_application_url")
    private String mOffsiteApplicationUrl = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="photo")
    private Photo mPhoto = null;
    @SerializedName(value="platform_review_status")
    private EnumPlatformReviewStatus mPlatformReviewStatus = null;
    @SerializedName(value="post")
    private Post mPost = null;
    @SerializedName(value="remote_type")
    private String mRemoteType = null;
    @SerializedName(value="review_rejection_reasons")
    private List<EnumReviewRejectionReasons> mReviewRejectionReasons = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="type")
    private EnumType mType = null;
    protected static Gson gson = null;

    JobOpening() {
    }

    public JobOpening(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public JobOpening(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public JobOpening fetch() throws APIException {
        JobOpening newInstance = JobOpening.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static JobOpening fetchById(Long id, APIContext context) throws APIException {
        return JobOpening.fetchById(id.toString(), context);
    }

    public static ListenableFuture<JobOpening> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return JobOpening.fetchByIdAsync(id.toString(), context);
    }

    public static JobOpening fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<JobOpening> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<JobOpening> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<JobOpening>(context, "", "/", "GET", JobOpening.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<JobOpening>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<JobOpening>(context, "", "/", "GET", JobOpening.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static JobOpening loadJSON(String json, APIContext context, String header) {
        JobOpening jobOpening = (JobOpening)JobOpening.getGson().fromJson(json, JobOpening.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(jobOpening.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        jobOpening.context = context;
        jobOpening.rawValue = json;
        jobOpening.header = header;
        return jobOpening;
    }

    public static APINodeList<JobOpening> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<JobOpening> jobOpenings = new APINodeList<JobOpening>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        jobOpenings.add(JobOpening.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return jobOpenings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            jobOpenings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        jobOpenings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            jobOpenings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            jobOpenings.add(JobOpening.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                jobOpenings.add(JobOpening.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            jobOpenings.add(JobOpening.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return jobOpenings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        jobOpenings.add(JobOpening.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return jobOpenings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        jobOpenings.add(JobOpening.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return jobOpenings;
                }
                jobOpenings.clear();
                jobOpenings.add(JobOpening.loadJSON(json, context, header));
                return jobOpenings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return JobOpening.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAddress() {
        return this.mAddress;
    }

    public String getFieldApplicationCallbackUrl() {
        return this.mApplicationCallbackUrl;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public List<String> getFieldErrors() {
        return this.mErrors;
    }

    public String getFieldExternalCompanyFacebookUrl() {
        return this.mExternalCompanyFacebookUrl;
    }

    public String getFieldExternalCompanyFullAddress() {
        return this.mExternalCompanyFullAddress;
    }

    public String getFieldExternalCompanyId() {
        return this.mExternalCompanyId;
    }

    public String getFieldExternalCompanyName() {
        return this.mExternalCompanyName;
    }

    public String getFieldExternalId() {
        return this.mExternalId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumJobStatus getFieldJobStatus() {
        return this.mJobStatus;
    }

    public Double getFieldLatitude() {
        return this.mLatitude;
    }

    public Double getFieldLongitude() {
        return this.mLongitude;
    }

    public String getFieldOffsiteApplicationUrl() {
        return this.mOffsiteApplicationUrl;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public Photo getFieldPhoto() {
        if (this.mPhoto != null) {
            this.mPhoto.context = this.getContext();
        }
        return this.mPhoto;
    }

    public EnumPlatformReviewStatus getFieldPlatformReviewStatus() {
        return this.mPlatformReviewStatus;
    }

    public Post getFieldPost() {
        if (this.mPost != null) {
            this.mPost.context = this.getContext();
        }
        return this.mPost;
    }

    public String getFieldRemoteType() {
        return this.mRemoteType;
    }

    public List<EnumReviewRejectionReasons> getFieldReviewRejectionReasons() {
        return this.mReviewRejectionReasons;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public EnumType getFieldType() {
        return this.mType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public JobOpening copyFrom(JobOpening instance) {
        this.mAddress = instance.mAddress;
        this.mApplicationCallbackUrl = instance.mApplicationCallbackUrl;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mErrors = instance.mErrors;
        this.mExternalCompanyFacebookUrl = instance.mExternalCompanyFacebookUrl;
        this.mExternalCompanyFullAddress = instance.mExternalCompanyFullAddress;
        this.mExternalCompanyId = instance.mExternalCompanyId;
        this.mExternalCompanyName = instance.mExternalCompanyName;
        this.mExternalId = instance.mExternalId;
        this.mId = instance.mId;
        this.mJobStatus = instance.mJobStatus;
        this.mLatitude = instance.mLatitude;
        this.mLongitude = instance.mLongitude;
        this.mOffsiteApplicationUrl = instance.mOffsiteApplicationUrl;
        this.mPage = instance.mPage;
        this.mPhoto = instance.mPhoto;
        this.mPlatformReviewStatus = instance.mPlatformReviewStatus;
        this.mPost = instance.mPost;
        this.mRemoteType = instance.mRemoteType;
        this.mReviewRejectionReasons = instance.mReviewRejectionReasons;
        this.mTitle = instance.mTitle;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<JobOpening> getParser() {
        return new APIRequest.ResponseParser<JobOpening>(){

            @Override
            public APINodeList<JobOpening> parseResponse(String response, APIContext context, APIRequest<JobOpening> request, String header) throws APIException.MalformedResponseException {
                return JobOpening.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumType {
        VALUE_CONTRACT("CONTRACT"),
        VALUE_FULL_TIME("FULL_TIME"),
        VALUE_INTERNSHIP("INTERNSHIP"),
        VALUE_PART_TIME("PART_TIME"),
        VALUE_VOLUNTEER("VOLUNTEER");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumReviewRejectionReasons {
        VALUE_ADULT_CONTENT("ADULT_CONTENT"),
        VALUE_DISCRIMINATION("DISCRIMINATION"),
        VALUE_DRUGS("DRUGS"),
        VALUE_GENERIC_DEFAULT("GENERIC_DEFAULT"),
        VALUE_ILLEGAL("ILLEGAL"),
        VALUE_IMPERSONATION("IMPERSONATION"),
        VALUE_MISLEADING("MISLEADING"),
        VALUE_MULTILEVEL_MARKETING("MULTILEVEL_MARKETING"),
        VALUE_PERSONAL_INFO("PERSONAL_INFO"),
        VALUE_SEXUAL("SEXUAL");

        private String value;

        private EnumReviewRejectionReasons(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumPlatformReviewStatus {
        VALUE_APPROVED("APPROVED"),
        VALUE_PENDING("PENDING"),
        VALUE_REJECTED("REJECTED");

        private String value;

        private EnumPlatformReviewStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumJobStatus {
        VALUE_CLOSED("CLOSED"),
        VALUE_DRAFT("DRAFT"),
        VALUE_OPEN("OPEN"),
        VALUE_PROVISIONAL("PROVISIONAL");

        private String value;

        private EnumJobStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<JobOpening> {
        JobOpening lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"address", "application_callback_url", "created_time", "description", "errors", "external_company_facebook_url", "external_company_full_address", "external_company_id", "external_company_name", "external_id", "id", "job_status", "latitude", "longitude", "offsite_application_url", "page", "photo", "platform_review_status", "post", "remote_type", "review_rejection_reasons", "title", "type"};

        @Override
        public JobOpening getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public JobOpening parseResponse(String response, String header) throws APIException {
            return JobOpening.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public JobOpening execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public JobOpening execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<JobOpening> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<JobOpening> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, JobOpening>(){

                public JobOpening apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGet requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGet requestApplicationCallbackUrlField() {
            return this.requestApplicationCallbackUrlField(true);
        }

        public APIRequestGet requestApplicationCallbackUrlField(boolean value) {
            this.requestField("application_callback_url", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestErrorsField() {
            return this.requestErrorsField(true);
        }

        public APIRequestGet requestErrorsField(boolean value) {
            this.requestField("errors", value);
            return this;
        }

        public APIRequestGet requestExternalCompanyFacebookUrlField() {
            return this.requestExternalCompanyFacebookUrlField(true);
        }

        public APIRequestGet requestExternalCompanyFacebookUrlField(boolean value) {
            this.requestField("external_company_facebook_url", value);
            return this;
        }

        public APIRequestGet requestExternalCompanyFullAddressField() {
            return this.requestExternalCompanyFullAddressField(true);
        }

        public APIRequestGet requestExternalCompanyFullAddressField(boolean value) {
            this.requestField("external_company_full_address", value);
            return this;
        }

        public APIRequestGet requestExternalCompanyIdField() {
            return this.requestExternalCompanyIdField(true);
        }

        public APIRequestGet requestExternalCompanyIdField(boolean value) {
            this.requestField("external_company_id", value);
            return this;
        }

        public APIRequestGet requestExternalCompanyNameField() {
            return this.requestExternalCompanyNameField(true);
        }

        public APIRequestGet requestExternalCompanyNameField(boolean value) {
            this.requestField("external_company_name", value);
            return this;
        }

        public APIRequestGet requestExternalIdField() {
            return this.requestExternalIdField(true);
        }

        public APIRequestGet requestExternalIdField(boolean value) {
            this.requestField("external_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestJobStatusField() {
            return this.requestJobStatusField(true);
        }

        public APIRequestGet requestJobStatusField(boolean value) {
            this.requestField("job_status", value);
            return this;
        }

        public APIRequestGet requestLatitudeField() {
            return this.requestLatitudeField(true);
        }

        public APIRequestGet requestLatitudeField(boolean value) {
            this.requestField("latitude", value);
            return this;
        }

        public APIRequestGet requestLongitudeField() {
            return this.requestLongitudeField(true);
        }

        public APIRequestGet requestLongitudeField(boolean value) {
            this.requestField("longitude", value);
            return this;
        }

        public APIRequestGet requestOffsiteApplicationUrlField() {
            return this.requestOffsiteApplicationUrlField(true);
        }

        public APIRequestGet requestOffsiteApplicationUrlField(boolean value) {
            this.requestField("offsite_application_url", value);
            return this;
        }

        public APIRequestGet requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGet requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGet requestPhotoField() {
            return this.requestPhotoField(true);
        }

        public APIRequestGet requestPhotoField(boolean value) {
            this.requestField("photo", value);
            return this;
        }

        public APIRequestGet requestPlatformReviewStatusField() {
            return this.requestPlatformReviewStatusField(true);
        }

        public APIRequestGet requestPlatformReviewStatusField(boolean value) {
            this.requestField("platform_review_status", value);
            return this;
        }

        public APIRequestGet requestPostField() {
            return this.requestPostField(true);
        }

        public APIRequestGet requestPostField(boolean value) {
            this.requestField("post", value);
            return this;
        }

        public APIRequestGet requestRemoteTypeField() {
            return this.requestRemoteTypeField(true);
        }

        public APIRequestGet requestRemoteTypeField(boolean value) {
            this.requestField("remote_type", value);
            return this;
        }

        public APIRequestGet requestReviewRejectionReasonsField() {
            return this.requestReviewRejectionReasonsField(true);
        }

        public APIRequestGet requestReviewRejectionReasonsField(boolean value) {
            this.requestField("review_rejection_reasons", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }
}

