/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CPASMerchantConfig
extends APINode {
    @SerializedName(value="accepted_tos")
    private Boolean mAcceptedTos = null;
    @SerializedName(value="beta_features")
    private List<String> mBetaFeatures = null;
    @SerializedName(value="business_outcomes_status")
    private List<Map<String, String>> mBusinessOutcomesStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_test_merchant")
    private Boolean mIsTestMerchant = null;
    @SerializedName(value="outcomes_compliance_status")
    private List<Map<String, Object>> mOutcomesComplianceStatus = null;
    @SerializedName(value="qualified_to_onboard")
    private Boolean mQualifiedToOnboard = null;
    protected static Gson gson = null;

    CPASMerchantConfig() {
    }

    public CPASMerchantConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CPASMerchantConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CPASMerchantConfig fetch() throws APIException {
        CPASMerchantConfig newInstance = CPASMerchantConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CPASMerchantConfig fetchById(Long id, APIContext context) throws APIException {
        return CPASMerchantConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CPASMerchantConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CPASMerchantConfig.fetchByIdAsync(id.toString(), context);
    }

    public static CPASMerchantConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CPASMerchantConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CPASMerchantConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CPASMerchantConfig>(context, "", "/", "GET", CPASMerchantConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CPASMerchantConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CPASMerchantConfig>(context, "", "/", "GET", CPASMerchantConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CPASMerchantConfig loadJSON(String json, APIContext context, String header) {
        CPASMerchantConfig cpasMerchantConfig = (CPASMerchantConfig)CPASMerchantConfig.getGson().fromJson(json, CPASMerchantConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(cpasMerchantConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        cpasMerchantConfig.context = context;
        cpasMerchantConfig.rawValue = json;
        cpasMerchantConfig.header = header;
        return cpasMerchantConfig;
    }

    public static APINodeList<CPASMerchantConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CPASMerchantConfig> cpasMerchantConfigs = new APINodeList<CPASMerchantConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        cpasMerchantConfigs.add(CPASMerchantConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return cpasMerchantConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            cpasMerchantConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        cpasMerchantConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            cpasMerchantConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            cpasMerchantConfigs.add(CPASMerchantConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                cpasMerchantConfigs.add(CPASMerchantConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            cpasMerchantConfigs.add(CPASMerchantConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return cpasMerchantConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        cpasMerchantConfigs.add(CPASMerchantConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return cpasMerchantConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        cpasMerchantConfigs.add(CPASMerchantConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return cpasMerchantConfigs;
                }
                cpasMerchantConfigs.clear();
                cpasMerchantConfigs.add(CPASMerchantConfig.loadJSON(json, context, header));
                return cpasMerchantConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CPASMerchantConfig.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldAcceptedTos() {
        return this.mAcceptedTos;
    }

    public List<String> getFieldBetaFeatures() {
        return this.mBetaFeatures;
    }

    public List<Map<String, String>> getFieldBusinessOutcomesStatus() {
        return this.mBusinessOutcomesStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsTestMerchant() {
        return this.mIsTestMerchant;
    }

    public List<Map<String, Object>> getFieldOutcomesComplianceStatus() {
        return this.mOutcomesComplianceStatus;
    }

    public Boolean getFieldQualifiedToOnboard() {
        return this.mQualifiedToOnboard;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CPASMerchantConfig copyFrom(CPASMerchantConfig instance) {
        this.mAcceptedTos = instance.mAcceptedTos;
        this.mBetaFeatures = instance.mBetaFeatures;
        this.mBusinessOutcomesStatus = instance.mBusinessOutcomesStatus;
        this.mId = instance.mId;
        this.mIsTestMerchant = instance.mIsTestMerchant;
        this.mOutcomesComplianceStatus = instance.mOutcomesComplianceStatus;
        this.mQualifiedToOnboard = instance.mQualifiedToOnboard;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CPASMerchantConfig> getParser() {
        return new APIRequest.ResponseParser<CPASMerchantConfig>(){

            @Override
            public APINodeList<CPASMerchantConfig> parseResponse(String response, APIContext context, APIRequest<CPASMerchantConfig> request, String header) throws APIException.MalformedResponseException {
                return CPASMerchantConfig.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CPASMerchantConfig> {
        CPASMerchantConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"accepted_tos", "beta_features", "business_outcomes_status", "id", "is_test_merchant", "outcomes_compliance_status", "qualified_to_onboard"};

        @Override
        public CPASMerchantConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CPASMerchantConfig parseResponse(String response, String header) throws APIException {
            return CPASMerchantConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CPASMerchantConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CPASMerchantConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CPASMerchantConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CPASMerchantConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CPASMerchantConfig>(){

                public CPASMerchantConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAcceptedTosField() {
            return this.requestAcceptedTosField(true);
        }

        public APIRequestGet requestAcceptedTosField(boolean value) {
            this.requestField("accepted_tos", value);
            return this;
        }

        public APIRequestGet requestBetaFeaturesField() {
            return this.requestBetaFeaturesField(true);
        }

        public APIRequestGet requestBetaFeaturesField(boolean value) {
            this.requestField("beta_features", value);
            return this;
        }

        public APIRequestGet requestBusinessOutcomesStatusField() {
            return this.requestBusinessOutcomesStatusField(true);
        }

        public APIRequestGet requestBusinessOutcomesStatusField(boolean value) {
            this.requestField("business_outcomes_status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsTestMerchantField() {
            return this.requestIsTestMerchantField(true);
        }

        public APIRequestGet requestIsTestMerchantField(boolean value) {
            this.requestField("is_test_merchant", value);
            return this;
        }

        public APIRequestGet requestOutcomesComplianceStatusField() {
            return this.requestOutcomesComplianceStatusField(true);
        }

        public APIRequestGet requestOutcomesComplianceStatusField(boolean value) {
            this.requestField("outcomes_compliance_status", value);
            return this;
        }

        public APIRequestGet requestQualifiedToOnboardField() {
            return this.requestQualifiedToOnboardField(true);
        }

        public APIRequestGet requestQualifiedToOnboardField(boolean value) {
            this.requestField("qualified_to_onboard", value);
            return this;
        }
    }
}

