/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BrandRequest
extends APINode {
    @SerializedName(value="ad_countries")
    private List<String> mAdCountries = null;
    @SerializedName(value="additional_contacts")
    private List<String> mAdditionalContacts = null;
    @SerializedName(value="approval_level")
    private Long mApprovalLevel = null;
    @SerializedName(value="cells")
    private List<Object> mCells = null;
    @SerializedName(value="countries")
    private List<String> mCountries = null;
    @SerializedName(value="deny_reason")
    private String mDenyReason = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="estimated_reach")
    private Long mEstimatedReach = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_multicell")
    private Boolean mIsMulticell = null;
    @SerializedName(value="locale")
    private String mLocale = null;
    @SerializedName(value="max_age")
    private Long mMaxAge = null;
    @SerializedName(value="min_age")
    private Long mMinAge = null;
    @SerializedName(value="questions")
    private List<Object> mQuestions = null;
    @SerializedName(value="region")
    private String mRegion = null;
    @SerializedName(value="request_status")
    private String mRequestStatus = null;
    @SerializedName(value="review_date")
    private String mReviewDate = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="submit_date")
    private String mSubmitDate = null;
    @SerializedName(value="total_budget")
    private Long mTotalBudget = null;
    protected static Gson gson = null;

    BrandRequest() {
    }

    public BrandRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BrandRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BrandRequest fetch() throws APIException {
        BrandRequest newInstance = BrandRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BrandRequest fetchById(Long id, APIContext context) throws APIException {
        return BrandRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BrandRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BrandRequest.fetchByIdAsync(id.toString(), context);
    }

    public static BrandRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BrandRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BrandRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BrandRequest>(context, "", "/", "GET", BrandRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BrandRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BrandRequest>(context, "", "/", "GET", BrandRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BrandRequest loadJSON(String json, APIContext context, String header) {
        BrandRequest brandRequest = (BrandRequest)BrandRequest.getGson().fromJson(json, BrandRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(brandRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        brandRequest.context = context;
        brandRequest.rawValue = json;
        brandRequest.header = header;
        return brandRequest;
    }

    public static APINodeList<BrandRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BrandRequest> brandRequests = new APINodeList<BrandRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        brandRequests.add(BrandRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return brandRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            brandRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        brandRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            brandRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            brandRequests.add(BrandRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                brandRequests.add(BrandRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            brandRequests.add(BrandRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return brandRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        brandRequests.add(BrandRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return brandRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        brandRequests.add(BrandRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return brandRequests;
                }
                brandRequests.clear();
                brandRequests.add(BrandRequest.loadJSON(json, context, header));
                return brandRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BrandRequest.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAdCountries() {
        return this.mAdCountries;
    }

    public List<String> getFieldAdditionalContacts() {
        return this.mAdditionalContacts;
    }

    public Long getFieldApprovalLevel() {
        return this.mApprovalLevel;
    }

    public List<Object> getFieldCells() {
        return this.mCells;
    }

    public List<String> getFieldCountries() {
        return this.mCountries;
    }

    public String getFieldDenyReason() {
        return this.mDenyReason;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public Long getFieldEstimatedReach() {
        return this.mEstimatedReach;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsMulticell() {
        return this.mIsMulticell;
    }

    public String getFieldLocale() {
        return this.mLocale;
    }

    public Long getFieldMaxAge() {
        return this.mMaxAge;
    }

    public Long getFieldMinAge() {
        return this.mMinAge;
    }

    public List<Object> getFieldQuestions() {
        return this.mQuestions;
    }

    public String getFieldRegion() {
        return this.mRegion;
    }

    public String getFieldRequestStatus() {
        return this.mRequestStatus;
    }

    public String getFieldReviewDate() {
        return this.mReviewDate;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldSubmitDate() {
        return this.mSubmitDate;
    }

    public Long getFieldTotalBudget() {
        return this.mTotalBudget;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BrandRequest copyFrom(BrandRequest instance) {
        this.mAdCountries = instance.mAdCountries;
        this.mAdditionalContacts = instance.mAdditionalContacts;
        this.mApprovalLevel = instance.mApprovalLevel;
        this.mCells = instance.mCells;
        this.mCountries = instance.mCountries;
        this.mDenyReason = instance.mDenyReason;
        this.mEndTime = instance.mEndTime;
        this.mEstimatedReach = instance.mEstimatedReach;
        this.mId = instance.mId;
        this.mIsMulticell = instance.mIsMulticell;
        this.mLocale = instance.mLocale;
        this.mMaxAge = instance.mMaxAge;
        this.mMinAge = instance.mMinAge;
        this.mQuestions = instance.mQuestions;
        this.mRegion = instance.mRegion;
        this.mRequestStatus = instance.mRequestStatus;
        this.mReviewDate = instance.mReviewDate;
        this.mStartTime = instance.mStartTime;
        this.mStatus = instance.mStatus;
        this.mSubmitDate = instance.mSubmitDate;
        this.mTotalBudget = instance.mTotalBudget;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BrandRequest> getParser() {
        return new APIRequest.ResponseParser<BrandRequest>(){

            @Override
            public APINodeList<BrandRequest> parseResponse(String response, APIContext context, APIRequest<BrandRequest> request, String header) throws APIException.MalformedResponseException {
                return BrandRequest.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<BrandRequest> {
        BrandRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_countries", "additional_contacts", "approval_level", "cells", "countries", "deny_reason", "end_time", "estimated_reach", "id", "is_multicell", "locale", "max_age", "min_age", "questions", "region", "request_status", "review_date", "start_time", "status", "submit_date", "total_budget"};

        @Override
        public BrandRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BrandRequest parseResponse(String response, String header) throws APIException {
            return BrandRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BrandRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BrandRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BrandRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BrandRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BrandRequest>(){

                public BrandRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdCountriesField() {
            return this.requestAdCountriesField(true);
        }

        public APIRequestGet requestAdCountriesField(boolean value) {
            this.requestField("ad_countries", value);
            return this;
        }

        public APIRequestGet requestAdditionalContactsField() {
            return this.requestAdditionalContactsField(true);
        }

        public APIRequestGet requestAdditionalContactsField(boolean value) {
            this.requestField("additional_contacts", value);
            return this;
        }

        public APIRequestGet requestApprovalLevelField() {
            return this.requestApprovalLevelField(true);
        }

        public APIRequestGet requestApprovalLevelField(boolean value) {
            this.requestField("approval_level", value);
            return this;
        }

        public APIRequestGet requestCellsField() {
            return this.requestCellsField(true);
        }

        public APIRequestGet requestCellsField(boolean value) {
            this.requestField("cells", value);
            return this;
        }

        public APIRequestGet requestCountriesField() {
            return this.requestCountriesField(true);
        }

        public APIRequestGet requestCountriesField(boolean value) {
            this.requestField("countries", value);
            return this;
        }

        public APIRequestGet requestDenyReasonField() {
            return this.requestDenyReasonField(true);
        }

        public APIRequestGet requestDenyReasonField(boolean value) {
            this.requestField("deny_reason", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestEstimatedReachField() {
            return this.requestEstimatedReachField(true);
        }

        public APIRequestGet requestEstimatedReachField(boolean value) {
            this.requestField("estimated_reach", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsMulticellField() {
            return this.requestIsMulticellField(true);
        }

        public APIRequestGet requestIsMulticellField(boolean value) {
            this.requestField("is_multicell", value);
            return this;
        }

        public APIRequestGet requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGet requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGet requestMaxAgeField() {
            return this.requestMaxAgeField(true);
        }

        public APIRequestGet requestMaxAgeField(boolean value) {
            this.requestField("max_age", value);
            return this;
        }

        public APIRequestGet requestMinAgeField() {
            return this.requestMinAgeField(true);
        }

        public APIRequestGet requestMinAgeField(boolean value) {
            this.requestField("min_age", value);
            return this;
        }

        public APIRequestGet requestQuestionsField() {
            return this.requestQuestionsField(true);
        }

        public APIRequestGet requestQuestionsField(boolean value) {
            this.requestField("questions", value);
            return this;
        }

        public APIRequestGet requestRegionField() {
            return this.requestRegionField(true);
        }

        public APIRequestGet requestRegionField(boolean value) {
            this.requestField("region", value);
            return this;
        }

        public APIRequestGet requestRequestStatusField() {
            return this.requestRequestStatusField(true);
        }

        public APIRequestGet requestRequestStatusField(boolean value) {
            this.requestField("request_status", value);
            return this;
        }

        public APIRequestGet requestReviewDateField() {
            return this.requestReviewDateField(true);
        }

        public APIRequestGet requestReviewDateField(boolean value) {
            this.requestField("review_date", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestSubmitDateField() {
            return this.requestSubmitDateField(true);
        }

        public APIRequestGet requestSubmitDateField(boolean value) {
            this.requestField("submit_date", value);
            return this;
        }

        public APIRequestGet requestTotalBudgetField() {
            return this.requestTotalBudgetField(true);
        }

        public APIRequestGet requestTotalBudgetField(boolean value) {
            this.requestField("total_budget", value);
            return this;
        }
    }
}

