/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PagePostExperiment
extends APINode {
    @SerializedName(value="auto_resolve_settings")
    private Object mAutoResolveSettings = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creator")
    private User mCreator = null;
    @SerializedName(value="declared_winning_time")
    private String mDeclaredWinningTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="insight_snapshots")
    private List<Map<String, List<Map<Long, Object>>>> mInsightSnapshots = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="optimization_goal")
    private String mOptimizationGoal = null;
    @SerializedName(value="publish_status")
    private String mPublishStatus = null;
    @SerializedName(value="publish_time")
    private String mPublishTime = null;
    @SerializedName(value="scheduled_experiment_timestamp")
    private String mScheduledExperimentTimestamp = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    PagePostExperiment() {
    }

    public PagePostExperiment(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PagePostExperiment(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PagePostExperiment fetch() throws APIException {
        PagePostExperiment newInstance = PagePostExperiment.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PagePostExperiment fetchById(Long id, APIContext context) throws APIException {
        return PagePostExperiment.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PagePostExperiment> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PagePostExperiment.fetchByIdAsync(id.toString(), context);
    }

    public static PagePostExperiment fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PagePostExperiment> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PagePostExperiment> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PagePostExperiment>(context, "", "/", "GET", PagePostExperiment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PagePostExperiment>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PagePostExperiment>(context, "", "/", "GET", PagePostExperiment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PagePostExperiment loadJSON(String json, APIContext context, String header) {
        PagePostExperiment pagePostExperiment = (PagePostExperiment)PagePostExperiment.getGson().fromJson(json, PagePostExperiment.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pagePostExperiment.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pagePostExperiment.context = context;
        pagePostExperiment.rawValue = json;
        pagePostExperiment.header = header;
        return pagePostExperiment;
    }

    public static APINodeList<PagePostExperiment> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PagePostExperiment> pagePostExperiments = new APINodeList<PagePostExperiment>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pagePostExperiments.add(PagePostExperiment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return pagePostExperiments;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pagePostExperiments.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pagePostExperiments.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pagePostExperiments.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pagePostExperiments.add(PagePostExperiment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pagePostExperiments.add(PagePostExperiment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pagePostExperiments.add(PagePostExperiment.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return pagePostExperiments;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pagePostExperiments.add(PagePostExperiment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return pagePostExperiments;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pagePostExperiments.add(PagePostExperiment.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pagePostExperiments;
                }
                pagePostExperiments.clear();
                pagePostExperiments.add(PagePostExperiment.loadJSON(json, context, header));
                return pagePostExperiments;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PagePostExperiment.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldAutoResolveSettings() {
        return this.mAutoResolveSettings;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public User getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public String getFieldDeclaredWinningTime() {
        return this.mDeclaredWinningTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Map<String, List<Map<Long, Object>>>> getFieldInsightSnapshots() {
        return this.mInsightSnapshots;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldOptimizationGoal() {
        return this.mOptimizationGoal;
    }

    public String getFieldPublishStatus() {
        return this.mPublishStatus;
    }

    public String getFieldPublishTime() {
        return this.mPublishTime;
    }

    public String getFieldScheduledExperimentTimestamp() {
        return this.mScheduledExperimentTimestamp;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PagePostExperiment copyFrom(PagePostExperiment instance) {
        this.mAutoResolveSettings = instance.mAutoResolveSettings;
        this.mCreationTime = instance.mCreationTime;
        this.mCreator = instance.mCreator;
        this.mDeclaredWinningTime = instance.mDeclaredWinningTime;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mInsightSnapshots = instance.mInsightSnapshots;
        this.mName = instance.mName;
        this.mOptimizationGoal = instance.mOptimizationGoal;
        this.mPublishStatus = instance.mPublishStatus;
        this.mPublishTime = instance.mPublishTime;
        this.mScheduledExperimentTimestamp = instance.mScheduledExperimentTimestamp;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PagePostExperiment> getParser() {
        return new APIRequest.ResponseParser<PagePostExperiment>(){

            @Override
            public APINodeList<PagePostExperiment> parseResponse(String response, APIContext context, APIRequest<PagePostExperiment> request, String header) throws APIException.MalformedResponseException {
                return PagePostExperiment.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<PagePostExperiment> {
        PagePostExperiment lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"auto_resolve_settings", "creation_time", "creator", "declared_winning_time", "description", "id", "insight_snapshots", "name", "optimization_goal", "publish_status", "publish_time", "scheduled_experiment_timestamp", "updated_time"};

        @Override
        public PagePostExperiment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PagePostExperiment parseResponse(String response, String header) throws APIException {
            return PagePostExperiment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PagePostExperiment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PagePostExperiment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PagePostExperiment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PagePostExperiment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PagePostExperiment>(){

                public PagePostExperiment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAutoResolveSettingsField() {
            return this.requestAutoResolveSettingsField(true);
        }

        public APIRequestGet requestAutoResolveSettingsField(boolean value) {
            this.requestField("auto_resolve_settings", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestDeclaredWinningTimeField() {
            return this.requestDeclaredWinningTimeField(true);
        }

        public APIRequestGet requestDeclaredWinningTimeField(boolean value) {
            this.requestField("declared_winning_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInsightSnapshotsField() {
            return this.requestInsightSnapshotsField(true);
        }

        public APIRequestGet requestInsightSnapshotsField(boolean value) {
            this.requestField("insight_snapshots", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGet requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGet requestPublishStatusField() {
            return this.requestPublishStatusField(true);
        }

        public APIRequestGet requestPublishStatusField(boolean value) {
            this.requestField("publish_status", value);
            return this;
        }

        public APIRequestGet requestPublishTimeField() {
            return this.requestPublishTimeField(true);
        }

        public APIRequestGet requestPublishTimeField(boolean value) {
            this.requestField("publish_time", value);
            return this;
        }

        public APIRequestGet requestScheduledExperimentTimestampField() {
            return this.requestScheduledExperimentTimestampField(true);
        }

        public APIRequestGet requestScheduledExperimentTimestampField(boolean value) {
            this.requestField("scheduled_experiment_timestamp", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }
}

