/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicPriceConfigByDate
extends APINode {
    @SerializedName(value="checkin_date")
    private String mCheckinDate = null;
    @SerializedName(value="prices")
    private String mPrices = null;
    @SerializedName(value="prices_pretty")
    private List<Object> mPricesPretty = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    DynamicPriceConfigByDate() {
    }

    public DynamicPriceConfigByDate(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public DynamicPriceConfigByDate(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public DynamicPriceConfigByDate fetch() throws APIException {
        DynamicPriceConfigByDate newInstance = DynamicPriceConfigByDate.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static DynamicPriceConfigByDate fetchById(Long id, APIContext context) throws APIException {
        return DynamicPriceConfigByDate.fetchById(id.toString(), context);
    }

    public static ListenableFuture<DynamicPriceConfigByDate> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return DynamicPriceConfigByDate.fetchByIdAsync(id.toString(), context);
    }

    public static DynamicPriceConfigByDate fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<DynamicPriceConfigByDate> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<DynamicPriceConfigByDate> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<DynamicPriceConfigByDate>(context, "", "/", "GET", DynamicPriceConfigByDate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<DynamicPriceConfigByDate>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<DynamicPriceConfigByDate>(context, "", "/", "GET", DynamicPriceConfigByDate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static DynamicPriceConfigByDate loadJSON(String json, APIContext context, String header) {
        DynamicPriceConfigByDate dynamicPriceConfigByDate = (DynamicPriceConfigByDate)DynamicPriceConfigByDate.getGson().fromJson(json, DynamicPriceConfigByDate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(dynamicPriceConfigByDate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        dynamicPriceConfigByDate.context = context;
        dynamicPriceConfigByDate.rawValue = json;
        dynamicPriceConfigByDate.header = header;
        return dynamicPriceConfigByDate;
    }

    public static APINodeList<DynamicPriceConfigByDate> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<DynamicPriceConfigByDate> dynamicPriceConfigByDates = new APINodeList<DynamicPriceConfigByDate>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        dynamicPriceConfigByDates.add(DynamicPriceConfigByDate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return dynamicPriceConfigByDates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            dynamicPriceConfigByDates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        dynamicPriceConfigByDates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            dynamicPriceConfigByDates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            dynamicPriceConfigByDates.add(DynamicPriceConfigByDate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                dynamicPriceConfigByDates.add(DynamicPriceConfigByDate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            dynamicPriceConfigByDates.add(DynamicPriceConfigByDate.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return dynamicPriceConfigByDates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        dynamicPriceConfigByDates.add(DynamicPriceConfigByDate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return dynamicPriceConfigByDates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        dynamicPriceConfigByDates.add(DynamicPriceConfigByDate.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return dynamicPriceConfigByDates;
                }
                dynamicPriceConfigByDates.clear();
                dynamicPriceConfigByDates.add(DynamicPriceConfigByDate.loadJSON(json, context, header));
                return dynamicPriceConfigByDates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DynamicPriceConfigByDate.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCheckinDate() {
        return this.mCheckinDate;
    }

    public String getFieldPrices() {
        return this.mPrices;
    }

    public List<Object> getFieldPricesPretty() {
        return this.mPricesPretty;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DynamicPriceConfigByDate copyFrom(DynamicPriceConfigByDate instance) {
        this.mCheckinDate = instance.mCheckinDate;
        this.mPrices = instance.mPrices;
        this.mPricesPretty = instance.mPricesPretty;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DynamicPriceConfigByDate> getParser() {
        return new APIRequest.ResponseParser<DynamicPriceConfigByDate>(){

            @Override
            public APINodeList<DynamicPriceConfigByDate> parseResponse(String response, APIContext context, APIRequest<DynamicPriceConfigByDate> request, String header) throws APIException.MalformedResponseException {
                return DynamicPriceConfigByDate.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<DynamicPriceConfigByDate> {
        DynamicPriceConfigByDate lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"checkin_date", "prices", "prices_pretty", "id"};

        @Override
        public DynamicPriceConfigByDate getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public DynamicPriceConfigByDate parseResponse(String response, String header) throws APIException {
            return DynamicPriceConfigByDate.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public DynamicPriceConfigByDate execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public DynamicPriceConfigByDate execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<DynamicPriceConfigByDate> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<DynamicPriceConfigByDate> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, DynamicPriceConfigByDate>(){

                public DynamicPriceConfigByDate apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCheckinDateField() {
            return this.requestCheckinDateField(true);
        }

        public APIRequestGet requestCheckinDateField(boolean value) {
            this.requestField("checkin_date", value);
            return this;
        }

        public APIRequestGet requestPricesField() {
            return this.requestPricesField(true);
        }

        public APIRequestGet requestPricesField(boolean value) {
            this.requestField("prices", value);
            return this;
        }

        public APIRequestGet requestPricesPrettyField() {
            return this.requestPricesPrettyField(true);
        }

        public APIRequestGet requestPricesPrettyField(boolean value) {
            this.requestField("prices_pretty", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

