/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeCollectionThumbnailInfo;
import com.facebook.ads.sdk.AdCreativeLinkDataCallToAction;
import com.facebook.ads.sdk.AdCreativePostClickConfiguration;
import com.facebook.ads.sdk.AdCustomizationRuleSpec;
import com.facebook.ads.sdk.Targeting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdCreativeVideoData
extends APINode {
    @SerializedName(value="additional_image_index")
    private Long mAdditionalImageIndex = null;
    @SerializedName(value="branded_content_shared_to_sponsor_status")
    private String mBrandedContentSharedToSponsorStatus = null;
    @SerializedName(value="branded_content_sponsor_page_id")
    private String mBrandedContentSponsorPageId = null;
    @SerializedName(value="call_to_action")
    private AdCreativeLinkDataCallToAction mCallToAction = null;
    @SerializedName(value="collection_thumbnails")
    private List<AdCreativeCollectionThumbnailInfo> mCollectionThumbnails = null;
    @SerializedName(value="customization_rules_spec")
    private List<AdCustomizationRuleSpec> mCustomizationRulesSpec = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="link_description")
    private String mLinkDescription = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="offer_id")
    private String mOfferId = null;
    @SerializedName(value="page_welcome_message")
    private String mPageWelcomeMessage = null;
    @SerializedName(value="post_click_configuration")
    private AdCreativePostClickConfiguration mPostClickConfiguration = null;
    @SerializedName(value="retailer_item_ids")
    private List<String> mRetailerItemIds = null;
    @SerializedName(value="targeting")
    private Targeting mTargeting = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeVideoData loadJSON(String json, APIContext context, String header) {
        AdCreativeVideoData adCreativeVideoData = (AdCreativeVideoData)AdCreativeVideoData.getGson().fromJson(json, AdCreativeVideoData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeVideoData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeVideoData.context = context;
        adCreativeVideoData.rawValue = json;
        adCreativeVideoData.header = header;
        return adCreativeVideoData;
    }

    public static APINodeList<AdCreativeVideoData> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeVideoData> adCreativeVideoDatas = new APINodeList<AdCreativeVideoData>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeVideoDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeVideoDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeVideoDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeVideoDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeVideoDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeVideoDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeVideoDatas;
                }
                adCreativeVideoDatas.clear();
                adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(json, context, header));
                return adCreativeVideoDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeVideoData.getGson().toJson((Object)this);
    }

    public Long getFieldAdditionalImageIndex() {
        return this.mAdditionalImageIndex;
    }

    public AdCreativeVideoData setFieldAdditionalImageIndex(Long value) {
        this.mAdditionalImageIndex = value;
        return this;
    }

    public String getFieldBrandedContentSharedToSponsorStatus() {
        return this.mBrandedContentSharedToSponsorStatus;
    }

    public AdCreativeVideoData setFieldBrandedContentSharedToSponsorStatus(String value) {
        this.mBrandedContentSharedToSponsorStatus = value;
        return this;
    }

    public String getFieldBrandedContentSponsorPageId() {
        return this.mBrandedContentSponsorPageId;
    }

    public AdCreativeVideoData setFieldBrandedContentSponsorPageId(String value) {
        this.mBrandedContentSponsorPageId = value;
        return this;
    }

    public AdCreativeLinkDataCallToAction getFieldCallToAction() {
        return this.mCallToAction;
    }

    public AdCreativeVideoData setFieldCallToAction(AdCreativeLinkDataCallToAction value) {
        this.mCallToAction = value;
        return this;
    }

    public AdCreativeVideoData setFieldCallToAction(String value) {
        Type type = new TypeToken<AdCreativeLinkDataCallToAction>(){}.getType();
        this.mCallToAction = (AdCreativeLinkDataCallToAction)AdCreativeLinkDataCallToAction.getGson().fromJson(value, type);
        return this;
    }

    public List<AdCreativeCollectionThumbnailInfo> getFieldCollectionThumbnails() {
        return this.mCollectionThumbnails;
    }

    public AdCreativeVideoData setFieldCollectionThumbnails(List<AdCreativeCollectionThumbnailInfo> value) {
        this.mCollectionThumbnails = value;
        return this;
    }

    public AdCreativeVideoData setFieldCollectionThumbnails(String value) {
        Type type = new TypeToken<List<AdCreativeCollectionThumbnailInfo>>(){}.getType();
        this.mCollectionThumbnails = (List)AdCreativeCollectionThumbnailInfo.getGson().fromJson(value, type);
        return this;
    }

    public List<AdCustomizationRuleSpec> getFieldCustomizationRulesSpec() {
        return this.mCustomizationRulesSpec;
    }

    public AdCreativeVideoData setFieldCustomizationRulesSpec(List<AdCustomizationRuleSpec> value) {
        this.mCustomizationRulesSpec = value;
        return this;
    }

    public AdCreativeVideoData setFieldCustomizationRulesSpec(String value) {
        Type type = new TypeToken<List<AdCustomizationRuleSpec>>(){}.getType();
        this.mCustomizationRulesSpec = (List)AdCustomizationRuleSpec.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public AdCreativeVideoData setFieldImageHash(String value) {
        this.mImageHash = value;
        return this;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public AdCreativeVideoData setFieldImageUrl(String value) {
        this.mImageUrl = value;
        return this;
    }

    public String getFieldLinkDescription() {
        return this.mLinkDescription;
    }

    public AdCreativeVideoData setFieldLinkDescription(String value) {
        this.mLinkDescription = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public AdCreativeVideoData setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public String getFieldOfferId() {
        return this.mOfferId;
    }

    public AdCreativeVideoData setFieldOfferId(String value) {
        this.mOfferId = value;
        return this;
    }

    public String getFieldPageWelcomeMessage() {
        return this.mPageWelcomeMessage;
    }

    public AdCreativeVideoData setFieldPageWelcomeMessage(String value) {
        this.mPageWelcomeMessage = value;
        return this;
    }

    public AdCreativePostClickConfiguration getFieldPostClickConfiguration() {
        return this.mPostClickConfiguration;
    }

    public AdCreativeVideoData setFieldPostClickConfiguration(AdCreativePostClickConfiguration value) {
        this.mPostClickConfiguration = value;
        return this;
    }

    public AdCreativeVideoData setFieldPostClickConfiguration(String value) {
        Type type = new TypeToken<AdCreativePostClickConfiguration>(){}.getType();
        this.mPostClickConfiguration = (AdCreativePostClickConfiguration)AdCreativePostClickConfiguration.getGson().fromJson(value, type);
        return this;
    }

    public List<String> getFieldRetailerItemIds() {
        return this.mRetailerItemIds;
    }

    public AdCreativeVideoData setFieldRetailerItemIds(List<String> value) {
        this.mRetailerItemIds = value;
        return this;
    }

    public Targeting getFieldTargeting() {
        return this.mTargeting;
    }

    public AdCreativeVideoData setFieldTargeting(Targeting value) {
        this.mTargeting = value;
        return this;
    }

    public AdCreativeVideoData setFieldTargeting(String value) {
        Type type = new TypeToken<Targeting>(){}.getType();
        this.mTargeting = (Targeting)Targeting.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public AdCreativeVideoData setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public AdCreativeVideoData setFieldVideoId(String value) {
        this.mVideoId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeVideoData copyFrom(AdCreativeVideoData instance) {
        this.mAdditionalImageIndex = instance.mAdditionalImageIndex;
        this.mBrandedContentSharedToSponsorStatus = instance.mBrandedContentSharedToSponsorStatus;
        this.mBrandedContentSponsorPageId = instance.mBrandedContentSponsorPageId;
        this.mCallToAction = instance.mCallToAction;
        this.mCollectionThumbnails = instance.mCollectionThumbnails;
        this.mCustomizationRulesSpec = instance.mCustomizationRulesSpec;
        this.mImageHash = instance.mImageHash;
        this.mImageUrl = instance.mImageUrl;
        this.mLinkDescription = instance.mLinkDescription;
        this.mMessage = instance.mMessage;
        this.mOfferId = instance.mOfferId;
        this.mPageWelcomeMessage = instance.mPageWelcomeMessage;
        this.mPostClickConfiguration = instance.mPostClickConfiguration;
        this.mRetailerItemIds = instance.mRetailerItemIds;
        this.mTargeting = instance.mTargeting;
        this.mTitle = instance.mTitle;
        this.mVideoId = instance.mVideoId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeVideoData> getParser() {
        return new APIRequest.ResponseParser<AdCreativeVideoData>(){

            @Override
            public APINodeList<AdCreativeVideoData> parseResponse(String response, APIContext context, APIRequest<AdCreativeVideoData> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeVideoData.parseResponse(response, context, request, header);
            }
        };
    }
}

