/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.serverside.utils;

import com.facebook.ads.sdk.serverside.utils.HashedListAdaptor;
import com.facebook.ads.utils.ServerSideApiUtil;
import com.google.gson.stream.JsonReader;
import java.io.IOException;

public class Sha256StringListAdaptor
extends HashedListAdaptor<String> {
    @Override
    protected String readFromJson(JsonReader reader) throws IOException {
        return reader.nextString();
    }

    @Override
    protected String normalizeAndHash(String value, String fieldName) {
        if (value == null) {
            return null;
        }
        String hashedValue = null;
        if (ServerSideApiUtil.isAlreadyHashed(value)) {
            hashedValue = value;
        } else {
            String normalizedString = ServerSideApiUtil.normalize(value, fieldName);
            if (normalizedString != null) {
                hashedValue = ServerSideApiUtil.hash(normalizedString);
            }
        }
        return hashedValue;
    }
}

