/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.serverside;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.serverside.CustomEndpointRequest;
import com.facebook.ads.sdk.serverside.CustomEndpointResponse;
import com.facebook.ads.sdk.serverside.Event;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CAPIGIngressRequest
implements CustomEndpointRequest {
    private boolean sendToDestinationOnly;
    private final String endpointURL;
    private CustomEndpointRequest.Filter filter;
    private final String accessKey;
    private final OkHttpClient client = new OkHttpClient();
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public CAPIGIngressRequest(String endpointURL, String accessKey) {
        this.validateEndpoint(endpointURL);
        this.endpointURL = endpointURL;
        this.sendToDestinationOnly = false;
        this.filter = null;
        this.accessKey = accessKey;
    }

    public void validateEndpoint(String url) throws InvalidParameterException {
        try {
            new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new InvalidParameterException("URL is in invalid format " + e.getMessage());
        }
    }

    @Override
    public boolean isSendToDestinationOnly() {
        return this.sendToDestinationOnly;
    }

    @Override
    public void setSendToDestinationOnly(boolean sendToDestinationOnly) {
        this.sendToDestinationOnly = sendToDestinationOnly;
    }

    @Override
    public void setFilter(CustomEndpointRequest.Filter filter) {
        this.filter = filter;
    }

    @Override
    public String getEndpoint() {
        return this.endpointURL;
    }

    /*
     * Exception decompiling
     */
    @Override
    public CustomEndpointResponse sendEvent(APIContext context, String pixelId, List<Event> events) throws APIException.FailedRequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Request createRequest(List<Event> events, String pixelId) {
        HashMap<String, Object> bodyParams = new HashMap<String, Object>();
        bodyParams.put("accessKey", this.accessKey);
        bodyParams.put("data", events);
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)new Gson().toJson(bodyParams));
        return new Request.Builder().url(this.endpointURL + "/capi/" + pixelId + "/events").post(requestBody).build();
    }

    @Override
    public ListenableFuture<CustomEndpointResponse> sendEventAsync(final APIContext context, String pixelId, List<Event> data) {
        context.log("========Start of Async API Call========");
        Request request = this.createRequest(data, pixelId);
        final SettableFuture future = SettableFuture.create();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                context.log(e.getMessage());
                future.setException((Throwable)new APIException.FailedRequestException("Server failed to accept events. " + e.getMessage()));
            }

            public void onResponse(Call call, Response response) {
                if (response.code() != 202) {
                    future.setException((Throwable)new APIException.FailedRequestException("Server response code is " + response.code() + " , expect: 202"));
                } else {
                    context.log("Events successfully received");
                    future.set((Object)new CustomEndpointResponse(response.message().toString(), String.valueOf(response.code())));
                }
            }
        });
        return future;
    }

    private /* synthetic */ boolean lambda$sendEvent$0(Event event) {
        return this.filter.shouldSendEvent(event);
    }
}

