/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class PageStartInfo
extends APINode {
    @SerializedName(value="date")
    private Object mDate = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static PageStartInfo loadJSON(String json, APIContext context, String header) {
        PageStartInfo pageStartInfo = (PageStartInfo)PageStartInfo.getGson().fromJson(json, PageStartInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageStartInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageStartInfo.context = context;
        pageStartInfo.rawValue = json;
        pageStartInfo.header = header;
        return pageStartInfo;
    }

    public static APINodeList<PageStartInfo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageStartInfo> pageStartInfos = new APINodeList<PageStartInfo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageStartInfos.add(PageStartInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return pageStartInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageStartInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageStartInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageStartInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageStartInfos.add(PageStartInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageStartInfos.add(PageStartInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageStartInfos.add(PageStartInfo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return pageStartInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageStartInfos.add(PageStartInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return pageStartInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageStartInfos.add(PageStartInfo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageStartInfos;
                }
                pageStartInfos.clear();
                pageStartInfos.add(PageStartInfo.loadJSON(json, context, header));
                return pageStartInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageStartInfo.getGson().toJson((Object)this);
    }

    public Object getFieldDate() {
        return this.mDate;
    }

    public PageStartInfo setFieldDate(Object value) {
        this.mDate = value;
        return this;
    }

    public String getFieldType() {
        return this.mType;
    }

    public PageStartInfo setFieldType(String value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageStartInfo copyFrom(PageStartInfo instance) {
        this.mDate = instance.mDate;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageStartInfo> getParser() {
        return new APIRequest.ResponseParser<PageStartInfo>(){

            @Override
            public APINodeList<PageStartInfo> parseResponse(String response, APIContext context, APIRequest<PageStartInfo> request, String header) throws APIException.MalformedResponseException {
                return PageStartInfo.parseResponse(response, context, request, header);
            }
        };
    }
}

