/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.PageUpcomingChange;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class PageChangeProposal
extends APINode {
    @SerializedName(value="acceptance_status")
    private String mAcceptanceStatus = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="current_value")
    private String mCurrentValue = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="proposed_value")
    private String mProposedValue = null;
    @SerializedName(value="upcoming_change_info")
    private PageUpcomingChange mUpcomingChangeInfo = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageChangeProposal loadJSON(String json, APIContext context, String header) {
        PageChangeProposal pageChangeProposal = (PageChangeProposal)PageChangeProposal.getGson().fromJson(json, PageChangeProposal.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageChangeProposal.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageChangeProposal.context = context;
        pageChangeProposal.rawValue = json;
        pageChangeProposal.header = header;
        return pageChangeProposal;
    }

    public static APINodeList<PageChangeProposal> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageChangeProposal> pageChangeProposals = new APINodeList<PageChangeProposal>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageChangeProposals.add(PageChangeProposal.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return pageChangeProposals;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageChangeProposals.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageChangeProposals.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageChangeProposals.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageChangeProposals.add(PageChangeProposal.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageChangeProposals.add(PageChangeProposal.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageChangeProposals.add(PageChangeProposal.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return pageChangeProposals;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageChangeProposals.add(PageChangeProposal.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return pageChangeProposals;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageChangeProposals.add(PageChangeProposal.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageChangeProposals;
                }
                pageChangeProposals.clear();
                pageChangeProposals.add(PageChangeProposal.loadJSON(json, context, header));
                return pageChangeProposals;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageChangeProposal.getGson().toJson((Object)this);
    }

    public String getFieldAcceptanceStatus() {
        return this.mAcceptanceStatus;
    }

    public PageChangeProposal setFieldAcceptanceStatus(String value) {
        this.mAcceptanceStatus = value;
        return this;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public PageChangeProposal setFieldCategory(String value) {
        this.mCategory = value;
        return this;
    }

    public String getFieldCurrentValue() {
        return this.mCurrentValue;
    }

    public PageChangeProposal setFieldCurrentValue(String value) {
        this.mCurrentValue = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public PageChangeProposal setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldProposedValue() {
        return this.mProposedValue;
    }

    public PageChangeProposal setFieldProposedValue(String value) {
        this.mProposedValue = value;
        return this;
    }

    public PageUpcomingChange getFieldUpcomingChangeInfo() {
        if (this.mUpcomingChangeInfo != null) {
            this.mUpcomingChangeInfo.context = this.getContext();
        }
        return this.mUpcomingChangeInfo;
    }

    public PageChangeProposal setFieldUpcomingChangeInfo(PageUpcomingChange value) {
        this.mUpcomingChangeInfo = value;
        return this;
    }

    public PageChangeProposal setFieldUpcomingChangeInfo(String value) {
        Type type = new TypeToken<PageUpcomingChange>(){}.getType();
        this.mUpcomingChangeInfo = (PageUpcomingChange)PageUpcomingChange.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageChangeProposal copyFrom(PageChangeProposal instance) {
        this.mAcceptanceStatus = instance.mAcceptanceStatus;
        this.mCategory = instance.mCategory;
        this.mCurrentValue = instance.mCurrentValue;
        this.mId = instance.mId;
        this.mProposedValue = instance.mProposedValue;
        this.mUpcomingChangeInfo = instance.mUpcomingChangeInfo;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageChangeProposal> getParser() {
        return new APIRequest.ResponseParser<PageChangeProposal>(){

            @Override
            public APINodeList<PageChangeProposal> parseResponse(String response, APIContext context, APIRequest<PageChangeProposal> request, String header) throws APIException.MalformedResponseException {
                return PageChangeProposal.parseResponse(response, context, request, header);
            }
        };
    }
}

