/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogItemChannelsToIntegrityStatus;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalServiceBusiness
extends APINode {
    @SerializedName(value="address")
    private Object mAddress = null;
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="availability")
    private EnumAvailability mAvailability = null;
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="condition")
    private EnumCondition mCondition = null;
    @SerializedName(value="cuisine_type")
    private String mCuisineType = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="custom_label_0")
    private String mCustomLabel0 = null;
    @SerializedName(value="custom_label_1")
    private String mCustomLabel1 = null;
    @SerializedName(value="custom_label_2")
    private String mCustomLabel2 = null;
    @SerializedName(value="custom_label_3")
    private String mCustomLabel3 = null;
    @SerializedName(value="custom_label_4")
    private String mCustomLabel4 = null;
    @SerializedName(value="custom_number_0")
    private Long mCustomNumber0 = null;
    @SerializedName(value="custom_number_1")
    private Long mCustomNumber1 = null;
    @SerializedName(value="custom_number_2")
    private Long mCustomNumber2 = null;
    @SerializedName(value="custom_number_3")
    private Long mCustomNumber3 = null;
    @SerializedName(value="custom_number_4")
    private Long mCustomNumber4 = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="expiration_date")
    private String mExpirationDate = null;
    @SerializedName(value="gtin")
    private String mGtin = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="local_service_business_id")
    private String mLocalServiceBusinessId = null;
    @SerializedName(value="phone")
    private String mPhone = null;
    @SerializedName(value="price")
    private String mPrice = null;
    @SerializedName(value="price_range")
    private String mPriceRange = null;
    @SerializedName(value="retailer_category")
    private String mRetailerCategory = null;
    @SerializedName(value="sanitized_images")
    private List<String> mSanitizedImages = null;
    @SerializedName(value="size")
    private String mSize = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="unit_price")
    private Object mUnitPrice = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="vendor_id")
    private String mVendorId = null;
    protected static Gson gson = null;

    LocalServiceBusiness() {
    }

    public LocalServiceBusiness(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LocalServiceBusiness(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LocalServiceBusiness fetch() throws APIException {
        LocalServiceBusiness newInstance = LocalServiceBusiness.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LocalServiceBusiness fetchById(Long id, APIContext context) throws APIException {
        return LocalServiceBusiness.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LocalServiceBusiness> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LocalServiceBusiness.fetchByIdAsync(id.toString(), context);
    }

    public static LocalServiceBusiness fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LocalServiceBusiness> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LocalServiceBusiness> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LocalServiceBusiness>(context, "", "/", "GET", LocalServiceBusiness.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LocalServiceBusiness>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LocalServiceBusiness>(context, "", "/", "GET", LocalServiceBusiness.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LocalServiceBusiness loadJSON(String json, APIContext context, String header) {
        LocalServiceBusiness localServiceBusiness = (LocalServiceBusiness)LocalServiceBusiness.getGson().fromJson(json, LocalServiceBusiness.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(localServiceBusiness.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        localServiceBusiness.context = context;
        localServiceBusiness.rawValue = json;
        localServiceBusiness.header = header;
        return localServiceBusiness;
    }

    public static APINodeList<LocalServiceBusiness> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LocalServiceBusiness> localServiceBusinesss = new APINodeList<LocalServiceBusiness>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        localServiceBusinesss.add(LocalServiceBusiness.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return localServiceBusinesss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            localServiceBusinesss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        localServiceBusinesss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            localServiceBusinesss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            localServiceBusinesss.add(LocalServiceBusiness.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                localServiceBusinesss.add(LocalServiceBusiness.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            localServiceBusinesss.add(LocalServiceBusiness.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return localServiceBusinesss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        localServiceBusinesss.add(LocalServiceBusiness.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return localServiceBusinesss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        localServiceBusinesss.add(LocalServiceBusiness.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return localServiceBusinesss;
                }
                localServiceBusinesss.clear();
                localServiceBusinesss.add(LocalServiceBusiness.loadJSON(json, context, header));
                return localServiceBusinesss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LocalServiceBusiness.getGson().toJson((Object)this);
    }

    public APIRequestGetChannelsToIntegrityStatus getChannelsToIntegrityStatus() {
        return new APIRequestGetChannelsToIntegrityStatus(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldAddress() {
        return this.mAddress;
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public EnumAvailability getFieldAvailability() {
        return this.mAvailability;
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public EnumCondition getFieldCondition() {
        return this.mCondition;
    }

    public String getFieldCuisineType() {
        return this.mCuisineType;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldCustomLabel0() {
        return this.mCustomLabel0;
    }

    public String getFieldCustomLabel1() {
        return this.mCustomLabel1;
    }

    public String getFieldCustomLabel2() {
        return this.mCustomLabel2;
    }

    public String getFieldCustomLabel3() {
        return this.mCustomLabel3;
    }

    public String getFieldCustomLabel4() {
        return this.mCustomLabel4;
    }

    public Long getFieldCustomNumber0() {
        return this.mCustomNumber0;
    }

    public Long getFieldCustomNumber1() {
        return this.mCustomNumber1;
    }

    public Long getFieldCustomNumber2() {
        return this.mCustomNumber2;
    }

    public Long getFieldCustomNumber3() {
        return this.mCustomNumber3;
    }

    public Long getFieldCustomNumber4() {
        return this.mCustomNumber4;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldExpirationDate() {
        return this.mExpirationDate;
    }

    public String getFieldGtin() {
        return this.mGtin;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldLocalServiceBusinessId() {
        return this.mLocalServiceBusinessId;
    }

    public String getFieldPhone() {
        return this.mPhone;
    }

    public String getFieldPrice() {
        return this.mPrice;
    }

    public String getFieldPriceRange() {
        return this.mPriceRange;
    }

    public String getFieldRetailerCategory() {
        return this.mRetailerCategory;
    }

    public List<String> getFieldSanitizedImages() {
        return this.mSanitizedImages;
    }

    public String getFieldSize() {
        return this.mSize;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public Object getFieldUnitPrice() {
        return this.mUnitPrice;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public String getFieldVendorId() {
        return this.mVendorId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LocalServiceBusiness copyFrom(LocalServiceBusiness instance) {
        this.mAddress = instance.mAddress;
        this.mApplinks = instance.mApplinks;
        this.mAvailability = instance.mAvailability;
        this.mBrand = instance.mBrand;
        this.mCategory = instance.mCategory;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mCondition = instance.mCondition;
        this.mCuisineType = instance.mCuisineType;
        this.mCurrency = instance.mCurrency;
        this.mCustomLabel0 = instance.mCustomLabel0;
        this.mCustomLabel1 = instance.mCustomLabel1;
        this.mCustomLabel2 = instance.mCustomLabel2;
        this.mCustomLabel3 = instance.mCustomLabel3;
        this.mCustomLabel4 = instance.mCustomLabel4;
        this.mCustomNumber0 = instance.mCustomNumber0;
        this.mCustomNumber1 = instance.mCustomNumber1;
        this.mCustomNumber2 = instance.mCustomNumber2;
        this.mCustomNumber3 = instance.mCustomNumber3;
        this.mCustomNumber4 = instance.mCustomNumber4;
        this.mDescription = instance.mDescription;
        this.mExpirationDate = instance.mExpirationDate;
        this.mGtin = instance.mGtin;
        this.mId = instance.mId;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImages = instance.mImages;
        this.mLocalServiceBusinessId = instance.mLocalServiceBusinessId;
        this.mPhone = instance.mPhone;
        this.mPrice = instance.mPrice;
        this.mPriceRange = instance.mPriceRange;
        this.mRetailerCategory = instance.mRetailerCategory;
        this.mSanitizedImages = instance.mSanitizedImages;
        this.mSize = instance.mSize;
        this.mTitle = instance.mTitle;
        this.mUnitPrice = instance.mUnitPrice;
        this.mUrl = instance.mUrl;
        this.mVendorId = instance.mVendorId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LocalServiceBusiness> getParser() {
        return new APIRequest.ResponseParser<LocalServiceBusiness>(){

            @Override
            public APINodeList<LocalServiceBusiness> parseResponse(String response, APIContext context, APIRequest<LocalServiceBusiness> request, String header) throws APIException.MalformedResponseException {
                return LocalServiceBusiness.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCondition {
        VALUE_PC_CPO("PC_CPO"),
        VALUE_PC_NEW("PC_NEW"),
        VALUE_PC_OPEN_BOX_NEW("PC_OPEN_BOX_NEW"),
        VALUE_PC_REFURBISHED("PC_REFURBISHED"),
        VALUE_PC_USED("PC_USED"),
        VALUE_PC_USED_FAIR("PC_USED_FAIR"),
        VALUE_PC_USED_GOOD("PC_USED_GOOD"),
        VALUE_PC_USED_LIKE_NEW("PC_USED_LIKE_NEW");

        private String value;

        private EnumCondition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAvailability {
        VALUE_AVAILABLE_FOR_ORDER("AVAILABLE_FOR_ORDER"),
        VALUE_DISCONTINUED("DISCONTINUED"),
        VALUE_IN_STOCK("IN_STOCK"),
        VALUE_OUT_OF_STOCK("OUT_OF_STOCK"),
        VALUE_PENDING("PENDING"),
        VALUE_PREORDER("PREORDER");

        private String value;

        private EnumAvailability(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<LocalServiceBusiness> {
        LocalServiceBusiness lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"address", "applinks", "availability", "brand", "category", "category_specific_fields", "condition", "cuisine_type", "currency", "custom_label_0", "custom_label_1", "custom_label_2", "custom_label_3", "custom_label_4", "custom_number_0", "custom_number_1", "custom_number_2", "custom_number_3", "custom_number_4", "description", "expiration_date", "gtin", "id", "image_fetch_status", "images", "local_service_business_id", "phone", "price", "price_range", "retailer_category", "sanitized_images", "size", "title", "unit_price", "url", "vendor_id"};

        @Override
        public LocalServiceBusiness getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LocalServiceBusiness parseResponse(String response, String header) throws APIException {
            return LocalServiceBusiness.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LocalServiceBusiness execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LocalServiceBusiness execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LocalServiceBusiness> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LocalServiceBusiness> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LocalServiceBusiness>(){

                public LocalServiceBusiness apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGet requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestAvailabilityField() {
            return this.requestAvailabilityField(true);
        }

        public APIRequestGet requestAvailabilityField(boolean value) {
            this.requestField("availability", value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGet requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestConditionField() {
            return this.requestConditionField(true);
        }

        public APIRequestGet requestConditionField(boolean value) {
            this.requestField("condition", value);
            return this;
        }

        public APIRequestGet requestCuisineTypeField() {
            return this.requestCuisineTypeField(true);
        }

        public APIRequestGet requestCuisineTypeField(boolean value) {
            this.requestField("cuisine_type", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestCustomLabel0Field() {
            return this.requestCustomLabel0Field(true);
        }

        public APIRequestGet requestCustomLabel0Field(boolean value) {
            this.requestField("custom_label_0", value);
            return this;
        }

        public APIRequestGet requestCustomLabel1Field() {
            return this.requestCustomLabel1Field(true);
        }

        public APIRequestGet requestCustomLabel1Field(boolean value) {
            this.requestField("custom_label_1", value);
            return this;
        }

        public APIRequestGet requestCustomLabel2Field() {
            return this.requestCustomLabel2Field(true);
        }

        public APIRequestGet requestCustomLabel2Field(boolean value) {
            this.requestField("custom_label_2", value);
            return this;
        }

        public APIRequestGet requestCustomLabel3Field() {
            return this.requestCustomLabel3Field(true);
        }

        public APIRequestGet requestCustomLabel3Field(boolean value) {
            this.requestField("custom_label_3", value);
            return this;
        }

        public APIRequestGet requestCustomLabel4Field() {
            return this.requestCustomLabel4Field(true);
        }

        public APIRequestGet requestCustomLabel4Field(boolean value) {
            this.requestField("custom_label_4", value);
            return this;
        }

        public APIRequestGet requestCustomNumber0Field() {
            return this.requestCustomNumber0Field(true);
        }

        public APIRequestGet requestCustomNumber0Field(boolean value) {
            this.requestField("custom_number_0", value);
            return this;
        }

        public APIRequestGet requestCustomNumber1Field() {
            return this.requestCustomNumber1Field(true);
        }

        public APIRequestGet requestCustomNumber1Field(boolean value) {
            this.requestField("custom_number_1", value);
            return this;
        }

        public APIRequestGet requestCustomNumber2Field() {
            return this.requestCustomNumber2Field(true);
        }

        public APIRequestGet requestCustomNumber2Field(boolean value) {
            this.requestField("custom_number_2", value);
            return this;
        }

        public APIRequestGet requestCustomNumber3Field() {
            return this.requestCustomNumber3Field(true);
        }

        public APIRequestGet requestCustomNumber3Field(boolean value) {
            this.requestField("custom_number_3", value);
            return this;
        }

        public APIRequestGet requestCustomNumber4Field() {
            return this.requestCustomNumber4Field(true);
        }

        public APIRequestGet requestCustomNumber4Field(boolean value) {
            this.requestField("custom_number_4", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestExpirationDateField() {
            return this.requestExpirationDateField(true);
        }

        public APIRequestGet requestExpirationDateField(boolean value) {
            this.requestField("expiration_date", value);
            return this;
        }

        public APIRequestGet requestGtinField() {
            return this.requestGtinField(true);
        }

        public APIRequestGet requestGtinField(boolean value) {
            this.requestField("gtin", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestLocalServiceBusinessIdField() {
            return this.requestLocalServiceBusinessIdField(true);
        }

        public APIRequestGet requestLocalServiceBusinessIdField(boolean value) {
            this.requestField("local_service_business_id", value);
            return this;
        }

        public APIRequestGet requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGet requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGet requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGet requestRetailerCategoryField() {
            return this.requestRetailerCategoryField(true);
        }

        public APIRequestGet requestRetailerCategoryField(boolean value) {
            this.requestField("retailer_category", value);
            return this;
        }

        public APIRequestGet requestSanitizedImagesField() {
            return this.requestSanitizedImagesField(true);
        }

        public APIRequestGet requestSanitizedImagesField(boolean value) {
            this.requestField("sanitized_images", value);
            return this;
        }

        public APIRequestGet requestSizeField() {
            return this.requestSizeField(true);
        }

        public APIRequestGet requestSizeField(boolean value) {
            this.requestField("size", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestUnitPriceField() {
            return this.requestUnitPriceField(true);
        }

        public APIRequestGet requestUnitPriceField(boolean value) {
            this.requestField("unit_price", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestVendorIdField() {
            return this.requestVendorIdField(true);
        }

        public APIRequestGet requestVendorIdField(boolean value) {
            this.requestField("vendor_id", value);
            return this;
        }
    }

    public static class APIRequestGetChannelsToIntegrityStatus
    extends APIRequest<CatalogItemChannelsToIntegrityStatus> {
        APINodeList<CatalogItemChannelsToIntegrityStatus> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"channels", "rejection_information"};

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> parseResponse(String response, String header) throws APIException {
            return CatalogItemChannelsToIntegrityStatus.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CatalogItemChannelsToIntegrityStatus>>(){

                public APINodeList<CatalogItemChannelsToIntegrityStatus> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetChannelsToIntegrityStatus(String nodeId, APIContext context) {
            super(context, nodeId, "/channels_to_integrity_status", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetChannelsToIntegrityStatus setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField() {
            return this.requestChannelsField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField(boolean value) {
            this.requestField("channels", value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField() {
            return this.requestRejectionInformationField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField(boolean value) {
            this.requestField("rejection_information", value);
            return this;
        }
    }
}

