/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.ExtendedCredit;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.ProductCatalog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ManagedPartnerBusiness
extends APINode {
    @SerializedName(value="ad_account")
    private AdAccount mAdAccount = null;
    @SerializedName(value="catalog_segment")
    private ProductCatalog mCatalogSegment = null;
    @SerializedName(value="extended_credit")
    private ExtendedCredit mExtendedCredit = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="seller_business_info")
    private Object mSellerBusinessInfo = null;
    @SerializedName(value="seller_business_status")
    private String mSellerBusinessStatus = null;
    @SerializedName(value="template")
    private List<Object> mTemplate = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ManagedPartnerBusiness loadJSON(String json, APIContext context, String header) {
        ManagedPartnerBusiness managedPartnerBusiness = (ManagedPartnerBusiness)ManagedPartnerBusiness.getGson().fromJson(json, ManagedPartnerBusiness.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(managedPartnerBusiness.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        managedPartnerBusiness.context = context;
        managedPartnerBusiness.rawValue = json;
        managedPartnerBusiness.header = header;
        return managedPartnerBusiness;
    }

    public static APINodeList<ManagedPartnerBusiness> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ManagedPartnerBusiness> managedPartnerBusinesss = new APINodeList<ManagedPartnerBusiness>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        managedPartnerBusinesss.add(ManagedPartnerBusiness.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return managedPartnerBusinesss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            managedPartnerBusinesss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        managedPartnerBusinesss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            managedPartnerBusinesss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            managedPartnerBusinesss.add(ManagedPartnerBusiness.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                managedPartnerBusinesss.add(ManagedPartnerBusiness.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            managedPartnerBusinesss.add(ManagedPartnerBusiness.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return managedPartnerBusinesss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        managedPartnerBusinesss.add(ManagedPartnerBusiness.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return managedPartnerBusinesss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        managedPartnerBusinesss.add(ManagedPartnerBusiness.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return managedPartnerBusinesss;
                }
                managedPartnerBusinesss.clear();
                managedPartnerBusinesss.add(ManagedPartnerBusiness.loadJSON(json, context, header));
                return managedPartnerBusinesss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ManagedPartnerBusiness.getGson().toJson((Object)this);
    }

    public AdAccount getFieldAdAccount() {
        if (this.mAdAccount != null) {
            this.mAdAccount.context = this.getContext();
        }
        return this.mAdAccount;
    }

    public ManagedPartnerBusiness setFieldAdAccount(AdAccount value) {
        this.mAdAccount = value;
        return this;
    }

    public ManagedPartnerBusiness setFieldAdAccount(String value) {
        Type type = new TypeToken<AdAccount>(){}.getType();
        this.mAdAccount = (AdAccount)AdAccount.getGson().fromJson(value, type);
        return this;
    }

    public ProductCatalog getFieldCatalogSegment() {
        if (this.mCatalogSegment != null) {
            this.mCatalogSegment.context = this.getContext();
        }
        return this.mCatalogSegment;
    }

    public ManagedPartnerBusiness setFieldCatalogSegment(ProductCatalog value) {
        this.mCatalogSegment = value;
        return this;
    }

    public ManagedPartnerBusiness setFieldCatalogSegment(String value) {
        Type type = new TypeToken<ProductCatalog>(){}.getType();
        this.mCatalogSegment = (ProductCatalog)ProductCatalog.getGson().fromJson(value, type);
        return this;
    }

    public ExtendedCredit getFieldExtendedCredit() {
        if (this.mExtendedCredit != null) {
            this.mExtendedCredit.context = this.getContext();
        }
        return this.mExtendedCredit;
    }

    public ManagedPartnerBusiness setFieldExtendedCredit(ExtendedCredit value) {
        this.mExtendedCredit = value;
        return this;
    }

    public ManagedPartnerBusiness setFieldExtendedCredit(String value) {
        Type type = new TypeToken<ExtendedCredit>(){}.getType();
        this.mExtendedCredit = (ExtendedCredit)ExtendedCredit.getGson().fromJson(value, type);
        return this;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public ManagedPartnerBusiness setFieldPage(Page value) {
        this.mPage = value;
        return this;
    }

    public ManagedPartnerBusiness setFieldPage(String value) {
        Type type = new TypeToken<Page>(){}.getType();
        this.mPage = (Page)Page.getGson().fromJson(value, type);
        return this;
    }

    public Object getFieldSellerBusinessInfo() {
        return this.mSellerBusinessInfo;
    }

    public ManagedPartnerBusiness setFieldSellerBusinessInfo(Object value) {
        this.mSellerBusinessInfo = value;
        return this;
    }

    public String getFieldSellerBusinessStatus() {
        return this.mSellerBusinessStatus;
    }

    public ManagedPartnerBusiness setFieldSellerBusinessStatus(String value) {
        this.mSellerBusinessStatus = value;
        return this;
    }

    public List<Object> getFieldTemplate() {
        return this.mTemplate;
    }

    public ManagedPartnerBusiness setFieldTemplate(List<Object> value) {
        this.mTemplate = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ManagedPartnerBusiness copyFrom(ManagedPartnerBusiness instance) {
        this.mAdAccount = instance.mAdAccount;
        this.mCatalogSegment = instance.mCatalogSegment;
        this.mExtendedCredit = instance.mExtendedCredit;
        this.mPage = instance.mPage;
        this.mSellerBusinessInfo = instance.mSellerBusinessInfo;
        this.mSellerBusinessStatus = instance.mSellerBusinessStatus;
        this.mTemplate = instance.mTemplate;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ManagedPartnerBusiness> getParser() {
        return new APIRequest.ResponseParser<ManagedPartnerBusiness>(){

            @Override
            public APINodeList<ManagedPartnerBusiness> parseResponse(String response, APIContext context, APIRequest<ManagedPartnerBusiness> request, String header) throws APIException.MalformedResponseException {
                return ManagedPartnerBusiness.parseResponse(response, context, request, header);
            }
        };
    }
}

