/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.serverside.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class HashedListAdaptor<T>
extends TypeAdapter<List<T>> {
    public List<T> read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        reader.beginArray();
        while (reader.hasNext()) {
            list.add(this.readFromJson(reader));
        }
        reader.endArray();
        return list;
    }

    protected abstract T readFromJson(JsonReader var1) throws IOException;

    public void write(JsonWriter writer, List<T> input) throws IOException {
        if (input == null) {
            writer.nullValue();
            return;
        }
        HashSet<String> hashedValues = new HashSet<String>();
        for (T value : input) {
            String fieldName = null;
            try {
                fieldName = this.getFieldName(writer);
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
                throw new RuntimeException("Error while reading current serializing field's name", ex);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                throw new RuntimeException("Error while reading current serializing field's name", ex);
            }
            String hashedValue = this.normalizeAndHash(value, fieldName);
            if (hashedValue == null) continue;
            hashedValues.add(hashedValue);
        }
        writer.beginArray();
        for (String hashedVal : hashedValues) {
            writer.value(hashedVal);
        }
        writer.endArray();
    }

    protected abstract String normalizeAndHash(T var1, String var2);

    protected String getFieldName(JsonWriter writer) throws NoSuchFieldException, IllegalAccessException {
        Field nameField = JsonWriter.class.getDeclaredField("deferredName");
        nameField.setAccessible(true);
        return (String)nameField.get(writer);
    }
}

