/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.businessdataapi;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.businessdataapi.Event;
import com.facebook.ads.sdk.businessdataapi.EventResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class EventRequest {
    @SerializedName(value="data")
    private List<Event> data = new ArrayList<Event>();
    @SerializedName(value="partner_agent")
    private String partnerAgent = null;
    private String pageId;
    private APIContext context;

    public EventRequest(String pageId, APIContext context) {
        this.pageId = pageId;
        this.context = context;
    }

    public EventRequest(String pageId, APIContext context, List<Event> data, String partnerAgent) {
        this.data = data;
        this.partnerAgent = partnerAgent;
        this.pageId = pageId;
        this.context = context;
    }

    public Gson getGson() {
        return new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
    }

    public EventRequest data(List<Event> data) {
        this.data = data;
        return this;
    }

    public List<Event> getData() {
        return this.data;
    }

    public void setData(List<Event> data) {
        this.data = data;
    }

    public EventRequest partnerAgent(String partnerAgent) {
        this.partnerAgent = partnerAgent;
        return this;
    }

    public String getPartnerAgent() {
        return this.partnerAgent;
    }

    public void setPartnerAgent(String partnerAgent) {
        this.partnerAgent = partnerAgent;
    }

    public EventResponse execute() throws APIException {
        try {
            Page.APIRequestCreateBusinessDatum request = new Page.APIRequestCreateBusinessDatum(this.pageId, this.context);
            request.setData(this.getGson().toJson(this.getData()));
            request.setPartnerAgent(this.getPartnerAgent());
            Page page = request.execute();
            EventResponse response = (EventResponse)this.getGson().fromJson(page.getRawResponse(), EventResponse.class);
            this.context.log(String.format("Successfully sent %d event(s)", response.getEventsReceived()));
            return response;
        }
        catch (APIException e) {
            this.context.log(e.getMessage());
            throw e;
        }
    }
}

