/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.BatchRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class APIRequest<T extends APINode> {
    public static final String USER_AGENT = "fbbizsdk-java-v11.0.0";
    private static IRequestExecutor executor = new DefaultRequestExecutor();
    private static IAsyncRequestExecutor asyncExecutor = new DefaultAsyncRequestExecutor();
    protected APIContext context;
    protected boolean useVideoEndpoint = false;
    protected String nodeId;
    protected String endpoint;
    protected String method;
    protected List<String> paramNames;
    protected ResponseParser<T> parser;
    protected Map<String, Object> params = new HashMap<String, Object>();
    protected List<String> returnFields;
    private String overrideUrl;
    private APIResponse lastResponse = null;

    public static void changeRequestExecutor(IRequestExecutor newExecutor) {
        executor = newExecutor;
    }

    public static void changeAsyncRequestExecutor(IAsyncRequestExecutor newExecutor) {
        asyncExecutor = newExecutor;
    }

    public static IRequestExecutor getExecutor() {
        return executor;
    }

    public static IAsyncRequestExecutor getAsyncExecutor() {
        return asyncExecutor;
    }

    public APIRequest(APIContext context, String nodeId, String endpoint, String method) {
        this(context, nodeId, endpoint, method, null, null);
    }

    public APIRequest(APIContext context, String nodeId, String endpoint, String method, ResponseParser<T> parser) {
        this(context, nodeId, endpoint, method, null, parser);
    }

    public APIRequest(APIContext context, String nodeId, String endpoint, String method, List<String> paramNames) {
        this(context, nodeId, endpoint, method, paramNames, null);
    }

    public APIRequest(APIContext context, String nodeId, String endpoint, String method, List<String> paramNames, ResponseParser<T> parser) {
        this.context = context;
        this.nodeId = nodeId;
        this.endpoint = endpoint;
        this.method = method;
        this.paramNames = paramNames;
        this.parser = parser;
    }

    public APIResponse getLastResponse() {
        return this.lastResponse;
    }

    public APIResponse parseResponse(String response, String header) throws APIException {
        if (this.parser != null) {
            return this.parser.parseResponse(response, this.context, this, header);
        }
        return APINode.parseResponse(response, this.context, new APIRequest<APINode>(this.context, this.nodeId, this.endpoint, this.method, this.paramNames), header);
    }

    public APIResponse execute() throws APIException {
        return this.execute(new HashMap<String, Object>());
    }

    public APIResponse execute(Map<String, Object> extraParams) throws APIException {
        ResponseWrapper rw = this.executeInternal(extraParams);
        this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
        return this.lastResponse;
    }

    public ListenableFuture<APIResponse> executeAsyncBase() throws APIException {
        return this.executeAsyncBase(new HashMap<String, Object>());
    }

    public ListenableFuture<APIResponse> executeAsyncBase(Map<String, Object> extraParams) throws APIException {
        return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<ResponseWrapper, APIResponse>(){

            public APIResponse apply(ResponseWrapper result) {
                try {
                    return APIRequest.this.parseResponse(result.getBody(), result.getHeader());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public APIRequest<T> setParam(String param, Object value) {
        this.setParamInternal(param, value);
        return this;
    }

    public APIRequest setParams(Map<String, Object> params) {
        this.setParamsInternal(params);
        return this;
    }

    public APIRequest requestFields(List<String> fields) {
        return this.requestFields(fields, true);
    }

    public APIRequest requestFields(List<String> fields, boolean value) {
        for (String field : fields) {
            this.requestField(field, value);
        }
        return this;
    }

    public APIRequest requestField(String field) {
        this.requestField(field, true);
        return this;
    }

    public APIRequest requestField(String field, boolean value) {
        this.requestFieldInternal(field, value);
        return this;
    }

    public APIRequest setUseVideoEndpoint(boolean useVideoEndpoint) {
        this.useVideoEndpoint = useVideoEndpoint;
        return this;
    }

    protected ResponseWrapper executeInternal() throws APIException {
        return this.executeInternal(null);
    }

    protected ResponseWrapper executeInternal(Map<String, Object> extraParams) throws APIException {
        ResponseWrapper response = null;
        try {
            this.context.log("========Start of API Call========");
            response = executor.execute(this.method, this.getApiUrl(), this.getAllParams(extraParams), this.context);
            this.context.log("Response:");
            this.context.log(response.getBody());
            this.context.log("========End of API Call========");
        }
        catch (IOException e) {
            throw new APIException.FailedRequestException(e);
        }
        return response;
    }

    protected ListenableFuture<ResponseWrapper> executeAsyncInternal() throws APIException {
        return this.executeAsyncInternal(null);
    }

    protected ListenableFuture<ResponseWrapper> executeAsyncInternal(Map<String, Object> extraParams) throws APIException {
        ListenableFuture<ResponseWrapper> response = null;
        try {
            this.context.log("========Start of Async API Call========");
            response = asyncExecutor.execute(this.method, this.getApiUrl(), this.getAllParams(extraParams), this.context);
            Futures.addCallback(response, (FutureCallback)new FutureCallback<ResponseWrapper>(){

                public void onSuccess(ResponseWrapper result) {
                    APIRequest.this.context.log("Response:");
                    APIRequest.this.context.log(result.getBody());
                    APIRequest.this.context.log("========End of API Call========");
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        catch (IOException e) {
            throw new APIException.FailedRequestException(e);
        }
        return response;
    }

    public APIContext getContext() {
        return this.context;
    }

    public void setContext(APIContext context) {
        this.context = context;
    }

    protected void setParamInternal(String param, Object value) {
        this.params.put(param, value);
    }

    protected void setParamsInternal(Map<String, Object> params) {
        this.params = params;
    }

    public void setOverrideUrl(String url) {
        this.overrideUrl = url;
    }

    protected void requestFieldInternal(String field, boolean addField) {
        if (this.returnFields == null) {
            this.returnFields = new ArrayList<String>();
        }
        if (addField) {
            if (!this.returnFields.contains(field)) {
                this.returnFields.add(field);
            }
        } else {
            this.returnFields.remove(field);
        }
    }

    private Map<String, Object> getAllParams(Map<String, Object> extraParams) {
        if (this.overrideUrl != null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> allParams = new HashMap<String, Object>(this.params);
        if (extraParams != null) {
            allParams.putAll(extraParams);
        }
        allParams.put("access_token", this.context.getAccessToken());
        if (this.context.hasAppSecret()) {
            allParams.put("appsecret_proof", this.context.getAppSecretProof());
        }
        if (this.returnFields != null) {
            allParams.put("fields", APIRequest.joinStringList(this.returnFields));
        }
        return allParams;
    }

    private static ResponseWrapper readResponse(HttpsURLConnection con) throws APIException, IOException {
        try {
            String inputLine;
            int responseCode = con.getResponseCode();
            String header = APIRequest.convertToString(con.getHeaderFields());
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return new ResponseWrapper(response.toString(), header);
        }
        catch (Exception e) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            throw new APIException.FailedRequestException(APIRequest.convertToString(con.getHeaderFields()), response.toString(), e);
        }
    }

    private String getApiUrl() {
        if (this.overrideUrl != null) {
            return this.overrideUrl;
        }
        String endpointBas = this.useVideoEndpoint ? this.context.getVideoEndpointBase() : this.context.getEndpointBase();
        return endpointBas + "/" + this.context.getVersion() + "/" + this.nodeId + this.endpoint;
    }

    public static String joinStringList(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        for (String s : list) {
            if (!isFirst) {
                result.append(",");
            }
            result.append(s);
            isFirst = false;
        }
        return result.toString();
    }

    private static String convertToString(Object input) {
        if (input == null) {
            return "null";
        }
        if (input instanceof Map) {
            Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
            return gson.toJson((Object)((Map)input));
        }
        if (input instanceof List) {
            Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
            return gson.toJson((Object)((List)input));
        }
        return input.toString();
    }

    public APIRequest addToBatch(BatchRequest batch) {
        batch.addRequest(this);
        return this;
    }

    public APIRequest addToBatch(BatchRequest batch, String name) {
        batch.addRequest(name, this);
        return this;
    }

    public APIRequest addToBatch(BatchRequest batch, String name, boolean omitResponseOnSuccess) {
        batch.addRequest(name, omitResponseOnSuccess, this);
        return this;
    }

    BatchRequest.BatchModeRequestInfo getBatchModeRequestInfo() throws IOException {
        BatchRequest.BatchModeRequestInfo info = new BatchRequest.BatchModeRequestInfo();
        HashMap<String, Object> allParams = new HashMap<String, Object>(this.params);
        if (this.returnFields != null) {
            allParams.put("fields", APIRequest.joinStringList(this.returnFields));
        }
        info.method = this.method;
        StringBuilder relativeUrl = new StringBuilder(this.context.getVersion() + "/" + this.nodeId + this.endpoint);
        if (this.method.equals("POST")) {
            info.files = new HashMap<String, File>();
            info.relativeUrl = relativeUrl.toString();
            StringBuilder body = new StringBuilder();
            boolean firstEntry = true;
            for (Map.Entry entry : allParams.entrySet()) {
                if (entry.getValue() instanceof File) {
                    info.files.put((String)entry.getKey(), (File)entry.getValue());
                    continue;
                }
                body.append((firstEntry ? "" : "&") + URLEncoder.encode(entry.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(APIRequest.convertToString(entry.getValue()), "UTF-8"));
                firstEntry = false;
            }
            info.body = body.toString();
        } else {
            boolean firstEntry = true;
            for (Map.Entry entry : allParams.entrySet()) {
                relativeUrl.append((firstEntry ? "?" : "&") + URLEncoder.encode(entry.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(APIRequest.convertToString(entry.getValue()), "UTF-8"));
                firstEntry = false;
            }
            info.relativeUrl = relativeUrl.toString();
        }
        return info;
    }

    public static class ResponseWrapper {
        private String body;
        private String header;

        public ResponseWrapper(String body, String header) {
            this.body = body;
            this.header = header;
        }

        public String getBody() {
            return this.body;
        }

        public String getHeader() {
            return this.header;
        }
    }

    public static class DefaultAsyncRequestExecutor
    implements IAsyncRequestExecutor {
        static OkHttpClient client = null;

        static void init() {
            client = new OkHttpClient();
        }

        @Override
        public ListenableFuture<ResponseWrapper> execute(String method, String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            if ("GET".equals(method)) {
                return this.sendGet(apiUrl, allParams, context);
            }
            if ("POST".equals(method)) {
                return this.sendPost(apiUrl, allParams, context);
            }
            if ("DELETE".equals(method)) {
                return this.sendDelete(apiUrl, allParams, context);
            }
            throw new IllegalArgumentException("Unsupported http method. Currently only GET, POST, and DELETE are supported");
        }

        @Override
        public ListenableFuture<ResponseWrapper> sendGet(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            context.log("Request:");
            context.log("GET: " + apiUrl.toString());
            Request request = new Request.Builder().url(RequestHelper.constructUrlString(apiUrl, allParams)).get().header("User-Agent", APIRequest.USER_AGENT).header("Content-Type", "application/x-www-form-urlencoded").build();
            return RequestHelper.invoke(client, request);
        }

        @Override
        public ListenableFuture<ResponseWrapper> sendPost(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            String boundary = "--------------------------" + new Random().nextLong();
            MultipartBody.Builder builder = new MultipartBody.Builder(boundary).setType(MultipartBody.FORM);
            for (Map.Entry<String, Object> entry : allParams.entrySet()) {
                if (entry.getValue() instanceof File) {
                    File file = (File)entry.getValue();
                    String contentType = RequestHelper.getContentTypeForFile(file);
                    builder.addFormDataPart(entry.getKey(), file.getName(), RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)file));
                    continue;
                }
                if (entry.getValue() instanceof byte[]) {
                    builder.addFormDataPart(entry.getKey(), "chunkfile", RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])((byte[])entry.getValue())));
                    continue;
                }
                builder.addFormDataPart(entry.getKey(), APIRequest.convertToString(entry.getValue()));
            }
            Request request = new Request.Builder().url(apiUrl).post((RequestBody)builder.build()).header("User-Agent", APIRequest.USER_AGENT).build();
            return RequestHelper.invoke(client, request);
        }

        @Override
        public ListenableFuture<ResponseWrapper> sendDelete(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            URL url = new URL(RequestHelper.constructUrlString(apiUrl, allParams));
            context.log("Delete: " + url.toString());
            Request request = new Request.Builder().url(RequestHelper.constructUrlString(apiUrl, allParams)).delete().header("User-Agent", APIRequest.USER_AGENT).build();
            return RequestHelper.invoke(client, request);
        }

        static {
            DefaultAsyncRequestExecutor.init();
        }
    }

    public static class DefaultRequestExecutor
    implements IRequestExecutor {
        @Override
        public ResponseWrapper execute(String method, String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            if ("GET".equals(method)) {
                return this.sendGet(apiUrl, allParams, context);
            }
            if ("POST".equals(method)) {
                return this.sendPost(apiUrl, allParams, context);
            }
            if ("DELETE".equals(method)) {
                return this.sendDelete(apiUrl, allParams, context);
            }
            throw new IllegalArgumentException("Unsupported http method. Currently only GET, POST, and DELETE are supported");
        }

        @Override
        public ResponseWrapper sendGet(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            URL url = new URL(RequestHelper.constructUrlString(apiUrl, allParams));
            context.log("Request:");
            context.log("GET: " + url.toString());
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", APIRequest.USER_AGENT);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            return APIRequest.readResponse(con);
        }

        @Override
        public ResponseWrapper sendPost(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            String boundary = "--------------------------" + new Random().nextLong();
            URL url = new URL(apiUrl);
            context.log("Post: " + url.toString());
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", APIRequest.USER_AGENT);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setDoOutput(true);
            int contentLength = RequestHelper.getContentLength(allParams, boundary, context);
            con.setRequestProperty("Content-Length", "" + contentLength);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            for (Map.Entry<String, Object> entry : allParams.entrySet()) {
                DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "--" + boundary + "\r\n");
                if (entry.getValue() instanceof File) {
                    File file = (File)entry.getValue();
                    String contentType = RequestHelper.getContentTypeForFile(file);
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + file.getName() + "\"\r\n");
                    if (contentType != null) {
                        DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "Content-Type: " + contentType + "\r\n");
                    }
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "\r\n");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] buffer = new byte[1024];
                    int count = 0;
                    while ((count = fileInputStream.read(buffer)) >= 0) {
                        wr.write(buffer, 0, count);
                    }
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "\r\n");
                    fileInputStream.close();
                    continue;
                }
                if (entry.getValue() instanceof byte[]) {
                    byte[] bytes = (byte[])entry.getValue();
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"chunkfile\"\r\n\r\n");
                    wr.write(bytes, 0, bytes.length);
                    DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "\r\n");
                    continue;
                }
                DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
                DefaultRequestExecutor.writeStringInUTF8Bytes(wr, APIRequest.convertToString(entry.getValue()));
                DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "\r\n");
            }
            DefaultRequestExecutor.writeStringInUTF8Bytes(wr, "--" + boundary + "--\r\n");
            wr.flush();
            wr.close();
            return APIRequest.readResponse(con);
        }

        @Override
        public ResponseWrapper sendDelete(String apiUrl, Map<String, Object> allParams, APIContext context) throws APIException, IOException {
            URL url = new URL(RequestHelper.constructUrlString(apiUrl, allParams));
            context.log("Delete: " + url.toString());
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("DELETE");
            con.setRequestProperty("User-Agent", APIRequest.USER_AGENT);
            return APIRequest.readResponse(con);
        }

        private static void writeStringInUTF8Bytes(DataOutputStream wr, String input) throws IOException {
            wr.write(input.getBytes("UTF-8"));
        }
    }

    public static class RequestHelper {
        private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
        public static Map<String, String> fileToContentTypeMap = new HashMap<String, String>();

        public static String getContentTypeForFile(File file) {
            String contentType = fileToContentTypeMap.get(RequestHelper.getFileExtension(file));
            if (contentType != null) {
                return contentType;
            }
            try {
                contentType = Files.probeContentType(file.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return contentType != null ? contentType : DEFAULT_CONTENT_TYPE;
        }

        private static String getFileExtension(File file) {
            String fileName = file.getName();
            int index = fileName.lastIndexOf(46);
            if (index == -1) {
                return "";
            }
            return fileName.substring(index, fileName.length());
        }

        public static int getContentLength(Map<String, Object> allParams, String boundary, APIContext context) throws IOException {
            int contentLength = 0;
            for (Map.Entry<String, Object> entry : allParams.entrySet()) {
                contentLength += ("--" + boundary + "\r\n").length();
                if (entry.getValue() instanceof File) {
                    File file = (File)entry.getValue();
                    String contentType = RequestHelper.getContentTypeForFile(file);
                    contentLength += RequestHelper.getLengthAndLog(context, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + file.getName() + "\"\r\n");
                    if (contentType != null) {
                        contentLength += RequestHelper.getLengthAndLog(context, "Content-Type: " + contentType + "\r\n");
                    }
                    contentLength += RequestHelper.getLengthAndLog(context, "\r\n");
                    contentLength = (int)((long)contentLength + file.length());
                    contentLength += RequestHelper.getLengthAndLog(context, "\r\n");
                    continue;
                }
                if (entry.getValue() instanceof byte[]) {
                    byte[] bytes = (byte[])entry.getValue();
                    contentLength += RequestHelper.getLengthAndLog(context, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"chunkfile\"\r\n");
                    contentLength += bytes.length;
                    contentLength += RequestHelper.getLengthAndLog(context, "\r\n");
                    continue;
                }
                contentLength += RequestHelper.getLengthAndLog(context, "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
                contentLength += RequestHelper.getLengthAndLog(context, APIRequest.convertToString(entry.getValue()));
                contentLength += RequestHelper.getLengthAndLog(context, "\r\n");
            }
            return contentLength += RequestHelper.getLengthAndLog(context, "--" + boundary + "--\r\n");
        }

        private static int getLengthAndLog(APIContext context, String input) throws IOException {
            context.log(input);
            return input.getBytes("UTF-8").length;
        }

        public static String constructUrlString(String apiUrl, Map<String, Object> allParams) throws IOException {
            StringBuilder urlString = new StringBuilder(apiUrl);
            boolean firstEntry = true;
            for (Map.Entry<String, Object> entry : allParams.entrySet()) {
                urlString.append((firstEntry ? "?" : "&") + URLEncoder.encode(entry.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(APIRequest.convertToString(entry.getValue()), "UTF-8"));
                firstEntry = false;
            }
            return urlString.toString();
        }

        public static ListenableFuture<ResponseWrapper> invoke(OkHttpClient client, Request request) {
            final SettableFuture future = SettableFuture.create();
            client.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    future.setException((Throwable)new APIException.FailedRequestException(e));
                }

                public void onResponse(Call call, Response response) throws IOException {
                    future.set((Object)new ResponseWrapper(response.body().string(), APIRequest.convertToString(response.headers())));
                }
            });
            return future;
        }

        static {
            fileToContentTypeMap.put(".atom", "application/atom+xml");
            fileToContentTypeMap.put(".rss", "application/rss+xml");
            fileToContentTypeMap.put(".xml", "application/xml");
            fileToContentTypeMap.put(".csv", "text/csv");
            fileToContentTypeMap.put(".txt", "text/plain");
        }
    }

    public static interface IAsyncRequestExecutor {
        public ListenableFuture<ResponseWrapper> execute(String var1, String var2, Map<String, Object> var3, APIContext var4) throws APIException, IOException;

        public ListenableFuture<ResponseWrapper> sendGet(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;

        public ListenableFuture<ResponseWrapper> sendPost(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;

        public ListenableFuture<ResponseWrapper> sendDelete(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;
    }

    public static interface IRequestExecutor {
        public ResponseWrapper execute(String var1, String var2, Map<String, Object> var3, APIContext var4) throws APIException, IOException;

        public ResponseWrapper sendGet(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;

        public ResponseWrapper sendPost(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;

        public ResponseWrapper sendDelete(String var1, Map<String, Object> var2, APIContext var3) throws APIException, IOException;
    }

    public static interface ResponseParser<T extends APINode> {
        public APINodeList<T> parseResponse(String var1, APIContext var2, APIRequest<T> var3, String var4) throws APIException.MalformedResponseException;
    }
}

