/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.facebook.ads.sdk.HotelRoom;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hotel
extends APINode {
    @SerializedName(value="address")
    private String mAddress = null;
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="guest_ratings")
    private String mGuestRatings = null;
    @SerializedName(value="hotel_id")
    private String mHotelId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="lowest_base_price")
    private String mLowestBasePrice = null;
    @SerializedName(value="loyalty_program")
    private String mLoyaltyProgram = null;
    @SerializedName(value="margin_level")
    private Long mMarginLevel = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="phone")
    private String mPhone = null;
    @SerializedName(value="sale_price")
    private String mSalePrice = null;
    @SerializedName(value="sanitized_images")
    private List<String> mSanitizedImages = null;
    @SerializedName(value="star_rating")
    private Double mStarRating = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    Hotel() {
    }

    public Hotel(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Hotel(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Hotel fetch() throws APIException {
        Hotel newInstance = Hotel.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Hotel fetchById(Long id, APIContext context) throws APIException {
        return Hotel.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Hotel> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Hotel.fetchByIdAsync(id.toString(), context);
    }

    public static Hotel fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Hotel> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Hotel> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Hotel>(context, "", "/", "GET", Hotel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Hotel>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Hotel>(context, "", "/", "GET", Hotel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Hotel loadJSON(String json, APIContext context, String header) {
        Hotel hotel = (Hotel)Hotel.getGson().fromJson(json, Hotel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(hotel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        hotel.context = context;
        hotel.rawValue = json;
        hotel.header = header;
        return hotel;
    }

    public static APINodeList<Hotel> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Hotel> hotels = new APINodeList<Hotel>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        hotels.add(Hotel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return hotels;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            hotels.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        hotels.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            hotels.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            hotels.add(Hotel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                hotels.add(Hotel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            hotels.add(Hotel.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return hotels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        hotels.add(Hotel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return hotels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        hotels.add(Hotel.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return hotels;
                }
                hotels.clear();
                hotels.add(Hotel.loadJSON(json, context, header));
                return hotels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Hotel.getGson().toJson((Object)this);
    }

    public APIRequestGetAugmentedRealitiesMetadata getAugmentedRealitiesMetadata() {
        return new APIRequestGetAugmentedRealitiesMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetHotelRooms getHotelRooms() {
        return new APIRequestGetHotelRooms(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideosMetadata getVideosMetadata() {
        return new APIRequestGetVideosMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAddress() {
        return this.mAddress;
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldGuestRatings() {
        return this.mGuestRatings;
    }

    public String getFieldHotelId() {
        return this.mHotelId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldLowestBasePrice() {
        return this.mLowestBasePrice;
    }

    public String getFieldLoyaltyProgram() {
        return this.mLoyaltyProgram;
    }

    public Long getFieldMarginLevel() {
        return this.mMarginLevel;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPhone() {
        return this.mPhone;
    }

    public String getFieldSalePrice() {
        return this.mSalePrice;
    }

    public List<String> getFieldSanitizedImages() {
        return this.mSanitizedImages;
    }

    public Double getFieldStarRating() {
        return this.mStarRating;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Hotel copyFrom(Hotel instance) {
        this.mAddress = instance.mAddress;
        this.mApplinks = instance.mApplinks;
        this.mBrand = instance.mBrand;
        this.mCategory = instance.mCategory;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mCurrency = instance.mCurrency;
        this.mDescription = instance.mDescription;
        this.mGuestRatings = instance.mGuestRatings;
        this.mHotelId = instance.mHotelId;
        this.mId = instance.mId;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImages = instance.mImages;
        this.mLowestBasePrice = instance.mLowestBasePrice;
        this.mLoyaltyProgram = instance.mLoyaltyProgram;
        this.mMarginLevel = instance.mMarginLevel;
        this.mName = instance.mName;
        this.mPhone = instance.mPhone;
        this.mSalePrice = instance.mSalePrice;
        this.mSanitizedImages = instance.mSanitizedImages;
        this.mStarRating = instance.mStarRating;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Hotel> getParser() {
        return new APIRequest.ResponseParser<Hotel>(){

            @Override
            public APINodeList<Hotel> parseResponse(String response, APIContext context, APIRequest<Hotel> request, String header) throws APIException.MalformedResponseException {
                return Hotel.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<Hotel> {
        Hotel lastResponse = null;
        public static final String[] PARAMS = new String[]{"address", "applinks", "base_price", "brand", "currency", "description", "guest_ratings", "images", "name", "phone", "star_rating", "url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Hotel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Hotel parseResponse(String response, String header) throws APIException {
            return Hotel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Hotel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Hotel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Hotel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Hotel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Hotel>(){

                public Hotel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAddress(Object address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestUpdate setAddress(String address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestUpdate setApplinks(Object applinks) {
            this.setParam("applinks", applinks);
            return this;
        }

        public APIRequestUpdate setApplinks(String applinks) {
            this.setParam("applinks", applinks);
            return this;
        }

        public APIRequestUpdate setBasePrice(Long basePrice) {
            this.setParam("base_price", basePrice);
            return this;
        }

        public APIRequestUpdate setBasePrice(String basePrice) {
            this.setParam("base_price", basePrice);
            return this;
        }

        public APIRequestUpdate setBrand(String brand) {
            this.setParam("brand", brand);
            return this;
        }

        public APIRequestUpdate setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setGuestRatings(List<Object> guestRatings) {
            this.setParam("guest_ratings", guestRatings);
            return this;
        }

        public APIRequestUpdate setGuestRatings(String guestRatings) {
            this.setParam("guest_ratings", guestRatings);
            return this;
        }

        public APIRequestUpdate setImages(List<Object> images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setImages(String images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setPhone(String phone) {
            this.setParam("phone", phone);
            return this;
        }

        public APIRequestUpdate setStarRating(Double starRating) {
            this.setParam("star_rating", starRating);
            return this;
        }

        public APIRequestUpdate setStarRating(String starRating) {
            this.setParam("star_rating", starRating);
            return this;
        }

        public APIRequestUpdate setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Hotel> {
        Hotel lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"address", "applinks", "brand", "category", "category_specific_fields", "currency", "description", "guest_ratings", "hotel_id", "id", "image_fetch_status", "images", "lowest_base_price", "loyalty_program", "margin_level", "name", "phone", "sale_price", "sanitized_images", "star_rating", "url"};

        @Override
        public Hotel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Hotel parseResponse(String response, String header) throws APIException {
            return Hotel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Hotel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Hotel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Hotel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Hotel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Hotel>(){

                public Hotel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGet requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGet requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestGuestRatingsField() {
            return this.requestGuestRatingsField(true);
        }

        public APIRequestGet requestGuestRatingsField(boolean value) {
            this.requestField("guest_ratings", value);
            return this;
        }

        public APIRequestGet requestHotelIdField() {
            return this.requestHotelIdField(true);
        }

        public APIRequestGet requestHotelIdField(boolean value) {
            this.requestField("hotel_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestLowestBasePriceField() {
            return this.requestLowestBasePriceField(true);
        }

        public APIRequestGet requestLowestBasePriceField(boolean value) {
            this.requestField("lowest_base_price", value);
            return this;
        }

        public APIRequestGet requestLoyaltyProgramField() {
            return this.requestLoyaltyProgramField(true);
        }

        public APIRequestGet requestLoyaltyProgramField(boolean value) {
            this.requestField("loyalty_program", value);
            return this;
        }

        public APIRequestGet requestMarginLevelField() {
            return this.requestMarginLevelField(true);
        }

        public APIRequestGet requestMarginLevelField(boolean value) {
            this.requestField("margin_level", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGet requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGet requestSalePriceField() {
            return this.requestSalePriceField(true);
        }

        public APIRequestGet requestSalePriceField(boolean value) {
            this.requestField("sale_price", value);
            return this;
        }

        public APIRequestGet requestSanitizedImagesField() {
            return this.requestSanitizedImagesField(true);
        }

        public APIRequestGet requestSanitizedImagesField(boolean value) {
            this.requestField("sanitized_images", value);
            return this;
        }

        public APIRequestGet requestStarRatingField() {
            return this.requestStarRatingField(true);
        }

        public APIRequestGet requestStarRatingField(boolean value) {
            this.requestField("star_rating", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetVideosMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetVideosMetadata.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideosMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/videos_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideosMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideosMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideosMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetHotelRooms
    extends APIRequest<HotelRoom> {
        APINodeList<HotelRoom> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"applinks", "base_price", "currency", "description", "id", "images", "margin_level", "name", "room_id", "sale_price", "url"};

        @Override
        public APINodeList<HotelRoom> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<HotelRoom> parseResponse(String response, String header) throws APIException {
            return HotelRoom.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<HotelRoom> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<HotelRoom> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<HotelRoom>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<HotelRoom>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<HotelRoom>>(){

                public APINodeList<HotelRoom> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetHotelRooms.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetHotelRooms(String nodeId, APIContext context) {
            super(context, nodeId, "/hotel_rooms", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetHotelRooms setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetHotelRooms setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetHotelRooms requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetHotelRooms requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetHotelRooms requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetHotelRooms requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetHotelRooms requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetHotelRooms requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetHotelRooms requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGetHotelRooms requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGetHotelRooms requestBasePriceField() {
            return this.requestBasePriceField(true);
        }

        public APIRequestGetHotelRooms requestBasePriceField(boolean value) {
            this.requestField("base_price", value);
            return this;
        }

        public APIRequestGetHotelRooms requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetHotelRooms requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetHotelRooms requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetHotelRooms requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetHotelRooms requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetHotelRooms requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetHotelRooms requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGetHotelRooms requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGetHotelRooms requestMarginLevelField() {
            return this.requestMarginLevelField(true);
        }

        public APIRequestGetHotelRooms requestMarginLevelField(boolean value) {
            this.requestField("margin_level", value);
            return this;
        }

        public APIRequestGetHotelRooms requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetHotelRooms requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetHotelRooms requestRoomIdField() {
            return this.requestRoomIdField(true);
        }

        public APIRequestGetHotelRooms requestRoomIdField(boolean value) {
            this.requestField("room_id", value);
            return this;
        }

        public APIRequestGetHotelRooms requestSalePriceField() {
            return this.requestSalePriceField(true);
        }

        public APIRequestGetHotelRooms requestSalePriceField(boolean value) {
            this.requestField("sale_price", value);
            return this;
        }

        public APIRequestGetHotelRooms requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetHotelRooms requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAugmentedRealitiesMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAugmentedRealitiesMetadata.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAugmentedRealitiesMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/augmented_realities_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAugmentedRealitiesMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

