/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPASParentCatalogSettings
extends APINode {
    @SerializedName(value="attribution_windows")
    private List<String> mAttributionWindows = null;
    @SerializedName(value="default_currency")
    private String mDefaultCurrency = null;
    @SerializedName(value="disable_use_as_parent_catalog")
    private Boolean mDisableUseAsParentCatalog = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    CPASParentCatalogSettings() {
    }

    public CPASParentCatalogSettings(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CPASParentCatalogSettings(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CPASParentCatalogSettings fetch() throws APIException {
        CPASParentCatalogSettings newInstance = CPASParentCatalogSettings.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CPASParentCatalogSettings fetchById(Long id, APIContext context) throws APIException {
        return CPASParentCatalogSettings.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CPASParentCatalogSettings> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CPASParentCatalogSettings.fetchByIdAsync(id.toString(), context);
    }

    public static CPASParentCatalogSettings fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CPASParentCatalogSettings> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CPASParentCatalogSettings> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CPASParentCatalogSettings>(context, "", "/", "GET", CPASParentCatalogSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CPASParentCatalogSettings>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CPASParentCatalogSettings>(context, "", "/", "GET", CPASParentCatalogSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CPASParentCatalogSettings loadJSON(String json, APIContext context, String header) {
        CPASParentCatalogSettings cpasParentCatalogSettings = (CPASParentCatalogSettings)CPASParentCatalogSettings.getGson().fromJson(json, CPASParentCatalogSettings.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(cpasParentCatalogSettings.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        cpasParentCatalogSettings.context = context;
        cpasParentCatalogSettings.rawValue = json;
        cpasParentCatalogSettings.header = header;
        return cpasParentCatalogSettings;
    }

    public static APINodeList<CPASParentCatalogSettings> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CPASParentCatalogSettings> cpasParentCatalogSettingss = new APINodeList<CPASParentCatalogSettings>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        cpasParentCatalogSettingss.add(CPASParentCatalogSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return cpasParentCatalogSettingss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            cpasParentCatalogSettingss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        cpasParentCatalogSettingss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            cpasParentCatalogSettingss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            cpasParentCatalogSettingss.add(CPASParentCatalogSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                cpasParentCatalogSettingss.add(CPASParentCatalogSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            cpasParentCatalogSettingss.add(CPASParentCatalogSettings.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return cpasParentCatalogSettingss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        cpasParentCatalogSettingss.add(CPASParentCatalogSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return cpasParentCatalogSettingss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        cpasParentCatalogSettingss.add(CPASParentCatalogSettings.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return cpasParentCatalogSettingss;
                }
                cpasParentCatalogSettingss.clear();
                cpasParentCatalogSettingss.add(CPASParentCatalogSettings.loadJSON(json, context, header));
                return cpasParentCatalogSettingss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CPASParentCatalogSettings.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAttributionWindows() {
        return this.mAttributionWindows;
    }

    public String getFieldDefaultCurrency() {
        return this.mDefaultCurrency;
    }

    public Boolean getFieldDisableUseAsParentCatalog() {
        return this.mDisableUseAsParentCatalog;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CPASParentCatalogSettings copyFrom(CPASParentCatalogSettings instance) {
        this.mAttributionWindows = instance.mAttributionWindows;
        this.mDefaultCurrency = instance.mDefaultCurrency;
        this.mDisableUseAsParentCatalog = instance.mDisableUseAsParentCatalog;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CPASParentCatalogSettings> getParser() {
        return new APIRequest.ResponseParser<CPASParentCatalogSettings>(){

            @Override
            public APINodeList<CPASParentCatalogSettings> parseResponse(String response, APIContext context, APIRequest<CPASParentCatalogSettings> request, String header) throws APIException.MalformedResponseException {
                return CPASParentCatalogSettings.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAttributionWindows {
        VALUE_DDA("DDA"),
        VALUE_DEFAULT("DEFAULT"),
        VALUE_X1D_CLICK("X1D_CLICK"),
        VALUE_X1D_VIEW("X1D_VIEW"),
        VALUE_X28D_CLICK("X28D_CLICK"),
        VALUE_X28D_VIEW("X28D_VIEW"),
        VALUE_X7D_CLICK("X7D_CLICK"),
        VALUE_X7D_VIEW("X7D_VIEW");

        private String value;

        private EnumAttributionWindows(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<CPASParentCatalogSettings> {
        CPASParentCatalogSettings lastResponse = null;
        public static final String[] PARAMS = new String[]{"attribution_windows"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CPASParentCatalogSettings getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CPASParentCatalogSettings parseResponse(String response, String header) throws APIException {
            return CPASParentCatalogSettings.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CPASParentCatalogSettings execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CPASParentCatalogSettings execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CPASParentCatalogSettings> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CPASParentCatalogSettings> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CPASParentCatalogSettings>(){

                public CPASParentCatalogSettings apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAttributionWindows(List<EnumAttributionWindows> attributionWindows) {
            this.setParam("attribution_windows", attributionWindows);
            return this;
        }

        public APIRequestUpdate setAttributionWindows(String attributionWindows) {
            this.setParam("attribution_windows", attributionWindows);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CPASParentCatalogSettings> {
        CPASParentCatalogSettings lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"attribution_windows", "default_currency", "disable_use_as_parent_catalog", "id"};

        @Override
        public CPASParentCatalogSettings getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CPASParentCatalogSettings parseResponse(String response, String header) throws APIException {
            return CPASParentCatalogSettings.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CPASParentCatalogSettings execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CPASParentCatalogSettings execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CPASParentCatalogSettings> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CPASParentCatalogSettings> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CPASParentCatalogSettings>(){

                public CPASParentCatalogSettings apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAttributionWindowsField() {
            return this.requestAttributionWindowsField(true);
        }

        public APIRequestGet requestAttributionWindowsField(boolean value) {
            this.requestField("attribution_windows", value);
            return this;
        }

        public APIRequestGet requestDefaultCurrencyField() {
            return this.requestDefaultCurrencyField(true);
        }

        public APIRequestGet requestDefaultCurrencyField(boolean value) {
            this.requestField("default_currency", value);
            return this;
        }

        public APIRequestGet requestDisableUseAsParentCatalogField() {
            return this.requestDisableUseAsParentCatalogField(true);
        }

        public APIRequestGet requestDisableUseAsParentCatalogField(boolean value) {
            this.requestField("disable_use_as_parent_catalog", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

