/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdoptablePet
extends APINode {
    @SerializedName(value="address")
    private Object mAddress = null;
    @SerializedName(value="adoptable_pet_id")
    private String mAdoptablePetId = null;
    @SerializedName(value="adoption_application_form_url")
    private String mAdoptionApplicationFormUrl = null;
    @SerializedName(value="age_bucket")
    private String mAgeBucket = null;
    @SerializedName(value="animal_type")
    private String mAnimalType = null;
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="availability")
    private String mAvailability = null;
    @SerializedName(value="breed")
    private String mBreed = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="coat_length")
    private String mCoatLength = null;
    @SerializedName(value="color")
    private String mColor = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="features")
    private List<String> mFeatures = null;
    @SerializedName(value="gender")
    private String mGender = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="price")
    private String mPrice = null;
    @SerializedName(value="sanitized_images")
    private List<String> mSanitizedImages = null;
    @SerializedName(value="secondary_color")
    private String mSecondaryColor = null;
    @SerializedName(value="shelter_email")
    private String mShelterEmail = null;
    @SerializedName(value="shelter_name")
    private String mShelterName = null;
    @SerializedName(value="shelter_page_id")
    private Page mShelterPageId = null;
    @SerializedName(value="shelter_phone")
    private String mShelterPhone = null;
    @SerializedName(value="size")
    private String mSize = null;
    @SerializedName(value="tertiary_color")
    private String mTertiaryColor = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    AdoptablePet() {
    }

    public AdoptablePet(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdoptablePet(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdoptablePet fetch() throws APIException {
        AdoptablePet newInstance = AdoptablePet.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdoptablePet fetchById(Long id, APIContext context) throws APIException {
        return AdoptablePet.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdoptablePet> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdoptablePet.fetchByIdAsync(id.toString(), context);
    }

    public static AdoptablePet fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdoptablePet> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdoptablePet> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdoptablePet>(context, "", "/", "GET", AdoptablePet.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdoptablePet>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdoptablePet>(context, "", "/", "GET", AdoptablePet.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdoptablePet loadJSON(String json, APIContext context, String header) {
        AdoptablePet adoptablePet = (AdoptablePet)AdoptablePet.getGson().fromJson(json, AdoptablePet.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adoptablePet.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adoptablePet.context = context;
        adoptablePet.rawValue = json;
        adoptablePet.header = header;
        return adoptablePet;
    }

    public static APINodeList<AdoptablePet> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdoptablePet> adoptablePets = new APINodeList<AdoptablePet>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adoptablePets.add(AdoptablePet.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adoptablePets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adoptablePets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adoptablePets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adoptablePets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adoptablePets.add(AdoptablePet.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adoptablePets.add(AdoptablePet.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adoptablePets.add(AdoptablePet.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adoptablePets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adoptablePets.add(AdoptablePet.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adoptablePets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adoptablePets.add(AdoptablePet.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adoptablePets;
                }
                adoptablePets.clear();
                adoptablePets.add(AdoptablePet.loadJSON(json, context, header));
                return adoptablePets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdoptablePet.getGson().toJson((Object)this);
    }

    public APIRequestGetAugmentedRealitiesMetadata getAugmentedRealitiesMetadata() {
        return new APIRequestGetAugmentedRealitiesMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideosMetadata getVideosMetadata() {
        return new APIRequestGetVideosMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldAddress() {
        return this.mAddress;
    }

    public String getFieldAdoptablePetId() {
        return this.mAdoptablePetId;
    }

    public String getFieldAdoptionApplicationFormUrl() {
        return this.mAdoptionApplicationFormUrl;
    }

    public String getFieldAgeBucket() {
        return this.mAgeBucket;
    }

    public String getFieldAnimalType() {
        return this.mAnimalType;
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public String getFieldAvailability() {
        return this.mAvailability;
    }

    public String getFieldBreed() {
        return this.mBreed;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public String getFieldCoatLength() {
        return this.mCoatLength;
    }

    public String getFieldColor() {
        return this.mColor;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public List<String> getFieldFeatures() {
        return this.mFeatures;
    }

    public String getFieldGender() {
        return this.mGender;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPrice() {
        return this.mPrice;
    }

    public List<String> getFieldSanitizedImages() {
        return this.mSanitizedImages;
    }

    public String getFieldSecondaryColor() {
        return this.mSecondaryColor;
    }

    public String getFieldShelterEmail() {
        return this.mShelterEmail;
    }

    public String getFieldShelterName() {
        return this.mShelterName;
    }

    public Page getFieldShelterPageId() {
        if (this.mShelterPageId != null) {
            this.mShelterPageId.context = this.getContext();
        }
        return this.mShelterPageId;
    }

    public String getFieldShelterPhone() {
        return this.mShelterPhone;
    }

    public String getFieldSize() {
        return this.mSize;
    }

    public String getFieldTertiaryColor() {
        return this.mTertiaryColor;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdoptablePet copyFrom(AdoptablePet instance) {
        this.mAddress = instance.mAddress;
        this.mAdoptablePetId = instance.mAdoptablePetId;
        this.mAdoptionApplicationFormUrl = instance.mAdoptionApplicationFormUrl;
        this.mAgeBucket = instance.mAgeBucket;
        this.mAnimalType = instance.mAnimalType;
        this.mApplinks = instance.mApplinks;
        this.mAvailability = instance.mAvailability;
        this.mBreed = instance.mBreed;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mCoatLength = instance.mCoatLength;
        this.mColor = instance.mColor;
        this.mCurrency = instance.mCurrency;
        this.mDescription = instance.mDescription;
        this.mFeatures = instance.mFeatures;
        this.mGender = instance.mGender;
        this.mId = instance.mId;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImages = instance.mImages;
        this.mName = instance.mName;
        this.mPrice = instance.mPrice;
        this.mSanitizedImages = instance.mSanitizedImages;
        this.mSecondaryColor = instance.mSecondaryColor;
        this.mShelterEmail = instance.mShelterEmail;
        this.mShelterName = instance.mShelterName;
        this.mShelterPageId = instance.mShelterPageId;
        this.mShelterPhone = instance.mShelterPhone;
        this.mSize = instance.mSize;
        this.mTertiaryColor = instance.mTertiaryColor;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdoptablePet> getParser() {
        return new APIRequest.ResponseParser<AdoptablePet>(){

            @Override
            public APINodeList<AdoptablePet> parseResponse(String response, APIContext context, APIRequest<AdoptablePet> request, String header) throws APIException.MalformedResponseException {
                return AdoptablePet.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdoptablePet> {
        AdoptablePet lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"address", "adoptable_pet_id", "adoption_application_form_url", "age_bucket", "animal_type", "applinks", "availability", "breed", "category_specific_fields", "coat_length", "color", "currency", "description", "features", "gender", "id", "image_fetch_status", "images", "name", "price", "sanitized_images", "secondary_color", "shelter_email", "shelter_name", "shelter_page_id", "shelter_phone", "size", "tertiary_color", "url"};

        @Override
        public AdoptablePet getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdoptablePet parseResponse(String response, String header) throws APIException {
            return AdoptablePet.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdoptablePet execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdoptablePet execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdoptablePet> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdoptablePet> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdoptablePet>(){

                public AdoptablePet apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGet requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGet requestAdoptablePetIdField() {
            return this.requestAdoptablePetIdField(true);
        }

        public APIRequestGet requestAdoptablePetIdField(boolean value) {
            this.requestField("adoptable_pet_id", value);
            return this;
        }

        public APIRequestGet requestAdoptionApplicationFormUrlField() {
            return this.requestAdoptionApplicationFormUrlField(true);
        }

        public APIRequestGet requestAdoptionApplicationFormUrlField(boolean value) {
            this.requestField("adoption_application_form_url", value);
            return this;
        }

        public APIRequestGet requestAgeBucketField() {
            return this.requestAgeBucketField(true);
        }

        public APIRequestGet requestAgeBucketField(boolean value) {
            this.requestField("age_bucket", value);
            return this;
        }

        public APIRequestGet requestAnimalTypeField() {
            return this.requestAnimalTypeField(true);
        }

        public APIRequestGet requestAnimalTypeField(boolean value) {
            this.requestField("animal_type", value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestAvailabilityField() {
            return this.requestAvailabilityField(true);
        }

        public APIRequestGet requestAvailabilityField(boolean value) {
            this.requestField("availability", value);
            return this;
        }

        public APIRequestGet requestBreedField() {
            return this.requestBreedField(true);
        }

        public APIRequestGet requestBreedField(boolean value) {
            this.requestField("breed", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestCoatLengthField() {
            return this.requestCoatLengthField(true);
        }

        public APIRequestGet requestCoatLengthField(boolean value) {
            this.requestField("coat_length", value);
            return this;
        }

        public APIRequestGet requestColorField() {
            return this.requestColorField(true);
        }

        public APIRequestGet requestColorField(boolean value) {
            this.requestField("color", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGet requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGet requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGet requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestSanitizedImagesField() {
            return this.requestSanitizedImagesField(true);
        }

        public APIRequestGet requestSanitizedImagesField(boolean value) {
            this.requestField("sanitized_images", value);
            return this;
        }

        public APIRequestGet requestSecondaryColorField() {
            return this.requestSecondaryColorField(true);
        }

        public APIRequestGet requestSecondaryColorField(boolean value) {
            this.requestField("secondary_color", value);
            return this;
        }

        public APIRequestGet requestShelterEmailField() {
            return this.requestShelterEmailField(true);
        }

        public APIRequestGet requestShelterEmailField(boolean value) {
            this.requestField("shelter_email", value);
            return this;
        }

        public APIRequestGet requestShelterNameField() {
            return this.requestShelterNameField(true);
        }

        public APIRequestGet requestShelterNameField(boolean value) {
            this.requestField("shelter_name", value);
            return this;
        }

        public APIRequestGet requestShelterPageIdField() {
            return this.requestShelterPageIdField(true);
        }

        public APIRequestGet requestShelterPageIdField(boolean value) {
            this.requestField("shelter_page_id", value);
            return this;
        }

        public APIRequestGet requestShelterPhoneField() {
            return this.requestShelterPhoneField(true);
        }

        public APIRequestGet requestShelterPhoneField(boolean value) {
            this.requestField("shelter_phone", value);
            return this;
        }

        public APIRequestGet requestSizeField() {
            return this.requestSizeField(true);
        }

        public APIRequestGet requestSizeField(boolean value) {
            this.requestField("size", value);
            return this;
        }

        public APIRequestGet requestTertiaryColorField() {
            return this.requestTertiaryColorField(true);
        }

        public APIRequestGet requestTertiaryColorField(boolean value) {
            this.requestField("tertiary_color", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetVideosMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetVideosMetadata.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideosMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/videos_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideosMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideosMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideosMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAugmentedRealitiesMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAugmentedRealitiesMetadata.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAugmentedRealitiesMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/augmented_realities_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAugmentedRealitiesMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

