/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.messenger;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.facebook.FacebookSdk;
import com.facebook.bolts.AppLinks;
import com.facebook.internal.FacebookSignatureValidator;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.messenger.MessengerThreadParams;
import com.facebook.messenger.ShareToMessengerParams;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$2\b\u0010%\u001a\u0004\u0018\u00010\u0004H\u0002J \u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J \u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/facebook/messenger/MessengerUtils;", "", "()V", "EXTRA_APP_ID", "", "EXTRA_EXTERNAL_URI", "EXTRA_IS_COMPOSE", "EXTRA_IS_REPLY", "EXTRA_METADATA", "EXTRA_PARTICIPANTS", "EXTRA_PROTOCOL_VERSION", "EXTRA_REPLY_TOKEN_KEY", "EXTRA_THREAD_TOKEN_KEY", "ORCA_THREAD_CATEGORY_20150314", "PACKAGE_NAME", "PROTOCOL_VERSION_20150314", "", "TAG", "finishShareToMessenger", "", "activity", "Landroid/app/Activity;", "shareToMessengerParams", "Lcom/facebook/messenger/ShareToMessengerParams;", "getAllAvailableProtocolVersions", "", "context", "Landroid/content/Context;", "getMessengerThreadParamsForIntent", "Lcom/facebook/messenger/MessengerThreadParams;", "intent", "Landroid/content/Intent;", "hasMessengerInstalled", "", "openMessengerInPlayStore", "parseParticipants", "", "s", "shareToMessenger", "requestCode", "shareToMessenger20150314", "startViewUri", "uri", "facebook-messenger_release"})
@SourceDebugExtension(value={"SMAP\nMessengerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessengerUtils.kt\ncom/facebook/messenger/MessengerUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,241:1\n37#2,2:242\n11335#3:244\n11670#3,2:245\n11672#3:270\n107#4:247\n79#4,22:248\n*S KotlinDebug\n*F\n+ 1 MessengerUtils.kt\ncom/facebook/messenger/MessengerUtils\n*L\n237#1:242,2\n238#1:244\n238#1:245,2\n238#1:270\n238#1:247\n238#1:248,22\n*E\n"})
public final class MessengerUtils {
    @NotNull
    public static final MessengerUtils INSTANCE = new MessengerUtils();
    @NotNull
    private static final String TAG = "MessengerUtils";
    @NotNull
    public static final String PACKAGE_NAME = "com.facebook.orca";
    @NotNull
    public static final String EXTRA_PROTOCOL_VERSION = "com.facebook.orca.extra.PROTOCOL_VERSION";
    @NotNull
    public static final String EXTRA_APP_ID = "com.facebook.orca.extra.APPLICATION_ID";
    @NotNull
    public static final String EXTRA_REPLY_TOKEN_KEY = "com.facebook.orca.extra.REPLY_TOKEN";
    @NotNull
    public static final String EXTRA_THREAD_TOKEN_KEY = "com.facebook.orca.extra.THREAD_TOKEN";
    @NotNull
    public static final String EXTRA_METADATA = "com.facebook.orca.extra.METADATA";
    @NotNull
    public static final String EXTRA_EXTERNAL_URI = "com.facebook.orca.extra.EXTERNAL_URI";
    @NotNull
    public static final String EXTRA_PARTICIPANTS = "com.facebook.orca.extra.PARTICIPANTS";
    @NotNull
    public static final String EXTRA_IS_REPLY = "com.facebook.orca.extra.IS_REPLY";
    @NotNull
    public static final String EXTRA_IS_COMPOSE = "com.facebook.orca.extra.IS_COMPOSE";
    public static final int PROTOCOL_VERSION_20150314 = 20150314;
    @NotNull
    public static final String ORCA_THREAD_CATEGORY_20150314 = "com.facebook.orca.category.PLATFORM_THREAD_20150314";

    private MessengerUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final void shareToMessenger(@NotNull Activity activity, int n, @NotNull ShareToMessengerParams shareToMessengerParams) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void shareToMessengerParams2;
            void activity2;
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)shareToMessengerParams2, (String)"shareToMessengerParams");
            if (!this.hasMessengerInstalled((Context)activity2)) {
                this.openMessengerInPlayStore((Context)activity2);
                return;
            }
            Set<Integer> allAvailableVersions = this.getAllAvailableProtocolVersions((Context)activity2);
            if (allAvailableVersions.contains(20150314)) {
                void requestCode;
                this.shareToMessenger20150314((Activity)activity2, (int)requestCode, (ShareToMessengerParams)shareToMessengerParams2);
            } else {
                this.openMessengerInPlayStore((Context)activity2);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    private final void shareToMessenger20150314(Activity activity, int requestCode, ShareToMessengerParams shareToMessengerParams) {
        try {
            Intent shareIntent = new Intent("android.intent.action.SEND");
            shareIntent.setFlags(1);
            shareIntent.setPackage(PACKAGE_NAME);
            shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)shareToMessengerParams.getUri());
            shareIntent.setType(shareToMessengerParams.getMimeType());
            shareIntent.putExtra(EXTRA_PROTOCOL_VERSION, 20150314);
            shareIntent.putExtra(EXTRA_APP_ID, FacebookSdk.getApplicationId());
            shareIntent.putExtra(EXTRA_METADATA, shareToMessengerParams.getMetaData());
            shareIntent.putExtra(EXTRA_EXTERNAL_URI, (Parcelable)shareToMessengerParams.getExternalUri());
            activity.startActivityForResult(shareIntent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            Intent openMessenger = activity.getPackageManager().getLaunchIntentForPackage(PACKAGE_NAME);
            activity.startActivity(openMessenger);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MessengerThreadParams getMessengerThreadParamsForIntent(@NotNull Intent intent) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            void intent2;
            Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
            Set set = intent2.getCategories();
            if (set == null) {
                return null;
            }
            Set categories = set;
            if (categories.contains(ORCA_THREAD_CATEGORY_20150314)) {
                MessengerThreadParams.Origin origin;
                Boolean isCompose;
                Bundle appLinkExtras;
                Bundle bundle = appLinkExtras = AppLinks.getAppLinkExtras((Intent)intent2);
                String threadToken = bundle != null ? bundle.getString(EXTRA_THREAD_TOKEN_KEY) : null;
                Bundle bundle2 = appLinkExtras;
                String metadata = bundle2 != null ? bundle2.getString(EXTRA_METADATA) : null;
                Bundle bundle3 = appLinkExtras;
                String participants = bundle3 != null ? bundle3.getString(EXTRA_PARTICIPANTS) : null;
                Bundle bundle4 = appLinkExtras;
                Boolean isReply = bundle4 != null ? Boolean.valueOf(bundle4.getBoolean(EXTRA_IS_REPLY)) : null;
                Bundle bundle5 = appLinkExtras;
                Boolean bl = isCompose = bundle5 != null ? Boolean.valueOf(bundle5.getBoolean(EXTRA_IS_COMPOSE)) : null;
                MessengerThreadParams.Origin origin2 = Intrinsics.areEqual((Object)isReply, (Object)true) ? MessengerThreadParams.Origin.REPLY_FLOW : (origin = Intrinsics.areEqual((Object)isCompose, (Object)true) ? MessengerThreadParams.Origin.COMPOSE_FLOW : MessengerThreadParams.Origin.UNKNOWN);
                if (threadToken != null && metadata != null) {
                    return new MessengerThreadParams(origin, threadToken, metadata, this.parseParticipants(participants));
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    public final void finishShareToMessenger(@NotNull Activity activity, @NotNull ShareToMessengerParams shareToMessengerParams) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)shareToMessengerParams, (String)"shareToMessengerParams");
        Intent originalIntent = activity.getIntent();
        Set categories = originalIntent.getCategories();
        if (categories == null) {
            activity.setResult(0, null);
            activity.finish();
            return;
        }
        if (categories.contains(ORCA_THREAD_CATEGORY_20150314)) {
            Intrinsics.checkNotNullExpressionValue((Object)originalIntent, (String)"originalIntent");
            Bundle appLinkExtras = AppLinks.getAppLinkExtras((Intent)originalIntent);
            Intent resultIntent = new Intent();
            if (appLinkExtras == null || !categories.contains(ORCA_THREAD_CATEGORY_20150314)) {
                throw new RuntimeException();
            }
            resultIntent.putExtra(EXTRA_PROTOCOL_VERSION, 20150314);
            String threadToken = appLinkExtras.getString(EXTRA_THREAD_TOKEN_KEY);
            resultIntent.putExtra(EXTRA_THREAD_TOKEN_KEY, threadToken);
            resultIntent.setDataAndType(shareToMessengerParams.getUri(), shareToMessengerParams.getMimeType());
            resultIntent.setFlags(1);
            resultIntent.putExtra(EXTRA_APP_ID, FacebookSdk.getApplicationId());
            resultIntent.putExtra(EXTRA_METADATA, shareToMessengerParams.getMetaData());
            resultIntent.putExtra(EXTRA_EXTERNAL_URI, (Parcelable)shareToMessengerParams.getExternalUri());
            activity.setResult(-1, resultIntent);
            activity.finish();
        } else {
            activity.setResult(0, null);
            activity.finish();
        }
    }

    public final boolean hasMessengerInstalled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return FacebookSignatureValidator.validateSignature((Context)context, (String)PACKAGE_NAME);
    }

    /*
     * WARNING - void declaration
     */
    public final void openMessengerInPlayStore(@NotNull Context context) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void context2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                this.startViewUri((Context)context2, "market://details?id=com.facebook.orca");
            }
            catch (ActivityNotFoundException anfe) {
                this.startViewUri((Context)context2, "http://play.google.com/store/apps/details?id=com.facebook.orca");
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<Integer> getAllAvailableProtocolVersions(Context context) {
        Cursor cursor;
        ContentResolver contentResolver = context.getContentResolver();
        Set allAvailableVersions = new HashSet();
        Uri uri = Uri.parse((String)"content://com.facebook.orca.provider.MessengerPlatformProvider/versions");
        String[] stringArray = new String[]{"version"};
        String[] projection = stringArray;
        Cursor cursor2 = cursor = contentResolver.query(uri, projection, null, null, null);
        if (cursor2 != null) {
            Closeable closeable = (Closeable)cursor2;
            Throwable throwable = null;
            try {
                Cursor c = (Cursor)closeable;
                boolean bl = false;
                int versionColumnIndex = c.getColumnIndex("version");
                while (c.moveToNext()) {
                    allAvailableVersions.add(c.getInt(versionColumnIndex));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return allAvailableVersions;
    }

    private final void startViewUri(Context context, String uri) {
        context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)uri)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseParticipants(String s) {
        void $this$mapTo$iv$iv;
        String[] parts;
        CharSequence charSequence = s;
        if (charSequence == null || charSequence.length() == 0) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = new String[]{","};
        String[] $this$toTypedArray$iv = (String[])StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] $this$map$iv = parts = thisCollection$iv.toArray(new String[0]);
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$trim$iv = it;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char c = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)c, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            collection.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        return (List)destination$iv$iv;
    }
}

