/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.Profile;
import com.facebook.ProfileTracker;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 T2\u00020\u0001:\u0002TUB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\u0011H\u0003J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020#H\u0002J\b\u00105\u001a\u000206H\u0003J\b\u00107\u001a\u00020\u0011H\u0002J\b\u00108\u001a\u000206H\u0014J0\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tH\u0014J\u0018\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020\tH\u0014J\u0010\u0010B\u001a\u0002062\u0006\u0010C\u001a\u00020DH\u0014J\b\u0010E\u001a\u00020DH\u0014J\u0010\u0010F\u001a\u0002062\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u0012\u0010G\u001a\u0002062\b\u0010H\u001a\u0004\u0018\u00010IH\u0003J\u0010\u0010J\u001a\u0002062\u0006\u0010K\u001a\u00020\u0011H\u0003J\u0010\u0010L\u001a\u0002062\u0006\u0010M\u001a\u00020\u0011H\u0003J\b\u0010N\u001a\u000206H\u0003J\u0010\u0010O\u001a\u0002062\b\u0010P\u001a\u0004\u0018\u00010\fJ\u0012\u0010Q\u001a\u0002062\b\u0010R\u001a\u0004\u0018\u00010\fH\u0003J\b\u0010S\u001a\u00020\u0011H\u0003R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u0010\u001a\u0004\u0018\u00010#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010-\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0013\"\u0004\b/\u0010\u0015\u00a8\u0006V"}, d2={"Lcom/facebook/login/widget/ProfilePictureView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "customizedDefaultProfilePicture", "Landroid/graphics/Bitmap;", "image", "Landroid/widget/ImageView;", "imageContents", "value", "", "isCropped", "()Z", "setCropped", "(Z)V", "lastRequest", "Lcom/facebook/internal/ImageRequest;", "onErrorListener", "Lcom/facebook/login/widget/ProfilePictureView$OnErrorListener;", "getOnErrorListener", "()Lcom/facebook/login/widget/ProfilePictureView$OnErrorListener;", "setOnErrorListener", "(Lcom/facebook/login/widget/ProfilePictureView$OnErrorListener;)V", "presetSize", "getPresetSize", "()I", "setPresetSize", "(I)V", "", "profileId", "getProfileId", "()Ljava/lang/String;", "setProfileId", "(Ljava/lang/String;)V", "profileTracker", "Lcom/facebook/ProfileTracker;", "queryHeight", "queryWidth", "shouldUpdateOnProfileChange", "getShouldUpdateOnProfileChange", "setShouldUpdateOnProfileChange", "getPresetSizeInPixels", "forcePreset", "getProfilePictureUri", "Landroid/net/Uri;", "accessToken", "initialize", "", "isUnspecifiedDimensions", "onDetachedFromWindow", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "parseAttributes", "processResponse", "response", "Lcom/facebook/internal/ImageResponse;", "refreshImage", "force", "sendImageRequest", "allowCachedResponse", "setBlankProfilePicture", "setDefaultProfilePicture", "inputBitmap", "setImageBitmap", "imageBitmap", "updateImageQueryParameters", "Companion", "OnErrorListener", "facebook-login_release"})
@SourceDebugExtension(value={"SMAP\nProfilePictureView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilePictureView.kt\ncom/facebook/login/widget/ProfilePictureView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,469:1\n1#2:470\n*E\n"})
public final class ProfilePictureView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageView image;
    private int queryHeight;
    private int queryWidth;
    @Nullable
    private Bitmap imageContents;
    @Nullable
    private ImageRequest lastRequest;
    @Nullable
    private Bitmap customizedDefaultProfilePicture;
    @Nullable
    private ProfileTracker profileTracker;
    @Nullable
    private String profileId;
    private boolean isCropped;
    @Nullable
    private OnErrorListener onErrorListener;
    private int presetSize;
    @NotNull
    private static final String TAG;
    public static final int CUSTOM = -1;
    public static final int SMALL = -2;
    public static final int NORMAL = -3;
    public static final int LARGE = -4;
    private static final int MIN_SIZE = 1;
    private static final boolean IS_CROPPED_DEFAULT_VALUE = true;
    @NotNull
    private static final String SUPER_STATE_KEY = "ProfilePictureView_superState";
    @NotNull
    private static final String PROFILE_ID_KEY = "ProfilePictureView_profileId";
    @NotNull
    private static final String PRESET_SIZE_KEY = "ProfilePictureView_presetSize";
    @NotNull
    private static final String IS_CROPPED_KEY = "ProfilePictureView_isCropped";
    @NotNull
    private static final String BITMAP_KEY = "ProfilePictureView_bitmap";
    @NotNull
    private static final String BITMAP_WIDTH_KEY = "ProfilePictureView_width";
    @NotNull
    private static final String BITMAP_HEIGHT_KEY = "ProfilePictureView_height";
    @NotNull
    private static final String PENDING_REFRESH_KEY = "ProfilePictureView_refresh";

    @Nullable
    public final String getProfileId() {
        return this.profileId;
    }

    public final void setProfileId(@Nullable String value) {
        boolean force = false;
        CharSequence charSequence = this.profileId;
        if (charSequence == null || charSequence.length() == 0 || !StringsKt.equals((String)this.profileId, (String)value, (boolean)true)) {
            this.setBlankProfilePicture();
            force = true;
        }
        this.profileId = value;
        this.refreshImage(force);
    }

    public final boolean isCropped() {
        return this.isCropped;
    }

    public final void setCropped(boolean value) {
        this.isCropped = value;
        this.refreshImage(false);
    }

    @Nullable
    public final OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public final void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public final int getPresetSize() {
        return this.presetSize;
    }

    public final void setPresetSize(int value) {
        switch (value) {
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                this.presetSize = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Must use a predefined preset size");
            }
        }
        this.requestLayout();
    }

    public final boolean getShouldUpdateOnProfileChange() {
        ProfileTracker profileTracker = this.profileTracker;
        return profileTracker != null ? profileTracker.isTracking() : false;
    }

    public final void setShouldUpdateOnProfileChange(boolean value) {
        block1: {
            block0: {
                if (!value) break block0;
                ProfileTracker profileTracker = this.profileTracker;
                if (profileTracker == null) break block1;
                profileTracker.startTracking();
                break block1;
            }
            ProfileTracker profileTracker = this.profileTracker;
            if (profileTracker == null) break block1;
            profileTracker.stopTracking();
        }
    }

    public ProfilePictureView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.image = new ImageView(this.getContext());
        this.isCropped = true;
        this.presetSize = -1;
        this.initialize();
    }

    public ProfilePictureView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.image = new ImageView(this.getContext());
        this.isCropped = true;
        this.presetSize = -1;
        this.initialize();
        this.parseAttributes(attrs);
    }

    public ProfilePictureView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.image = new ImageView(this.getContext());
        this.isCropped = true;
        this.presetSize = -1;
        this.initialize();
        this.parseAttributes(attrs);
    }

    private final void initialize() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            this.removeAllViews();
            FrameLayout.LayoutParams imageLayout = new FrameLayout.LayoutParams(-1, -1);
            this.image.setLayoutParams((ViewGroup.LayoutParams)imageLayout);
            this.image.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            this.addView((View)this.image);
            this.profileTracker = new ProfileTracker(this){
                final /* synthetic */ ProfilePictureView this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void onCurrentProfileChanged(@Nullable Profile oldProfile, @Nullable Profile currentProfile) {
                    Profile profile = currentProfile;
                    this.this$0.setProfileId(profile != null ? profile.getId() : null);
                    ProfilePictureView.access$refreshImage(this.this$0, true);
                }
            };
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    public final void setDefaultProfilePicture(@Nullable Bitmap inputBitmap) {
        this.customizedDefaultProfilePicture = inputBitmap;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMeasure = widthMeasureSpec;
        int heightMeasure = heightMeasureSpec;
        ViewGroup.LayoutParams params = this.getLayoutParams();
        boolean customMeasure = false;
        int newHeight = View.MeasureSpec.getSize((int)heightMeasure);
        int newWidth = View.MeasureSpec.getSize((int)widthMeasure);
        if (View.MeasureSpec.getMode((int)heightMeasure) != 0x40000000 && params.height == -2) {
            newHeight = this.getPresetSizeInPixels(true);
            heightMeasure = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
            customMeasure = true;
        }
        if (View.MeasureSpec.getMode((int)widthMeasure) != 0x40000000 && params.width == -2) {
            newWidth = this.getPresetSizeInPixels(true);
            widthMeasure = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
            customMeasure = true;
        }
        if (customMeasure) {
            this.setMeasuredDimension(newWidth, newHeight);
            this.measureChildren(widthMeasure, heightMeasure);
        } else {
            super.onMeasure(widthMeasure, heightMeasure);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.refreshImage(false);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle instanceState = new Bundle();
        instanceState.putParcelable(SUPER_STATE_KEY, superState);
        instanceState.putString(PROFILE_ID_KEY, this.profileId);
        instanceState.putInt(PRESET_SIZE_KEY, this.presetSize);
        instanceState.putBoolean(IS_CROPPED_KEY, this.isCropped);
        instanceState.putInt(BITMAP_WIDTH_KEY, this.queryWidth);
        instanceState.putInt(BITMAP_HEIGHT_KEY, this.queryHeight);
        instanceState.putBoolean(PENDING_REFRESH_KEY, this.lastRequest != null);
        return (Parcelable)instanceState;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!Intrinsics.areEqual(state.getClass(), Bundle.class)) {
            super.onRestoreInstanceState(state);
        } else {
            Bundle instanceState = (Bundle)state;
            super.onRestoreInstanceState(instanceState.getParcelable(SUPER_STATE_KEY));
            this.setProfileId(instanceState.getString(PROFILE_ID_KEY));
            this.setPresetSize(instanceState.getInt(PRESET_SIZE_KEY));
            this.setCropped(instanceState.getBoolean(IS_CROPPED_KEY));
            this.queryWidth = instanceState.getInt(BITMAP_WIDTH_KEY);
            this.queryHeight = instanceState.getInt(BITMAP_HEIGHT_KEY);
            this.refreshImage(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.lastRequest = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void parseAttributes(AttributeSet attributeSet) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void attrs;
            TypedArray typedArray = this.getContext().obtainStyledAttributes((AttributeSet)attrs, R.styleable.com_facebook_profile_picture_view);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026ook_profile_picture_view)");
            TypedArray a = typedArray;
            this.setPresetSize(a.getInt(R.styleable.com_facebook_profile_picture_view_com_facebook_preset_size, -1));
            this.setCropped(a.getBoolean(R.styleable.com_facebook_profile_picture_view_com_facebook_is_cropped, true));
            a.recycle();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshImage(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void force;
            boolean changed = this.updateImageQueryParameters();
            String profileId = this.profileId;
            if (profileId == null || ((CharSequence)profileId).length() == 0 || this.isUnspecifiedDimensions()) {
                this.setBlankProfilePicture();
            } else if (changed || force != false) {
                this.sendImageRequest(true);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    private final boolean isUnspecifiedDimensions() {
        return this.queryWidth == 0 && this.queryHeight == 0;
    }

    private final void setBlankProfilePicture() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            ImageRequest imageRequest = this.lastRequest;
            if (imageRequest != null) {
                ImageRequest it = imageRequest;
                boolean bl = false;
                ImageDownloader.cancelRequest((ImageRequest)it);
            }
            Bitmap customizedPicture = this.customizedDefaultProfilePicture;
            if (customizedPicture == null) {
                int blankImageResource = this.isCropped ? R.drawable.com_facebook_profile_picture_blank_square : R.drawable.com_facebook_profile_picture_blank_portrait;
                this.setImageBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)blankImageResource));
            } else {
                this.updateImageQueryParameters();
                Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)customizedPicture, (int)this.queryWidth, (int)this.queryHeight, (boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createScaledBitmap(custo\u2026idth, queryHeight, false)");
                Bitmap scaledBitmap = bitmap;
                this.setImageBitmap(scaledBitmap);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setImageBitmap(Bitmap bitmap) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void imageBitmap;
            void v0 = imageBitmap;
            if (v0 != null) {
                void it = v0;
                boolean bl = false;
                this.imageContents = it;
                this.image.setImageBitmap((Bitmap)it);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendImageRequest(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void allowCachedResponse;
            String string2;
            if (AccessToken.Companion.isCurrentAccessTokenActive()) {
                string2 = AccessToken.Companion.getCurrentAccessToken();
                if (string2 == null || (string2 = string2.getToken()) == null) {
                    string2 = "";
                }
            } else {
                string2 = "";
            }
            String accessToken = string2;
            Uri profilePictureUri = this.getProfilePictureUri(accessToken);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            ImageRequest request = new ImageRequest.Builder(context, profilePictureUri).setAllowCachedRedirects((boolean)allowCachedResponse).setCallerTag((Object)this).setCallback(arg_0 -> ProfilePictureView.sendImageRequest$lambda$2(this, arg_0)).build();
            ImageRequest imageRequest = this.lastRequest;
            if (imageRequest != null) {
                ImageRequest it = imageRequest;
                boolean bl2 = false;
                ImageDownloader.cancelRequest((ImageRequest)it);
            }
            this.lastRequest = request;
            ImageDownloader.downloadAsync((ImageRequest)request);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    private final Uri getProfilePictureUri(String accessToken) {
        Profile currentProfile = Profile.Companion.getCurrentProfile();
        return currentProfile != null && AccessToken.Companion.isLoggedInWithInstagram() ? currentProfile.getProfilePictureUri(this.queryWidth, this.queryHeight) : ImageRequest.Companion.getProfilePictureUri(this.profileId, this.queryWidth, this.queryHeight, accessToken);
    }

    /*
     * WARNING - void declaration
     */
    private final void processResponse(ImageResponse imageResponse) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void response;
            if (response == null || !Intrinsics.areEqual((Object)response.getRequest(), (Object)this.lastRequest)) {
                return;
            }
            this.lastRequest = null;
            Bitmap responseImage = response.getBitmap();
            Exception error = response.getError();
            if (error != null) {
                OnErrorListener listener = this.onErrorListener;
                if (listener != null) {
                    listener.onError(new FacebookException("Error in downloading profile picture for profileId: " + this.profileId, (Throwable)error));
                } else {
                    Logger.Companion.log(LoggingBehavior.REQUESTS, 6, TAG, error.toString());
                }
            } else {
                Bitmap bitmap = responseImage;
                if (bitmap != null) {
                    Bitmap it = bitmap;
                    boolean bl = false;
                    this.setImageBitmap(it);
                    if (response.isCachedRedirect()) {
                        this.sendImageRequest(false);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    private final boolean updateImageQueryParameters() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return false;
        }
        try {
            int newHeightPx = this.getHeight();
            int newWidthPx = this.getWidth();
            if (newWidthPx < 1 || newHeightPx < 1) {
                return false;
            }
            int presetSize = this.getPresetSizeInPixels(false);
            if (presetSize != 0) {
                newWidthPx = presetSize;
                newHeightPx = presetSize;
            }
            if (newWidthPx <= newHeightPx) {
                newHeightPx = this.isCropped ? newWidthPx : 0;
            } else {
                newWidthPx = this.isCropped ? newHeightPx : 0;
            }
            boolean changed = newWidthPx != this.queryWidth || newHeightPx != this.queryHeight;
            this.queryWidth = newWidthPx;
            this.queryHeight = newHeightPx;
            return changed;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getPresetSizeInPixels(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            int n;
            void forcePreset;
            if (this.presetSize == -1 && forcePreset == false) {
                return 0;
            }
            switch (this.presetSize) {
                case -2: {
                    n = R.dimen.com_facebook_profilepictureview_preset_size_small;
                    break;
                }
                case -3: {
                    n = R.dimen.com_facebook_profilepictureview_preset_size_normal;
                    break;
                }
                case -4: {
                    n = R.dimen.com_facebook_profilepictureview_preset_size_large;
                    break;
                }
                case -1: {
                    n = R.dimen.com_facebook_profilepictureview_preset_size_normal;
                    break;
                }
                default: {
                    return 0;
                }
            }
            int dimensionId = n;
            return this.getResources().getDimensionPixelSize(dimensionId);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    private static final void sendImageRequest$lambda$2(ProfilePictureView this$0, ImageResponse response) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.processResponse(response);
    }

    public static final /* synthetic */ void access$refreshImage(ProfilePictureView $this, boolean force) {
        $this.refreshImage(force);
    }

    static {
        String string2 = ProfilePictureView.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProfilePictureView::class.java.simpleName");
        TAG = string2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/facebook/login/widget/ProfilePictureView$Companion;", "", "()V", "BITMAP_HEIGHT_KEY", "", "BITMAP_KEY", "BITMAP_WIDTH_KEY", "CUSTOM", "", "IS_CROPPED_DEFAULT_VALUE", "", "IS_CROPPED_KEY", "LARGE", "MIN_SIZE", "NORMAL", "PENDING_REFRESH_KEY", "PRESET_SIZE_KEY", "PROFILE_ID_KEY", "SMALL", "SUPER_STATE_KEY", "TAG", "getTAG", "()Ljava/lang/String;", "facebook-login_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/login/widget/ProfilePictureView$OnErrorListener;", "", "onError", "", "error", "Lcom/facebook/FacebookException;", "facebook-login_release"})
    public static interface OnErrorListener {
        public void onError(@NotNull FacebookException var1);
    }
}

