/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.content.SharedPreferences;
import android.view.View;
import com.facebook.FacebookSdk;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\b\u0010\u0014\u001a\u00020\rH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/appevents/suggestedevents/PredictionHistoryManager;", "", "()V", "CLICKED_PATH_STORE", "", "SUGGESTED_EVENTS_HISTORY", "clickedViewPaths", "", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "shardPreferences", "Landroid/content/SharedPreferences;", "addPrediction", "", "pathID", "predictedEvent", "getPathID", "view", "Landroid/view/View;", "text", "initAndWait", "queryEvent", "facebook-core_release"})
public final class PredictionHistoryManager {
    @NotNull
    public static final PredictionHistoryManager INSTANCE = new PredictionHistoryManager();
    @NotNull
    private static final Map<String, String> clickedViewPaths = new LinkedHashMap();
    @NotNull
    private static final String SUGGESTED_EVENTS_HISTORY = "SUGGESTED_EVENTS_HISTORY";
    @NotNull
    private static final String CLICKED_PATH_STORE = "com.facebook.internal.SUGGESTED_EVENTS_HISTORY";
    private static SharedPreferences shardPreferences;
    @NotNull
    private static final AtomicBoolean initialized;

    private PredictionHistoryManager() {
    }

    private final void initAndWait() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            String string;
            if (initialized.get()) {
                return;
            }
            SharedPreferences sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(CLICKED_PATH_STORE, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getApplicationContext()\n\u2026RE, Context.MODE_PRIVATE)");
            shardPreferences = sharedPreferences;
            SharedPreferences sharedPreferences2 = shardPreferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shardPreferences");
                sharedPreferences2 = null;
            }
            if ((string = sharedPreferences2.getString(SUGGESTED_EVENTS_HISTORY, "")) == null) {
                string = "";
            }
            clickedViewPaths.putAll(Utility.jsonStrToMap(string));
            initialized.set(true);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void addPrediction(@NotNull String string, @NotNull String string2) {
        if (CrashShieldHandler.isObjectCrashing(PredictionHistoryManager.class)) {
            return;
        }
        try {
            void predictedEvent;
            String pathID;
            Intrinsics.checkNotNullParameter((Object)pathID, (String)"pathID");
            Intrinsics.checkNotNullParameter((Object)predictedEvent, (String)"predictedEvent");
            if (!initialized.get()) {
                INSTANCE.initAndWait();
            }
            clickedViewPaths.put(pathID, (String)predictedEvent);
            SharedPreferences sharedPreferences = shardPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shardPreferences");
                sharedPreferences = null;
            }
            sharedPreferences.edit().putString(SUGGESTED_EVENTS_HISTORY, Utility.mapToJsonStr(MapsKt.toMap(clickedViewPaths))).apply();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PredictionHistoryManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final String getPathID(@NotNull View view, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(PredictionHistoryManager.class)) {
            return null;
        }
        try {
            void text;
            View view2;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            View view3 = view2;
            JSONObject pathRoute = new JSONObject();
            try {
                pathRoute.put("text", (Object)text);
                JSONArray currentPath = new JSONArray();
                while (view3 != null) {
                    currentPath.put((Object)view3.getClass().getSimpleName());
                    view3 = (View)ViewHierarchy.getParentOfView(view3);
                }
                pathRoute.put("classname", (Object)currentPath);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Utility.sha256hash(pathRoute.toString());
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PredictionHistoryManager.class);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String queryEvent(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(PredictionHistoryManager.class)) {
            return null;
        }
        try {
            String pathID;
            Intrinsics.checkNotNullParameter((Object)pathID, (String)"pathID");
            return clickedViewPaths.containsKey(pathID) ? clickedViewPaths.get(pathID) : null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PredictionHistoryManager.class);
            return null;
        }
    }

    static {
        initialized = new AtomicBoolean(false);
    }
}

