/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.facebook.appevents.iap.InAppPurchaseBillingClientWrapper;
import com.facebook.appevents.iap.InAppPurchaseBillingClientWrapperV2V4;
import com.facebook.appevents.iap.InAppPurchaseBillingClientWrapperV5V7;
import com.facebook.appevents.iap.InAppPurchaseLoggerManager;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.appevents.integrity.ProtectedModeManager;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseAutoLogger;", "", "()V", "failedToCreateWrapper", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getFailedToCreateWrapper", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "logPurchase", "", "billingClientVersion", "Lcom/facebook/appevents/iap/InAppPurchaseUtils$BillingClientVersion;", "packageName", "", "startIapLogging", "context", "Landroid/content/Context;", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseAutoLogger {
    @NotNull
    public static final InAppPurchaseAutoLogger INSTANCE = new InAppPurchaseAutoLogger();
    @NotNull
    private static final AtomicBoolean failedToCreateWrapper = new AtomicBoolean(false);

    private InAppPurchaseAutoLogger() {
    }

    @NotNull
    public final AtomicBoolean getFailedToCreateWrapper() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            return failedToCreateWrapper;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final synchronized void startIapLogging(@NotNull Context context, @NotNull InAppPurchaseUtils.BillingClientVersion billingClientVersion) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            void billingClientVersion2;
            Context context2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)billingClientVersion2, (String)"billingClientVersion");
            if (failedToCreateWrapper.get()) {
                return;
            }
            Ref.ObjectRef billingClientWrapper = new Ref.ObjectRef();
            if (billingClientVersion2 == InAppPurchaseUtils.BillingClientVersion.V2_V4) {
                billingClientWrapper.element = InAppPurchaseBillingClientWrapperV2V4.Companion.getOrCreateInstance(context2);
            } else if (billingClientVersion2 == InAppPurchaseUtils.BillingClientVersion.V5_V7) {
                billingClientWrapper.element = InAppPurchaseBillingClientWrapperV5V7.Companion.getOrCreateInstance(context2);
            }
            if (billingClientWrapper.element == null) {
                failedToCreateWrapper.set(true);
                return;
            }
            if (FeatureManager.isEnabled(FeatureManager.Feature.AndroidIAPSubscriptionAutoLogging) && (!ProtectedModeManager.isEnabled() || billingClientVersion2 == InAppPurchaseUtils.BillingClientVersion.V2_V4)) {
                ((InAppPurchaseBillingClientWrapper)billingClientWrapper.element).queryPurchaseHistory(InAppPurchaseUtils.IAPProductType.INAPP, () -> InAppPurchaseAutoLogger.startIapLogging$lambda$1(billingClientWrapper, (InAppPurchaseUtils.BillingClientVersion)billingClientVersion2, context2));
            } else {
                ((InAppPurchaseBillingClientWrapper)billingClientWrapper.element).queryPurchaseHistory(InAppPurchaseUtils.IAPProductType.INAPP, () -> InAppPurchaseAutoLogger.startIapLogging$lambda$2((InAppPurchaseUtils.BillingClientVersion)billingClientVersion2, context2));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logPurchase(InAppPurchaseUtils.BillingClientVersion billingClientVersion, String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void packageName;
            void billingClientVersion2;
            boolean isFirstAppLaunch = InAppPurchaseLoggerManager.getIsFirstAppLaunchWithNewIAP();
            if (isFirstAppLaunch) {
                InAppPurchaseLoggerManager.migrateOldCacheHistory();
            }
            if (billingClientVersion2 == InAppPurchaseUtils.BillingClientVersion.V2_V4) {
                InAppPurchaseLoggerManager.filterPurchaseLogging(InAppPurchaseBillingClientWrapperV2V4.Companion.getIapPurchaseDetailsMap(), InAppPurchaseBillingClientWrapperV2V4.Companion.getSkuDetailsMap(), false, (String)packageName, (InAppPurchaseUtils.BillingClientVersion)billingClientVersion2, isFirstAppLaunch);
                InAppPurchaseLoggerManager.filterPurchaseLogging(InAppPurchaseBillingClientWrapperV2V4.Companion.getSubsPurchaseDetailsMap(), InAppPurchaseBillingClientWrapperV2V4.Companion.getSkuDetailsMap(), true, (String)packageName, (InAppPurchaseUtils.BillingClientVersion)billingClientVersion2, isFirstAppLaunch);
                InAppPurchaseBillingClientWrapperV2V4.Companion.getIapPurchaseDetailsMap().clear();
                InAppPurchaseBillingClientWrapperV2V4.Companion.getSubsPurchaseDetailsMap().clear();
            } else {
                InAppPurchaseLoggerManager.filterPurchaseLogging(InAppPurchaseBillingClientWrapperV5V7.Companion.getIapPurchaseDetailsMap(), InAppPurchaseBillingClientWrapperV5V7.Companion.getProductDetailsMap(), false, (String)packageName, (InAppPurchaseUtils.BillingClientVersion)billingClientVersion2, isFirstAppLaunch);
                InAppPurchaseLoggerManager.filterPurchaseLogging(InAppPurchaseBillingClientWrapperV5V7.Companion.getSubsPurchaseDetailsMap(), InAppPurchaseBillingClientWrapperV5V7.Companion.getProductDetailsMap(), true, (String)packageName, (InAppPurchaseUtils.BillingClientVersion)billingClientVersion2, isFirstAppLaunch);
                InAppPurchaseBillingClientWrapperV5V7.Companion.getIapPurchaseDetailsMap().clear();
                InAppPurchaseBillingClientWrapperV5V7.Companion.getSubsPurchaseDetailsMap().clear();
            }
            if (isFirstAppLaunch) {
                InAppPurchaseLoggerManager.setAppHasBeenLaunchedWithNewIAP();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void startIapLogging$lambda$1$lambda$0(InAppPurchaseUtils.BillingClientVersion billingClientVersion, Context context) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            void $context;
            InAppPurchaseUtils.BillingClientVersion $billingClientVersion;
            Intrinsics.checkNotNullParameter((Object)((Object)$billingClientVersion), (String)"$billingClientVersion");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            String string = $context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
            INSTANCE.logPurchase($billingClientVersion, string);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void startIapLogging$lambda$1(Ref.ObjectRef objectRef, InAppPurchaseUtils.BillingClientVersion billingClientVersion, Context context) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            void $context;
            void $billingClientVersion;
            Ref.ObjectRef $billingClientWrapper;
            Intrinsics.checkNotNullParameter((Object)$billingClientWrapper, (String)"$billingClientWrapper");
            Intrinsics.checkNotNullParameter((Object)$billingClientVersion, (String)"$billingClientVersion");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            ((InAppPurchaseBillingClientWrapper)$billingClientWrapper.element).queryPurchaseHistory(InAppPurchaseUtils.IAPProductType.SUBS, () -> InAppPurchaseAutoLogger.startIapLogging$lambda$1$lambda$0((InAppPurchaseUtils.BillingClientVersion)$billingClientVersion, (Context)$context));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void startIapLogging$lambda$2(InAppPurchaseUtils.BillingClientVersion billingClientVersion, Context context) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseAutoLogger.class)) {
            return;
        }
        try {
            void $context;
            InAppPurchaseUtils.BillingClientVersion $billingClientVersion;
            Intrinsics.checkNotNullParameter((Object)((Object)$billingClientVersion), (String)"$billingClientVersion");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            String string = $context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
            INSTANCE.logPurchase($billingClientVersion, string);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseAutoLogger.class);
            return;
        }
    }
}

