/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import com.facebook.appevents.codeless.internal.ParameterComponent;
import com.facebook.appevents.codeless.internal.PathComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0003!\"#BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u00a8\u0006$"}, d2={"Lcom/facebook/appevents/codeless/internal/EventBinding;", "", "eventName", "", "method", "Lcom/facebook/appevents/codeless/internal/EventBinding$MappingMethod;", "type", "Lcom/facebook/appevents/codeless/internal/EventBinding$ActionType;", "appVersion", "path", "", "Lcom/facebook/appevents/codeless/internal/PathComponent;", "parameters", "Lcom/facebook/appevents/codeless/internal/ParameterComponent;", "componentId", "pathType", "activityName", "(Ljava/lang/String;Lcom/facebook/appevents/codeless/internal/EventBinding$MappingMethod;Lcom/facebook/appevents/codeless/internal/EventBinding$ActionType;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getActivityName", "()Ljava/lang/String;", "getAppVersion", "getComponentId", "getEventName", "getMethod", "()Lcom/facebook/appevents/codeless/internal/EventBinding$MappingMethod;", "getPathType", "getType", "()Lcom/facebook/appevents/codeless/internal/EventBinding$ActionType;", "viewParameters", "getViewParameters", "()Ljava/util/List;", "viewPath", "getViewPath", "ActionType", "Companion", "MappingMethod", "facebook-core_release"})
public final class EventBinding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String eventName;
    @NotNull
    private final MappingMethod method;
    @NotNull
    private final ActionType type;
    @NotNull
    private final String appVersion;
    @NotNull
    private final List<PathComponent> path;
    @NotNull
    private final List<ParameterComponent> parameters;
    @NotNull
    private final String componentId;
    @NotNull
    private final String pathType;
    @NotNull
    private final String activityName;

    public EventBinding(@NotNull String eventName, @NotNull MappingMethod method, @NotNull ActionType type, @NotNull String appVersion, @NotNull List<PathComponent> path, @NotNull List<ParameterComponent> parameters, @NotNull String componentId, @NotNull String pathType, @NotNull String activityName) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)appVersion, (String)"appVersion");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        Intrinsics.checkNotNullParameter((Object)pathType, (String)"pathType");
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        this.eventName = eventName;
        this.method = method;
        this.type = type;
        this.appVersion = appVersion;
        this.path = path;
        this.parameters = parameters;
        this.componentId = componentId;
        this.pathType = pathType;
        this.activityName = activityName;
    }

    @NotNull
    public final String getEventName() {
        return this.eventName;
    }

    @NotNull
    public final MappingMethod getMethod() {
        return this.method;
    }

    @NotNull
    public final ActionType getType() {
        return this.type;
    }

    @NotNull
    public final String getAppVersion() {
        return this.appVersion;
    }

    @NotNull
    public final String getComponentId() {
        return this.componentId;
    }

    @NotNull
    public final String getPathType() {
        return this.pathType;
    }

    @NotNull
    public final String getActivityName() {
        return this.activityName;
    }

    @NotNull
    public final List<PathComponent> getViewPath() {
        List<PathComponent> list = Collections.unmodifiableList(this.path);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(path)");
        return list;
    }

    @NotNull
    public final List<ParameterComponent> getViewParameters() {
        List<ParameterComponent> list = Collections.unmodifiableList(this.parameters);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(parameters)");
        return list;
    }

    @JvmStatic
    @NotNull
    public static final List<EventBinding> parseArray(@Nullable JSONArray array) {
        return Companion.parseArray(array);
    }

    @JvmStatic
    @NotNull
    public static final EventBinding getInstanceFromJson(@NotNull JSONObject mapping) throws JSONException, IllegalArgumentException {
        return Companion.getInstanceFromJson(mapping);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/facebook/appevents/codeless/internal/EventBinding$ActionType;", "", "(Ljava/lang/String;I)V", "CLICK", "SELECTED", "TEXT_CHANGED", "facebook-core_release"})
    public static final class ActionType
    extends Enum<ActionType> {
        public static final /* enum */ ActionType CLICK = new ActionType();
        public static final /* enum */ ActionType SELECTED = new ActionType();
        public static final /* enum */ ActionType TEXT_CHANGED = new ActionType();
        private static final /* synthetic */ ActionType[] $VALUES;

        public static ActionType[] values() {
            return (ActionType[])$VALUES.clone();
        }

        public static ActionType valueOf(String value) {
            return Enum.valueOf(ActionType.class, value);
        }

        static {
            $VALUES = actionTypeArray = new ActionType[]{ActionType.CLICK, ActionType.SELECTED, ActionType.TEXT_CHANGED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/facebook/appevents/codeless/internal/EventBinding$Companion;", "", "()V", "getInstanceFromJson", "Lcom/facebook/appevents/codeless/internal/EventBinding;", "mapping", "Lorg/json/JSONObject;", "parseArray", "", "array", "Lorg/json/JSONArray;", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<EventBinding> parseArray(@Nullable JSONArray array) {
            ArrayList<EventBinding> eventBindings = new ArrayList<EventBinding>();
            if (array != null) {
                try {
                    int n = array.length();
                    for (int i = 0; i < n; ++i) {
                        JSONObject jSONObject = array.getJSONObject(i);
                        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"array.getJSONObject(i)");
                        EventBinding eventBinding = this.getInstanceFromJson(jSONObject);
                        eventBindings.add(eventBinding);
                    }
                }
                catch (JSONException jSONException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return eventBindings;
        }

        @JvmStatic
        @NotNull
        public final EventBinding getInstanceFromJson(@NotNull JSONObject mapping) throws JSONException, IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            String eventName = mapping.getString("event_name");
            String string = mapping.getString("method");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapping.getString(\"method\")");
            String string2 = string;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
            MappingMethod method = MappingMethod.valueOf(string3);
            String string4 = mapping.getString("event_type");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"mapping.getString(\"event_type\")");
            String string5 = string4;
            Locale locale2 = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ENGLISH");
            String string6 = string5.toUpperCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toUpperCase(locale)");
            ActionType type = ActionType.valueOf(string6);
            String appVersion = mapping.getString("app_version");
            JSONArray jsonPathArray = mapping.getJSONArray("path");
            ArrayList<PathComponent> path = new ArrayList<PathComponent>();
            int n = jsonPathArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jsonPath = jsonPathArray.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jsonPath, (String)"jsonPath");
                PathComponent component = new PathComponent(jsonPath);
                path.add(component);
            }
            String pathType = mapping.optString("path_type", "absolute");
            JSONArray jsonParameterArray = mapping.optJSONArray("parameters");
            ArrayList<ParameterComponent> parameters = new ArrayList<ParameterComponent>();
            if (jsonParameterArray != null) {
                int n2 = jsonParameterArray.length();
                for (int i = 0; i < n2; ++i) {
                    JSONObject jsonParameter = jsonParameterArray.getJSONObject(i);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonParameter, (String)"jsonParameter");
                    ParameterComponent component = new ParameterComponent(jsonParameter);
                    parameters.add(component);
                }
            }
            String componentId = mapping.optString("component_id");
            String activityName = mapping.optString("activity_name");
            Intrinsics.checkNotNullExpressionValue((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullExpressionValue((Object)appVersion, (String)"appVersion");
            List list = path;
            List list2 = parameters;
            Intrinsics.checkNotNullExpressionValue((Object)componentId, (String)"componentId");
            Intrinsics.checkNotNullExpressionValue((Object)pathType, (String)"pathType");
            Intrinsics.checkNotNullExpressionValue((Object)activityName, (String)"activityName");
            return new EventBinding(eventName, method, type, appVersion, list, list2, componentId, pathType, activityName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/appevents/codeless/internal/EventBinding$MappingMethod;", "", "(Ljava/lang/String;I)V", "MANUAL", "INFERENCE", "facebook-core_release"})
    public static final class MappingMethod
    extends Enum<MappingMethod> {
        public static final /* enum */ MappingMethod MANUAL = new MappingMethod();
        public static final /* enum */ MappingMethod INFERENCE = new MappingMethod();
        private static final /* synthetic */ MappingMethod[] $VALUES;

        public static MappingMethod[] values() {
            return (MappingMethod[])$VALUES.clone();
        }

        public static MappingMethod valueOf(String value) {
            return Enum.valueOf(MappingMethod.class, value);
        }

        static {
            $VALUES = mappingMethodArray = new MappingMethod[]{MappingMethod.MANUAL, MappingMethod.INFERENCE};
        }
    }
}

