/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\r\u0010\n\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/internal/instrument/ExceptionAnalyzer;", "", "()V", "enabled", "", "enable", "", "execute", "e", "", "isDebug", "isDebug$facebook_core_release", "sendExceptionAnalysisReports", "sendExceptionAnalysisReports$facebook_core_release", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nExceptionAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionAnalyzer.kt\ncom/facebook/internal/instrument/ExceptionAnalyzer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n13579#2,2:100\n*S KotlinDebug\n*F\n+ 1 ExceptionAnalyzer.kt\ncom/facebook/internal/instrument/ExceptionAnalyzer\n*L\n47#1:100,2\n*E\n"})
public final class ExceptionAnalyzer {
    @NotNull
    public static final ExceptionAnalyzer INSTANCE = new ExceptionAnalyzer();
    private static boolean enabled;

    private ExceptionAnalyzer() {
    }

    @JvmStatic
    @VisibleForTesting(otherwise=2)
    public static final boolean isDebug$facebook_core_release() {
        return false;
    }

    @JvmStatic
    public static final void enable() {
        enabled = true;
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            INSTANCE.sendExceptionAnalysisReports$facebook_core_release();
        }
    }

    @JvmStatic
    public static final void execute(@Nullable Throwable e) {
        block6: {
            block5: {
                if (!enabled) break block5;
                if (!INSTANCE.isDebug$facebook_core_release() && e != null) break block6;
            }
            return;
        }
        Set disabledFeatures = new HashSet();
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
        Object[] $this$forEach$iv = stackTraceElementArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StackTraceElement it = (StackTraceElement)element$iv;
            boolean bl = false;
            String string = it.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
            FeatureManager.Feature feature = FeatureManager.getFeature(string);
            if (feature == FeatureManager.Feature.Unknown) continue;
            FeatureManager.disableFeature(feature);
            disabledFeatures.add(feature.toString());
        }
        if (FacebookSdk.getAutoLogAppEventsEnabled() && !((Collection)disabledFeatures).isEmpty()) {
            InstrumentData.Builder.build(new JSONArray((Collection)disabledFeatures)).save();
        }
    }

    @VisibleForTesting(otherwise=2)
    public final void sendExceptionAnalysisReports$facebook_core_release() {
        if (Utility.isDataProcessingRestricted()) {
            return;
        }
        File[] reports = InstrumentUtility.listExceptionAnalysisReportFiles();
        List requests = new ArrayList();
        for (File report : reports) {
            InstrumentData instrumentData = InstrumentData.Builder.load(report);
            if (!instrumentData.isValid()) continue;
            JSONObject params = new JSONObject();
            try {
                params.put("crash_shield", (Object)instrumentData.toString());
                String string = "%s/instruments";
                Object[] objectArray = new Object[]{FacebookSdk.getApplicationId()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                GraphRequest request = GraphRequest.Companion.newPostRequest(null, string2, params, arg_0 -> ExceptionAnalyzer.sendExceptionAnalysisReports$lambda$1(instrumentData, arg_0));
                requests.add(request);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (requests.isEmpty()) {
            return;
        }
        GraphRequestBatch requestBatch = new GraphRequestBatch(requests);
        requestBatch.executeAsync();
    }

    private static final void sendExceptionAnalysisReports$lambda$1(InstrumentData $instrumentData, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)$instrumentData, (String)"$instrumentData");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            if (response.getError() == null) {
                JSONObject jSONObject;
                JSONObject jSONObject2 = jSONObject = response.getJsonObject();
                boolean bl = jSONObject2 != null ? jSONObject2.getBoolean("success") : false;
                if (bl) {
                    $instrumentData.clear();
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

