/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Validate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J'\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u0018\u001a\u00060\bj\u0002`\tJ\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001J\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\u001c\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/facebook/internal/Logger;", "", "behavior", "Lcom/facebook/LoggingBehavior;", "tag", "", "(Lcom/facebook/LoggingBehavior;Ljava/lang/String;)V", "contents", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "", "priority", "getPriority", "()I", "setPriority", "(I)V", "append", "", "string", "format", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "stringBuilder", "appendKeyValue", "key", "getContents", "log", "logString", "shouldLog", "", "Companion", "facebook-core_release"})
public final class Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoggingBehavior behavior;
    @NotNull
    private final String tag;
    @NotNull
    private StringBuilder contents;
    private int priority;
    @NotNull
    public static final String LOG_TAG_BASE = "FacebookSDK.";
    @NotNull
    private static final HashMap<String, String> stringsToReplace = new HashMap();

    public Logger(@NotNull LoggingBehavior behavior, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)behavior), (String)"behavior");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.priority = 3;
        this.behavior = behavior;
        this.tag = LOG_TAG_BASE + Validate.notNullOrEmpty(tag, "tag");
        this.contents = new StringBuilder();
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int value) {
        Object[] objectArray = new Object[]{7, 3, 6, 4, 2, 5};
        Validate.oneOf(value, "value", objectArray);
        this.setPriority(value);
    }

    @NotNull
    public final String getContents() {
        String string = this.contents.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contents.toString()");
        return Logger.Companion.replaceStrings(string);
    }

    public final void log() {
        String string = this.contents.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contents.toString()");
        this.logString(string);
        this.contents = new StringBuilder();
    }

    public final void logString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Companion.log(this.behavior, this.priority, this.tag, string);
    }

    public final void append(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        if (this.shouldLog()) {
            this.contents.append((CharSequence)stringBuilder);
        }
    }

    public final void append(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.shouldLog()) {
            this.contents.append(string);
        }
    }

    public final void append(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (this.shouldLog()) {
            Object[] objectArray = Arrays.copyOf(args, args.length);
            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
            this.contents.append(string);
        }
    }

    public final void appendKeyValue(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object[] objectArray = new Object[]{key, value};
        this.append("  %s:\t%s\n", objectArray);
    }

    private final boolean shouldLog() {
        return FacebookSdk.isLoggingBehaviorEnabled(this.behavior);
    }

    @JvmStatic
    public static final synchronized void registerStringToReplace(@NotNull String original, @NotNull String replace) {
        Companion.registerStringToReplace(original, replace);
    }

    @JvmStatic
    public static final synchronized void registerAccessToken(@NotNull String accessToken) {
        Companion.registerAccessToken(accessToken);
    }

    @JvmStatic
    public static final void log(@NotNull LoggingBehavior behavior, @NotNull String tag, @NotNull String string) {
        Companion.log(behavior, tag, string);
    }

    @JvmStatic
    public static final void log(@NotNull LoggingBehavior behavior, @NotNull String tag, @NotNull String format, Object ... args) {
        Companion.log(behavior, tag, format, args);
    }

    @JvmStatic
    public static final void log(@NotNull LoggingBehavior behavior, int priority, @NotNull String tag, @NotNull String format, Object ... args) {
        Companion.log(behavior, priority, tag, format, args);
    }

    @JvmStatic
    public static final void log(@NotNull LoggingBehavior behavior, int priority, @NotNull String tag, @NotNull String string) {
        Companion.log(behavior, priority, tag, string);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007JA\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0013J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J9\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/internal/Logger$Companion;", "", "()V", "LOG_TAG_BASE", "", "stringsToReplace", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "log", "", "behavior", "Lcom/facebook/LoggingBehavior;", "priority", "", "tag", "string", "format", "args", "", "(Lcom/facebook/LoggingBehavior;ILjava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "(Lcom/facebook/LoggingBehavior;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "registerAccessToken", "accessToken", "registerStringToReplace", "original", "replace", "replaceStrings", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final synchronized void registerStringToReplace(@NotNull String original, @NotNull String replace) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)replace, (String)"replace");
            ((Map)stringsToReplace).put(original, replace);
        }

        @JvmStatic
        public final synchronized void registerAccessToken(@NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            if (!FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.INCLUDE_ACCESS_TOKENS)) {
                this.registerStringToReplace(accessToken, "ACCESS_TOKEN_REMOVED");
            }
        }

        @JvmStatic
        public final void log(@NotNull LoggingBehavior behavior, @NotNull String tag, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)((Object)behavior), (String)"behavior");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.log(behavior, 3, tag, string);
        }

        @JvmStatic
        public final void log(@NotNull LoggingBehavior behavior, @NotNull String tag, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)((Object)behavior), (String)"behavior");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (FacebookSdk.isLoggingBehaviorEnabled(behavior)) {
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                String string2 = string;
                this.log(behavior, 3, tag, string2);
            }
        }

        @JvmStatic
        public final void log(@NotNull LoggingBehavior behavior, int priority, @NotNull String tag, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)((Object)behavior), (String)"behavior");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (FacebookSdk.isLoggingBehaviorEnabled(behavior)) {
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                String string2 = string;
                this.log(behavior, priority, tag, string2);
            }
        }

        @JvmStatic
        public final void log(@NotNull LoggingBehavior behavior, int priority, @NotNull String tag, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)((Object)behavior), (String)"behavior");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String tag2 = tag;
            String string2 = string;
            if (FacebookSdk.isLoggingBehaviorEnabled(behavior)) {
                string2 = this.replaceStrings(string2);
                if (!StringsKt.startsWith$default((String)tag2, (String)Logger.LOG_TAG_BASE, (boolean)false, (int)2, null)) {
                    tag2 = Logger.LOG_TAG_BASE + tag2;
                }
                Log.println((int)priority, (String)tag2, (String)string2);
                if (behavior == LoggingBehavior.DEVELOPER_ERRORS) {
                    new Exception().printStackTrace();
                }
            }
        }

        private final synchronized String replaceStrings(String string) {
            String string2 = string;
            for (Map.Entry entry : ((Map)stringsToReplace).entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                string2 = StringsKt.replace$default((String)string2, (String)key, (String)value, (boolean)false, (int)4, null);
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

