/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/internal/BundleJSONConverter;", "", "()V", "SETTERS", "", "Ljava/lang/Class;", "Lcom/facebook/internal/BundleJSONConverter$Setter;", "convertToBundle", "Landroid/os/Bundle;", "jsonObject", "Lorg/json/JSONObject;", "convertToJSON", "bundle", "Setter", "facebook-core_release"})
public final class BundleJSONConverter {
    @NotNull
    public static final BundleJSONConverter INSTANCE = new BundleJSONConverter();
    @NotNull
    private static final Map<Class<?>, Setter> SETTERS = new HashMap();

    private BundleJSONConverter() {
    }

    @JvmStatic
    @NotNull
    public static final JSONObject convertToJSON(@NotNull Bundle bundle) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        JSONObject json = new JSONObject();
        for (String key : bundle.keySet()) {
            Setter setter;
            Object value;
            if (bundle.get(key) == null) continue;
            if (value instanceof List) {
                JSONArray jsonArray = new JSONArray();
                List listValue = (List)value;
                for (String stringValue : listValue) {
                    jsonArray.put((Object)stringValue);
                }
                json.put(key, (Object)jsonArray);
                continue;
            }
            if (value instanceof Bundle) {
                json.put(key, (Object)BundleJSONConverter.convertToJSON((Bundle)value));
                continue;
            }
            if (SETTERS.get(value.getClass()) == null) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass());
            }
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            setter.setOnJSON(json, key, value);
        }
        return json;
    }

    @JvmStatic
    @NotNull
    public static final Bundle convertToBundle(@NotNull JSONObject jsonObject) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Bundle bundle = new Bundle();
        Iterator jsonIterator = jsonObject.keys();
        while (jsonIterator.hasNext()) {
            Setter setter;
            String key = (String)jsonIterator.next();
            Object value = jsonObject.get(key);
            if (value == JSONObject.NULL) continue;
            if (value instanceof JSONObject) {
                bundle.putBundle(key, BundleJSONConverter.convertToBundle((JSONObject)value));
                continue;
            }
            if (SETTERS.get(value.getClass()) == null) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass());
            }
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            setter.setOnBundle(bundle, key, value);
        }
        return bundle;
    }

    static {
        SETTERS.put(Boolean.class, new Setter(){

            @Override
            public void setOnBundle(@NotNull Bundle bundle, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                bundle.putBoolean(key, ((Boolean)value).booleanValue());
            }

            @Override
            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                json.put(key, value);
            }
        });
        SETTERS.put(Integer.class, new Setter(){

            @Override
            public void setOnBundle(@NotNull Bundle bundle, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                bundle.putInt(key, ((Integer)value).intValue());
            }

            @Override
            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                json.put(key, value);
            }
        });
        SETTERS.put(Long.class, new Setter(){

            @Override
            public void setOnBundle(@NotNull Bundle bundle, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                bundle.putLong(key, ((Long)value).longValue());
            }

            @Override
            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                json.put(key, value);
            }
        });
        SETTERS.put(Double.class, new Setter(){

            @Override
            public void setOnBundle(@NotNull Bundle bundle, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                bundle.putDouble(key, ((Double)value).doubleValue());
            }

            @Override
            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                json.put(key, value);
            }
        });
        SETTERS.put(String.class, new Setter(){

            @Override
            public void setOnBundle(@NotNull Bundle bundle, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                bundle.putString(key, (String)value);
            }

            @Override
            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                json.put(key, value);
            }
        });
        SETTERS.put(String[].class, new Setter(){

            @Override
            public void setOnBundle(@NotNull Bundle bundle, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                throw new IllegalArgumentException("Unexpected type from JSON");
            }

            @Override
            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                JSONArray jsonArray = new JSONArray();
                for (String stringValue : (String[])value) {
                    jsonArray.put((Object)stringValue);
                }
                json.put(key, (Object)jsonArray);
            }
        });
        SETTERS.put(JSONArray.class, new Setter(){

            @Override
            public void setOnBundle(@NotNull Bundle bundle, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                JSONArray jsonArray = (JSONArray)value;
                ArrayList<Object> stringArrayList = new ArrayList<Object>();
                if (jsonArray.length() == 0) {
                    bundle.putStringArrayList(key, stringArrayList);
                    return;
                }
                int n = jsonArray.length();
                for (int i = 0; i < n; ++i) {
                    Object current = jsonArray.get(i);
                    if (!(current instanceof String)) {
                        throw new IllegalArgumentException("Unexpected type in an array: " + current.getClass());
                    }
                    stringArrayList.add(current);
                }
                bundle.putStringArrayList(key, stringArrayList);
            }

            @Override
            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @NotNull Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                throw new IllegalArgumentException("JSONArray's are not supported in bundles.");
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H&J \u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H&\u00a8\u0006\f"}, d2={"Lcom/facebook/internal/BundleJSONConverter$Setter;", "", "setOnBundle", "", "bundle", "Landroid/os/Bundle;", "key", "", "value", "setOnJSON", "json", "Lorg/json/JSONObject;", "facebook-core_release"})
    public static interface Setter {
        public void setOnBundle(@NotNull Bundle var1, @NotNull String var2, @NotNull Object var3) throws JSONException;

        public void setOnJSON(@NotNull JSONObject var1, @NotNull String var2, @NotNull Object var3) throws JSONException;
    }
}

