/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.integrity;

import com.facebook.FacebookSdk;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u001c\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/appevents/integrity/IntegrityManager;", "", "()V", "INTEGRITY_TYPE_ADDRESS", "", "INTEGRITY_TYPE_HEALTH", "INTEGRITY_TYPE_NONE", "RESTRICTIVE_ON_DEVICE_PARAMS_KEY", "enabled", "", "isSampleEnabled", "enable", "", "getIntegrityPredictionResult", "textFeature", "processParameters", "parameters", "", "shouldFilter", "input", "facebook-core_release"})
public final class IntegrityManager {
    @NotNull
    public static final IntegrityManager INSTANCE = new IntegrityManager();
    @NotNull
    public static final String INTEGRITY_TYPE_NONE = "none";
    @NotNull
    public static final String INTEGRITY_TYPE_ADDRESS = "address";
    @NotNull
    public static final String INTEGRITY_TYPE_HEALTH = "health";
    @NotNull
    private static final String RESTRICTIVE_ON_DEVICE_PARAMS_KEY = "_onDeviceParams";
    private static boolean enabled;
    private static boolean isSampleEnabled;

    private IntegrityManager() {
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(IntegrityManager.class)) {
            return;
        }
        try {
            enabled = true;
            isSampleEnabled = FetchedAppGateKeepersManager.getGateKeeperForKey("FBSDKFeatureIntegritySample", FacebookSdk.getApplicationId(), false);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, IntegrityManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void processParameters(@NotNull Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing(IntegrityManager.class)) {
            return;
        }
        try {
            Map<String, String> parameters;
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            if (!enabled || parameters.isEmpty()) {
                return;
            }
            try {
                List keys = CollectionsKt.toList((Iterable)parameters.keySet());
                JSONObject restrictiveParamJson = new JSONObject();
                for (String key : keys) {
                    String value;
                    if (parameters.get(key) == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    if (!INSTANCE.shouldFilter(key) && !INSTANCE.shouldFilter(value)) continue;
                    parameters.remove(key);
                    restrictiveParamJson.put(key, (Object)(isSampleEnabled ? value : ""));
                }
                if (restrictiveParamJson.length() != 0) {
                    Map<String, String> map2 = parameters;
                    String string = RESTRICTIVE_ON_DEVICE_PARAMS_KEY;
                    String string2 = restrictiveParamJson.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"restrictiveParamJson.toString()");
                    String string3 = string2;
                    map2.put(string, string3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, IntegrityManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldFilter(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void input;
            String predictResult = this.getIntegrityPredictionResult((String)input);
            return !Intrinsics.areEqual((Object)INTEGRITY_TYPE_NONE, (Object)predictResult);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getIntegrityPredictionResult(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            String[] res;
            void textFeature;
            int n = 0;
            Object object = new float[30];
            while (n < 30) {
                int n2 = n++;
                object[n2] = 0.0f;
            }
            float[] dense = object;
            object = new float[1][];
            object[0] = (float)dense;
            Object object2 = object;
            object = new String[1];
            object[0] = textFeature;
            Object object3 = res = ModelManager.predict(ModelManager.Task.MTML_INTEGRITY_DETECT, (float[][])object2, (String[])object);
            if (res == null || (object3 = object3[0]) == null) {
                object3 = INTEGRITY_TYPE_NONE;
            }
            return object3;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }
}

