/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.gps.topics;

import android.adservices.topics.GetTopicsRequest;
import android.adservices.topics.GetTopicsResponse;
import android.adservices.topics.Topic;
import android.adservices.topics.TopicsManager;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.gps.topics.GpsTopicsManager;
import com.facebook.appevents.gps.topics.TopicData;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\b\u0010\u0018\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/appevents/gps/topics/GpsTopicsManager;", "", "()V", "RECORD_OBSERVATION", "", "TAG", "", "executor", "Ljava/util/concurrent/Executor;", "getExecutor", "()Ljava/util/concurrent/Executor;", "executor$delegate", "Lkotlin/Lazy;", "isTopicsObservationEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "enableTopicsObservation", "", "getTopics", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/facebook/appevents/gps/topics/TopicData;", "processObservedTopics", "response", "Landroid/adservices/topics/GetTopicsResponse;", "shouldObserveTopics", "facebook-core_release"})
@SourceDebugExtension(value={"SMAP\nGpsTopicsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpsTopicsManager.kt\ncom/facebook/appevents/gps/topics/GpsTopicsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1549#2:110\n1620#2,3:111\n*S KotlinDebug\n*F\n+ 1 GpsTopicsManager.kt\ncom/facebook/appevents/gps/topics/GpsTopicsManager\n*L\n100#1:110\n100#1:111,3\n*E\n"})
public final class GpsTopicsManager {
    @NotNull
    public static final GpsTopicsManager INSTANCE = new GpsTopicsManager();
    private static final boolean RECORD_OBSERVATION = true;
    @NotNull
    private static final String TAG;
    @NotNull
    private static final Lazy executor$delegate;
    @NotNull
    private static final AtomicBoolean isTopicsObservationEnabled;

    private GpsTopicsManager() {
    }

    private final Executor getExecutor() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            Lazy lazy = executor$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-executor>(...)");
            return (Executor)object;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    @JvmStatic
    public static final void enableTopicsObservation() {
        if (CrashShieldHandler.isObjectCrashing(GpsTopicsManager.class)) {
            return;
        }
        try {
            isTopicsObservationEnabled.set(true);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, GpsTopicsManager.class);
            return;
        }
    }

    @JvmStatic
    @TargetApi(value=34)
    @NotNull
    public static final CompletableFuture<List<TopicData>> getTopics() {
        if (CrashShieldHandler.isObjectCrashing(GpsTopicsManager.class)) {
            return null;
        }
        try {
            if (!INSTANCE.shouldObserveTopics()) {
                CompletableFuture<List<TopicData>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(emptyList())");
                return completableFuture;
            }
            CompletableFuture<List<TopicData>> futureResult = new CompletableFuture<List<TopicData>>();
            try {
                Context context = FacebookSdk.getApplicationContext();
                OutcomeReceiver callback2 = (OutcomeReceiver)new OutcomeReceiver<GetTopicsResponse, Exception>(futureResult){
                    final /* synthetic */ CompletableFuture<List<TopicData>> $futureResult;
                    {
                        this.$futureResult = $futureResult;
                    }

                    public void onResult(@NotNull GetTopicsResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        try {
                            this.$futureResult.complete(GpsTopicsManager.access$processObservedTopics(GpsTopicsManager.INSTANCE, response));
                        }
                        catch (Throwable error) {
                            Log.w((String)GpsTopicsManager.access$getTAG$p(), (String)"GPS_TOPICS_PROCESSING_FAILURE", (Throwable)error);
                            this.$futureResult.completeExceptionally(error);
                        }
                    }

                    public void onError(@NotNull Exception error) {
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        Log.w((String)GpsTopicsManager.access$getTAG$p(), (String)"GPS_TOPICS_OBSERVATION_FAILURE", (Throwable)error);
                        this.$futureResult.completeExceptionally(error);
                    }
                };
                GetTopicsRequest.Builder topicsRequestBuilder = new GetTopicsRequest.Builder();
                topicsRequestBuilder.setShouldRecordObservation(true);
                topicsRequestBuilder.setAdsSdkName(context.getPackageName());
                TopicsManager topicsManager = (TopicsManager)context.getSystemService(TopicsManager.class);
                if (topicsManager != null) {
                    topicsManager.getTopics(topicsRequestBuilder.build(), INSTANCE.getExecutor(), (OutcomeReceiver<GetTopicsResponse, Exception>)callback2);
                }
            }
            catch (Throwable error) {
                Log.w((String)TAG, (String)"GPS_TOPICS_OBSERVATION_FAILURE", (Throwable)error);
                futureResult.completeExceptionally(error);
            }
            return futureResult;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, GpsTopicsManager.class);
            return null;
        }
    }

    @JvmStatic
    public static final boolean shouldObserveTopics() {
        if (CrashShieldHandler.isObjectCrashing(GpsTopicsManager.class)) {
            return false;
        }
        try {
            if (!isTopicsObservationEnabled.get()) {
                return false;
            }
            try {
                Class.forName("android.adservices.topics.TopicsManager");
            }
            catch (Throwable error) {
                Log.w((String)TAG, (String)"GPS_TOPICS_DEPENDENCY_FAILURE", (Throwable)error);
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, GpsTopicsManager.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=34)
    private final List<TopicData> processObservedTopics(GetTopicsResponse getTopicsResponse) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void $this$mapTo$iv$iv;
            void response;
            List<Topic> list = response.getTopics();
            Intrinsics.checkNotNullExpressionValue(list, (String)"response.topics");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void topic;
                Topic topic2 = (Topic)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new TopicData(topic.getTaxonomyVersion(), topic.getModelVersion(), topic.getTopicId()));
            }
            return (List)destination$iv$iv;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ List access$processObservedTopics(GpsTopicsManager gpsTopicsManager, GetTopicsResponse getTopicsResponse) {
        if (CrashShieldHandler.isObjectCrashing(GpsTopicsManager.class)) {
            return null;
        }
        try {
            void response;
            GpsTopicsManager $this;
            return $this.processObservedTopics((GetTopicsResponse)response);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, GpsTopicsManager.class);
            return null;
        }
    }

    public static final /* synthetic */ String access$getTAG$p() {
        if (CrashShieldHandler.isObjectCrashing(GpsTopicsManager.class)) {
            return null;
        }
        try {
            return TAG;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, GpsTopicsManager.class);
            return null;
        }
    }

    static {
        String string = GpsTopicsManager.class.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GpsTopicsManager::class.java.toString()");
        TAG = string;
        executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);
        isTopicsObservationEnabled = new AtomicBoolean(false);
    }
}

