/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\bR\u00020\u0000H\u0002J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0018\u00010\bR\u00020\u0000H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0006\u0010\u0019\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0018\u00010\bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/internal/WorkQueue;", "", "maxConcurrent", "", "executor", "Ljava/util/concurrent/Executor;", "(ILjava/util/concurrent/Executor;)V", "pendingJobs", "Lcom/facebook/internal/WorkQueue$WorkNode;", "runningCount", "runningJobs", "workLock", "Ljava/util/concurrent/locks/ReentrantLock;", "addActiveWorkItem", "Lcom/facebook/internal/WorkQueue$WorkItem;", "callback", "Ljava/lang/Runnable;", "addToFront", "", "execute", "", "node", "finishItemAndStartNew", "finished", "startItem", "validate", "Companion", "WorkItem", "WorkNode", "facebook-core_release"})
@SourceDebugExtension(value={"SMAP\nWorkQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkQueue.kt\ncom/facebook/internal/WorkQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class WorkQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxConcurrent;
    @NotNull
    private final Executor executor;
    @NotNull
    private final ReentrantLock workLock;
    @Nullable
    private WorkNode pendingJobs;
    @Nullable
    private WorkNode runningJobs;
    private int runningCount;
    public static final int DEFAULT_MAX_CONCURRENT = 8;

    @JvmOverloads
    public WorkQueue(int maxConcurrent, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.maxConcurrent = maxConcurrent;
        this.executor = executor;
        this.workLock = new ReentrantLock();
    }

    public /* synthetic */ WorkQueue(int n, Executor executor, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        if ((n2 & 2) != 0) {
            executor = FacebookSdk.getExecutor();
        }
        this(n, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final WorkItem addActiveWorkItem(@NotNull Runnable callback2, boolean addToFront) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        WorkNode node = new WorkNode(callback2);
        Lock lock = this.workLock;
        lock.lock();
        try {
            boolean bl = false;
            this.pendingJobs = node.addToList(this.pendingJobs, addToFront);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.startItem();
        return node;
    }

    public static /* synthetic */ WorkItem addActiveWorkItem$default(WorkQueue workQueue, Runnable runnable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return workQueue.addActiveWorkItem(runnable, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validate() {
        Lock lock = this.workLock;
        lock.lock();
        try {
            boolean bl = false;
            int count = 0;
            if (this.runningJobs != null) {
                WorkNode walk = this.runningJobs;
                do {
                    if (walk == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    walk.verify(true);
                    ++count;
                } while ((walk = walk.getNext()) != this.runningJobs);
            }
            WorkQueue.Companion.assert(this.runningCount == count);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void startItem() {
        this.finishItemAndStartNew(null);
    }

    private final void finishItemAndStartNew(WorkNode finished) {
        int n;
        WorkNode ready = null;
        this.workLock.lock();
        if (finished != null) {
            this.runningJobs = finished.removeFromList(this.runningJobs);
            n = this.runningCount;
            this.runningCount = n + -1;
        }
        if (this.runningCount < this.maxConcurrent && (ready = this.pendingJobs) != null) {
            this.pendingJobs = ready.removeFromList(this.pendingJobs);
            this.runningJobs = ready.addToList(this.runningJobs, false);
            n = this.runningCount;
            this.runningCount = n + 1;
            ready.setRunning(true);
        }
        this.workLock.unlock();
        if (ready != null) {
            this.execute(ready);
        }
    }

    private final void execute(WorkNode node) {
        this.executor.execute(() -> WorkQueue.execute$lambda$2(node, this));
    }

    @JvmOverloads
    public WorkQueue(int maxConcurrent) {
        this(maxConcurrent, null, 2, null);
    }

    @JvmOverloads
    public WorkQueue() {
        this(0, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final WorkItem addActiveWorkItem(@NotNull Runnable callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        return WorkQueue.addActiveWorkItem$default(this, callback2, false, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void execute$lambda$2(WorkNode $node, WorkQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            $node.getCallback().run();
        }
        finally {
            this$0.finishItemAndStartNew($node);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/internal/WorkQueue$Companion;", "", "()V", "DEFAULT_MAX_CONCURRENT", "", "assert", "", "condition", "", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void assert(boolean condition) {
            if (!condition) {
                throw new FacebookException("Validation failed");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\b"}, d2={"Lcom/facebook/internal/WorkQueue$WorkItem;", "", "isRunning", "", "()Z", "cancel", "moveToFront", "", "facebook-core_release"})
    public static interface WorkItem {
        public boolean cancel();

        public boolean isRunning();

        public void moveToFront();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0012\u001a\u00060\u0000R\u00020\r2\f\u0010\u0013\u001a\b\u0018\u00010\u0000R\u00020\r2\u0006\u0010\u0014\u001a\u00020\bJ\b\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\b\u0018\u00010\u0000R\u00020\r2\f\u0010\u0013\u001a\b\u0018\u00010\u0000R\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR*\u0010\u000e\u001a\b\u0018\u00010\u0000R\u00020\r2\f\u0010\f\u001a\b\u0018\u00010\u0000R\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0018\u00010\u0000R\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/internal/WorkQueue$WorkNode;", "Lcom/facebook/internal/WorkQueue$WorkItem;", "callback", "Ljava/lang/Runnable;", "(Lcom/facebook/internal/WorkQueue;Ljava/lang/Runnable;)V", "getCallback", "()Ljava/lang/Runnable;", "isRunning", "", "()Z", "setRunning", "(Z)V", "<set-?>", "Lcom/facebook/internal/WorkQueue;", "next", "getNext", "()Lcom/facebook/internal/WorkQueue$WorkNode;", "prev", "addToList", "list", "addToFront", "cancel", "moveToFront", "", "removeFromList", "verify", "shouldBeRunning", "facebook-core_release"})
    private final class WorkNode
    implements WorkItem {
        @NotNull
        private final Runnable callback;
        @Nullable
        private WorkNode next;
        @Nullable
        private WorkNode prev;
        private boolean isRunning;

        public WorkNode(Runnable callback2) {
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            this.callback = callback2;
        }

        @NotNull
        public final Runnable getCallback() {
            return this.callback;
        }

        @Nullable
        public final WorkNode getNext() {
            return this.next;
        }

        @Override
        public boolean isRunning() {
            return this.isRunning;
        }

        public void setRunning(boolean bl) {
            this.isRunning = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            Lock lock = WorkQueue.this.workLock;
            WorkQueue workQueue = WorkQueue.this;
            lock.lock();
            try {
                boolean bl = false;
                if (!this.isRunning()) {
                    workQueue.pendingJobs = this.removeFromList(workQueue.pendingJobs);
                    boolean bl2 = true;
                    return bl2;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void moveToFront() {
            Lock lock = WorkQueue.this.workLock;
            WorkQueue workQueue = WorkQueue.this;
            lock.lock();
            try {
                boolean bl = false;
                if (!this.isRunning()) {
                    workQueue.pendingJobs = this.removeFromList(workQueue.pendingJobs);
                    workQueue.pendingJobs = this.addToList(workQueue.pendingJobs, true);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        @NotNull
        public final WorkNode addToList(@Nullable WorkNode list, boolean addToFront) {
            WorkNode list2 = list;
            Companion.assert(this.next == null);
            Companion.assert(this.prev == null);
            if (list2 == null) {
                list2 = this.next = (this.prev = this);
            } else {
                this.next = list2;
                this.prev = list2.prev;
                if (this.prev != null) {
                    (this.prev = list2.prev).next = this;
                }
                if (this.next != null) {
                    WorkNode workNode = this.prev;
                    WorkNode workNode2 = this.next.prev = workNode != null ? workNode.next : null;
                }
            }
            if (list2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return addToFront ? this : list2;
        }

        @Nullable
        public final WorkNode removeFromList(@Nullable WorkNode list) {
            WorkNode list2 = list;
            Companion.assert(this.next != null);
            Companion.assert(this.prev != null);
            if (list2 == this) {
                WorkNode workNode = list2 = this.next == this ? null : this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this.prev = null;
            return list2;
        }

        public final void verify(boolean shouldBeRunning) {
            WorkNode workNode = this.prev;
            if (workNode == null || (workNode = workNode.next) == null) {
                workNode = this;
            }
            Companion.assert(workNode == this);
            WorkNode workNode2 = this.next;
            if (workNode2 == null || (workNode2 = workNode2.prev) == null) {
                workNode2 = this;
            }
            Companion.assert(workNode2 == this);
            Companion.assert(this.isRunning() == shouldBeRunning);
        }
    }
}

