/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.gps.ara;

import android.adservices.common.AdServicesOutcomeReceiver;
import android.adservices.measurement.MeasurementManager;
import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.OutcomeReceiver;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.gps.GpsCapabilityChecker;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.net.URLEncoder;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/appevents/gps/ara/GpsAraTriggersManager;", "", "()V", "SERVER_URI", "", "TAG", "enabled", "", "canRegisterTrigger", "enable", "", "getEventParameters", "event", "Lcom/facebook/appevents/AppEvent;", "registerTrigger", "applicationId", "registerTriggerAsync", "facebook-core_release"})
public final class GpsAraTriggersManager {
    @NotNull
    public static final GpsAraTriggersManager INSTANCE = new GpsAraTriggersManager();
    private static boolean enabled;
    @NotNull
    private static final String TAG;
    @NotNull
    private static final String SERVER_URI = "https://www.facebook.com/privacy_sandbox/mobile/register/trigger";

    private GpsAraTriggersManager() {
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(GpsAraTriggersManager.class)) {
            return;
        }
        try {
            enabled = true;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, GpsAraTriggersManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void registerTriggerAsync(@NotNull String string, @NotNull AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void event;
            void applicationId;
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            FacebookSdk.INSTANCE.getExecutor().execute(() -> GpsAraTriggersManager.registerTriggerAsync$lambda-0((String)applicationId, (AppEvent)event));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=34)
    public final void registerTrigger(@NotNull String string, @NotNull AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void event;
            void applicationId;
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.canRegisterTrigger()) {
                return;
            }
            Context context = FacebookSdk.INSTANCE.getApplicationContext();
            MeasurementManager measurementManager = null;
            try {
                measurementManager = (MeasurementManager)context.getSystemService(MeasurementManager.class);
                if (measurementManager == null) {
                    measurementManager = MeasurementManager.get(context.getApplicationContext());
                }
                if (measurementManager == null) {
                    Log.w((String)TAG, (String)"FAILURE_GET_MEASUREMENT_MANAGER");
                    return;
                }
                String params = this.getEventParameters((AppEvent)event);
                String appIdKey = "app_id";
                Uri uri = Uri.parse((String)("https://www.facebook.com/privacy_sandbox/mobile/register/trigger?" + appIdKey + '=' + (String)applicationId + '&' + params));
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(\"$SERVER_URI?$appIdKey=$applicationId&$params\")");
                Uri attributionTriggerUri = uri;
                if (GpsCapabilityChecker.INSTANCE.useOutcomeReceiver()) {
                    OutcomeReceiver outcomeReceiver2 = (OutcomeReceiver)new OutcomeReceiver<Object, Exception>(){

                        public void onResult(@NotNull Object result) {
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            Log.d((String)GpsAraTriggersManager.access$getTAG$p(), (String)"OUTCOME_RECEIVER_TRIGGER_SUCCESS");
                        }

                        public void onError(@NotNull Exception error) {
                            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                            Log.d((String)GpsAraTriggersManager.access$getTAG$p(), (String)"OUTCOME_RECEIVER_TRIGGER_FAILURE");
                        }
                    };
                    measurementManager.registerTrigger(attributionTriggerUri, FacebookSdk.INSTANCE.getExecutor(), (OutcomeReceiver<Object, Exception>)outcomeReceiver2);
                } else {
                    AdServicesOutcomeReceiver adServicesOutcomeReceiver2 = new AdServicesOutcomeReceiver<Object, Exception>(){

                        public void onResult(@NotNull Object result) {
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            Log.d((String)GpsAraTriggersManager.access$getTAG$p(), (String)"AD_SERVICE_OUTCOME_RECEIVER_TRIGGER_SUCCESS");
                        }

                        public void onError(@NotNull Exception error) {
                            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                            Log.d((String)GpsAraTriggersManager.access$getTAG$p(), (String)"AD_SERVICE_OUTCOME_RECEIVER_TRIGGER_FAILURE");
                        }
                    };
                    measurementManager.registerTrigger(attributionTriggerUri, FacebookSdk.INSTANCE.getExecutor(), adServicesOutcomeReceiver2);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"FAILURE_TRIGGER_REGISTRATION_FAILED");
            }
            catch (NoClassDefFoundError e) {
                Log.w((String)TAG, (String)"FAILURE_TRIGGER_REGISTRATION_NO_CLASS_FOUND");
            }
            catch (NoSuchMethodError e) {
                Log.w((String)TAG, (String)"FAILURE_TRIGGER_REGISTRATION_NO_METHOD_FOUND");
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private final boolean canRegisterTrigger() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            if (!enabled) {
                return false;
            }
            try {
                Class.forName("android.adservices.measurement.MeasurementManager");
                return true;
            }
            catch (Exception e) {
                Log.i((String)TAG, (String)"FAILURE_NO_MEASUREMENT_MANAGER_CLASS");
                return false;
            }
            catch (NoClassDefFoundError e) {
                Log.i((String)TAG, (String)"FAILURE_NO_MEASUREMENT_MANAGER_CLASS_DEF");
                return false;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getEventParameters(AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void event;
            JSONObject params = event.getJSONObject();
            if (params == null || params.length() == 0) {
                return "";
            }
            Iterator iterator = params.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"params.keys()");
            return SequencesKt.joinToString$default((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<String, String>(params){
                final /* synthetic */ JSONObject $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @Nullable
                public final String invoke(String key) {
                    Object object = this.$params.opt(key);
                    if (object == null) {
                        return null;
                    }
                    Object value = object;
                    try {
                        String encodedKey = URLEncoder.encode(key, "UTF-8");
                        String encodedValue = URLEncoder.encode(value.toString(), "UTF-8");
                        object = encodedKey + '=' + encodedValue;
                    }
                    catch (Exception e) {
                        object = null;
                    }
                    return object;
                }
            })), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerTriggerAsync$lambda-0(String string, AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(GpsAraTriggersManager.class)) {
            return;
        }
        try {
            void $event;
            String $applicationId;
            Intrinsics.checkNotNullParameter((Object)$applicationId, (String)"$applicationId");
            Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
            INSTANCE.registerTrigger($applicationId, (AppEvent)$event);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, GpsAraTriggersManager.class);
            return;
        }
    }

    public static final /* synthetic */ String access$getTAG$p() {
        if (CrashShieldHandler.isObjectCrashing(GpsAraTriggersManager.class)) {
            return null;
        }
        try {
            return TAG;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, GpsAraTriggersManager.class);
            return null;
        }
    }

    static {
        String string = GpsAraTriggersManager.class.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GpsAraTriggersManager::class.java.toString()");
        TAG = string;
    }
}

