/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.os.Bundle;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b:\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010;\u001a\u00020\u0004H\u0007J\b\u0010<\u001a\u00020\u0004H\u0007J\b\u0010=\u001a\u00020\u0004H\u0007J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00040?H\u0007J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00040?H\u0007J\b\u0010A\u001a\u00020\u0004H\u0007J\b\u0010B\u001a\u00020\u0004H\u0007J\b\u0010C\u001a\u00020\u0004H\u0007J\u0010\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u0004H\u0007J\b\u0010F\u001a\u00020\u0004H\u0007J\b\u0010G\u001a\u00020\u0004H\u0007J$\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010IH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\n :*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/facebook/internal/ServerProtocol;", "", "()V", "DIALOG_AUTHORITY_FORMAT", "", "DIALOG_CANCEL_URI", "DIALOG_PARAM_ACCESS_TOKEN", "DIALOG_PARAM_APP_ID", "DIALOG_PARAM_AUTHENTICATION_TOKEN", "DIALOG_PARAM_AUTH_TYPE", "DIALOG_PARAM_CBT", "DIALOG_PARAM_CCT_OVER_LOGGED_OUT_APP_SWITCH", "DIALOG_PARAM_CLIENT_ID", "DIALOG_PARAM_CODE_CHALLENGE", "DIALOG_PARAM_CODE_CHALLENGE_METHOD", "DIALOG_PARAM_CODE_REDIRECT_URI", "DIALOG_PARAM_CUSTOM_TABS_PREFETCHING", "DIALOG_PARAM_DEFAULT_AUDIENCE", "DIALOG_PARAM_DISPLAY", "DIALOG_PARAM_DISPLAY_TOUCH", "DIALOG_PARAM_E2E", "DIALOG_PARAM_FAIL_ON_LOGGED_OUT", "DIALOG_PARAM_FX_APP", "DIALOG_PARAM_IES", "DIALOG_PARAM_LEGACY_OVERRIDE", "DIALOG_PARAM_LOGIN_BEHAVIOR", "DIALOG_PARAM_MESSENGER_PAGE_ID", "DIALOG_PARAM_NONCE", "DIALOG_PARAM_REDIRECT_URI", "DIALOG_PARAM_RESET_MESSENGER_STATE", "DIALOG_PARAM_RESPONSE_TYPE", "DIALOG_PARAM_RETURN_SCOPES", "DIALOG_PARAM_SCOPE", "DIALOG_PARAM_SDK_VERSION", "DIALOG_PARAM_SKIP_DEDUPE", "DIALOG_PARAM_SSO_DEVICE", "DIALOG_PARAM_STATE", "DIALOG_PATH", "DIALOG_REDIRECT_CHROME_OS_URI", "DIALOG_REDIRECT_URI", "DIALOG_REREQUEST_AUTH_TYPE", "DIALOG_RESPONSE_TYPE_CODE", "DIALOG_RESPONSE_TYPE_ID_TOKEN_AND_SIGNED_REQUEST", "DIALOG_RESPONSE_TYPE_TOKEN_AND_SCOPES", "DIALOG_RESPONSE_TYPE_TOKEN_AND_SIGNED_REQUEST", "DIALOG_RETURN_SCOPES_TRUE", "FALLBACK_DIALOG_DISPLAY_VALUE_TOUCH", "FALLBACK_DIALOG_PARAM_APP_ID", "FALLBACK_DIALOG_PARAM_BRIDGE_ARGS", "FALLBACK_DIALOG_PARAM_KEY_HASH", "FALLBACK_DIALOG_PARAM_METHOD_ARGS", "FALLBACK_DIALOG_PARAM_METHOD_RESULTS", "FALLBACK_DIALOG_PARAM_VERSION", "GAMING_DIALOG_AUTHORITY_FORMAT", "GRAPH_URL_FORMAT", "GRAPH_VIDEO_URL_FORMAT", "INSTAGRAM_OAUTH_PATH", "TAG", "kotlin.jvm.PlatformType", "getDefaultAPIVersion", "getDialogAuthority", "getErrorConnectionFailure", "getErrorsProxyAuthDisabled", "", "getErrorsUserCanceled", "getFacebookGraphUrlBase", "getGamingDialogAuthority", "getGraphUrlBase", "getGraphUrlBaseForSubdomain", "subdomain", "getGraphVideoUrlBase", "getInstagramDialogAuthority", "getQueryParamsForPlatformActivityIntentWebFallback", "Landroid/os/Bundle;", "callId", "version", "", "methodArgs", "facebook-core_release"})
public final class ServerProtocol {
    @NotNull
    public static final ServerProtocol INSTANCE = new ServerProtocol();
    private static final String TAG = ServerProtocol.class.getName();
    @NotNull
    private static final String DIALOG_AUTHORITY_FORMAT = "m.%s";
    @NotNull
    private static final String GAMING_DIALOG_AUTHORITY_FORMAT = "%s";
    @NotNull
    public static final String DIALOG_PATH = "dialog/";
    @NotNull
    public static final String DIALOG_PARAM_ACCESS_TOKEN = "access_token";
    @NotNull
    public static final String DIALOG_PARAM_APP_ID = "app_id";
    @NotNull
    public static final String DIALOG_PARAM_AUTH_TYPE = "auth_type";
    @NotNull
    public static final String DIALOG_PARAM_CBT = "cbt";
    @NotNull
    public static final String DIALOG_PARAM_CLIENT_ID = "client_id";
    @NotNull
    public static final String DIALOG_PARAM_CODE_CHALLENGE = "code_challenge";
    @NotNull
    public static final String DIALOG_PARAM_CODE_CHALLENGE_METHOD = "code_challenge_method";
    @NotNull
    public static final String DIALOG_PARAM_CODE_REDIRECT_URI = "code_redirect_uri";
    @NotNull
    public static final String DIALOG_PARAM_CUSTOM_TABS_PREFETCHING = "cct_prefetching";
    @NotNull
    public static final String DIALOG_PARAM_DISPLAY = "display";
    @NotNull
    public static final String DIALOG_PARAM_DISPLAY_TOUCH = "touch";
    @NotNull
    public static final String DIALOG_PARAM_E2E = "e2e";
    @NotNull
    public static final String DIALOG_PARAM_AUTHENTICATION_TOKEN = "id_token";
    @NotNull
    public static final String DIALOG_PARAM_IES = "ies";
    @NotNull
    public static final String DIALOG_PARAM_LEGACY_OVERRIDE = "legacy_override";
    @NotNull
    public static final String DIALOG_PARAM_LOGIN_BEHAVIOR = "login_behavior";
    @NotNull
    public static final String DIALOG_PARAM_NONCE = "nonce";
    @NotNull
    public static final String DIALOG_PARAM_REDIRECT_URI = "redirect_uri";
    @NotNull
    public static final String DIALOG_PARAM_RESPONSE_TYPE = "response_type";
    @NotNull
    public static final String DIALOG_PARAM_RETURN_SCOPES = "return_scopes";
    @NotNull
    public static final String DIALOG_PARAM_SCOPE = "scope";
    @NotNull
    public static final String DIALOG_PARAM_SSO_DEVICE = "sso";
    @NotNull
    public static final String DIALOG_PARAM_DEFAULT_AUDIENCE = "default_audience";
    @NotNull
    public static final String DIALOG_PARAM_SDK_VERSION = "sdk";
    @NotNull
    public static final String DIALOG_PARAM_STATE = "state";
    @NotNull
    public static final String DIALOG_PARAM_FAIL_ON_LOGGED_OUT = "fail_on_logged_out";
    @NotNull
    public static final String DIALOG_PARAM_CCT_OVER_LOGGED_OUT_APP_SWITCH = "cct_over_app_switch";
    @NotNull
    public static final String DIALOG_PARAM_MESSENGER_PAGE_ID = "messenger_page_id";
    @NotNull
    public static final String DIALOG_PARAM_RESET_MESSENGER_STATE = "reset_messenger_state";
    @NotNull
    public static final String DIALOG_REREQUEST_AUTH_TYPE = "rerequest";
    @NotNull
    public static final String DIALOG_PARAM_FX_APP = "fx_app";
    @NotNull
    public static final String DIALOG_PARAM_SKIP_DEDUPE = "skip_dedupe";
    @NotNull
    public static final String DIALOG_RESPONSE_TYPE_CODE = "code,signed_request,graph_domain";
    @NotNull
    public static final String DIALOG_RESPONSE_TYPE_TOKEN_AND_SCOPES = "token,signed_request,graph_domain,granted_scopes";
    @NotNull
    public static final String DIALOG_RESPONSE_TYPE_TOKEN_AND_SIGNED_REQUEST = "token,signed_request,graph_domain";
    @NotNull
    public static final String DIALOG_RESPONSE_TYPE_ID_TOKEN_AND_SIGNED_REQUEST = "id_token,token,signed_request,graph_domain";
    @NotNull
    public static final String DIALOG_RETURN_SCOPES_TRUE = "true";
    @NotNull
    public static final String DIALOG_REDIRECT_URI = "fbconnect://success";
    @NotNull
    public static final String DIALOG_REDIRECT_CHROME_OS_URI = "fbconnect://chrome_os_success";
    @NotNull
    public static final String DIALOG_CANCEL_URI = "fbconnect://cancel";
    @NotNull
    public static final String FALLBACK_DIALOG_PARAM_APP_ID = "app_id";
    @NotNull
    public static final String FALLBACK_DIALOG_PARAM_BRIDGE_ARGS = "bridge_args";
    @NotNull
    public static final String FALLBACK_DIALOG_PARAM_KEY_HASH = "android_key_hash";
    @NotNull
    public static final String FALLBACK_DIALOG_PARAM_METHOD_ARGS = "method_args";
    @NotNull
    public static final String FALLBACK_DIALOG_PARAM_METHOD_RESULTS = "method_results";
    @NotNull
    public static final String FALLBACK_DIALOG_PARAM_VERSION = "version";
    @NotNull
    public static final String FALLBACK_DIALOG_DISPLAY_VALUE_TOUCH = "touch";
    @NotNull
    public static final String INSTAGRAM_OAUTH_PATH = "oauth/authorize";
    @NotNull
    private static final String GRAPH_VIDEO_URL_FORMAT = "https://graph-video.%s";
    @NotNull
    private static final String GRAPH_URL_FORMAT = "https://graph.%s";

    private ServerProtocol() {
    }

    @JvmStatic
    @NotNull
    public static final String getDefaultAPIVersion() {
        return "v16.0";
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> getErrorsProxyAuthDisabled() {
        Object[] objectArray = new String[]{"service_disabled", "AndroidAuthKillSwitchException"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> getErrorsUserCanceled() {
        Object[] objectArray = new String[]{"access_denied", "OAuthAccessDeniedException"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @JvmStatic
    @NotNull
    public static final String getErrorConnectionFailure() {
        return "CONNECTION_FAILURE";
    }

    @JvmStatic
    @NotNull
    public static final String getDialogAuthority() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = DIALOG_AUTHORITY_FORMAT;
        Object[] objectArray = new Object[1];
        objectArray[0] = FacebookSdk.INSTANCE.getFacebookDomain();
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getGamingDialogAuthority() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = GAMING_DIALOG_AUTHORITY_FORMAT;
        Object[] objectArray = new Object[1];
        objectArray[0] = FacebookSdk.INSTANCE.getFacebookGamingDomain();
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getInstagramDialogAuthority() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = DIALOG_AUTHORITY_FORMAT;
        Object[] objectArray = new Object[1];
        objectArray[0] = FacebookSdk.INSTANCE.getInstagramDomain();
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getGraphUrlBase() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = GRAPH_URL_FORMAT;
        Object[] objectArray = new Object[1];
        objectArray[0] = FacebookSdk.INSTANCE.getGraphDomain();
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getGraphVideoUrlBase() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = GRAPH_VIDEO_URL_FORMAT;
        Object[] objectArray = new Object[1];
        objectArray[0] = FacebookSdk.INSTANCE.getGraphDomain();
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getFacebookGraphUrlBase() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = GRAPH_URL_FORMAT;
        Object[] objectArray = new Object[1];
        objectArray[0] = FacebookSdk.INSTANCE.getFacebookDomain();
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getGraphUrlBaseForSubdomain(@NotNull String subdomain) {
        Intrinsics.checkNotNullParameter((Object)subdomain, (String)"subdomain");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = GRAPH_URL_FORMAT;
        Object[] objectArray = new Object[]{subdomain};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final Bundle getQueryParamsForPlatformActivityIntentWebFallback(@NotNull String callId, int version, @Nullable Bundle methodArgs) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        String keyHash = FacebookSdk.getApplicationSignature(context);
        if (Utility.isNullOrEmpty(keyHash)) {
            return null;
        }
        Bundle webParams = new Bundle();
        webParams.putString(FALLBACK_DIALOG_PARAM_KEY_HASH, keyHash);
        webParams.putString("app_id", FacebookSdk.INSTANCE.getApplicationId());
        webParams.putInt(FALLBACK_DIALOG_PARAM_VERSION, version);
        webParams.putString(DIALOG_PARAM_DISPLAY, "touch");
        Bundle bridgeArguments = new Bundle();
        bridgeArguments.putString("action_id", callId);
        try {
            JSONObject bridgeArgsJSON = BundleJSONConverter.convertToJSON(bridgeArguments);
            Bundle bundle = methodArgs;
            JSONObject methodArgsJSON = BundleJSONConverter.convertToJSON(bundle == null ? new Bundle() : bundle);
            if (bridgeArgsJSON == null || methodArgsJSON == null) {
                return null;
            }
            webParams.putString(FALLBACK_DIALOG_PARAM_BRIDGE_ARGS, bridgeArgsJSON.toString());
            webParams.putString(FALLBACK_DIALOG_PARAM_METHOD_ARGS, methodArgsJSON.toString());
        }
        catch (JSONException je) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, 6, string, Intrinsics.stringPlus((String)"Error creating Url -- ", (Object)((Object)je)));
            return null;
        }
        catch (IllegalArgumentException je) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, 6, string, Intrinsics.stringPlus((String)"Error creating Url -- ", (Object)je));
            return null;
        }
        return webParams;
    }
}

