/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.OperationalData;
import com.facebook.appevents.OperationalDataEnum;
import com.facebook.appevents.iap.InAppPurchase;
import com.facebook.appevents.iap.InAppPurchaseActivityLifecycleTracker;
import com.facebook.appevents.iap.InAppPurchaseAutoLogger;
import com.facebook.appevents.iap.InAppPurchaseDedupeConfig;
import com.facebook.appevents.iap.InAppPurchaseLoggerManager;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0002JB\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0007JF\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001b2\u001c\u0010#\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\f0 H\u0007J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0004H\u0003J\b\u0010&\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R<\u0010\b\u001a0\u0012\u0004\u0012\u00020\n\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\f0\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0010\u001a0\u0012\u0004\u0012\u00020\n\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\f0\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseManager;", "", "()V", "GOOGLE_BILLINGCLIENT_VERSION", "", "enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "specificBillingLibraryVersion", "timesOfImplicitPurchases", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/facebook/appevents/iap/InAppPurchase;", "", "Lkotlin/Pair;", "", "Landroid/os/Bundle;", "Lcom/facebook/appevents/OperationalData;", "timesOfManualPurchases", "enableAutoLogging", "", "getBillingClientVersion", "Lcom/facebook/appevents/iap/InAppPurchaseUtils$BillingClientVersion;", "getDedupeParameter", "newPurchaseParameters", "newPurchaseOperationalData", "oldPurchaseParameters", "oldPurchaseOperationalData", "dedupingWithImplicitlyLoggedHistory", "", "withTestDedupeKeys", "getSpecificBillingLibraryVersion", "performDedupe", "purchases", "", "time", "isImplicitlyLogged", "purchaseParameters", "setSpecificBillingLibraryVersion", "version", "startTracking", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseManager {
    @NotNull
    public static final InAppPurchaseManager INSTANCE = new InAppPurchaseManager();
    @NotNull
    private static final ConcurrentHashMap<InAppPurchase, List<Pair<Long, Pair<Bundle, OperationalData>>>> timesOfManualPurchases = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<InAppPurchase, List<Pair<Long, Pair<Bundle, OperationalData>>>> timesOfImplicitPurchases = new ConcurrentHashMap();
    @Nullable
    private static String specificBillingLibraryVersion;
    @NotNull
    private static final String GOOGLE_BILLINGCLIENT_VERSION = "com.google.android.play.billingclient.version";
    @NotNull
    private static final AtomicBoolean enabled;

    private InAppPurchaseManager() {
    }

    @JvmStatic
    public static final void enableAutoLogging() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return;
        }
        try {
            if (!AutomaticAnalyticsLogger.INSTANCE.isImplicitPurchaseLoggingEnabled()) {
                InAppPurchaseLoggerManager.INSTANCE.updateLatestPossiblePurchaseTime();
                return;
            }
            enabled.set(true);
            INSTANCE.startTracking();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void startTracking() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return;
        }
        try {
            if (!enabled.get()) {
                return;
            }
            InAppPurchaseUtils.BillingClientVersion billingClientVersion = INSTANCE.getBillingClientVersion();
            int n = WhenMappings.$EnumSwitchMapping$0[billingClientVersion.ordinal()];
            switch (n) {
                case 1: {
                    return;
                }
                case 2: {
                    InAppPurchaseActivityLifecycleTracker.startIapLogging(InAppPurchaseUtils.BillingClientVersion.V1);
                    break;
                }
                case 3: {
                    if (FeatureManager.isEnabled(FeatureManager.Feature.IapLoggingLib2)) {
                        InAppPurchaseAutoLogger.startIapLogging(FacebookSdk.INSTANCE.getApplicationContext(), billingClientVersion);
                        break;
                    }
                    InAppPurchaseActivityLifecycleTracker.startIapLogging(InAppPurchaseUtils.BillingClientVersion.V2_V4);
                    break;
                }
                case 4: {
                    if (!FeatureManager.isEnabled(FeatureManager.Feature.IapLoggingLib5To7)) break;
                    InAppPurchaseAutoLogger.startIapLogging(FacebookSdk.INSTANCE.getApplicationContext(), billingClientVersion);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return;
        }
    }

    @JvmStatic
    private static final void setSpecificBillingLibraryVersion(String string) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return;
        }
        try {
            String version;
            specificBillingLibraryVersion = version;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getSpecificBillingLibraryVersion() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return null;
        }
        try {
            return specificBillingLibraryVersion;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return null;
        }
    }

    private final InAppPurchaseUtils.BillingClientVersion getBillingClientVersion() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            try {
                String[] stringArray;
                Context context = FacebookSdk.INSTANCE.getApplicationContext();
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.getApplicationInfo(\n                    context.packageName, PackageManager.GET_META_DATA\n                )");
                ApplicationInfo info = applicationInfo;
                Object object = info.metaData.getString(GOOGLE_BILLINGCLIENT_VERSION);
                if (object == null) {
                    return InAppPurchaseUtils.BillingClientVersion.NONE;
                }
                String[] version = stringArray = object;
                object = new String[]{"."};
                List versionArray = StringsKt.split$default((CharSequence)((CharSequence)version), (String[])object, (boolean)false, (int)3, (int)2, null);
                object = (CharSequence)version;
                boolean bl = false;
                if (object.length() == 0) {
                    return InAppPurchaseUtils.BillingClientVersion.V5_V7;
                }
                InAppPurchaseManager.setSpecificBillingLibraryVersion(Intrinsics.stringPlus((String)"GPBL.", (Object)version));
                Integer n = StringsKt.toIntOrNull((String)((String)versionArray.get(0)));
                if (n == null) {
                    return InAppPurchaseUtils.BillingClientVersion.V5_V7;
                }
                int majorVersion = n;
                return majorVersion == 1 ? InAppPurchaseUtils.BillingClientVersion.V1 : (majorVersion < 5 ? InAppPurchaseUtils.BillingClientVersion.V2_V4 : InAppPurchaseUtils.BillingClientVersion.V5_V7);
            }
            catch (Exception e) {
                return InAppPurchaseUtils.BillingClientVersion.V5_V7;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final synchronized Bundle performDedupe(@NotNull List<InAppPurchase> list, long l, boolean bl, @NotNull List<Pair<Bundle, OperationalData>> list2) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return null;
        }
        try {
            void isImplicitlyLogged;
            void purchaseParameters;
            List<InAppPurchase> purchases;
            Intrinsics.checkNotNullParameter(purchases, (String)"purchases");
            Intrinsics.checkNotNullParameter((Object)purchaseParameters, (String)"purchaseParameters");
            Collection collection = (Collection)purchaseParameters;
            boolean bl2 = false;
            int n = 0;
            if (collection.isEmpty()) {
                return null;
            }
            collection = purchaseParameters;
            if (purchases.size() != collection.size()) {
                return null;
            }
            Bundle dedupeParameters = null;
            ArrayList<Pair> purchasesToRemoveFromHistory = new ArrayList<Pair>();
            n = 0;
            int n2 = purchases.size() + -1;
            if (n <= n2) {
                do {
                    List<Pair<Long, Pair<Bundle, OperationalData>>> list3;
                    void time;
                    int i = n++;
                    InAppPurchase purchase = purchases.get(i);
                    Pair pair = (Pair)purchaseParameters.get(i);
                    Bundle newPurchaseParameters = (Bundle)pair.component1();
                    OperationalData newPurchaseOperationalData = (OperationalData)pair.component2();
                    List<Pair<Long, Pair<Bundle, OperationalData>>> dedupeCandidates = null;
                    boolean foundActualDuplicate = false;
                    double d = purchase.getAmount();
                    boolean bl3 = false;
                    InAppPurchase roundedPurchase = new InAppPurchase(purchase.getEventName(), new BigDecimal(String.valueOf(d)).setScale(2, RoundingMode.HALF_UP).doubleValue(), purchase.getCurrency());
                    dedupeCandidates = isImplicitlyLogged != false ? timesOfManualPurchases.get(roundedPurchase) : timesOfImplicitPurchases.get(roundedPurchase);
                    Long oldestValidTime = null;
                    String dedupeParameter = null;
                    String testDedupeParameter = null;
                    Collection collection2 = dedupeCandidates;
                    boolean bl4 = false;
                    boolean l3 = false;
                    if (!(collection2 == null || collection2.isEmpty())) {
                        for (Pair pair2 : dedupeCandidates) {
                            long candidateTime = ((Number)pair2.getFirst()).longValue();
                            Pair pair3 = (Pair)pair2.getSecond();
                            Bundle candidateParameters = (Bundle)pair3.component1();
                            OperationalData candidateOperationalData = (OperationalData)pair3.component2();
                            void var28_50 = time - candidateTime;
                            boolean bl5 = false;
                            if (Math.abs((long)var28_50) > InAppPurchaseDedupeConfig.INSTANCE.getDedupeWindow() || oldestValidTime != null && candidateTime >= oldestValidTime) continue;
                            dedupeParameter = InAppPurchaseManager.getDedupeParameter$default(INSTANCE, newPurchaseParameters, newPurchaseOperationalData, candidateParameters, candidateOperationalData, isImplicitlyLogged == false, false, 32, null);
                            String potentialTestDedupeParameter = INSTANCE.getDedupeParameter(newPurchaseParameters, newPurchaseOperationalData, candidateParameters, candidateOperationalData, isImplicitlyLogged == false, true);
                            if (potentialTestDedupeParameter != null) {
                                testDedupeParameter = potentialTestDedupeParameter;
                            }
                            if (dedupeParameter == null) continue;
                            foundActualDuplicate = true;
                            oldestValidTime = candidateTime;
                            purchasesToRemoveFromHistory.add(new Pair((Object)roundedPurchase, (Object)candidateTime));
                        }
                    }
                    if (testDedupeParameter != null) {
                        if (dedupeParameters == null) {
                            dedupeParameters = new Bundle();
                        }
                        dedupeParameters.putString("fb_iap_test_dedup_result", "1");
                        dedupeParameters.putString("fb_iap_test_dedup_key_used", testDedupeParameter);
                    }
                    if (foundActualDuplicate) {
                        long l2;
                        Long l4;
                        if (dedupeParameters == null) {
                            dedupeParameters = new Bundle();
                        }
                        long oldestValidTimeInSeconds = (l4 = oldestValidTime) == null ? 0L : (l2 = l4 / (long)1000);
                        dedupeParameters.putString("fb_iap_non_deduped_event_time", String.valueOf(oldestValidTimeInSeconds));
                        dedupeParameters.putString("fb_iap_actual_dedup_result", "1");
                        dedupeParameters.putString("fb_iap_actual_dedup_key_used", dedupeParameter);
                    }
                    if (isImplicitlyLogged != false && !foundActualDuplicate) {
                        List<Pair<Long, Pair<Bundle, OperationalData>>> list4;
                        if (timesOfImplicitPurchases.get(roundedPurchase) == null) {
                            Map map = timesOfImplicitPurchases;
                            boolean list5 = false;
                            List list6 = new ArrayList();
                            l3 = false;
                            map.put(roundedPurchase, list6);
                        }
                        if ((list4 = timesOfImplicitPurchases.get(roundedPurchase)) == null) continue;
                        list4.add((Pair<Long, Pair<Bundle, OperationalData>>)new Pair((Object)((long)time), (Object)new Pair((Object)newPurchaseParameters, (Object)newPurchaseOperationalData)));
                        continue;
                    }
                    if (isImplicitlyLogged != false || foundActualDuplicate) continue;
                    if (timesOfManualPurchases.get(roundedPurchase) == null) {
                        Map map = timesOfManualPurchases;
                        boolean bl6 = false;
                        List list4 = new ArrayList();
                        l3 = false;
                        map.put(roundedPurchase, list4);
                    }
                    if ((list3 = timesOfManualPurchases.get(roundedPurchase)) == null) continue;
                    list3.add((Pair<Long, Pair<Bundle, OperationalData>>)new Pair((Object)((long)time), (Object)new Pair((Object)newPurchaseParameters, (Object)newPurchaseOperationalData)));
                } while (n <= n2);
            }
            for (Pair purchaseInfo : purchasesToRemoveFromHistory) {
                List<Pair<Long, Pair<Bundle, OperationalData>>> purchaseHistory;
                List<Pair<Long, Pair<Bundle, OperationalData>>> list5 = purchaseHistory = isImplicitlyLogged != false ? timesOfManualPurchases.get(purchaseInfo.getFirst()) : timesOfImplicitPurchases.get(purchaseInfo.getFirst());
                if (purchaseHistory == null) continue;
                Object object = purchaseHistory.iterator();
                int n3 = 0;
                while (object.hasNext()) {
                    int index = n3++;
                    Pair<Long, Pair<Bundle, OperationalData>> timeBundlePair = object.next();
                    if (((Number)timeBundlePair.getFirst()).longValue() != ((Number)purchaseInfo.getSecond()).longValue()) continue;
                    purchaseHistory.remove(index);
                    break;
                }
                if (isImplicitlyLogged != false) {
                    if (purchaseHistory.isEmpty()) {
                        timesOfManualPurchases.remove(purchaseInfo.getFirst());
                        continue;
                    }
                    object = timesOfManualPurchases;
                    Object object2 = purchaseInfo.getFirst();
                    boolean bl7 = false;
                    object.put(object2, purchaseHistory);
                    continue;
                }
                if (purchaseHistory.isEmpty()) {
                    timesOfImplicitPurchases.remove(purchaseInfo.getFirst());
                    continue;
                }
                object = timesOfImplicitPurchases;
                Object object3 = purchaseInfo.getFirst();
                boolean bl8 = false;
                object.put(object3, purchaseHistory);
            }
            return dedupeParameters;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getDedupeParameter(@Nullable Bundle bundle, @Nullable OperationalData operationalData, @Nullable Bundle bundle2, @Nullable OperationalData operationalData2, boolean bl, boolean bl2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void dedupingWithImplicitlyLoggedHistory;
            void withTestDedupeKeys;
            List<Pair<String, List<String>>> dedupeParameters;
            List<Pair<String, List<String>>> list = dedupeParameters = withTestDedupeKeys != false ? InAppPurchaseDedupeConfig.INSTANCE.getTestDedupeParameters((boolean)dedupingWithImplicitlyLoggedHistory) : InAppPurchaseDedupeConfig.INSTANCE.getDedupeParameters((boolean)dedupingWithImplicitlyLoggedHistory);
            if (dedupeParameters == null) {
                return null;
            }
            for (Pair<String, List<String>> parameter : dedupeParameters) {
                void newPurchaseOperationalData;
                void newPurchaseParameters;
                Iterator iterator = OperationalData.Companion.getParameter(OperationalDataEnum.IAPParameters, (String)parameter.getFirst(), (Bundle)newPurchaseParameters, (OperationalData)newPurchaseOperationalData);
                String parameterInNewEvent = iterator instanceof String ? (String)((Object)iterator) : null;
                iterator = parameterInNewEvent;
                boolean bl3 = false;
                boolean bl4 = false;
                if (iterator == null || iterator.length() == 0) continue;
                for (String equivalentParameter : (List)parameter.getSecond()) {
                    void oldPurchaseOperationalData;
                    void oldPurchaseParameters;
                    Object object = OperationalData.Companion.getParameter(OperationalDataEnum.IAPParameters, equivalentParameter, (Bundle)oldPurchaseParameters, (OperationalData)oldPurchaseOperationalData);
                    String parameterInOldEvent = object instanceof String ? (String)object : null;
                    object = parameterInOldEvent;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if (object == null || object.length() == 0 || !Intrinsics.areEqual((Object)parameterInOldEvent, (Object)parameterInNewEvent)) continue;
                    return dedupingWithImplicitlyLoggedHistory != false ? (String)parameter.getFirst() : equivalentParameter;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    public static /* synthetic */ String getDedupeParameter$default(InAppPurchaseManager inAppPurchaseManager, Bundle bundle, OperationalData operationalData, Bundle bundle2, OperationalData operationalData2, boolean bl, boolean bl2, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return null;
        }
        try {
            if ((n & 0x20) != 0) {
                bl2 = false;
            }
            return inAppPurchaseManager.getDedupeParameter(bundle, operationalData, bundle2, operationalData2, bl, bl2);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return null;
        }
    }

    static {
        enabled = new AtomicBoolean(false);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InAppPurchaseUtils.BillingClientVersion.values().length];
            nArray[InAppPurchaseUtils.BillingClientVersion.NONE.ordinal()] = 1;
            nArray[InAppPurchaseUtils.BillingClientVersion.V1.ordinal()] = 2;
            nArray[InAppPurchaseUtils.BillingClientVersion.V2_V4.ordinal()] = 3;
            nArray[InAppPurchaseUtils.BillingClientVersion.V5_V7.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

