/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.AuthenticationToken;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.Utility;
import com.facebook.login.LoginClient;
import com.facebook.login.PKCEUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u0000 52\u00020\u0001:\u00015B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0014J\b\u0010\u001d\u001a\u00020\rH\u0014J\u0012\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)H\u0014J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020!H\u0016J\u0010\u00101\u001a\u00020$2\u0006\u0010*\u001a\u00020+H&J\u0018\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020$H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004R,\u0010\u000b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00066"}, d2={"Lcom/facebook/login/LoginMethodHandler;", "Landroid/os/Parcelable;", "loginClient", "Lcom/facebook/login/LoginClient;", "(Lcom/facebook/login/LoginClient;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getLoginClient", "()Lcom/facebook/login/LoginClient;", "setLoginClient", "methodLoggingExtras", "", "", "getMethodLoggingExtras", "()Ljava/util/Map;", "setMethodLoggingExtras", "(Ljava/util/Map;)V", "nameForLogging", "getNameForLogging", "()Ljava/lang/String;", "addLoggingExtra", "", "key", "value", "", "cancel", "getClientState", "authId", "getRedirectUrl", "logWebLoginCompleted", "e2e", "needsInternetPermission", "", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "processCodeExchange", "Landroid/os/Bundle;", "request", "Lcom/facebook/login/LoginClient$Request;", "values", "putChallengeParam", "param", "Lorg/json/JSONObject;", "shouldKeepTrackOfMultipleIntents", "tryAuthorize", "writeToParcel", "dest", "flags", "Companion", "facebook-common_release"})
@VisibleForTesting(otherwise=3)
public abstract class LoginMethodHandler
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<String, String> methodLoggingExtras;
    public LoginClient loginClient;
    @NotNull
    public static final String USER_CANCELED_LOG_IN_ERROR_MESSAGE = "User canceled log in.";
    @NotNull
    public static final String NO_SIGNED_REQUEST_ERROR_MESSAGE = "Authorization response does not contain the signed_request";
    @NotNull
    public static final String NO_USER_ID_ERROR_MESSAGE = "Failed to retrieve user_id from signed_request";

    @Nullable
    public final Map<String, String> getMethodLoggingExtras() {
        return this.methodLoggingExtras;
    }

    public final void setMethodLoggingExtras(@Nullable Map<String, String> map) {
        this.methodLoggingExtras = map;
    }

    @NotNull
    public final LoginClient getLoginClient() {
        LoginClient loginClient = this.loginClient;
        if (loginClient != null) {
            return loginClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"loginClient");
        return null;
    }

    public final void setLoginClient(@NotNull LoginClient loginClient) {
        Intrinsics.checkNotNullParameter((Object)loginClient, (String)"<set-?>");
        this.loginClient = loginClient;
    }

    @NotNull
    public abstract String getNameForLogging();

    public LoginMethodHandler(@NotNull LoginClient loginClient) {
        Intrinsics.checkNotNullParameter((Object)loginClient, (String)"loginClient");
        this.setLoginClient(loginClient);
    }

    protected LoginMethodHandler(@NotNull Parcel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Map map = Utility.readStringMapFromParcel((Parcel)source);
        this.methodLoggingExtras = map != null ? MapsKt.toMutableMap((Map)map) : null;
    }

    public abstract int tryAuthorize(@NotNull LoginClient.Request var1);

    public boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        return false;
    }

    public boolean needsInternetPermission() {
        return false;
    }

    public void cancel() {
    }

    public void putChallengeParam(@NotNull JSONObject param) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
    }

    @NotNull
    protected String getRedirectUrl() {
        return "fb" + FacebookSdk.getApplicationId() + "://authorize/";
    }

    @NotNull
    protected String getClientState(@NotNull String authId) {
        Intrinsics.checkNotNullParameter((Object)authId, (String)"authId");
        JSONObject param = new JSONObject();
        try {
            param.put("0_auth_logger_id", (Object)authId);
            param.put("3_method", (Object)this.getNameForLogging());
            this.putChallengeParam(param);
        }
        catch (JSONException e) {
            Log.w((String)"LoginMethodHandler", (String)("Error creating client state json: " + e.getMessage()));
        }
        String string2 = param.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"param.toString()");
        return string2;
    }

    protected void addLoggingExtra(@Nullable String key, @Nullable Object value) {
        block1: {
            if (this.methodLoggingExtras == null) {
                this.methodLoggingExtras = new HashMap();
            }
            Map<String, String> map = this.methodLoggingExtras;
            if (map == null) break block1;
            Object object = value;
            map.put(key, object != null ? object.toString() : null);
        }
    }

    protected void logWebLoginCompleted(@Nullable String e2e) {
        Object object = this.getLoginClient().getPendingRequest();
        if (object == null || (object = ((LoginClient.Request)object).getApplicationId()) == null) {
            object = FacebookSdk.getApplicationId();
        }
        Object applicationId = object;
        InternalAppEventsLogger logger = new InternalAppEventsLogger((Context)this.getLoginClient().getActivity(), (String)applicationId);
        Bundle parameters = new Bundle();
        parameters.putString("fb_web_login_e2e", e2e);
        parameters.putLong("fb_web_login_switchback_time", System.currentTimeMillis());
        parameters.putString("app_id", (String)applicationId);
        logger.logEventImplicitly("fb_dialogs_web_login_dialog_complete", null, parameters);
    }

    @NotNull
    protected Bundle processCodeExchange(@NotNull LoginClient.Request request, @NotNull Bundle values) throws FacebookException {
        String string2;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                String code = values.getString("code");
                if (Utility.isNullOrEmpty((String)code)) {
                    throw new FacebookException("No code param found from the request");
                }
                string2 = code;
                if (string2 == null) break block11;
                String it = string2;
                boolean bl = false;
                String string3 = this.getRedirectUrl();
                String string4 = request.getCodeVerifier();
                if (string4 == null) {
                    string4 = "";
                }
                GraphRequest graphRequest = PKCEUtil.createCodeExchangeRequest(it, string3, string4);
                string2 = graphRequest;
                if (graphRequest != null) break block12;
            }
            throw new FacebookException("Failed to create code exchange request");
        }
        String codeExchangeRequest = string2;
        GraphResponse PKCEResponse = codeExchangeRequest.executeAndWait();
        FacebookRequestError facebookRequestError = PKCEResponse.getError();
        if (facebookRequestError != null) {
            FacebookRequestError requestError = facebookRequestError;
            boolean bl = false;
            throw new FacebookServiceException(requestError, requestError.getErrorMessage());
        }
        try {
            String accessTokenString;
            JSONObject PKCEResultJson;
            JSONObject jSONObject = PKCEResultJson = PKCEResponse.getJSONObject();
            String string5 = accessTokenString = jSONObject != null ? jSONObject.getString("access_token") : null;
            if (PKCEResultJson == null || Utility.isNullOrEmpty((String)accessTokenString)) {
                throw new FacebookException("No access token found from result");
            }
            values.putString("access_token", accessTokenString);
            if (PKCEResultJson.has("id_token")) {
                values.putString("id_token", PKCEResultJson.getString("id_token"));
            }
        }
        catch (JSONException ex) {
            throw new FacebookException("Fail to process code exchange response: " + ex.getMessage());
        }
        return values;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Utility.writeStringMapToParcel((Parcel)dest, this.methodLoggingExtras);
    }

    public boolean shouldKeepTrackOfMultipleIntents() {
        return false;
    }

    @JvmStatic
    @Nullable
    public static final AuthenticationToken createAuthenticationTokenFromNativeLogin(@NotNull Bundle bundle, @Nullable String expectedNonce) throws FacebookException {
        return Companion.createAuthenticationTokenFromNativeLogin(bundle, expectedNonce);
    }

    @JvmStatic
    @Nullable
    public static final AccessToken createAccessTokenFromNativeLogin(@NotNull Bundle bundle, @Nullable AccessTokenSource source, @NotNull String applicationId) {
        return Companion.createAccessTokenFromNativeLogin(bundle, source, applicationId);
    }

    @JvmStatic
    @Nullable
    public static final AuthenticationToken createAuthenticationTokenFromWebBundle(@NotNull Bundle bundle, @Nullable String expectedNonce) throws FacebookException {
        return Companion.createAuthenticationTokenFromWebBundle(bundle, expectedNonce);
    }

    @JvmStatic
    @Nullable
    public static final AccessToken createAccessTokenFromWebBundle(@Nullable Collection<String> requestedPermissions, @NotNull Bundle bundle, @Nullable AccessTokenSource source, @NotNull String applicationId) throws FacebookException {
        return Companion.createAccessTokenFromWebBundle(requestedPermissions, bundle, source, applicationId);
    }

    @JvmStatic
    @NotNull
    public static final String getUserIDFromSignedRequest(@Nullable String signedRequest) throws FacebookException {
        return Companion.getUserIDFromSignedRequest(signedRequest);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J6\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/login/LoginMethodHandler$Companion;", "", "()V", "NO_SIGNED_REQUEST_ERROR_MESSAGE", "", "NO_USER_ID_ERROR_MESSAGE", "USER_CANCELED_LOG_IN_ERROR_MESSAGE", "createAccessTokenFromNativeLogin", "Lcom/facebook/AccessToken;", "bundle", "Landroid/os/Bundle;", "source", "Lcom/facebook/AccessTokenSource;", "applicationId", "createAccessTokenFromWebBundle", "requestedPermissions", "", "createAuthenticationTokenFromNativeLogin", "Lcom/facebook/AuthenticationToken;", "expectedNonce", "createAuthenticationTokenFromWebBundle", "getUserIDFromSignedRequest", "signedRequest", "facebook-common_release"})
    @SourceDebugExtension(value={"SMAP\nLoginMethodHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginMethodHandler.kt\ncom/facebook/login/LoginMethodHandler$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,324:1\n37#2,2:325\n37#2,2:327\n37#2,2:329\n37#2,2:331\n*S KotlinDebug\n*F\n+ 1 LoginMethodHandler.kt\ncom/facebook/login/LoginMethodHandler$Companion\n*L\n273#1:325,2\n278#1:327,2\n283#1:329,2\n312#1:331,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final AuthenticationToken createAuthenticationTokenFromNativeLogin(@NotNull Bundle bundle, @Nullable String expectedNonce) throws FacebookException {
            AuthenticationToken authenticationToken;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            String authenticationTokenString = bundle.getString("com.facebook.platform.extra.ID_TOKEN");
            if (authenticationTokenString == null || ((CharSequence)authenticationTokenString).length() == 0 || expectedNonce == null || ((CharSequence)expectedNonce).length() == 0) {
                authenticationToken = null;
            } else {
                AuthenticationToken authenticationToken2;
                try {
                    authenticationToken2 = new AuthenticationToken(authenticationTokenString, expectedNonce);
                }
                catch (Exception _ex) {
                    throw new FacebookException(_ex.getMessage());
                }
                authenticationToken = authenticationToken2;
            }
            return authenticationToken;
        }

        @JvmStatic
        @Nullable
        public final AccessToken createAccessTokenFromNativeLogin(@NotNull Bundle bundle, @Nullable AccessTokenSource source, @NotNull String applicationId) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Date expires = Utility.getBundleLongAsDate((Bundle)bundle, (String)"com.facebook.platform.extra.EXPIRES_SECONDS_SINCE_EPOCH", (Date)new Date(0L));
            ArrayList permissions = bundle.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
            String token = bundle.getString("com.facebook.platform.extra.ACCESS_TOKEN");
            Date dataAccessExpirationTime = Utility.getBundleLongAsDate((Bundle)bundle, (String)"com.facebook.platform.extra.EXTRA_DATA_ACCESS_EXPIRATION_TIME", (Date)new Date(0L));
            if (token == null || ((CharSequence)token).length() == 0) {
                return null;
            }
            String userId = bundle.getString("com.facebook.platform.extra.USER_ID");
            if (userId == null || ((CharSequence)userId).length() == 0) {
                return null;
            }
            String graphDomain = bundle.getString("graph_domain");
            return new AccessToken(token, applicationId, userId, (Collection)permissions, null, null, source, expires, new Date(), dataAccessExpirationTime, graphDomain);
        }

        @JvmStatic
        @Nullable
        public final AuthenticationToken createAuthenticationTokenFromWebBundle(@NotNull Bundle bundle, @Nullable String expectedNonce) throws FacebookException {
            AuthenticationToken authenticationToken;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            String authenticationTokenString = bundle.getString("id_token");
            if (authenticationTokenString == null || ((CharSequence)authenticationTokenString).length() == 0 || expectedNonce == null || ((CharSequence)expectedNonce).length() == 0) {
                authenticationToken = null;
            } else {
                AuthenticationToken authenticationToken2;
                try {
                    authenticationToken2 = new AuthenticationToken(authenticationTokenString, expectedNonce);
                }
                catch (Exception ex) {
                    throw new FacebookException(ex.getMessage(), (Throwable)ex);
                }
                authenticationToken = authenticationToken2;
            }
            return authenticationToken;
        }

        @JvmStatic
        @Nullable
        public final AccessToken createAccessTokenFromWebBundle(@Nullable Collection<String> requestedPermissions, @NotNull Bundle bundle, @Nullable AccessTokenSource source, @NotNull String applicationId) throws FacebookException {
            Object thisCollection$iv;
            Object thisCollection$iv2;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Collection grantedRequestedPermissions = requestedPermissions;
            Date expires = Utility.getBundleLongAsDate((Bundle)bundle, (String)"expires_in", (Date)new Date());
            String string2 = bundle.getString("access_token");
            if (string2 == null) {
                return null;
            }
            String token = string2;
            Date dataAccessExpirationTime = Utility.getBundleLongAsDate((Bundle)bundle, (String)"data_access_expiration_time", (Date)new Date(0L));
            String grantedPermissions = bundle.getString("granted_scopes");
            if (grantedPermissions != null && ((CharSequence)grantedPermissions).length() > 0) {
                String[] stringArray = new String[]{","};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)grantedPermissions, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray2 = false;
                thisCollection$iv2 = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
                grantedRequestedPermissions = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
            }
            String deniedPermissions = bundle.getString("denied_scopes");
            List declinedPermissions = null;
            if (deniedPermissions != null && ((CharSequence)deniedPermissions).length() > 0) {
                thisCollection$iv2 = new String[]{","};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)deniedPermissions, (String[])thisCollection$iv2, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray3 = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] $i$f$toTypedArray2 = thisCollection$iv.toArray(new String[0]);
                declinedPermissions = CollectionsKt.arrayListOf((Object[])Arrays.copyOf($i$f$toTypedArray2, $i$f$toTypedArray2.length));
            }
            String expiredScopes = bundle.getString("expired_scopes");
            List expiredPermissions = null;
            if (expiredScopes != null && ((CharSequence)expiredScopes).length() > 0) {
                thisCollection$iv = new String[]{","};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)expiredScopes, (String[])thisCollection$iv, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv3 = $this$toTypedArray$iv;
                String[] $i$f$toTypedArray3 = thisCollection$iv3.toArray(new String[0]);
                expiredPermissions = CollectionsKt.arrayListOf((Object[])Arrays.copyOf($i$f$toTypedArray3, $i$f$toTypedArray3.length));
            }
            if (Utility.isNullOrEmpty((String)token)) {
                return null;
            }
            String graphDomain = bundle.getString("graph_domain");
            String signedRequest = bundle.getString("signed_request");
            String userId = this.getUserIDFromSignedRequest(signedRequest);
            return new AccessToken(token, applicationId, userId, grantedRequestedPermissions, (Collection)declinedPermissions, (Collection)expiredPermissions, source, expires, new Date(), dataAccessExpirationTime, graphDomain);
        }

        @JvmStatic
        @NotNull
        public final String getUserIDFromSignedRequest(@Nullable String signedRequest) throws FacebookException {
            if (signedRequest == null || ((CharSequence)signedRequest).length() == 0) {
                throw new FacebookException(LoginMethodHandler.NO_SIGNED_REQUEST_ERROR_MESSAGE);
            }
            try {
                String[] stringArray = new String[]{"."};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)signedRequest, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] signatureAndPayload = thisCollection$iv.toArray(new String[0]);
                if (signatureAndPayload.length == 2) {
                    byte[] data = Base64.decode((String)signatureAndPayload[1], (int)0);
                    Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                    String dataStr = new String(data, Charsets.UTF_8);
                    JSONObject jsonObject = new JSONObject(dataStr);
                    String string2 = jsonObject.getString("user_id");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.getString(\"user_id\")");
                    return string2;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            throw new FacebookException(LoginMethodHandler.NO_USER_ID_ERROR_MESSAGE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

