/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.share.internal.CameraEffectJSONUtility;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareCameraEffectContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareHashtag;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareMediaContent;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareStoryContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0007J \u0010 \u001a\u00020\u00042\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\""}, d2={"Lcom/facebook/share/internal/NativeDialogParameters;", "", "()V", "create", "Landroid/os/Bundle;", "cameraEffectContent", "Lcom/facebook/share/model/ShareCameraEffectContent;", "attachmentUrlsBundle", "dataErrorsFatal", "", "linkContent", "Lcom/facebook/share/model/ShareLinkContent;", "mediaContent", "Lcom/facebook/share/model/ShareMediaContent;", "mediaInfos", "", "photoContent", "Lcom/facebook/share/model/SharePhotoContent;", "imageUrls", "", "storyContent", "Lcom/facebook/share/model/ShareStoryContent;", "mediaInfo", "stickerInfo", "videoContent", "Lcom/facebook/share/model/ShareVideoContent;", "videoUrl", "callId", "Ljava/util/UUID;", "shareContent", "Lcom/facebook/share/model/ShareContent;", "shouldFailOnDataError", "createBaseParameters", "content", "facebook-common_release"})
public final class NativeDialogParameters {
    @NotNull
    public static final NativeDialogParameters INSTANCE = new NativeDialogParameters();

    private NativeDialogParameters() {
    }

    @JvmStatic
    @Nullable
    public static final Bundle create(@NotNull UUID callId, @NotNull ShareContent<?, ?> shareContent, boolean shouldFailOnDataError) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        Intrinsics.checkNotNullParameter(shareContent, (String)"shareContent");
        Bundle nativeParams = null;
        ShareContent<?, ?> shareContent2 = shareContent;
        if (shareContent2 instanceof ShareLinkContent) {
            nativeParams = INSTANCE.create((ShareLinkContent)shareContent, shouldFailOnDataError);
        } else if (shareContent2 instanceof SharePhotoContent) {
            List list;
            List list2 = ShareInternalUtility.getPhotoUrls((SharePhotoContent)shareContent, callId);
            if (list2 == null) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            } else {
                list = list2;
            }
            List photoUrls = list;
            nativeParams = INSTANCE.create((SharePhotoContent)shareContent, photoUrls, shouldFailOnDataError);
        } else if (shareContent2 instanceof ShareVideoContent) {
            String videoUrl = ShareInternalUtility.getVideoUrl((ShareVideoContent)shareContent, callId);
            nativeParams = INSTANCE.create((ShareVideoContent)shareContent, videoUrl, shouldFailOnDataError);
        } else if (shareContent2 instanceof ShareMediaContent) {
            List list;
            List list3 = ShareInternalUtility.getMediaInfos((ShareMediaContent)shareContent, callId);
            if (list3 == null) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            } else {
                list = list3;
            }
            List mediaInfos = list;
            nativeParams = INSTANCE.create((ShareMediaContent)shareContent, mediaInfos, shouldFailOnDataError);
        } else if (shareContent2 instanceof ShareCameraEffectContent) {
            Bundle attachmentUrlsBundle = ShareInternalUtility.getTextureUrlBundle((ShareCameraEffectContent)shareContent, callId);
            nativeParams = INSTANCE.create((ShareCameraEffectContent)shareContent, attachmentUrlsBundle, shouldFailOnDataError);
        } else if (shareContent2 instanceof ShareStoryContent) {
            Bundle mediaInfo = ShareInternalUtility.getBackgroundAssetMediaInfo((ShareStoryContent)shareContent, callId);
            Bundle stickerInfo = ShareInternalUtility.getStickerUrl((ShareStoryContent)shareContent, callId);
            nativeParams = INSTANCE.create((ShareStoryContent)shareContent, mediaInfo, stickerInfo, shouldFailOnDataError);
        }
        return nativeParams;
    }

    private final Bundle create(ShareCameraEffectContent cameraEffectContent, Bundle attachmentUrlsBundle, boolean dataErrorsFatal) {
        Bundle params = this.createBaseParameters(cameraEffectContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"effect_id", (String)cameraEffectContent.getEffectId());
        if (attachmentUrlsBundle != null) {
            params.putBundle("effect_textures", attachmentUrlsBundle);
        }
        try {
            JSONObject argsJSON = CameraEffectJSONUtility.convertToJSON(cameraEffectContent.getArguments());
            if (argsJSON != null) {
                Utility.putNonEmptyString((Bundle)params, (String)"effect_arguments", (String)argsJSON.toString());
            }
        }
        catch (JSONException e) {
            throw new FacebookException(Intrinsics.stringPlus((String)"Unable to create a JSON Object from the provided CameraEffectArguments: ", (Object)e.getMessage()));
        }
        return params;
    }

    private final Bundle create(ShareLinkContent linkContent, boolean dataErrorsFatal) {
        Bundle params = this.createBaseParameters(linkContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"QUOTE", (String)linkContent.getQuote());
        Utility.putUri((Bundle)params, (String)"MESSENGER_LINK", (Uri)linkContent.getContentUrl());
        Utility.putUri((Bundle)params, (String)"TARGET_DISPLAY", (Uri)linkContent.getContentUrl());
        return params;
    }

    private final Bundle create(SharePhotoContent photoContent, List<String> imageUrls, boolean dataErrorsFatal) {
        Bundle params = this.createBaseParameters(photoContent, dataErrorsFatal);
        params.putStringArrayList("PHOTOS", new ArrayList(imageUrls));
        return params;
    }

    private final Bundle create(ShareVideoContent videoContent, String videoUrl, boolean dataErrorsFatal) {
        Bundle params = this.createBaseParameters(videoContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"TITLE", (String)videoContent.getContentTitle());
        Utility.putNonEmptyString((Bundle)params, (String)"DESCRIPTION", (String)videoContent.getContentDescription());
        Utility.putNonEmptyString((Bundle)params, (String)"VIDEO", (String)videoUrl);
        return params;
    }

    private final Bundle create(ShareMediaContent mediaContent, List<Bundle> mediaInfos, boolean dataErrorsFatal) {
        Bundle params = this.createBaseParameters(mediaContent, dataErrorsFatal);
        params.putParcelableArrayList("MEDIA", new ArrayList(mediaInfos));
        return params;
    }

    private final Bundle create(ShareStoryContent storyContent, Bundle mediaInfo, Bundle stickerInfo, boolean dataErrorsFatal) {
        Bundle params = this.createBaseParameters(storyContent, dataErrorsFatal);
        if (mediaInfo != null) {
            params.putParcelable("bg_asset", (Parcelable)mediaInfo);
        }
        if (stickerInfo != null) {
            params.putParcelable("interactive_asset_uri", (Parcelable)stickerInfo);
        }
        List<String> backgroundColorList = storyContent.getBackgroundColorList();
        Collection collection = backgroundColorList;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            params.putStringArrayList("top_background_color_list", new ArrayList(backgroundColorList));
        }
        Utility.putNonEmptyString((Bundle)params, (String)"content_url", (String)storyContent.getAttributionLink());
        return params;
    }

    private final Bundle createBaseParameters(ShareContent<?, ?> content, boolean dataErrorsFatal) {
        Bundle params = new Bundle();
        Utility.putUri((Bundle)params, (String)"LINK", (Uri)content.getContentUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"PLACE", (String)content.getPlaceId());
        Utility.putNonEmptyString((Bundle)params, (String)"PAGE", (String)content.getPageId());
        Utility.putNonEmptyString((Bundle)params, (String)"REF", (String)content.getRef());
        Utility.putNonEmptyString((Bundle)params, (String)"REF", (String)content.getRef());
        params.putBoolean("DATA_FAILURES_FATAL", dataErrorsFatal);
        List<String> peopleIds = content.getPeopleIds();
        Object object = peopleIds;
        boolean bl = false;
        boolean bl2 = false;
        if (!(object == null || object.isEmpty())) {
            params.putStringArrayList("FRIENDS", new ArrayList(peopleIds));
        }
        Utility.putNonEmptyString((Bundle)params, (String)"HASHTAG", (String)((object = content.getShareHashtag()) == null ? null : ((ShareHashtag)object).getHashtag()));
        return params;
    }
}

