/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.util.process;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.AnyThread;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;

@AnyThread
@Keep
public final class ProcessUtils {
    private static final AtomicBoolean sRemoteRenderingProcess = new AtomicBoolean();
    @Nullable
    private static String sProcessName;

    private ProcessUtils() {
    }

    public static void setRemoteRenderingProcess(boolean value) {
        sRemoteRenderingProcess.set(value);
    }

    public static boolean isRemoteRenderingProcess() {
        return sRemoteRenderingProcess.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getProcessName(Context context) {
        Class<ProcessUtils> clazz = ProcessUtils.class;
        synchronized (ProcessUtils.class) {
            if (sProcessName != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sProcessName;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (Build.VERSION.SDK_INT >= 28) {
                return ProcessUtils.getProcessNameAPI28();
            }
            Context applicationContext = context.getApplicationContext();
            if (applicationContext instanceof Application) {
                String processName = ProcessUtils.getProcessNameViaReflection((Application)applicationContext);
                Class<ProcessUtils> clazz2 = ProcessUtils.class;
                synchronized (ProcessUtils.class) {
                    sProcessName = processName;
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return sProcessName;
                }
            }
            return null;
        }
    }

    @Nullable
    private static String getProcessNameAPI28() {
        try {
            Method getProcessName = Application.class.getMethod("getProcessName", null);
            return (String)getProcessName.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static String getProcessNameViaReflection(Application app) {
        try {
            Field loadedApkField = app.getClass().getField("mLoadedApk");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(app);
            Field activityThreadField = loadedApk.getClass().getDeclaredField("mActivityThread");
            activityThreadField.setAccessible(true);
            Object activityThread = activityThreadField.get(loadedApk);
            Method getProcessName = activityThread.getClass().getDeclaredMethod("getProcessName", null);
            return (String)getProcessName.invoke(activityThread, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getProcessSpecificName(String originalName, Context context) {
        String packageName = context.getPackageName();
        String processName = ProcessUtils.getProcessName(context);
        if (!TextUtils.isEmpty((CharSequence)processName) && !packageName.equals(processName)) {
            String shortProcessName = processName.contains(":") ? processName.split(":")[1] : processName;
            return originalName + "_" + shortProcessName;
        }
        return originalName;
    }
}

