/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import androidx.annotation.Keep;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.ads.internal.util.common.Preconditions;
import com.facebook.infer.annotation.Nullsafe;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
public final class AudienceNetworkAds {
    public static final String TAG = "FBAudienceNetwork";

    private AudienceNetworkAds() {
    }

    public static void initialize(Context context) {
        Preconditions.checkNotNull(context, "Context can not be null.");
        DynamicLoaderFactory.initialize(context, null, null, false);
    }

    public static boolean isInitialized(Context context) {
        if (DynamicLoaderFactory.getDynamicLoader() == null) {
            return false;
        }
        return DynamicLoaderFactory.makeLoader(context).createAudienceNetworkAdsApi().isInitialized();
    }

    public static InitSettingsBuilder buildInitSettings(Context context) {
        Preconditions.checkNotNull(context, "Context can not be null.");
        return new com.facebook.ads.internal.api.InitSettingsBuilder(context);
    }

    public static int getAdFormatForPlacement(Context context, String placementId) {
        return DynamicLoaderFactory.makeLoader(context).createAudienceNetworkAdsApi().getAdFormatForPlacement(placementId);
    }

    @Keep
    public static interface InitListener {
        public void onInitialized(InitResult var1);
    }

    @Keep
    public static interface InitResult {
        public boolean isSuccess();

        public String getMessage();
    }

    @Keep
    public static interface InitSettingsBuilder {
        public InitSettingsBuilder withPlacementIds(List<String> var1);

        public InitSettingsBuilder withMediationService(String var1);

        public InitSettingsBuilder withInitListener(InitListener var1);

        public void initialize();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Keep
    public static @interface AdFormat {
        public static final int UNKNOWN = 0;
        public static final int BANNER = 1;
        public static final int INTERSTITIAL = 2;
        public static final int NATIVE = 4;
        public static final int NATIVE_BANNER = 5;
        public static final int REWARDED_VIDEO = 6;
    }
}

