/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.ads.internal.api.AdSizeApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Serializable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
public class AdSize
implements Serializable {
    @Deprecated
    public static final AdSize BANNER_320_50 = new AdSize(4);
    public static final AdSize INTERSTITIAL = new AdSize(100);
    public static final AdSize BANNER_HEIGHT_50 = new AdSize(5);
    public static final AdSize BANNER_HEIGHT_90 = new AdSize(6);
    public static final AdSize RECTANGLE_HEIGHT_250 = new AdSize(7);
    private final int mInitWidth;
    private final int mInitHeight;
    private final int mInitSizeType;
    private final int UNDEFINED = -1;
    @Nullable
    private AdSizeApi mAdSizeApi;

    public AdSize(int width, int height) {
        this.mInitSizeType = -1;
        this.mInitWidth = width;
        this.mInitHeight = height;
    }

    private AdSize(int sizeType) {
        this.mInitSizeType = sizeType;
        this.mInitWidth = -1;
        this.mInitHeight = -1;
    }

    public int getWidth() {
        if (this.mInitSizeType != -1) {
            return this.getAdSizeApi(this.mInitSizeType).getWidth();
        }
        return this.mInitWidth;
    }

    public int getHeight() {
        if (this.mInitSizeType != -1) {
            return this.getAdSizeApi(this.mInitSizeType).getHeight();
        }
        return this.mInitHeight;
    }

    public static AdSize fromWidthAndHeight(int width, int height) {
        if (INTERSTITIAL.getHeight() == height && INTERSTITIAL.getWidth() == width) {
            return INTERSTITIAL;
        }
        if (BANNER_320_50.getHeight() == height && BANNER_320_50.getWidth() == width) {
            return BANNER_320_50;
        }
        if (BANNER_HEIGHT_50.getHeight() == height && BANNER_HEIGHT_50.getWidth() == width) {
            return BANNER_HEIGHT_50;
        }
        if (BANNER_HEIGHT_90.getHeight() == height && BANNER_HEIGHT_90.getWidth() == width) {
            return BANNER_HEIGHT_90;
        }
        if (RECTANGLE_HEIGHT_250.getHeight() == height && RECTANGLE_HEIGHT_250.getWidth() == width) {
            return RECTANGLE_HEIGHT_250;
        }
        StringBuilder errorMessage = new StringBuilder("Can't create AdSize using this width = ");
        errorMessage.append(width);
        errorMessage.append(" && height = ");
        errorMessage.append(height);
        throw new IllegalArgumentException(errorMessage.toString());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdSize adSize = (AdSize)o;
        if (this.getWidth() != adSize.getWidth()) {
            return false;
        }
        return this.getHeight() == adSize.getHeight();
    }

    public int hashCode() {
        int result = this.getWidth();
        result = 31 * result + this.getHeight();
        return result;
    }

    private AdSizeApi getAdSizeApi(int sizeType) {
        if (this.mAdSizeApi == null) {
            this.mAdSizeApi = DynamicLoaderFactory.makeLoaderUnsafe().createAdSizeApi(sizeType);
        }
        return this.mAdSizeApi;
    }
}

