/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.server.spring;

import com.expediagroup.graphql.generator.ClasspathTypeResolver;
import com.expediagroup.graphql.generator.GraphQLTypeResolver;
import com.expediagroup.graphql.generator.SchemaGeneratorConfig;
import com.expediagroup.graphql.generator.ToSchemaKt;
import com.expediagroup.graphql.generator.TopLevelNames;
import com.expediagroup.graphql.generator.TopLevelObject;
import com.expediagroup.graphql.generator.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.generator.extensions.GraphQLSchemaExtensionsKt;
import com.expediagroup.graphql.generator.hooks.NoopSchemaGeneratorHooks;
import com.expediagroup.graphql.generator.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.generator.internal.state.ClassScanner;
import com.expediagroup.graphql.server.Schema;
import com.expediagroup.graphql.server.operations.Mutation;
import com.expediagroup.graphql.server.operations.Query;
import com.expediagroup.graphql.server.operations.Subscription;
import com.expediagroup.graphql.server.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.server.spring.GraphQLExecutionConfiguration;
import com.expediagroup.graphql.server.spring.extensions.GeneratorExtensionsKt;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(value={"graphql.federation.enabled"}, havingValue="false", matchIfMissing=true)
@Configuration
@Import(value={GraphQLExecutionConfiguration.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0017J4\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0017JZ\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u000f2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00180\u000f2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00180\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006 "}, d2={"Lcom/expediagroup/graphql/server/spring/NonFederatedSchemaAutoConfiguration;", "", "config", "Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;", "<init>", "(Lcom/expediagroup/graphql/server/spring/GraphQLConfigurationProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "typeResolver", "Lcom/expediagroup/graphql/generator/GraphQLTypeResolver;", "schemaConfig", "Lcom/expediagroup/graphql/generator/SchemaGeneratorConfig;", "topLevelNames", "Ljava/util/Optional;", "Lcom/expediagroup/graphql/generator/TopLevelNames;", "hooks", "Lcom/expediagroup/graphql/generator/hooks/SchemaGeneratorHooks;", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/generator/execution/KotlinDataFetcherFactoryProvider;", "schema", "Lgraphql/schema/GraphQLSchema;", "queries", "", "Lcom/expediagroup/graphql/server/operations/Query;", "mutations", "Lcom/expediagroup/graphql/server/operations/Mutation;", "subscriptions", "Lcom/expediagroup/graphql/server/operations/Subscription;", "schemaObject", "Lcom/expediagroup/graphql/server/Schema;", "graphql-kotlin-spring-server"})
public class NonFederatedSchemaAutoConfiguration {
    @NotNull
    private final GraphQLConfigurationProperties config;
    private final Logger logger;

    public NonFederatedSchemaAutoConfiguration(@NotNull GraphQLConfigurationProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.logger = LoggerFactory.getLogger(NonFederatedSchemaAutoConfiguration.class);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLTypeResolver typeResolver() {
        return (GraphQLTypeResolver)new ClasspathTypeResolver(new ClassScanner(this.config.getPackages()));
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SchemaGeneratorConfig schemaConfig(@NotNull Optional<TopLevelNames> topLevelNames, @NotNull Optional<SchemaGeneratorHooks> hooks, @NotNull KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider, @NotNull GraphQLTypeResolver typeResolver) {
        Intrinsics.checkNotNullParameter(topLevelNames, (String)"topLevelNames");
        Intrinsics.checkNotNullParameter(hooks, (String)"hooks");
        Intrinsics.checkNotNullParameter((Object)dataFetcherFactoryProvider, (String)"dataFetcherFactoryProvider");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        List<String> list = this.config.getPackages();
        TopLevelNames topLevelNames2 = topLevelNames.orElse(new TopLevelNames(null, null, null, 7, null));
        Intrinsics.checkNotNullExpressionValue((Object)topLevelNames2, (String)"orElse(...)");
        SchemaGeneratorHooks schemaGeneratorHooks = hooks.orElse((SchemaGeneratorHooks)NoopSchemaGeneratorHooks.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)schemaGeneratorHooks, (String)"orElse(...)");
        return new SchemaGeneratorConfig(list, topLevelNames2, schemaGeneratorHooks, dataFetcherFactoryProvider, this.config.getIntrospection().getEnabled(), null, typeResolver, 32, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull Optional<List<Query>> queries, @NotNull Optional<List<Mutation>> mutations, @NotNull Optional<List<Subscription>> subscriptions, @NotNull SchemaGeneratorConfig schemaConfig, @NotNull Optional<Schema> schemaObject) {
        GraphQLSchema graphQLSchema;
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        Intrinsics.checkNotNullParameter(mutations, (String)"mutations");
        Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        Intrinsics.checkNotNullParameter(schemaObject, (String)"schemaObject");
        List<Query> list = queries.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"orElse(...)");
        List<TopLevelObject> list2 = GeneratorExtensionsKt.toTopLevelObjects(list);
        List<Mutation> list3 = mutations.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list3, (String)"orElse(...)");
        List<TopLevelObject> list4 = GeneratorExtensionsKt.toTopLevelObjects(list3);
        List<Subscription> list5 = subscriptions.orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue(list5, (String)"orElse(...)");
        Schema schema = schemaObject.orElse(null);
        GraphQLSchema schema2 = graphQLSchema = ToSchemaKt.toSchema((SchemaGeneratorConfig)schemaConfig, list2, list4, GeneratorExtensionsKt.toTopLevelObjects(list5), (TopLevelObject)(schema != null ? GeneratorExtensionsKt.toTopLevelObject(schema) : null));
        boolean bl = false;
        if (this.config.getPrintSchema()) {
            this.logger.info("\n" + GraphQLSchemaExtensionsKt.print$default((GraphQLSchema)schema2, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (int)63, null));
        }
        return graphQLSchema;
    }
}

