/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring.execution;

import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.execution.ApolloSubscriptionHooks;
import com.expediagroup.graphql.spring.execution.ApolloSubscriptionSessionState;
import com.expediagroup.graphql.spring.execution.SubscriptionHandler;
import com.expediagroup.graphql.spring.model.SubscriptionOperationMessage;
import com.expediagroup.graphql.types.GraphQLRequest;
import com.expediagroup.graphql.types.GraphQLResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0002J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\n\u0010$\u001a\u00060%j\u0002`&H\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0002J(\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0002J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionProtocolHandler;", "", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "subscriptionHandler", "Lcom/expediagroup/graphql/spring/execution/SubscriptionHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "subscriptionHooks", "Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionHooks;", "(Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;Lcom/expediagroup/graphql/spring/execution/SubscriptionHandler;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionHooks;)V", "acknowledgeMessage", "Lcom/expediagroup/graphql/spring/model/SubscriptionOperationMessage;", "basicConnectionErrorMessage", "keepAliveMessage", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sessionState", "Lcom/expediagroup/graphql/spring/execution/ApolloSubscriptionSessionState;", "convertToMessageOrNull", "payload", "", "getConnectionParams", "", "getKeepAliveFlux", "Lreactor/core/publisher/Flux;", "session", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "handle", "onComplete", "Lreactor/core/publisher/Mono;", "operationMessage", "onDisconnect", "graphQLContext", "onException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onInit", "onOperation", "onStart", "onStop", "onUnknownOperation", "startSubscription", "graphql-kotlin-spring-server"})
public final class ApolloSubscriptionProtocolHandler {
    private final ApolloSubscriptionSessionState sessionState;
    private final Logger logger;
    private final SubscriptionOperationMessage keepAliveMessage;
    private final SubscriptionOperationMessage basicConnectionErrorMessage;
    private final SubscriptionOperationMessage acknowledgeMessage;
    private final GraphQLConfigurationProperties config;
    private final SubscriptionHandler subscriptionHandler;
    private final ObjectMapper objectMapper;
    private final ApolloSubscriptionHooks subscriptionHooks;

    @NotNull
    public final Flux<SubscriptionOperationMessage> handle(@NotNull String payload, @NotNull WebSocketSession session) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        SubscriptionOperationMessage subscriptionOperationMessage = this.convertToMessageOrNull(payload);
        if (subscriptionOperationMessage == null) {
            Flux flux = Flux.just((Object)this.basicConnectionErrorMessage);
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(basicConnectionErrorMessage)");
            return flux;
        }
        SubscriptionOperationMessage operationMessage = subscriptionOperationMessage;
        this.logger.debug("GraphQL subscription client message, sessionId=" + session.getId() + " operationMessage=" + operationMessage);
        Flux flux = Mono.subscriberContext().flatMapMany(new Function<T, Publisher<? extends R>>(this, operationMessage, session){
            final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
            final /* synthetic */ SubscriptionOperationMessage $operationMessage;
            final /* synthetic */ WebSocketSession $session;

            @NotNull
            public final CorePublisher<SubscriptionOperationMessage> apply(Context reactorContext) {
                CorePublisher corePublisher;
                try {
                    Object graphQLContext = reactorContext.getOrDefault((Object)"graphQLContext", null);
                    String string = this.$operationMessage.getType();
                    corePublisher = Intrinsics.areEqual((Object)string, (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_INIT.getType()) ? (CorePublisher)ApolloSubscriptionProtocolHandler.access$onInit(this.this$0, this.$operationMessage, this.$session, graphQLContext) : (Intrinsics.areEqual((Object)string, (Object)SubscriptionOperationMessage.ClientMessages.GQL_START.getType()) ? (CorePublisher)ApolloSubscriptionProtocolHandler.access$onStart(this.this$0, this.$operationMessage, this.$session, graphQLContext) : (Intrinsics.areEqual((Object)string, (Object)SubscriptionOperationMessage.ClientMessages.GQL_STOP.getType()) ? (CorePublisher)ApolloSubscriptionProtocolHandler.access$onStop(this.this$0, this.$operationMessage, this.$session) : (Intrinsics.areEqual((Object)string, (Object)SubscriptionOperationMessage.ClientMessages.GQL_CONNECTION_TERMINATE.getType()) ? (CorePublisher)ApolloSubscriptionProtocolHandler.access$onDisconnect(this.this$0, this.$session, graphQLContext) : (CorePublisher)ApolloSubscriptionProtocolHandler.access$onUnknownOperation(this.this$0, this.$operationMessage, this.$session))));
                }
                catch (Exception exception) {
                    corePublisher = (CorePublisher)ApolloSubscriptionProtocolHandler.access$onException(this.this$0, exception);
                }
                return corePublisher;
            }
            {
                this.this$0 = apolloSubscriptionProtocolHandler;
                this.$operationMessage = subscriptionOperationMessage;
                this.$session = webSocketSession;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Mono.subscriberContext()\u2026)\n            }\n        }");
        return flux;
    }

    private final SubscriptionOperationMessage convertToMessageOrNull(String payload) {
        SubscriptionOperationMessage subscriptionOperationMessage;
        try {
            ObjectMapper $this$readValue$iv = this.objectMapper;
            boolean $i$f$readValue = false;
            String string = payload;
            ObjectMapper objectMapper = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<SubscriptionOperationMessage>(){};
            subscriptionOperationMessage = (SubscriptionOperationMessage)objectMapper.readValue(string, typeReference);
        }
        catch (Exception exception) {
            this.logger.error("Error parsing the subscription message", (Throwable)exception);
            subscriptionOperationMessage = null;
        }
        return subscriptionOperationMessage;
    }

    private final Flux<SubscriptionOperationMessage> getKeepAliveFlux(WebSocketSession session) {
        Long keepAliveInterval = this.config.getSubscriptions().getKeepAliveInterval();
        if (keepAliveInterval != null) {
            Flux flux = Flux.interval((Duration)Duration.ofMillis(keepAliveInterval)).map(new Function<T, V>(this){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;

                @NotNull
                public final SubscriptionOperationMessage apply(Long it) {
                    return ApolloSubscriptionProtocolHandler.access$getKeepAliveMessage$p(this.this$0);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                }
            }).doOnSubscribe((Consumer)new Consumer<Subscription>(this, session){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;

                public final void accept(Subscription it) {
                    ApolloSubscriptionSessionState apolloSubscriptionSessionState = ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0);
                    Subscription subscription = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)subscription, (String)"it");
                    apolloSubscriptionSessionState.saveKeepAliveSubscription(this.$session, subscription);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.interval(Duration.o\u2026bscription(session, it) }");
            return flux;
        }
        Flux flux = Flux.empty();
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.empty()");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> startSubscription(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        if (operationMessage.getId() == null) {
            this.logger.error("GraphQL subscription operation id is required");
            Flux flux = Flux.just((Object)this.basicConnectionErrorMessage);
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(basicConnectionErrorMessage)");
            return flux;
        }
        if (this.sessionState.operationExists(session, operationMessage)) {
            this.logger.info("Already subscribed to operation " + operationMessage.getId() + " for session " + session.getId());
            Flux flux = Flux.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.empty()");
            return flux;
        }
        Object payload = operationMessage.getPayload();
        if (payload == null) {
            this.logger.error("GraphQL subscription payload was null instead of a GraphQLRequest object");
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            return flux;
        }
        try {
            ObjectMapper $this$convertValue$iv = this.objectMapper;
            boolean $i$f$convertValue = false;
            Object object = payload;
            ObjectMapper objectMapper = $this$convertValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<GraphQLRequest>(){};
            GraphQLRequest request = (GraphQLRequest)objectMapper.convertValue(object, typeReference);
            Flux flux = this.subscriptionHandler.executeSubscription(request).map(new Function<T, V>(operationMessage){
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public final SubscriptionOperationMessage apply(GraphQLResponse<?> it) {
                    SubscriptionOperationMessage subscriptionOperationMessage;
                    List list = it.getErrors();
                    if (list != null) {
                        Collection collection = list;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            subscriptionOperationMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_ERROR.getType(), this.$operationMessage.getId(), it);
                            return subscriptionOperationMessage;
                        }
                    }
                    subscriptionOperationMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_DATA.getType(), this.$operationMessage.getId(), it);
                    return subscriptionOperationMessage;
                }
                {
                    this.$operationMessage = subscriptionOperationMessage;
                }
            }).doOnSubscribe((Consumer)new Consumer<Subscription>(this, session, operationMessage){
                final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
                final /* synthetic */ WebSocketSession $session;
                final /* synthetic */ SubscriptionOperationMessage $operationMessage;

                public final void accept(Subscription it) {
                    ApolloSubscriptionSessionState apolloSubscriptionSessionState = ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0);
                    Subscription subscription = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)subscription, (String)"it");
                    apolloSubscriptionSessionState.saveOperation(this.$session, this.$operationMessage, subscription);
                }
                {
                    this.this$0 = apolloSubscriptionProtocolHandler;
                    this.$session = webSocketSession;
                    this.$operationMessage = subscriptionOperationMessage;
                }
            }).concatWith((Publisher)this.onComplete(operationMessage, session));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"subscriptionHandler.exec\u2026erationMessage, session))");
            return flux;
        }
        catch (Exception exception) {
            this.logger.error("Error running graphql subscription", (Throwable)exception);
            this.sessionState.stopOperation(session, operationMessage);
            Flux flux = Flux.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.just(SubscriptionOp\u2026d = operationMessage.id))");
            return flux;
        }
    }

    private final Flux<SubscriptionOperationMessage> onInit(SubscriptionOperationMessage operationMessage, WebSocketSession session, Object graphQLContext) {
        Map<String, String> connectionParams = this.getConnectionParams(operationMessage.getPayload());
        Mono<Unit> onConnect2 = this.subscriptionHooks.onConnect(connectionParams, session, graphQLContext);
        this.sessionState.saveOnConnectHook(session, onConnect2);
        Mono mono = Mono.just((Object)this.acknowledgeMessage);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"Mono.just(acknowledgeMessage)");
        Mono acknowledgeMessage = mono;
        Flux<SubscriptionOperationMessage> keepAliveFlux = this.getKeepAliveFlux(session);
        Flux flux = acknowledgeMessage.concatWith((Publisher)keepAliveFlux);
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"acknowledgeMessage.concatWith(keepAliveFlux)");
        return flux;
    }

    private final Map<String, String> getConnectionParams(Object payload) {
        if (payload != null && payload instanceof Map) {
            Map map = (Map)payload;
            boolean bl = false;
            if (!map.isEmpty() && CollectionsKt.first((Iterable)((Map)payload).keySet()) instanceof String && CollectionsKt.first((Iterable)((Map)payload).values()) instanceof String) {
                return (Map)payload;
            }
        }
        return MapsKt.emptyMap();
    }

    private final Flux<SubscriptionOperationMessage> onStart(SubscriptionOperationMessage operationMessage, WebSocketSession session, Object graphQLContext) {
        Mono<Unit> mono = this.sessionState.onConnect(session);
        if (mono == null) {
            mono = this.subscriptionHooks.onConnect(MapsKt.emptyMap(), session, graphQLContext);
        }
        Mono<Unit> onConnect2 = mono;
        Flux flux = onConnect2.flatMapMany(new Function<T, Publisher<? extends R>>(this, operationMessage, session, graphQLContext){
            final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
            final /* synthetic */ SubscriptionOperationMessage $operationMessage;
            final /* synthetic */ WebSocketSession $session;
            final /* synthetic */ Object $graphQLContext;

            @NotNull
            public final Flux<SubscriptionOperationMessage> apply(Unit it) {
                return ApolloSubscriptionProtocolHandler.access$onOperation(this.this$0, this.$operationMessage, this.$session, this.$graphQLContext);
            }
            {
                this.this$0 = apolloSubscriptionProtocolHandler;
                this.$operationMessage = subscriptionOperationMessage;
                this.$session = webSocketSession;
                this.$graphQLContext = object;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"onConnect.flatMapMany { \u2026ession, graphQLContext) }");
        return flux;
    }

    private final Flux<SubscriptionOperationMessage> onOperation(SubscriptionOperationMessage operationMessage, WebSocketSession session, Object graphQLContext) {
        Flux flux = this.subscriptionHooks.onOperation(operationMessage, session, graphQLContext).flatMapMany(new Function<T, Publisher<? extends R>>(this, operationMessage, session){
            final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
            final /* synthetic */ SubscriptionOperationMessage $operationMessage;
            final /* synthetic */ WebSocketSession $session;

            @NotNull
            public final Flux<SubscriptionOperationMessage> apply(Unit it) {
                return ApolloSubscriptionProtocolHandler.access$startSubscription(this.this$0, this.$operationMessage, this.$session);
            }
            {
                this.this$0 = apolloSubscriptionProtocolHandler;
                this.$operationMessage = subscriptionOperationMessage;
                this.$session = webSocketSession;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"subscriptionHooks.onOper\u2026rationMessage, session) }");
        return flux;
    }

    private final Mono<SubscriptionOperationMessage> onComplete(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        Mono mono = this.subscriptionHooks.onOperationComplete(session).then(this.sessionState.completeOperation(session, operationMessage));
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"subscriptionHooks.onOper\u2026ssion, operationMessage))");
        return mono;
    }

    private final Mono<SubscriptionOperationMessage> onStop(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        Mono mono = this.subscriptionHooks.onOperationComplete(session).then(this.sessionState.stopOperation(session, operationMessage));
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"subscriptionHooks.onOper\u2026ssion, operationMessage))");
        return mono;
    }

    private final Mono<SubscriptionOperationMessage> onDisconnect(WebSocketSession session, Object graphQLContext) {
        Mono mono = this.subscriptionHooks.onDisconnect(session, graphQLContext).flatMap(new Function<T, Mono<? extends R>>(this, session){
            final /* synthetic */ ApolloSubscriptionProtocolHandler this$0;
            final /* synthetic */ WebSocketSession $session;

            @NotNull
            public final Mono<SubscriptionOperationMessage> apply(Unit it) {
                ApolloSubscriptionProtocolHandler.access$getSessionState$p(this.this$0).terminateSession(this.$session);
                return Mono.empty();
            }
            {
                this.this$0 = apolloSubscriptionProtocolHandler;
                this.$session = webSocketSession;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"subscriptionHooks.onDisc\u2026ationMessage>()\n        }");
        return mono;
    }

    private final Mono<SubscriptionOperationMessage> onUnknownOperation(SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        this.logger.error("Unknown subscription operation " + operationMessage);
        this.sessionState.stopOperation(session, operationMessage);
        Mono mono = Mono.just((Object)new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), operationMessage.getId(), null, 4, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"Mono.just(SubscriptionOp\u2026d = operationMessage.id))");
        return mono;
    }

    private final Mono<SubscriptionOperationMessage> onException(Exception exception) {
        this.logger.error("Error parsing the subscription message", (Throwable)exception);
        Mono mono = Mono.just((Object)this.basicConnectionErrorMessage);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"Mono.just(basicConnectionErrorMessage)");
        return mono;
    }

    public ApolloSubscriptionProtocolHandler(@NotNull GraphQLConfigurationProperties config, @NotNull SubscriptionHandler subscriptionHandler, @NotNull ObjectMapper objectMapper, @NotNull ApolloSubscriptionHooks subscriptionHooks) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)subscriptionHandler, (String)"subscriptionHandler");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkParameterIsNotNull((Object)subscriptionHooks, (String)"subscriptionHooks");
        this.config = config;
        this.subscriptionHandler = subscriptionHandler;
        this.objectMapper = objectMapper;
        this.subscriptionHooks = subscriptionHooks;
        this.sessionState = new ApolloSubscriptionSessionState();
        this.logger = LoggerFactory.getLogger(ApolloSubscriptionProtocolHandler.class);
        this.keepAliveMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_KEEP_ALIVE.getType(), null, null, 6, null);
        this.basicConnectionErrorMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ERROR.getType(), null, null, 6, null);
        this.acknowledgeMessage = new SubscriptionOperationMessage(SubscriptionOperationMessage.ServerMessages.GQL_CONNECTION_ACK.getType(), null, null, 6, null);
    }

    public static final /* synthetic */ Flux access$onInit(ApolloSubscriptionProtocolHandler $this, SubscriptionOperationMessage operationMessage, WebSocketSession session, Object graphQLContext) {
        return $this.onInit(operationMessage, session, graphQLContext);
    }

    public static final /* synthetic */ Flux access$onStart(ApolloSubscriptionProtocolHandler $this, SubscriptionOperationMessage operationMessage, WebSocketSession session, Object graphQLContext) {
        return $this.onStart(operationMessage, session, graphQLContext);
    }

    public static final /* synthetic */ Mono access$onStop(ApolloSubscriptionProtocolHandler $this, SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        return $this.onStop(operationMessage, session);
    }

    public static final /* synthetic */ Mono access$onDisconnect(ApolloSubscriptionProtocolHandler $this, WebSocketSession session, Object graphQLContext) {
        return $this.onDisconnect(session, graphQLContext);
    }

    public static final /* synthetic */ Mono access$onUnknownOperation(ApolloSubscriptionProtocolHandler $this, SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        return $this.onUnknownOperation(operationMessage, session);
    }

    public static final /* synthetic */ Mono access$onException(ApolloSubscriptionProtocolHandler $this, Exception exception) {
        return $this.onException(exception);
    }

    public static final /* synthetic */ SubscriptionOperationMessage access$getKeepAliveMessage$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.keepAliveMessage;
    }

    public static final /* synthetic */ ApolloSubscriptionSessionState access$getSessionState$p(ApolloSubscriptionProtocolHandler $this) {
        return $this.sessionState;
    }

    public static final /* synthetic */ Flux access$onOperation(ApolloSubscriptionProtocolHandler $this, SubscriptionOperationMessage operationMessage, WebSocketSession session, Object graphQLContext) {
        return $this.onOperation(operationMessage, session, graphQLContext);
    }

    public static final /* synthetic */ Flux access$startSubscription(ApolloSubscriptionProtocolHandler $this, SubscriptionOperationMessage operationMessage, WebSocketSession session) {
        return $this.startSubscription(operationMessage, session);
    }
}

