/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring;

import com.expediagroup.graphql.SchemaGeneratorConfig;
import com.expediagroup.graphql.ToSchemaKt;
import com.expediagroup.graphql.TopLevelNames;
import com.expediagroup.graphql.TopLevelObject;
import com.expediagroup.graphql.execution.KotlinDataFetcherFactoryProvider;
import com.expediagroup.graphql.extensions.GraphQLSchemaExtensionsKt;
import com.expediagroup.graphql.hooks.NoopSchemaGeneratorHooks;
import com.expediagroup.graphql.hooks.SchemaGeneratorHooks;
import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.extensions.GeneratorExtensionsKt;
import com.expediagroup.graphql.spring.operations.Mutation;
import com.expediagroup.graphql.spring.operations.Query;
import com.expediagroup.graphql.spring.operations.Subscription;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(havingValue="false", matchIfMissing=true, value={"graphql.federation.enabled"})
@Configuration
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\t2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J4\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/expediagroup/graphql/spring/SchemaAutoConfiguration;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "schema", "Lgraphql/schema/GraphQLSchema;", "queries", "Ljava/util/Optional;", "", "Lcom/expediagroup/graphql/spring/operations/Query;", "mutations", "Lcom/expediagroup/graphql/spring/operations/Mutation;", "subscriptions", "Lcom/expediagroup/graphql/spring/operations/Subscription;", "schemaConfig", "Lcom/expediagroup/graphql/SchemaGeneratorConfig;", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "topLevelNames", "Lcom/expediagroup/graphql/TopLevelNames;", "hooks", "Lcom/expediagroup/graphql/hooks/SchemaGeneratorHooks;", "dataFetcherFactoryProvider", "Lcom/expediagroup/graphql/execution/KotlinDataFetcherFactoryProvider;", "graphql-kotlin-spring-server"})
public class SchemaAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(SchemaAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SchemaGeneratorConfig schemaConfig(@NotNull GraphQLConfigurationProperties config, @NotNull Optional<TopLevelNames> topLevelNames, @NotNull Optional<SchemaGeneratorHooks> hooks, @NotNull KotlinDataFetcherFactoryProvider dataFetcherFactoryProvider) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(topLevelNames, (String)"topLevelNames");
        Intrinsics.checkParameterIsNotNull(hooks, (String)"hooks");
        Intrinsics.checkParameterIsNotNull((Object)dataFetcherFactoryProvider, (String)"dataFetcherFactoryProvider");
        SchemaGeneratorHooks generatorHooks = hooks.orElse((SchemaGeneratorHooks)NoopSchemaGeneratorHooks.INSTANCE);
        List<String> list = config.getPackages();
        TopLevelNames topLevelNames2 = topLevelNames.orElse(new TopLevelNames(null, null, null, 7, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)topLevelNames2, (String)"topLevelNames.orElse(TopLevelNames())");
        SchemaGeneratorHooks schemaGeneratorHooks = generatorHooks;
        Intrinsics.checkExpressionValueIsNotNull((Object)schemaGeneratorHooks, (String)"generatorHooks");
        return new SchemaGeneratorConfig(list, topLevelNames2, schemaGeneratorHooks, dataFetcherFactoryProvider, config.getIntrospection().getEnabled());
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GraphQLSchema schema(@NotNull Optional<List<Query>> queries, @NotNull Optional<List<Mutation>> mutations, @NotNull Optional<List<Subscription>> subscriptions, @NotNull SchemaGeneratorConfig schemaConfig) {
        Intrinsics.checkParameterIsNotNull(queries, (String)"queries");
        Intrinsics.checkParameterIsNotNull(mutations, (String)"mutations");
        Intrinsics.checkParameterIsNotNull(subscriptions, (String)"subscriptions");
        Intrinsics.checkParameterIsNotNull((Object)schemaConfig, (String)"schemaConfig");
        List<Query> list = queries.orElse(CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"queries.orElse(emptyList())");
        List<TopLevelObject> list2 = GeneratorExtensionsKt.toTopLevelObjects(list);
        List<Mutation> list3 = mutations.orElse(CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"mutations.orElse(emptyList())");
        List<TopLevelObject> list4 = GeneratorExtensionsKt.toTopLevelObjects(list3);
        List<Subscription> list5 = subscriptions.orElse(CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull(list5, (String)"subscriptions.orElse(emptyList())");
        GraphQLSchema schema = ToSchemaKt.toSchema((SchemaGeneratorConfig)schemaConfig, list2, list4, GeneratorExtensionsKt.toTopLevelObjects(list5));
        this.logger.info('\n' + GraphQLSchemaExtensionsKt.print$default((GraphQLSchema)schema, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (int)31, null));
        return schema;
    }
}

