/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring.exception;

import com.expediagroup.graphql.spring.exception.SimpleKotlinGraphQLError;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/expediagroup/graphql/spring/exception/KotlinDataFetcherExceptionHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onException", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "graphql-kotlin-spring-server"})
public final class KotlinDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(KotlinDataFetcherExceptionHandler.class);

    @NotNull
    public DataFetcherExceptionHandlerResult onException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        Intrinsics.checkParameterIsNotNull((Object)handlerParameters, (String)"handlerParameters");
        Throwable exception = handlerParameters.getException();
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ExecutionPath path = handlerParameters.getPath();
        Throwable throwable = exception;
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"exception");
        GraphQLError error = new SimpleKotlinGraphQLError(throwable, CollectionsKt.listOf((Object)sourceLocation), path.toList(), null, 8, null);
        this.logger.warn(error.getMessage(), exception);
        DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = DataFetcherExceptionHandlerResult.newResult((GraphQLError)error).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFetcherExceptionHandlerResult, (String)"DataFetcherExceptionHand\u2026.newResult(error).build()");
        return dataFetcherExceptionHandlerResult;
    }
}

