/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.spring;

import com.expediagroup.graphql.spring.GraphQLConfigurationProperties;
import com.expediagroup.graphql.spring.execution.SimpleSubscriptionHandler;
import com.expediagroup.graphql.spring.execution.SubscriptionHandler;
import com.expediagroup.graphql.spring.operations.Subscription;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@Configuration
@ConditionalOnBean(value={Subscription.class})
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017\u00a8\u0006\u000f"}, d2={"Lcom/expediagroup/graphql/spring/SubscriptionAutoConfiguration;", "", "()V", "subscriptionHandler", "Lcom/expediagroup/graphql/spring/execution/SubscriptionHandler;", "graphQL", "Lgraphql/GraphQL;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "subscriptionHandlerMapping", "Lorg/springframework/web/reactive/HandlerMapping;", "config", "Lcom/expediagroup/graphql/spring/GraphQLConfigurationProperties;", "websocketHandlerAdapter", "Lorg/springframework/web/reactive/socket/server/support/WebSocketHandlerAdapter;", "graphql-kotlin-spring-server"})
public class SubscriptionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SubscriptionHandler subscriptionHandler(@NotNull GraphQL graphQL2, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)graphQL2, (String)"graphQL");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        return new SimpleSubscriptionHandler(graphQL2, objectMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public WebSocketHandlerAdapter websocketHandlerAdapter() {
        return new WebSocketHandlerAdapter();
    }

    @Bean
    @NotNull
    public HandlerMapping subscriptionHandlerMapping(@NotNull GraphQLConfigurationProperties config, @NotNull SubscriptionHandler subscriptionHandler) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)subscriptionHandler, (String)"subscriptionHandler");
        return (HandlerMapping)new SimpleUrlHandlerMapping(MapsKt.mapOf((Pair)TuplesKt.to((Object)config.getSubscriptions().getEndpoint(), (Object)subscriptionHandler)), Integer.MIN_VALUE);
    }
}

