/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.maven;

import com.expediagroup.graphql.plugin.graalvm.GenerateGraalVmMetadataKt;
import com.expediagroup.graphql.plugin.maven.AbstractSourceMojo;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u00068\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/expediagroup/graphql/plugin/maven/GenerateGraalVmMetadataMojo;", "Lcom/expediagroup/graphql/plugin/maven/AbstractSourceMojo;", "()V", "mainClassName", "", "outputDirectory", "Ljava/io/File;", "getOutputDirectory", "()Ljava/io/File;", "setOutputDirectory", "(Ljava/io/File;)V", "packages", "", "generate", "", "graphql-kotlin-maven-plugin"})
@Mojo(name="generate-graalvm-metadata", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class GenerateGraalVmMetadataMojo
extends AbstractSourceMojo {
    @Parameter(required=true)
    private List<String> packages;
    @Parameter
    @Nullable
    private String mainClassName;
    @Parameter(name="outputDirectory", defaultValue="${project.build.outputDirectory}")
    public File outputDirectory;

    @Override
    @NotNull
    public File getOutputDirectory() {
        File file = this.outputDirectory;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"outputDirectory");
        return null;
    }

    @Override
    public void setOutputDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.outputDirectory = file;
    }

    @Override
    public void generate() {
        File metadataDirectory = new File(this.getOutputDirectory(), "META-INF/native-image/" + this.getProject$graphql_kotlin_maven_plugin().getGroupId() + "/" + this.getProject$graphql_kotlin_maven_plugin().getName() + "/graphql");
        if (!metadataDirectory.isDirectory() && !metadataDirectory.mkdirs()) {
            throw new RuntimeException("failed to create reachability metadata directory");
        }
        this.getLog().debug((CharSequence)"attempting to generate GraalVM using custom classloader");
        List<String> list = this.packages;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packages");
            list = null;
        }
        GenerateGraalVmMetadataKt.generateGraalVmMetadata((File)metadataDirectory, list, (String)this.mainClassName);
        this.getLog().debug((CharSequence)"successfully generated GraalVM metadata");
    }
}

