/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.plugin.gradle.tasks;

import com.expediagroup.graphql.plugin.gradle.actions.GenerateGraalVmMetadataAction;
import com.expediagroup.graphql.plugin.gradle.parameters.GenerateGraalVmMetadataParameters;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0019H'R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00020\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00020\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/expediagroup/graphql/plugin/gradle/tasks/GraphQLGraalVmMetadataTask;", "Lorg/gradle/api/tasks/SourceTask;", "()V", "mainClassName", "Lorg/gradle/api/provider/Property;", "", "getMainClassName", "()Lorg/gradle/api/provider/Property;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "packages", "Lorg/gradle/api/provider/ListProperty;", "getPackages", "()Lorg/gradle/api/provider/ListProperty;", "pluginClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPluginClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "projectClasspath", "getProjectClasspath", "generateMetadata", "", "getWorkerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "graphql-kotlin-gradle-plugin"})
public abstract class GraphQLGraalVmMetadataTask
extends SourceTask {
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @NotNull
    private final ConfigurableFileCollection projectClasspath;
    @Input
    @NotNull
    private final ListProperty<String> packages;
    @Input
    @Optional
    @NotNull
    private final Property<String> mainClassName;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDirectory;

    public GraphQLGraalVmMetadataTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.pluginClasspath = configurableFileCollection;
        ConfigurableFileCollection configurableFileCollection2 = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"project.objects.fileCollection()");
        this.projectClasspath = configurableFileCollection2;
        ListProperty listProperty = this.getProject().getObjects().listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"project.objects.listProperty(String::class.java)");
        this.packages = listProperty;
        Property property = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.mainClassName = property;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.outputDirectory = directoryProperty;
        this.setGroup("GraphQL");
        this.setDescription("Generate GraalVM reflect metadata for GraphQL Kotlin servers.");
        this.outputDirectory.convention(this.getProject().getLayout().getBuildDirectory().dir("generated/graphqlGraalVmResources"));
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getProjectClasspath() {
        return this.projectClasspath;
    }

    @NotNull
    public final ListProperty<String> getPackages() {
        return this.packages;
    }

    @NotNull
    public final Property<String> getMainClassName() {
        return this.mainClassName;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public final void generateMetadata() {
        Object object = this.packages.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"packages.get()");
        List packages = (List)object;
        if (packages.isEmpty()) {
            throw new RuntimeException("attempt to generate SDL failed - missing required supportedPackages property");
        }
        File file = ((Directory)this.outputDirectory.dir("META-INF/native-image/" + this.getProject().getGroup() + "/" + this.getProject().getName() + "/graphql").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.dir(\"MET\u2026e}/graphql\").get().asFile");
        File targetDirectory = file;
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw new RuntimeException("failed to generate target resource directory = " + targetDirectory);
        }
        WorkQueue workQueue2 = this.getWorkerExecutor().classLoaderIsolation(arg_0 -> GraphQLGraalVmMetadataTask.generateMetadata$lambda$0((Function1)new Function1<ClassLoaderWorkerSpec, Unit>(this){
            final /* synthetic */ GraphQLGraalVmMetadataTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ClassLoaderWorkerSpec workerSpec) {
                Intrinsics.checkNotNullParameter((Object)workerSpec, (String)"workerSpec");
                FileCollection fileCollection = this.this$0.getPluginClasspath().plus((FileCollection)this.this$0.getProjectClasspath());
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"pluginClasspath.plus(projectClasspath)");
                Iterable iterable = (Iterable)fileCollection;
                Set set = this.this$0.getSource().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"source.files");
                List workerClasspath = CollectionsKt.plus((Iterable)iterable, (Iterable)set);
                Object[] objectArray = new Object[]{workerClasspath};
                workerSpec.getClasspath().from(objectArray);
                Logger logger = this.this$0.getLogger();
                Set set2 = workerSpec.getClasspath().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"workerSpec.classpath.files");
                logger.debug("worker classpath: \n" + CollectionsKt.joinToString$default((Iterable)set2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"@TaskAction\n    fun gene\u2026 GraalVM metadata\")\n    }");
        WorkQueue workQueue3 = workQueue2;
        this.getLogger().debug("submitting work item to generate GraalVM for the schema included in packages = {}", (Object)packages);
        workQueue3.submit(GenerateGraalVmMetadataAction.class, arg_0 -> GraphQLGraalVmMetadataTask.generateMetadata$lambda$1((Function1)new Function1<GenerateGraalVmMetadataParameters, Unit>((List<String>)packages, this, targetDirectory){
            final /* synthetic */ List<String> $packages;
            final /* synthetic */ GraphQLGraalVmMetadataTask this$0;
            final /* synthetic */ File $targetDirectory;
            {
                this.$packages = $packages;
                this.this$0 = $receiver;
                this.$targetDirectory = $targetDirectory;
                super(1);
            }

            public final void invoke(@NotNull GenerateGraalVmMetadataParameters parameters) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getSupportedPackages().set((Iterable)this.$packages);
                parameters.getMainClassName().set(this.this$0.getMainClassName().getOrNull());
                parameters.getOutputDirectory().set((Object)this.$targetDirectory);
            }
        }, arg_0));
        workQueue3.await();
        this.getLogger().debug("successfully generated GraalVM metadata");
    }

    private static final void generateMetadata$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void generateMetadata$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

