/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.wait.strategy;

import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.clusterlogs.LogPatternDetector;
import com.exasol.clusterlogs.LogPatternDetectorFactory;
import com.exasol.containers.ssh.SshException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;

public class LogFileEntryWaitStrategy
extends AbstractWaitStrategy {
    private static final long WAIT_DURATION_IN_MILLISECONDS = TimeUnit.MINUTES.toMillis(2L);
    private static final long POLLING_DELAY_IN_MILLISECONDS = TimeUnit.SECONDS.toMillis(1L);
    private final LogPatternDetector detector;

    public LogFileEntryWaitStrategy(LogPatternDetectorFactory detectorFactory, String logPath, String logNamePattern, String pattern, BucketFsMonitor.State state) {
        this(detectorFactory.createLogPatternDetector(logPath, logNamePattern, pattern, state));
    }

    public LogFileEntryWaitStrategy(LogPatternDetector detector) {
        this.detector = detector;
    }

    protected void waitUntilReady() {
        long expiry = System.currentTimeMillis() + this.getWaitTimeOutMilliseconds();
        while (System.currentTimeMillis() < expiry) {
            try {
                if (this.detector.isPatternPresent()) {
                    return;
                }
                Thread.sleep(POLLING_DELAY_IN_MILLISECONDS);
            }
            catch (SshException | IOException | UnsupportedOperationException exception) {
                throw new ContainerLaunchException("Caught exception while waiting for log entry.", (Throwable)exception);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                throw new ContainerLaunchException("Waiting for log entry got interrupted.", (Throwable)exception);
            }
        }
        throw new ContainerLaunchException("Timeout: " + this.detector.describe() + "\nActual log file content: \"" + this.detector.getActualLog() + "\"");
    }

    protected long getWaitTimeOutMilliseconds() {
        return WAIT_DURATION_IN_MILLISECONDS;
    }
}

