/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.tls;

import com.exasol.config.ClusterConfiguration;
import com.exasol.containers.ContainerFileOperations;
import com.exasol.containers.ExasolContainer;
import com.exasol.containers.ExasolContainerException;
import com.exasol.errorreporting.ExaError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.function.Supplier;

public class CertificateProvider {
    private final Supplier<Optional<ClusterConfiguration>> configProvider;
    private final ContainerFileOperations fileOperations;

    public CertificateProvider(Supplier<Optional<ClusterConfiguration>> configProvider, ContainerFileOperations fileOperations) {
        this.configProvider = configProvider;
        this.fileOperations = fileOperations;
    }

    CertificateProvider(ExasolContainer<? extends ExasolContainer<?>> container, ContainerFileOperations fileOperations) {
        this(() -> Optional.of(container.getClusterConfiguration()), fileOperations);
    }

    public Optional<X509Certificate> getCertificate() {
        return this.readCertificate().map(this::parseCertificate);
    }

    private Optional<String> readCertificate() {
        Optional<ClusterConfiguration> configuration = this.configProvider.get();
        if (configuration.isEmpty()) {
            return Optional.empty();
        }
        String certPath = configuration.get().getTlsCertificatePath();
        try {
            String certContent = this.fileOperations.readFile(certPath, StandardCharsets.UTF_8);
            return Optional.of(certContent);
        }
        catch (ExasolContainerException exception) {
            return Optional.empty();
        }
    }

    private X509Certificate parseCertificate(String certContent) {
        X509Certificate x509Certificate;
        ByteArrayInputStream is = new ByteArrayInputStream(certContent.getBytes(StandardCharsets.UTF_8));
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)cf.generateCertificate(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CertificateException exception) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETC-7").message("Error parsing certificate {{certificateContent}}.", new Object[]{certContent}).ticketMitigation().toString(), exception);
            }
        }
        ((InputStream)is).close();
        return x509Certificate;
    }

    public Optional<String> getSha256Fingerprint() {
        return this.getEncodedCertificate().map(CertificateProvider::sha256).map(bytes -> CertificateProvider.bytesToHexWithPadding(bytes, 32));
    }

    private Optional<byte[]> getEncodedCertificate() {
        Optional<X509Certificate> certificate = this.getCertificate();
        if (certificate.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(certificate.get().getEncoded());
        }
        catch (CertificateEncodingException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETC-8").message("Unable get encoded certificate for {{certificate}}.", new Object[]{certificate.get()}).ticketMitigation().toString(), exception);
        }
    }

    static byte[] sha256(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETC-9").message("Unable to calculate SHA-256 of certificate content.", new Object[0]).ticketMitigation().toString(), exception);
        }
    }

    static String bytesToHexWithPadding(byte[] bytes, int byteCount) {
        String hex = CertificateProvider.bytesToHex(bytes);
        if (hex.length() >= byteCount * 2) {
            return hex;
        }
        return "0".repeat(byteCount * 2 - hex.length()) + hex;
    }

    static String bytesToHex(byte[] bytes) {
        String hex = new BigInteger(1, bytes).toString(16);
        if (hex.length() % 2 == 0) {
            return hex;
        }
        return "0" + hex;
    }
}

