/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.exasol.containers.ssh.FileVisitor;
import com.exasol.containers.ssh.Ssh;
import com.exasol.containers.ssh.SshException;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class RemoteFileWriter {
    private static final int BUFFER_SIZE = 1024;
    private final Ssh ssh;

    RemoteFileWriter(Ssh ssh) {
        this.ssh = ssh;
    }

    void write(Path local, String remote) throws IOException, JSchException {
        Channel channel = this.ssh.openChannel("exec");
        ((ChannelExec)channel).setCommand("scp -t " + remote);
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();
        channel.connect();
        this.assertAckOrThrowException(in, "first");
        out.write(FileVisitor.fileHeader(local).getBytes());
        out.flush();
        this.assertAckOrThrowException(in, "second");
        try (InputStream fis = Files.newInputStream(local, new OpenOption[0]);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
        }
        FileVisitor.sendZeroByte(out);
        this.assertAckOrThrowException(in, "final");
        out.close();
        channel.disconnect();
    }

    private void assertAckOrThrowException(InputStream stream, String messagePrefix) throws IOException, SshException {
        if (FileVisitor.checkAck(stream) != 0) {
            throw new SshException(messagePrefix + " ack != 0");
        }
    }
}

