/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.exasol.containers.ssh.SessionBuilder;
import com.exasol.containers.ssh.Ssh;
import com.exasol.containers.ssh.SshException;
import com.exasol.containers.ssh.SshKeys;
import com.exasol.errorreporting.ExaError;
import com.jcraft.jsch.Session;
import java.io.File;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public final class DockerAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerAccess.class);
    private final SessionBuilderProvider sessionBuilderProvider;
    private final DockerProbe dockerProbe;
    private final SshKeys sshKeys;
    private final Path temporaryCredentialsDirectory;
    private Mode cachedAccessMode = Mode.UNKNOWN;
    private Ssh cachedSshConnection = null;

    private DockerAccess(Builder builder) {
        this.sessionBuilderProvider = builder.sessionBuilderProvider;
        this.dockerProbe = builder.dockerProbe;
        this.sshKeys = builder.sshKeys;
        this.temporaryCredentialsDirectory = builder.temporaryCredentialsDirectory;
    }

    public SshKeys getSshKeys() {
        return this.sshKeys;
    }

    public boolean supportsDockerExec() {
        return this.getMode() == Mode.DOCKER_EXEC;
    }

    synchronized Mode getMode() {
        if (this.cachedAccessMode == Mode.UNKNOWN) {
            Container.ExecResult result = this.dockerProbe.probeFile("/exa/etc/EXAConf");
            if (result.getExitCode() == 0) {
                LOGGER.trace("Docker container supports docker exec");
                this.cachedAccessMode = Mode.DOCKER_EXEC;
            } else {
                LOGGER.trace("Docker container requires SSH access");
                this.cachedAccessMode = Mode.SSH;
            }
        }
        return this.cachedAccessMode;
    }

    public synchronized Ssh getSsh() {
        if (this.cachedSshConnection == null) {
            this.createTemporaryCredentialDirectoryIfMissing();
            Session session = this.sessionBuilderProvider.get().identity(this.sshKeys.getIdentityProvider()).build();
            this.cachedSshConnection = new Ssh(session);
        }
        return this.cachedSshConnection;
    }

    private void createTemporaryCredentialDirectoryIfMissing() {
        File directory = this.temporaryCredentialsDirectory.toFile();
        if (!directory.exists() && !directory.mkdirs()) {
            ExaError.messageBuilder((String)"F-ETC-23").message("Unable to create directory for temporary credentials: {{path}}", new Object[0]).parameter("path", (Object)directory.toString());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SessionBuilderProvider sessionBuilderProvider;
        private DockerProbe dockerProbe;
        private SshKeys sshKeys;
        private Path temporaryCredentialsDirectory;

        private Builder() {
        }

        public Builder sessionBuilderProvider(SessionBuilderProvider sessionBuilderProvider) {
            this.sessionBuilderProvider = sessionBuilderProvider;
            return this;
        }

        public Builder dockerProbe(DockerProbe dockerProbe) {
            this.dockerProbe = dockerProbe;
            return this;
        }

        public Builder sshKeys(SshKeys sshKeys) {
            this.sshKeys = sshKeys;
            return this;
        }

        public DockerAccess build() {
            return new DockerAccess(this);
        }

        public Builder temporaryCredentialsDirectory(Path temporaryCredentialsDirectory) {
            this.temporaryCredentialsDirectory = temporaryCredentialsDirectory;
            return this;
        }
    }

    @FunctionalInterface
    public static interface DockerProbe {
        public Container.ExecResult probeFile(String var1);
    }

    @FunctionalInterface
    public static interface SessionBuilderProvider {
        public SessionBuilder get() throws SshException;
    }

    static enum Mode {
        UNKNOWN,
        SSH,
        DOCKER_EXEC;

    }
}

